# vim:tabstop=4:shiftwidth=4:softtabstop=0:noexpandtab

FEATURE_FLAG_VALUE = $(word 2,$(subst =, ,$(filter $(1)=%,$(FEATURE_FLAGS))))

include modules.make

PLATFORM_NAME := $(call FEATURE_FLAG_VALUE,PLATFORM_NAME)

.SUFFIXES:

.PHONY: all
.DEFAULT_GOAL := all

CFLAGS = -std=c99 -ffunction-sections -fdata-sections -fno-common -mno-unaligned-access

WARNFLAGS = \
  -Wall \
  -Wextra \
  -Wno-missing-field-initializers \
  -Wno-array-bounds \
  -Wmissing-include-dirs \
  -Wunknown-pragmas \
  -Wundef \
  -Wshadow \
  -Wpointer-arith \
  -Wstrict-prototypes \
  -Wold-style-declaration \
  -Wmissing-prototypes \
  -Wnested-externs \
  -Winvalid-pch \
  -Wunused-parameter \
  -Wcast-qual \
  -Wcast-align \
  -Wwrite-strings \
  -Wmissing-declarations \
  $(if $(filter TX_ENABLE_EVENT_TRACE, $(FEATURE_FLAGS)),, \
    -Wredundant-decls \
  ) \
  -Winline \

WARNFLAGS += -Werror

ASMFLAGS =

LDFLAGS = -static -nostartfiles -nostdlib -nodefaultlibs -Wl,--cref -Wl,--warn-common -Wl,-d

-include $(ENV_DIRECTORY)/symbols.make

.PHONY: debug
debug: all

ifneq ($(filter debug, $(MAKECMDGOALS)),)
CFLAGS += -DDEBUG -ggdb -Os
ASMFLAGS += --defsym DEBUG=1 -ggdb
LDFLAGS  += -Wl,-Os
BUILD_TYPE = debug
else
CFLAGS += -DNDEBUG -ggdb -Os
ASMFLAGS += -ggdb
LDFLAGS  += -Wl,-Os
BUILD_TYPE = release
endif

version: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/version.make

$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/version.make:
	@echo $(notdir $@)
	@echo "LANTRONIX_VERSION = $(TARGET_VERSION)" > $@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile: \
  $(wildcard defines.make) modules.make $(RULES_DIRECTORY)/common.make
	@echo $@
	@$(MKDIR) -p $(addprefix $(WORK_DIRECTORY)/$(PROJECT_NAME)/, \
	  dependencies \
	  includes \
	  lantronix \
	  lantronix/includes/system \
	  lantronix/libraries \
	  lantronix/modules \
	  libraries \
	  modules \
	  objects \
	  project \
      $(PROJECT_DIRECTORIES) \
	)
	@touch $@

.PHONY: clean
clean:
	$(RM) -r $(WORK_DIRECTORY)/$(PROJECT_NAME)

EVALUATED_FLAGS = \
  NETS_SOFTAP_START=0 \
  NETS_ETHERNET_START=$(call FEATURE_FLAG_VALUE,MAX_NETS_SOFTAP) \
  NETS_WLAN_START=$(shell echo $$(($(call FEATURE_FLAG_VALUE,MAX_NETS_SOFTAP)+$(call FEATURE_FLAG_VALUE,MAX_NETS_ETHERNET)))) \
  NETS_CELLULAR_START=$(shell echo $$(($(call FEATURE_FLAG_VALUE,MAX_NETS_SOFTAP)+$(call FEATURE_FLAG_VALUE,MAX_NETS_ETHERNET)+$(call FEATURE_FLAG_VALUE,MAX_NETS_WLAN)))) \
  NETS_LOOPBACK_START=$(shell echo $$(($(call FEATURE_FLAG_VALUE,MAX_NETS_SOFTAP)+$(call FEATURE_FLAG_VALUE,MAX_NETS_ETHERNET)+$(call FEATURE_FLAG_VALUE,MAX_NETS_WLAN)+$(call FEATURE_FLAG_VALUE,MAX_NETS_CELLULAR)))) \
  NETS_TOTAL_NUM=$(shell echo $$(($(call FEATURE_FLAG_VALUE,MAX_NETS_SOFTAP)+$(call FEATURE_FLAG_VALUE,MAX_NETS_ETHERNET)+$(call FEATURE_FLAG_VALUE,MAX_NETS_WLAN)+$(call FEATURE_FLAG_VALUE,MAX_NETS_CELLULAR)+$(call FEATURE_FLAG_VALUE,MAX_NETS_LOOPBACK)))) \

ALL_C_COMPILE_SOURCES :=
ALL_ASM_SOURCES :=

BARE_C_DEFINES := $(strip $(FEATURE_FLAGS) $(EVALUATED_FLAGS))

C_DEFINES := $(addprefix -D,$(BARE_C_DEFINES))

ALL_MODULE_DIRECTORIES := $(dir $(wildcard $(BASE_DIRECTORY)/module/*/bom/cfiles.make))

ALL_MODULE_NAMES := $(foreach DIR,$(ALL_MODULE_DIRECTORIES),$(lastword $(subst /, ,$(patsubst %/bom/,%,$(DIR)))))

ALL_UNEXCLUDED_MODULE_NAMES := $(filter-out $(EXCLUDED_MODULES),$(ALL_MODULE_NAMES))

$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/includes/all_of_the_module_definitions.h : \
  $(foreach MODULE,$(ALL_MODULE_NAMES),$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/includes/$(MODULE)_module_definitions.h)
	@echo $(notdir $@)
	@echo "/* Generated by makefile */" > $@
	@for m in $(ALL_MODULE_NAMES); do echo "#include \"$$m"_module_definitions.h\"; done >> $@

ALL_UNSORTED_MODULE_DEFS := \
  $(foreach \
    MODULE, \
    $(ALL_MODULE_NAMES), \
    $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(strip $(MODULE))/$(strip $(MODULE))_module_defs_unsorted.dat \
  )

$(WORK_DIRECTORY)/$(PROJECT_NAME)/module_defs_sort.txt : $(ALL_UNSORTED_MODULE_DEFS)
	@echo $(notdir $@)
	@cat $(ALL_UNSORTED_MODULE_DEFS) | sort -r -g -u | unix2dos > $@

PRUNE_TO_MODULE_DIRECTORY = $(patsubst $(BASE_DIRECTORY)/module/%,%,$(1))

include $(RULES_DIRECTORY)/basic_rules.make

define MODULE_DEFINES_LINK_template

ifeq ($(1),main)

NON_STRIPPED_MAIN_SYMBOLS := \
  _start \
  ltrx_linker_module_main_data_offset \
  ltrx_linker_module_main_data_size \
  ltrx_linker_module_main_flash_end \
  ltrx_linker_module_main_ram_end \
  $$(KEPT_MAIN_SYMBOLS) \

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/object_names$(2).txt: \
  $$($(1)_OBJECTS)
	@echo $$(notdir $$@)
	@echo "$$(addprefix %,$$(notdir $$($(1)_OBJECTS)))" > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/inputs$(2).ld: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/object_names$(2).txt
	@echo $$(notdir $$@)
	@echo "GROUP (" > $$@
	@sed -e 's|%|\n$(WORK_NORMALIZED_DIRECTORY)/$(PROJECT_NAME)/objects/|g' $$< >> $$@
	@echo ")" >> $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/main$(2).ld: \
  $(BASE_DIRECTORY)/module/main/bsp/$(BSP_DIRECTORY_NAME)/main.ld
	@echo $$(notdir $$@)
	@sed \
	  -e 's/<INSTALL_ADDRESS_FW>/$$(INSTALL_ADDRESS_FW$(2))/' \
	  -e 's/<PARTITION_SIZE>/$$(PARTITION_SIZE)/' \
	  -e 's/<MAIN_LINK_KEEPS_GO_HERE>/$$(foreach SYM,$$(KEPT_MAIN_SYMBOLS),KEEP\(*\(*.$$(SYM)\)\))/' $$< > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).symbols.elf: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/inputs$(2).ld \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/main$(2).ld
	@echo $$(notdir $$@)
	$(quiet)$(CC) \
	  -Wl,--gc-sections \
	  $$(LDFLAGS) \
	  -Wl,-Map,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).symbols.map \
	  -Wl,-T $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/inputs$(2).ld \
	  -Wl,-T $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/main$(2).ld \
	  -Wl,--entry=$(call FEATURE_FLAG_VALUE,ENTRY_POINT) \
	  $$($(1)_LIBRARIES) \
	  -o $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/strip_commands$(2).txt: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).symbols.elf
	@echo $$(notdir $$@)
	@echo "$$(addprefix -K ,$$(NON_STRIPPED_MAIN_SYMBOLS))" > $$@
	@echo "$(WORK_NORMALIZED_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).symbols.elf" >> $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/$(1)$(2).elf: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/strip_commands$(2).txt
	@echo $$(notdir $$@)
	@cp -f $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).symbols.map $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).map
	@$(STRIP) @$$< -o $$@

else

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).symbols.elf: \
  $$($(1)_OBJECTS) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/main$(2).elf \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/module_reloc.ld
	@echo $$(notdir $$@)
	$(quiet)$(CC) \
	  -r \
	  -Wl,--just-symbols=$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/main$(2).elf \
	  -Wl,--gc-sections \
	  $$(LDFLAGS) -Wl,-Map,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).symbols.map \
	  -Wl,-T $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/module_reloc.ld \
	  -Wl,--undefined=g_$(1)ModuleInfo \
	  -Wl,--start-group \
	  $$($(1)_OBJECTS) \
	  $$(wildcard $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/libraries/*_module_libs.o) \
	  $$($(1)_LIBRARIES) \
	  -Wl,--end-group \
	  $$($(1)_LDFLAGS) \
	  -o $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/$(1)$(2).elf: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).symbols.elf
	@echo $$(notdir $$@)
	@$(STRIP) --strip-unneeded $$< -o $$@

endif

endef # MODULE_DEFINES_LINK_template

define MODULE_DEFINES_template

MY_DIR := $(BASE_DIRECTORY)/module/$(1)
BSP_DIR := $(BASE_DIRECTORY)/module/$(1)/bsp/$(BSP_DIRECTORY_NAME)

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/module_reloc.ld: \
  $(LD_DIRECTORY)/module_reloc.ld
	@echo $$(notdir $$@)
	@sed \
      -e 's/<FORCED_FLASH_SECTIONS_GO_HERE>/$$($(1)_FORCED_FLASH_SECTIONS)/' \
      -e 's/<FORCED_RAM_SECTIONS_GO_HERE>/$$($(1)_FORCED_RAM_SECTIONS)/' \
      $$< > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)_module_defs_unsorted.dat : \
  $(RULES_DIRECTORY)/module_defs_sort.m4 \
  $(RULES_DIRECTORY)/module_defs_clean.m4 \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/module_*.m4d) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile
	@echo $$(notdir $$@)
	@$(MKDIR) -p $$(dir $$@)
	$(veryquiet)m4 \
	  -I$(BASE_DIRECTORY)/module/$(1) \
	  -I$(RULES_DIRECTORY) \
	  $(addprefix -D,$(strip MODULE_NAME=$(1) $(FEATURE_FLAGS) $(EVALUATED_FLAGS) $(VARDEF_NUMBER_RANGE_FLAGS))) \
	  $$< > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/includes/$(1)_module_definitions.h : \
  $(RULES_DIRECTORY)/module_definitions_h.m4 \
  $(RULES_DIRECTORY)/module_defs_clean.m4 \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/module_*.m4d) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile
	@echo $$(notdir $$@)
	$(veryquiet)m4 \
	  -I$(BASE_DIRECTORY)/module/$(1) \
	  -I$(RULES_DIRECTORY) \
	  -DTHIS_MODULE_NAME=\`$(1)\' \
	  $(addprefix -D,$(strip $(FEATURE_FLAGS) $(EVALUATED_FLAGS) $(VARDEF_NUMBER_RANGE_FLAGS))) \
	  $$< > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/includes/$(1)_module_libs.h : \
  $(RULES_DIRECTORY)/module_libs_h.m4 \
  $(RULES_DIRECTORY)/module_defs_clean.m4 \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/module_*.m4d) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile
	@echo $$(notdir $$@)
	$(veryquiet)m4 \
	  -I$(BASE_DIRECTORY)/module/$(1) \
	  -I$(RULES_DIRECTORY) \
	  -DTHIS_MODULE_NAME=\`$(1)\' \
	  $(addprefix -D,$(strip $(FEATURE_FLAGS) $(EVALUATED_FLAGS) $(VARDEF_NUMBER_RANGE_FLAGS))) \
	  $$< > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)_module_libs.c : \
  $(RULES_DIRECTORY)/module_libs_c.m4 \
  $(RULES_DIRECTORY)/module_defs_clean.m4 \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/module_*.m4d) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile
	@echo $$(notdir $$@)
	@$(MKDIR) -p $$(dir $$@)
	$(veryquiet)m4 \
	  -I$(BASE_DIRECTORY)/module/$(1) \
	  -I$(RULES_DIRECTORY) \
	  -DTHIS_MODULE_NAME=\`$(1)\' \
	  $(addprefix -D,$(strip $(FEATURE_FLAGS) $(EVALUATED_FLAGS) $(VARDEF_NUMBER_RANGE_FLAGS))) \
	  $$< > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/includes/$(1)_module_defs.h : \
  $(RULES_DIRECTORY)/module_defs_h.m4 \
  $(RULES_DIRECTORY)/module_defs_clean.m4 \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/module_*.m4d) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile
	@echo $$(notdir $$@)
	$(veryquiet)m4 \
	  -I$(BASE_DIRECTORY)/module/$(1) \
	  -I$(RULES_DIRECTORY) \
	  -DTHIS_MODULE_NAME=\`$(1)\' \
	  $(addprefix -D,$(strip $(FEATURE_FLAGS) $(EVALUATED_FLAGS) $(VARDEF_NUMBER_RANGE_FLAGS))) \
	  $$< > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/module_defs.c : \
  $(RULES_DIRECTORY)/module_defs_c.m4 \
  $(RULES_DIRECTORY)/module_defs_clean.m4 \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/module_*.m4d) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile
	@echo $$(notdir $$@)
	@$(MKDIR) -p $$(dir $$@)
	$(veryquiet)m4 \
	  -I$(BASE_DIRECTORY)/module/$(1) \
	  -I$(RULES_DIRECTORY) \
	  -DTHIS_MODULE_NAME=\`$(1)\' \
	  $(addprefix -D,$(strip $(FEATURE_FLAGS) $(EVALUATED_FLAGS) $(VARDEF_NUMBER_RANGE_FLAGS))) \
	  $$< > $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/libraries/$(1)_module_libs.o : \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/objects/$(call MANGLE,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)_module_libs.o)
	@echo $$(notdir $$@)
	$(veryquiet)cp -f -T $$< $$@

BINARY_EMBEDDED :=
-include $(BASE_DIRECTORY)/module/$(1)/bom/binary_embedded.make

PREPROC_EMBEDDED :=
-include $(BASE_DIRECTORY)/module/$(1)/bom/preproc_embedded.make

GZIP_EMBEDDED :=
-include $(BASE_DIRECTORY)/module/$(1)/bom/gzip_embedded.make

$(1)_EMBEDDED_FILES := $$(BINARY_EMBEDDED) $$(PREPROC_EMBEDDED)

$$(foreach FILE,$$(GZIP_EMBEDDED),$$(eval $$(call GZIP_template,$(1),$$(FILE))))

include $(BASE_DIRECTORY)/module/$(1)/bom/cfiles.make
MODULE_C_COMPILE_SOURCES := $$(CFILES)
MODULE_C_COMPILE_SOURCES += $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/module_defs.c
MODULE_C_COMPILE_SOURCES += $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/module_datetime.c
MODULE_C_COMPILE_SOURCES += \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded_files.c \
  $$(addprefix $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded/c/, \
    $$(addsuffix .c, $$(call PRUNE_TO_MODULE_DIRECTORY,$$($(1)_EMBEDDED_FILES))) \
  )

$$(foreach FILE,$$(BINARY_EMBEDDED),$$(eval $$(call COPY_template,$(1),$$(FILE))))
$$(foreach FILE,$$(PREPROC_EMBEDDED),$$(eval $$(call PREPROCESS_template,$(1),$$(FILE))))
$$(foreach FILE,$$($(1)_EMBEDDED_FILES),$$(eval $$(call BUILD_FILE_STRUCT_template,$(1),$$(FILE))))

MODULE_ASM_SOURCES := $$(ASMFILES)

ALL_C_COMPILE_SOURCES += \
  $$(MODULE_C_COMPILE_SOURCES) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)_module_libs.c

ALL_ASM_SOURCES += $$(MODULE_ASM_SOURCES)

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded_files.c: \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/bom/binary_embedded.make) \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/bom/preproc_embedded.make) \
  $(wildcard $(BASE_DIRECTORY)/module/$(1)/bom/gzip_embedded.make) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile
	@echo $$(basename $$@)
	@$(MKDIR) -p $$(dir $$@)
	@echo "/* Generated by makefile */" > $$@
	@echo "#include \"ltrx_embedded_files.h\"" >> $$@
	@echo >> $$@
	@echo "#define EMBEDDED_FILE_REFERENCE(x) Embedded_file_ ## x ## _contents" >> $$@
	@echo >> $$@
	@for f in $$(subst /,_slash_,$$(subst .,_dot_,$$(call PRUNE_TO_MODULE_DIRECTORY,$$($(1)_EMBEDDED_FILES)))); do \
	    echo "$$$$f" ; \
	done | sort | awk -v vpath="" -v dpath="" -f $(RULES_DIRECTORY)/embedded_files1.awk >> $$@
	@echo >> $$@
	@echo "const struct ltrx_embedded_file * const g_Embedded_file_contents[] = {" >> $$@
	@for f in $$(subst /,_slash_,$$(subst .,_dot_,$$(call PRUNE_TO_MODULE_DIRECTORY,$$($(1)_EMBEDDED_FILES)))); do \
	    echo "$$$$f" ; \
	done | sort | awk -v vpath="" -v dpath="" -f $(RULES_DIRECTORY)/embedded_files2.awk >> $$@
	@echo "    0 /* No more files */" >> $$@
	@echo "};" >> $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/module_datetime.c : \
  $(RULES_DIRECTORY)/module_datetime.c \
  $$(CFILES) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/module_defs.c
	@echo $$@
	@cp -T $$< $$@

$(1)_OBJECTS := \
  $$(addprefix $(WORK_DIRECTORY)/$(PROJECT_NAME)/objects/,$$(call MANGLE,$$(MODULE_C_COMPILE_SOURCES:.c=.o))) \
  $$(addprefix $(WORK_DIRECTORY)/$(PROJECT_NAME)/objects/,$$(call MANGLE,$$(MODULE_ASM_SOURCES:.s=.o)))

-include $(BASE_DIRECTORY)/module/$(1)/extend.make

endef # MODULE_DEFINES_template

define MODULE_SELECT_template

ifeq ($(1),main)

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).elf: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/$(1)$(2).elf
	@echo $$(notdir $$@)
	@$(MKDIR) -p $$(dir $$@)
	@cp -f $$< $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).stripped.elf: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).elf
	@echo $$(notdir $$@)
	@$(STRIP) --strip-all $$< -o $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).bin: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).stripped.elf
	@echo $$(notdir $$@)
	@$(OBJCOPY) -O binary -R .comment -R .ARM.attributes $$< $$@

else

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).elf: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/$(1)$(2).elf \
  $(LD_DIRECTORY)/module_final.ld \
  $(PREVIOUS_ELF_FILE)
	@echo $$(notdir $$@)
	@$(MKDIR) -p $$(dir $$@)
	$(quiet)$(CC) \
	  $$(LDFLAGS) -Wl,-Map,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).map \
	  -Wl,-T $(LD_DIRECTORY)/module_final.ld \
	  -Wl,--defsym,ltrx_linker_module_$(1)_flash_end=ltrx_linker_module_flash_end \
	  -Wl,--defsym,ltrx_linker_module_$(1)_ram_end=ltrx_linker_module_ram_end \
	  -Wl,--start-group \
	  -Ttext $$(call SYMBOL_VALUE,$(PREVIOUS_ELF_FILE),ltrx_linker_module_$(PREVIOUS_MODULE)_flash_end) \
	  -Tdata $$(call SYMBOL_VALUE,$(PREVIOUS_ELF_FILE),ltrx_linker_module_$(PREVIOUS_MODULE)_ram_end) \
	  $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/$(1)$(2).elf \
	  -Wl,--end-group \
	  -o $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).stripped.elf: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).elf
	@echo $$(notdir $$@)
	$(quiet)$(STRIP) --strip-all $$< -o $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).bin: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).stripped.elf
	@echo $$(notdir $$@)
	$(quiet)$(OBJCOPY) -O binary -R .comment -R .ARM.attributes $$< $$@

endif

PREVIOUS_ELF_FILE := $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).elf
PREVIOUS_MODULE := $(1)

endef # MODULE_SELECT_template

define MODULE_UNSELECT_template
$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1)$(2).elf: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/$(1)$(2).elf \
  $(LD_DIRECTORY)/module_final.ld
	@echo ; echo UNSELECT LINK $$@
	$(quiet)$(MKDIR) -p $$(dir $$@)
	$(quiet)$(CC) \
	  $$(LDFLAGS) -Wl,-Map,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/$(1).map \
	  -Wl,-T $(LD_DIRECTORY)/module_final.ld \
	  -Wl,--defsym,ltrx_linker_module_$(1)_flash_end=ltrx_linker_module_flash_end \
	  -Wl,--defsym,ltrx_linker_module_$(1)_ram_end=ltrx_linker_module_ram_end \
	  -Wl,--start-group \
	  -Ttext 0x0 \
	  -Tdata 0x0 \
	  $$< \
	  -Wl,--end-group \
	  -o $$@
endef

ALL_GENERATED_HEADERS := \
  $(foreach \
    MODULE, \
    $(ALL_MODULE_NAMES), \
    $(WORK_DIRECTORY)/$(PROJECT_NAME)/includes/$(strip $(MODULE))_module_defs.h \
    $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/includes/$(strip $(MODULE))_module_definitions.h \
    $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/includes/$(strip $(MODULE))_module_libs.h \
  ) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/includes/all_of_the_module_definitions.h \

DEPENDENCY_INCLUDES = \
  $(addprefix -isystem ,$(SYSTEM_INCLUDES)) \
  $(addprefix -I,$(strip \
    $(dir $(1)) \
    $(PROJECT_INCLUDES) \
    $(wildcard $(addsuffix /includes,$(addprefix $(BASE_DIRECTORY)/module/,$(firstword $(subst /, ,$(patsubst $(BASE_DIRECTORY)/module/%,%,$(filter $(BASE_DIRECTORY)/module/%,$(1)))))))) \
    $($(firstword $(subst /, ,$(patsubst $(BASE_DIRECTORY)/module/%,%,$(filter $(BASE_DIRECTORY)/module/%,$(1)))))_INCLUDE_PATHS) \
  )) \

SYMBOL_VALUE = 0x$(shell $(OBJDUMP) -t $(1) | grep $(2) | cut -c1-8)

MODULE_ORDERED_NAMES := $(filter main,$(MODULE_NAMES)) $(filter-out main $(EXCLUDED_MODULES),$(MODULE_NAMES))

#
# Project final images
#
define PROJECT_IMAGE_template

$(WORK_DIRECTORY)/$(PROJECT_NAME)/project/project$(1).bin: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/main$(1).bin \
  $$(foreach MODULE,$$(filter-out main,$(MODULE_ORDERED_NAMES)), \
    $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$$(MODULE)/$$(MODULE)$(1).bin \
  ) \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile
	@echo $$(notdir $$@)
	@$(RM) $$@
	$(veryquiet)cat $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/main$(1).bin > $$@
	$(veryquiet)$$(foreach MODULE,$$(filter-out main,$(MODULE_ORDERED_NAMES)), \
	  cat \
	  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$$(MODULE)/$$(MODULE)$(1).bin \
	  >> $$@; \
	)
	@echo >> $$@

$(WORK_DIRECTORY)/$(PROJECT_NAME)/project/project$(1).rom: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/project$(1).bin \
  $(MKIMAGE)
	@echo $$(notdir $$@)
	$(MKIMAGE) \
	  -m -o -u$(PARTITION_SIZE) -a$$(INSTALL_ADDRESS_FW$(1)) \
	  -x$(LOAD_ADDRESS_FW) -r$(TARGET_VERSION) -i$(PRODUCT_ID) \
	  -p$$(BOOTLOADER_LOAD_LENGTH$(1)) -q$$(BOOTLOADER_LOAD_OFFSET$(1)) \
	  -s$(ENTRY_POINT_OFFSET) $(2) -t3 $$<

$(WORK_DIRECTORY)/$(PROJECT_NAME)/$(TARGET_NAME)$(1).rom: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/project$(1).rom
	@echo $$(notdir $$@)
	$(quiet)cp -f $$< $$@

endef

#
# Final Image
#
define PROJECT_IMAGE_HASH_template

$(WORK_DIRECTORY)/$(PROJECT_NAME)/$(1).sha256: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/$(1).rom
	@echo $$(notdir $$@)
	$(quiet)sha256sum $$< > $$@

endef

ifeq ($(words $(PARTITION_NAMES)),0)

$(eval $(call PROJECT_IMAGE_template,))

else

$(WORK_DIRECTORY)/$(PROJECT_NAME)/$(TARGET_NAME).rom: \
  $(foreach PART,$(PARTITION_NAMES), \
    $(WORK_DIRECTORY)/$(PROJECT_NAME)/$(TARGET_NAME)$(PART).rom \
  ) \
  $(MKIMAGE)
	@echo $(notdir $@)
	$(MKIMAGE) -c $@ $(foreach PART,$(PARTITION_NAMES),$(WORK_DIRECTORY)/$(PROJECT_NAME)/$(TARGET_NAME)$(PART).rom)

$(foreach PNUM,$(PARTITION_NUMBERS),\
  $(eval \
    $(call PROJECT_IMAGE_template,$(word $(PNUM),$(PARTITION_NAMES)),-w$(PNUM))\
  )\
  $(eval \
    $(call PROJECT_IMAGE_HASH_template,$(TARGET_NAME)$(word $(PNUM),$(PARTITION_NAMES)))\
  )\
)

endif

$(eval $(call PROJECT_IMAGE_HASH_template,$(TARGET_NAME)))

-include $(ENV_DIRECTORY)/config.make

ifeq ($(filter clean doc $(cfg_targets) $(jtag_targets) midas eclipse,$(MAKECMDGOALS)),)
define MODULE_IMAGE_DEFINES_template
$$(foreach MODULE,$(ALL_UNEXCLUDED_MODULE_NAMES),$$(eval $$(call MODULE_DEFINES_LINK_template,$$(strip $$(MODULE)),$(1))))
endef
ifeq ($(words $(PARTITION_NAMES)),0)
$(foreach MODULE,$(ALL_MODULE_NAMES),$(eval $(call MODULE_DEFINES_template,$(strip $(MODULE)))))
$(foreach MODULE,$(ALL_UNEXCLUDED_MODULE_NAMES),$(eval $(call MODULE_DEFINES_LINK_template,$(strip $(MODULE)))))
else
$(foreach MODULE,$(ALL_MODULE_NAMES),$(eval $(call MODULE_DEFINES_template,$(strip $(MODULE)),$(lastword $(PARTITION_NAMES)))))
$(foreach PART,$(PARTITION_NAMES),$(eval $(call MODULE_IMAGE_DEFINES_template,$(PART))))
endif

define MODULE_IMAGE_SELECT_template
$$(foreach MODULE,$(MODULE_ORDERED_NAMES),$$(eval $$(call MODULE_SELECT_template,$$(strip $$(MODULE)),$(1))))
endef
ifeq ($(words $(PARTITION_NAMES)),0)
$(foreach MODULE,$(MODULE_ORDERED_NAMES),$(eval $(call MODULE_SELECT_template,$(strip $(MODULE)))))
else
$(foreach PART,$(PARTITION_NAMES),$(eval $(call MODULE_IMAGE_SELECT_template,$(PART))))
endif

define MODULE_IMAGE_UNSELECT_template
$$(foreach MODULE,$(filter-out $(MODULE_ORDERED_NAMES),$(ALL_UNEXCLUDED_MODULE_NAMES)),$$(eval $$(call MODULE_UNSELECT_template,$$(strip $$(MODULE)),$(1))))
endef
ifeq ($(words $(PARTITION_NAMES)),0)
$(foreach MODULE,$(filter-out $(MODULE_ORDERED_NAMES),$(ALL_UNEXCLUDED_MODULE_NAMES)),$(eval $(call MODULE_UNSELECT_template,$(strip $(MODULE)))))
else
$(foreach PART,$(PARTITION_NAMES),$(eval $(call MODULE_IMAGE_UNSELECT_template,$(PART))))
endif
$(foreach FILE,$(ALL_C_COMPILE_SOURCES),$(eval $(call C_DEPENDENCY_template,$(FILE))))
$(foreach FILE,$(ALL_C_COMPILE_SOURCES),$(eval $(call C_SOURCE_template,$(FILE))))
$(foreach FILE,$(CFILES),$(eval $(call C_SOURCE_check_template,$(FILE))))
$(foreach FILE,$(ALL_ASM_SOURCES),$(eval $(call ASM_SOURCE_template,$(FILE))))
endif # target filter
