/* This file is automatically generated. */
/* DO NOT EDIT. */

#pragma once

/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright 2015-2025, Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the License Agreement).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi product.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*****************************************************************************/
/*                             Includes                                      */
/*****************************************************************************/

#include <stdarg.h>
#include <stdint.h>
#include <stdbool.h>
#include "ltrx_cfgvar.h"

/*****************************************************************************/
/*                       Generated Definitions                               */
/*****************************************************************************/

/* From define_external_include declarations: */

                                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
/* Structures referenced by define_external_function declarations: */

struct ltrx_network_protocol_handle;
struct input_stream;
struct input_stream_from_varid;                                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                

struct security_external_functions
{

    bool (*ltrx_tls_set_trusted_authorities)(
        struct ltrx_network_protocol_handle *lnph,
        const char * const *trustedAuthArray
    );
    bool (*ltrx_ssl_credential_is_present)(
        const char *credential
    );
    struct input_stream * (*ltrx_ssl_client_credential_trusted_authority)(
        struct input_stream_from_varid *inStream,
        const char *credential,
        uint32_t zeroBasedTrustedAuthIndex
    );
    struct input_stream * (*ltrx_ssl_server_credential_private_key)(
        struct input_stream_from_varid *inStream,
        const char *credential
    );
    struct input_stream * (*ltrx_ssl_server_credential_certificate)(
        struct input_stream_from_varid *inStream,
        const char *credential
    );
    struct input_stream * (*ltrx_ssl_server_credential_higher_authority)(
        struct input_stream_from_varid *inStream,
        const char *credential,
        uint32_t zeroBasedHigherAuthIndex
    );
    uint32_t (*ltrx_ssl_credential_get_protocols)(
        const char *credential
    );
    bool (*ltrx_SHA512_allocDigest)(
        void **pSha512Ctx
    );
    bool (*ltrx_SHA512_freeDigest)(
        void *pSha512Ctx
    );
    bool (*ltrx_SHA512_initDigest)(
        void *pSha512Ctx
    );
    bool (*ltrx_SHA512_updateDigest)(
        void *pSha512Ctx,
        const char *pData,
        uint32_t dataLen
    );
    bool (*ltrx_SHA512_finalDigest)(
        void *pSha512Ctx,
        char *pShaOutput
    );
    bool (*ltrx_SHA512_completeDigest)(
        const char *pData,
        uint32_t dataLen,
        char *pShaOutput
    );                                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
};

/* From vardef declarations: */


/* Begin index TLS Credential */
#define VARDEF_ELEMENT_GROUP_TLS_CREDENTIAL 1  
    
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_INSTANCE 2
#define VARDEF_NUMBER_217_HAS_ALREADY_BEEN_USED security-2  
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_INSTANCE_STRLEN_MAX 30
    
#define VARDEF_BITFLAG_TLS_CREDENTIAL_PROTOCOLS__TLS1_0 1
#define VARDEF_BITFLAG_TLS_CREDENTIAL_PROTOCOLS__TLS1_1 2
#define VARDEF_BITFLAG_TLS_CREDENTIAL_PROTOCOLS__TLS1_2 3

#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_PROTOCOLS 3
#define VARDEF_NUMBER_224_HAS_ALREADY_BEEN_USED security-3 
    
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_APPLICATION_LAYER_PROTOCOL 4
#define VARDEF_NUMBER_258_HAS_ALREADY_BEEN_USED security-4  
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_APPLICATION_LAYER_PROTOCOL_STRLEN_MAX 255
    
/* Begin index Ciphers */
#define VARDEF_ELEMENT_GROUP_TLS_CREDENTIAL_CIPHERS 5  
        
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 7
#define VARDEF_NUMBER_364_HAS_ALREADY_BEEN_USED security-7 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 8
#define VARDEF_NUMBER_369_HAS_ALREADY_BEEN_USED security-8 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 9
#define VARDEF_NUMBER_362_HAS_ALREADY_BEEN_USED security-9 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 10
#define VARDEF_NUMBER_363_HAS_ALREADY_BEEN_USED security-10 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 11
#define VARDEF_NUMBER_378_HAS_ALREADY_BEEN_USED security-11 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 12
#define VARDEF_NUMBER_379_HAS_ALREADY_BEEN_USED security-12 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 13
#define VARDEF_NUMBER_365_HAS_ALREADY_BEEN_USED security-13 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 14
#define VARDEF_NUMBER_366_HAS_ALREADY_BEEN_USED security-14 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA_1 15
#define VARDEF_NUMBER_367_HAS_ALREADY_BEEN_USED security-15 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA_1 16
#define VARDEF_NUMBER_368_HAS_ALREADY_BEEN_USED security-16 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 17
#define VARDEF_NUMBER_410_HAS_ALREADY_BEEN_USED security-17 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 18
#define VARDEF_NUMBER_411_HAS_ALREADY_BEEN_USED security-18 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA_1 19
#define VARDEF_NUMBER_412_HAS_ALREADY_BEEN_USED security-19 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA_1 20
#define VARDEF_NUMBER_413_HAS_ALREADY_BEEN_USED security-20 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 21
#define VARDEF_NUMBER_418_HAS_ALREADY_BEEN_USED security-21 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 22
#define VARDEF_NUMBER_416_HAS_ALREADY_BEEN_USED security-22 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 23
#define VARDEF_NUMBER_417_HAS_ALREADY_BEEN_USED security-23 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 24
#define VARDEF_NUMBER_377_HAS_ALREADY_BEEN_USED security-24 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_DHE_RSA_WITH_AES_256_CBC_SHA_1 25
#define VARDEF_NUMBER_376_HAS_ALREADY_BEEN_USED security-25 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 26
#define VARDEF_NUMBER_375_HAS_ALREADY_BEEN_USED security-26 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_DHE_RSA_WITH_AES_128_CBC_SHA_1 27
#define VARDEF_NUMBER_374_HAS_ALREADY_BEEN_USED security-27 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_RSA_WITH_AES_256_GCM_SHA384 28
#define VARDEF_NUMBER_414_HAS_ALREADY_BEEN_USED security-28 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_RSA_WITH_AES_128_GCM_SHA256 29
#define VARDEF_NUMBER_415_HAS_ALREADY_BEEN_USED security-29 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_RSA_WITH_AES_256_CBC_SHA256 30
#define VARDEF_NUMBER_370_HAS_ALREADY_BEEN_USED security-30 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_RSA_WITH_AES_256_CBC_SHA_1 31
#define VARDEF_NUMBER_371_HAS_ALREADY_BEEN_USED security-31 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_RSA_WITH_AES_128_CBC_SHA256 32
#define VARDEF_NUMBER_372_HAS_ALREADY_BEEN_USED security-32 
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CIPHERS_TLS_RSA_WITH_AES_128_CBC_SHA_1 33
#define VARDEF_NUMBER_373_HAS_ALREADY_BEEN_USED security-33  
    
/* End index Ciphers */
#define VARDEF_ELEMENT_END_TLS_CREDENTIAL_CIPHERS 34  
    
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_PRIVATE_KEY 35
#define VARDEF_NUMBER_221_HAS_ALREADY_BEEN_USED security-35  
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_PRIVATE_KEY_STRLEN_MAX 4000
    
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE 36
#define VARDEF_NUMBER_222_HAS_ALREADY_BEEN_USED security-36  
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_STRLEN_MAX 4000
    
/* Begin index -pkcs12 */
#define VARDEF_ELEMENT_GROUP_TLS_CREDENTIAL__PKCS12 37  
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL__PKCS12_UPLOADED_PKCS12 38
#define VARDEF_NUMBER_257_HAS_ALREADY_BEEN_USED security-38 
    
/* End index -pkcs12 */
#define VARDEF_ELEMENT_END_TLS_CREDENTIAL__PKCS12 39  
    
/* Begin index Higher Authority */
#define VARDEF_ELEMENT_GROUP_TLS_CREDENTIAL_HIGHER_AUTHORITY 40  
        
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_CERTIFICATE 42
#define VARDEF_NUMBER_223_HAS_ALREADY_BEEN_USED security-42  
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_CERTIFICATE_STRLEN_MAX 4000
    
/* End index Higher Authority */
#define VARDEF_ELEMENT_END_TLS_CREDENTIAL_HIGHER_AUTHORITY 43  
    
/* Begin index Trusted Authority */
#define VARDEF_ELEMENT_GROUP_TLS_CREDENTIAL_TRUSTED_AUTHORITY 44  
        
        
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_CERTIFICATE 46
#define VARDEF_NUMBER_218_HAS_ALREADY_BEEN_USED security-46  
#define VARDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_CERTIFICATE_STRLEN_MAX 4000
    
/* End index Trusted Authority */
#define VARDEF_ELEMENT_END_TLS_CREDENTIAL_TRUSTED_AUTHORITY 47  

struct vardef_values_tls_credential;
bool TlsCredentialTestSet(
    uint32_t zeroBasedIndex,
    struct vardef_values_tls_credential *config,
    bool set,
    const struct ltrx_write_user_message_info *lwumi
);
void TlsCredentialWarnings(
    uint32_t zeroBasedIndex,
    const struct ltrx_write_user_message_info *lwumi
);
/* End index TLS Credential */
#define VARDEF_ELEMENT_END_TLS_CREDENTIAL 48  

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
/* Structures for groups of data */


                                
                                                                                                                                                                                                                                                                        
                            
                
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
                                
                                                                                                                                                                                                                                                                        
                            
                
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
                                
                                                                                                                                                                                                                                                                        
                            
                
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
                                
                                                                                                                                                                                                                                                                        
                            
                
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
                        
struct vardef_values_tls_credential_ciphers {        
        
    bool tls_ecdhe_ecdsa_with_chacha20_poly1305_sha256;        
    bool tls_ecdhe_rsa_with_chacha20_poly1305_sha256;        
    bool tls_ecdhe_ecdsa_with_aes_256_gcm_sha384;        
    bool tls_ecdhe_rsa_with_aes_256_gcm_sha384;        
    bool tls_ecdhe_ecdsa_with_aes_128_gcm_sha256;        
    bool tls_ecdhe_rsa_with_aes_128_gcm_sha256;        
    bool tls_ecdhe_ecdsa_with_aes_256_cbc_sha384;        
    bool tls_ecdhe_rsa_with_aes_256_cbc_sha384;        
    bool tls_ecdhe_ecdsa_with_aes_256_cbc_sha_1;        
    bool tls_ecdhe_rsa_with_aes_256_cbc_sha_1;        
    bool tls_ecdhe_ecdsa_with_aes_128_cbc_sha256;        
    bool tls_ecdhe_rsa_with_aes_128_cbc_sha256;        
    bool tls_ecdhe_ecdsa_with_aes_128_cbc_sha_1;        
    bool tls_ecdhe_rsa_with_aes_128_cbc_sha_1;        
    bool tls_dhe_rsa_with_chacha20_poly1305_sha256;        
    bool tls_dhe_rsa_with_aes_256_gcm_sha384;        
    bool tls_dhe_rsa_with_aes_128_gcm_sha256;        
    bool tls_dhe_rsa_with_aes_256_cbc_sha256;        
    bool tls_dhe_rsa_with_aes_256_cbc_sha_1;        
    bool tls_dhe_rsa_with_aes_128_cbc_sha256;        
    bool tls_dhe_rsa_with_aes_128_cbc_sha_1;        
    bool tls_rsa_with_aes_256_gcm_sha384;        
    bool tls_rsa_with_aes_128_gcm_sha256;        
    bool tls_rsa_with_aes_256_cbc_sha256;        
    bool tls_rsa_with_aes_256_cbc_sha_1;        
    bool tls_rsa_with_aes_128_cbc_sha256;        
    bool tls_rsa_with_aes_128_cbc_sha_1;    
};
                    
struct vardef_values_tls_credential__pkcs12 {        
    bool uploaded_pkcs12;    
};
    
struct vardef_values_tls_credential_higher_authority {        
            
    char certificate[4000 + 1];    
};
    
struct vardef_values_tls_credential_trusted_authority {        
            
    char certificate[4000 + 1];    
};

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                

struct vardef_values_tls_credential {        
    char instance[30 + 1];    
    uint32_t protocols;        
    char application_layer_protocol[255 + 1];    
    struct vardef_values_tls_credential_ciphers ciphers;        
                                                                                                                                                                                                                                    
    char private_key[4000 + 1];        
    char certificate[4000 + 1];    
    struct vardef_values_tls_credential__pkcs12 _pkcs12;                
    struct vardef_values_tls_credential_higher_authority higher_authority[3];        
                    
    struct vardef_values_tls_credential_trusted_authority trusted_authority[5];        
                
};

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
/* From statusdef declarations: */

                                                                                                                                                                                                                                                                                                                            
 
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL 1 
    
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_INSTANCE 2  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_INSTANCE_STRLEN_MAX 30
     
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_CERTIFICATE 3 
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_INSTANCE 4  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_INSTANCE_STRLEN_MAX 1
                
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_VERSION 5 
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SERIAL_NUMBER 6  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SERIAL_NUMBER_STRLEN_MAX 48
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SIGNATURE_ALGORITHM 7  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SIGNATURE_ALGORITHM_STRLEN_MAX 26
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_CERTIFICATE_ISSUER 8 
             
/* statusdef_summary 9 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_ISSUER_NAME 10  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_ISSUER_NAME_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_ISSUER_ORG 11  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_ISSUER_ORG_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_ISSUER_UNIT 12  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_ISSUER_UNIT_STRLEN_MAX 60
        
/* End index Issuer */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_CERTIFICATE_ISSUER 13         
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_BEGINS_ON 14  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_BEGINS_ON_STRLEN_MAX 18
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_EXPIRES_ON 15  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_EXPIRES_ON_STRLEN_MAX 18
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_CERTIFICATE_SUBJECT 16 
             
/* statusdef_summary 17 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SUBJECT_NAME 18  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SUBJECT_NAME_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SUBJECT_ORG 19  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SUBJECT_ORG_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SUBJECT_UNIT 20  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_SUBJECT_UNIT_STRLEN_MAX 60
        
/* End index Subject */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_CERTIFICATE_SUBJECT 21         
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_PUBLIC_KEY_ALGORITHM 22  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_PUBLIC_KEY_ALGORITHM_STRLEN_MAX 14
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_PUBLIC_KEY_SIZE 23  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_PUBLIC_KEY_SIZE_STRLEN_MAX 10
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS 24 
             
/* statusdef_summary 25 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS_IS_CRITICAL 26 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS_IS_CRITICAL__FALSE 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS_IS_CRITICAL__TRUE 1 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS_CA 27 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS_CA__NOT_PRESENT 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS_CA__FALSE 1 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS_CA__TRUE 2 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS_PATH_LENGTH 28 
        
/* End index Basic Constraints */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_CERTIFICATE_BASIC_CONSTRAINTS 29          
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_CERTIFICATE_KEY_USAGE 30 
             
/* statusdef_summary 31 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_KEY_USAGE_IS_PRESENT 32 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_CERTIFICATE_KEY_USAGE_IS_PRESENT__FALSE 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_CERTIFICATE_KEY_USAGE_IS_PRESENT__TRUE 1 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_KEY_USAGE_BITS 33  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_CERTIFICATE_KEY_USAGE_BITS_STRLEN_MAX 6
        
/* End index Key Usage */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_CERTIFICATE_KEY_USAGE 34     
/* End index Certificate */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_CERTIFICATE 35      
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_HIGHER_AUTHORITY 36 
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_INSTANCE 37  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_INSTANCE_STRLEN_MAX 2
                
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_VERSION 38 
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SERIAL_NUMBER 39  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SERIAL_NUMBER_STRLEN_MAX 48
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SIGNATURE_ALGORITHM 40  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SIGNATURE_ALGORITHM_STRLEN_MAX 26
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_HIGHER_AUTHORITY_ISSUER 41 
             
/* statusdef_summary 42 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_ISSUER_NAME 43  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_ISSUER_NAME_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_ISSUER_ORG 44  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_ISSUER_ORG_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_ISSUER_UNIT 45  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_ISSUER_UNIT_STRLEN_MAX 60
        
/* End index Issuer */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_HIGHER_AUTHORITY_ISSUER 46         
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BEGINS_ON 47  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BEGINS_ON_STRLEN_MAX 18
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_EXPIRES_ON 48  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_EXPIRES_ON_STRLEN_MAX 18
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_HIGHER_AUTHORITY_SUBJECT 49 
             
/* statusdef_summary 50 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SUBJECT_NAME 51  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SUBJECT_NAME_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SUBJECT_ORG 52  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SUBJECT_ORG_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SUBJECT_UNIT 53  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_SUBJECT_UNIT_STRLEN_MAX 60
        
/* End index Subject */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_HIGHER_AUTHORITY_SUBJECT 54         
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_PUBLIC_KEY_ALGORITHM 55  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_PUBLIC_KEY_ALGORITHM_STRLEN_MAX 14
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_PUBLIC_KEY_SIZE 56  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_PUBLIC_KEY_SIZE_STRLEN_MAX 10
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS 57 
             
/* statusdef_summary 58 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS_IS_CRITICAL 59 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS_IS_CRITICAL__FALSE 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS_IS_CRITICAL__TRUE 1 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS_CA 60 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS_CA__NOT_PRESENT 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS_CA__FALSE 1 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS_CA__TRUE 2 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS_PATH_LENGTH 61 
        
/* End index Basic Constraints */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_HIGHER_AUTHORITY_BASIC_CONSTRAINTS 62          
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_HIGHER_AUTHORITY_KEY_USAGE 63 
             
/* statusdef_summary 64 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_KEY_USAGE_IS_PRESENT 65 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_HIGHER_AUTHORITY_KEY_USAGE_IS_PRESENT__FALSE 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_HIGHER_AUTHORITY_KEY_USAGE_IS_PRESENT__TRUE 1 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_KEY_USAGE_BITS 66  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_HIGHER_AUTHORITY_KEY_USAGE_BITS_STRLEN_MAX 6
        
/* End index Key Usage */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_HIGHER_AUTHORITY_KEY_USAGE 67     
/* End index Higher Authority */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_HIGHER_AUTHORITY 68      
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_TRUSTED_AUTHORITY 69 
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_INSTANCE 70  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_INSTANCE_STRLEN_MAX 2
                
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_VERSION 71 
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SERIAL_NUMBER 72  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SERIAL_NUMBER_STRLEN_MAX 48
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SIGNATURE_ALGORITHM 73  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SIGNATURE_ALGORITHM_STRLEN_MAX 26
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_TRUSTED_AUTHORITY_ISSUER 74 
             
/* statusdef_summary 75 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_ISSUER_NAME 76  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_ISSUER_NAME_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_ISSUER_ORG 77  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_ISSUER_ORG_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_ISSUER_UNIT 78  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_ISSUER_UNIT_STRLEN_MAX 60
        
/* End index Issuer */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_TRUSTED_AUTHORITY_ISSUER 79         
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BEGINS_ON 80  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BEGINS_ON_STRLEN_MAX 18
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_EXPIRES_ON 81  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_EXPIRES_ON_STRLEN_MAX 18
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SUBJECT 82 
             
/* statusdef_summary 83 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SUBJECT_NAME 84  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SUBJECT_NAME_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SUBJECT_ORG 85  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SUBJECT_ORG_STRLEN_MAX 60
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SUBJECT_UNIT 86  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SUBJECT_UNIT_STRLEN_MAX 60
        
/* End index Subject */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_TRUSTED_AUTHORITY_SUBJECT 87         
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_PUBLIC_KEY_ALGORITHM 88  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_PUBLIC_KEY_ALGORITHM_STRLEN_MAX 14
        
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_PUBLIC_KEY_SIZE 89  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_PUBLIC_KEY_SIZE_STRLEN_MAX 10
         
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS 90 
             
/* statusdef_summary 91 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS_IS_CRITICAL 92 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS_IS_CRITICAL__FALSE 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS_IS_CRITICAL__TRUE 1 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS_CA 93 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS_CA__NOT_PRESENT 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS_CA__FALSE 1 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS_CA__TRUE 2 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS_PATH_LENGTH 94 
        
/* End index Basic Constraints */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_TRUSTED_AUTHORITY_BASIC_CONSTRAINTS 95          
#define STATUSDEF_ELEMENT_GROUP_TLS_CREDENTIAL_TRUSTED_AUTHORITY_KEY_USAGE 96 
             
/* statusdef_summary 97 */ 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_KEY_USAGE_IS_PRESENT 98 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_KEY_USAGE_IS_PRESENT__FALSE 0 
#define STATUSDEF_ENUM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_KEY_USAGE_IS_PRESENT__TRUE 1 
            
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_KEY_USAGE_BITS 99  
#define STATUSDEF_ELEMENT_ITEM_TLS_CREDENTIAL_TRUSTED_AUTHORITY_KEY_USAGE_BITS_STRLEN_MAX 6
        
/* End index Key Usage */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_TRUSTED_AUTHORITY_KEY_USAGE 100     
/* End index Trusted Authority */ 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL_TRUSTED_AUTHORITY 101 
/* End index TLS Credential */
struct statusdef_values_tls_credential;
void TlsCredentialGetStatus(
    uint32_t zeroBasedIndex,
    struct statusdef_values_tls_credential *status,
    const struct ltrx_write_user_message_info *lwumi
); 
#define STATUSDEF_ELEMENT_END_TLS_CREDENTIAL 102 
    
         
        
#define STATUSDEF_ENUM_TLS_DISPLAY_CIPHER_SUPPORTED__NO 0 
#define STATUSDEF_ENUM_TLS_DISPLAY_CIPHER_SUPPORTED__YES 1 
        
#define STATUSDEF_ENUM_TLS_DISPLAY_CIPHER_MINIMUM_VERSION__SSLV3 0 
#define STATUSDEF_ENUM_TLS_DISPLAY_CIPHER_MINIMUM_VERSION__TLS1_0 1 
#define STATUSDEF_ENUM_TLS_DISPLAY_CIPHER_MINIMUM_VERSION__TLS1_1 2 
#define STATUSDEF_ENUM_TLS_DISPLAY_CIPHER_MINIMUM_VERSION__TLS1_2 3 
        
    
/* End index Cipher */
/* End index TLS Display */
struct statusdef_values_tls_display;
void TlsDisplayGetStatus(
    uint32_t zeroBasedIndex,
    struct statusdef_values_tls_display *status,
    const struct ltrx_write_user_message_info *lwumi
);
    
        
        
#define STATUSDEF_ENUM_TLS_SOCKETS_SOCKET_TYPE__SERVER 0 
#define STATUSDEF_ENUM_TLS_SOCKETS_SOCKET_TYPE__CLIENT 1 
        
#define STATUSDEF_ENUM_TLS_SOCKETS_SOCKET_STATE__DISABLED 0 
#define STATUSDEF_ENUM_TLS_SOCKETS_SOCKET_STATE__CLOSED 1 
#define STATUSDEF_ENUM_TLS_SOCKETS_SOCKET_STATE__NEGOTIATING 2 
#define STATUSDEF_ENUM_TLS_SOCKETS_SOCKET_STATE__OPEN 3 
        
#define STATUSDEF_ENUM_TLS_SOCKETS_SOCKET_TLS_SOCKET__NO 0 
#define STATUSDEF_ENUM_TLS_SOCKETS_SOCKET_TLS_SOCKET__YES 1 
         
        
         
        
    
/* End index Socket */
/* End index TLS Sockets */
struct statusdef_values_tls_sockets;
void TlsSocketsGetStatus(
    uint32_t zeroBasedIndex,
    struct statusdef_values_tls_sockets *status,
    const struct ltrx_write_user_message_info *lwumi
);
/* Structures for groups of status */


                                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
                                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
                                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
                                                                                                                                                                                                                                                                                                                            
                                                                        
struct statusdef_values_tls_credential_certificate_issuer {                            
    char name[60 + 1];                
    char org[60 + 1];                
    char unit[60 + 1];        
};
                                
struct statusdef_values_tls_credential_certificate_subject {                            
    char name[60 + 1];                
    char org[60 + 1];                
    char unit[60 + 1];        
};
                                
struct statusdef_values_tls_credential_certificate_basic_constraints {                        
    uint8_t is_critical;            
    uint8_t ca;            
    int8_t path_length;        
};
        
struct statusdef_values_tls_credential_certificate_key_usage {                        
    uint8_t is_present;                
    char bits[6 + 1];        
};
                                                                    
struct statusdef_values_tls_credential_higher_authority_issuer {                            
    char name[60 + 1];                
    char org[60 + 1];                
    char unit[60 + 1];        
};
                                
struct statusdef_values_tls_credential_higher_authority_subject {                            
    char name[60 + 1];                
    char org[60 + 1];                
    char unit[60 + 1];        
};
                                
struct statusdef_values_tls_credential_higher_authority_basic_constraints {                        
    uint8_t is_critical;            
    uint8_t ca;            
    int8_t path_length;        
};
        
struct statusdef_values_tls_credential_higher_authority_key_usage {                        
    uint8_t is_present;                
    char bits[6 + 1];        
};
                                                                    
struct statusdef_values_tls_credential_trusted_authority_issuer {                            
    char name[60 + 1];                
    char org[60 + 1];                
    char unit[60 + 1];        
};
                                
struct statusdef_values_tls_credential_trusted_authority_subject {                            
    char name[60 + 1];                
    char org[60 + 1];                
    char unit[60 + 1];        
};
                                
struct statusdef_values_tls_credential_trusted_authority_basic_constraints {                        
    uint8_t is_critical;            
    uint8_t ca;            
    int8_t path_length;        
};
        
struct statusdef_values_tls_credential_trusted_authority_key_usage {                        
    uint8_t is_present;                
    char bits[6 + 1];        
};
                                                                                                                                
                                                                                                                                                                                                                                                                                                                            
            
struct statusdef_values_tls_credential_certificate {            
    char instance[1 + 1];                
    uint8_t version;            
    char serial_number[48 + 1];            
    char signature_algorithm[26 + 1];        
    struct statusdef_values_tls_credential_certificate_issuer issuer;                                                                                
    char begins_on[18 + 1];            
    char expires_on[18 + 1];        
    struct statusdef_values_tls_credential_certificate_subject subject;                                                                                
    char public_key_algorithm[14 + 1];            
    char public_key_size[10 + 1];        
    struct statusdef_values_tls_credential_certificate_basic_constraints basic_constraints;                                                                
    struct statusdef_values_tls_credential_certificate_key_usage key_usage;                                                    
};
    
struct statusdef_values_tls_credential_higher_authority {            
    char instance[2 + 1];                
    uint8_t version;            
    char serial_number[48 + 1];            
    char signature_algorithm[26 + 1];        
    struct statusdef_values_tls_credential_higher_authority_issuer issuer;                                                                                
    char begins_on[18 + 1];            
    char expires_on[18 + 1];        
    struct statusdef_values_tls_credential_higher_authority_subject subject;                                                                                
    char public_key_algorithm[14 + 1];            
    char public_key_size[10 + 1];        
    struct statusdef_values_tls_credential_higher_authority_basic_constraints basic_constraints;                                                                
    struct statusdef_values_tls_credential_higher_authority_key_usage key_usage;                                                    
};
    
struct statusdef_values_tls_credential_trusted_authority {            
    char instance[2 + 1];                
    uint8_t version;            
    char serial_number[48 + 1];            
    char signature_algorithm[26 + 1];        
    struct statusdef_values_tls_credential_trusted_authority_issuer issuer;                                                                                
    char begins_on[18 + 1];            
    char expires_on[18 + 1];        
    struct statusdef_values_tls_credential_trusted_authority_subject subject;                                                                                
    char public_key_algorithm[14 + 1];            
    char public_key_size[10 + 1];        
    struct statusdef_values_tls_credential_trusted_authority_basic_constraints basic_constraints;                                                                
    struct statusdef_values_tls_credential_trusted_authority_key_usage key_usage;                                                    
};
                                                                                                                            
                                                                                                                                                                                                                                                                                                                            

struct statusdef_values_tls_credential {        
    char instance[30 + 1];    
    struct statusdef_values_tls_credential_certificate certificate;                                                                                                                                                                                                                                                                                                                                                                                            
    struct statusdef_values_tls_credential_higher_authority higher_authority[3];                                                                                                                                                                                                                                                                                                                                                                                            
    struct statusdef_values_tls_credential_trusted_authority trusted_authority[5];                                                                                                                                                                                                                                                                                                                                                                                        
};
                                                                                                                            
extern const struct ltrx_module_info g_securityModuleInfo;

