# vim:tabstop=4:shiftwidth=4:softtabstop=0:noexpandtab

HOST_PLATFORM := $(shell uname)
ifeq ($(filter MINGW64_NT-% MSYS_NT-% Linux,$(HOST_PLATFORM)),)
$(error This platform is not supported: $(HOST_PLATFORM))
endif

ifeq ($(or $(filter clean dump erase download run reset config,$(MAKECMDGOALS)),$(MAKE_RESTARTS)),)
$(info Building on host platform $(HOST_PLATFORM))
endif

#
# Pick up command line args & defaults for build debug/log options
#
ocd_logpath := $(shell pwd)
ocd_logfile := $(ocd_logpath)/ocd.log
ocd_dbg :=

quiet_mkimage :=-qq
quiet_wget :=-q
veryquiet :=@

ifneq ($(VERBOSE),)
ifeq ($(filter 1 2 3,$(VERBOSE)),)
$(info NOTE: Only 3 verbose levels supported. Defaulting to level 1.)
verbose_debug := 1
else
verbose_debug := $(VERBOSE)
endif
quiet :=
quiet_wget := -nv
ocd_output :=
ifeq ($(verbose_debug),2)
quiet_mkimage :=-q
quiet_wget :=
ocd_dbg :=-d2
else ifeq ($(verbose_debug),3)
quiet_mkimage :=
quiet_wget := -v
ocd_dbg :=-d3
veryquiet :=
endif
else
quiet :=@
ocd_output := > $(ocd_logfile) 2>&1
endif

ifneq ($(OCDLOG),)
ocd_loglevel := $(OCDLOG)
else
ocd_loglevel := 0
endif

PROJECT_NAME := $(notdir $(abspath .))
PROJECT_ROOT_DIRECTORY := $(abspath ../../..)

BASE_DIRECTORY := $(PROJECT_ROOT_DIRECTORY)/custom
WORK_DIRECTORY := $(PROJECT_ROOT_DIRECTORY)/work
ifeq ($(HOST_PLATFORM),Linux)
BASE_NORMALIZED_DIRECTORY := $(BASE_DIRECTORY)
WORK_NORMALIZED_DIRECTORY := $(WORK_DIRECTORY)
else
BASE_NORMALIZED_DIRECTORY := $(shell [ -d $(BASE_DIRECTORY) ] && cd $(BASE_DIRECTORY) && pwd -W)
WORK_NORMALIZED_DIRECTORY := $(shell [ -d $(WORK_DIRECTORY) ] && cd $(WORK_DIRECTORY) && pwd -W)
endif


ENV_DIRECTORY := $(PROJECT_ROOT_DIRECTORY)/env
RULES_DIRECTORY := $(PROJECT_ROOT_DIRECTORY)/rules
LANTRONIX_DIRECTORY := $(PROJECT_ROOT_DIRECTORY)/lantronix
PROJECT_DIRECTORY := $(PROJECT_ROOT_DIRECTORY)/build
LD_DIRECTORY := $(LANTRONIX_DIRECTORY)

GENERATED_TOOLS_DIRECTORY := $(LANTRONIX_DIRECTORY)/bin

TARGET_NAME = $(PROJECT_NAME)_$(TARGET_VERSION)

export PROJECT_INCLUDES = \
  $(LANTRONIX_DIRECTORY)/includes/system \
  $(LANTRONIX_DIRECTORY)/includes \
  $(BASE_DIRECTORY)/includes \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/includes \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/includes \

#
# Define tools based on environment.
#
TOOLCHAIN_BASE_DIR := $(PROJECT_ROOT_DIRECTORY)/toolchain/gcc-arm-none-eabi
TOOLCHAIN_BIN_DIR := $(TOOLCHAIN_BASE_DIR)/bin
GCC_VERSION := $(shell $(TOOLCHAIN_BIN_DIR)/arm-none-eabi-gcc -dumpversion)
TOOLCHAIN_INC_DIR := $(TOOLCHAIN_BASE_DIR)/arm-none-eabi/include
TOOLCHAIN_LIB_INC_DIR := $(TOOLCHAIN_BASE_DIR)/lib/gcc/arm-none-eabi/$(GCC_VERSION)/include
TOOLCHAIN_LIB_INC_FIXED_DIR := $(TOOLCHAIN_BASE_DIR)/lib/gcc/arm-none-eabi/$(GCC_VERSION)/include-fixed
MKDIR := mkdir

CROSS := $(TOOLCHAIN_BIN_DIR)/arm-none-eabi-
CC := $(CROSS)gcc
LD := $(CROSS)ld
AR := $(CROSS)ar
AS := $(CROSS)as
STRIP := $(CROSS)strip
OBJCOPY := $(CROSS)objcopy
OBJDUMP := $(CROSS)objdump
SIZE := $(CROSS)size

SHORTENED_NAME = $(patsubst $(PROJECT_ROOT_DIRECTORY)/%,%,$(1))
MANGLE = $(subst /,__,$(subst ..,up,$(call SHORTENED_NAME,$(1))))

VARDEF_NUMBER_RANGE_FLAGS := \
  VARDEF_NUMBER_RANGE_MAX=59999 \
  VARDEF_NUMBER_RANGE_MIN=50000 \

SYSTEM_INCLUDES := \
  $(TOOLCHAIN_INC_DIR) \
  $(TOOLCHAIN_LIB_INC_DIR) \
  $(TOOLCHAIN_LIB_INC_FIXED_DIR) \

ifeq ($(HOST_PLATFORM),Linux)
BUILD_HOST := linux64
BUILD_HOST_EXE_SUFFIX := $(BUILD_HOST)
else
BUILD_HOST := win64
BUILD_HOST_EXE_SUFFIX := $(BUILD_HOST).exe
endif

BIN2HEADER := $(GENERATED_TOOLS_DIRECTORY)/bin2header-$(BUILD_HOST_EXE_SUFFIX)
MKIMAGE := $(GENERATED_TOOLS_DIRECTORY)/ltrx-mkimage-$(BUILD_HOST_EXE_SUFFIX)
SIGNIMAGE := $(GENERATED_TOOLS_DIRECTORY)/ltrx-signimage-$(BUILD_HOST_EXE_SUFFIX)

LANTRONIX_MODULE_NAMES := $(basename $(notdir $(wildcard $(LANTRONIX_DIRECTORY)/modules/*.elf)))

define LANTRONIX_ELF_COPY_template
$(WORK_DIRECTORY)/$(PROJECT_NAME)/lantronix/modules/$(notdir $(1)): $(1)
	@echo $$(notdir $$@)
	@$(MKDIR) -p $$(dir $$@)
	@cp -f $$< $$@
endef

$(foreach MODULE,$(LANTRONIX_MODULE_NAMES),\
  $(eval $(call LANTRONIX_ELF_COPY_template,$(LANTRONIX_DIRECTORY)/modules/$(MODULE).elf))\
)
