
/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright ©2015-2025, Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the �License Agreement�).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi product.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*****************************************************************************/
/*                           Documentation                                   */
/*****************************************************************************/

/*!
** \addtogroup example
** @{
*/

/*!
** \defgroup snmp_demo snmp_demo
** @{
**
** The \b snmp_demo module implements a custom MIB in SNMP, working in
** conjunction with the \b snmp module which implements the SNMP agent.
** This custom MIB implementation facilitates responses to SNMP commands
** such as get, set, get next, and so on.
**
** Build it from project "snmpDemo".
*/

/*****************************************************************************/
/*                             Includes                                      */
/*****************************************************************************/

#include "snmp_demo_module_defs.h" /* Automatically generated by make. */
#include "ltrx_tlog.h" /* Delivered with SDK. */
#include "ltrx_snmp.h"
#include "snmp_module_definitions.h"
#include "snmp_module_libs.h"
#include <string.h>

/*****************************************************************************/
/*                             Structs                                       */
/*****************************************************************************/

typedef struct serialPortTable
{
    int serialPortIndex;
    char *serialPortName;
    int serialPortInPktCnt;
    int serialPortOutPktCnt;
    unsigned long  serialPortInSpeed;
    unsigned long  serialPortOutSpeed;
    int serialPortInFlowCtrl;
    int serialPortOutFlowCtrl;
}serialPortTableStruct;

/*****************************************************************************/
/*                            Prototypes                                     */
/*****************************************************************************/

/*****************************************************************************/
/*                         Local Constants                                   */
/*****************************************************************************/
#define MAX_SERIAL_SNMP_SUPPORT 1
#define SERIAL_MIB_OID 0x2b,6,1,2,1,10,34

const struct snmp_external_functions *g_snmpExternalFunctionEntry_pointer;

const struct ltrx_module_info *g_snmpModule;

/*****************************************************************************/
/*                         Local Variables                                   */
/*****************************************************************************/

static int serialPortNumber = 0;

serialPortTableStruct serialPortParams[MAX_SERIAL_SNMP_SUPPORT];

/*****************************************************************************/
/*                               Code                                        */
/*****************************************************************************/

static void SerialInitializeMIBTable(uint16_t port)
{
    serialPortNumber++;
    serialPortParams[port].serialPortIndex       = port+1;
    serialPortParams[port].serialPortInPktCnt    = 0;
    serialPortParams[port].serialPortInPktCnt    = 0;
    serialPortParams[port].serialPortInSpeed     = 0;
    serialPortParams[port].serialPortOutSpeed    = 0;
    serialPortParams[port].serialPortInFlowCtrl  = 0;
    serialPortParams[port].serialPortOutFlowCtrl = 0;
    serialPortParams[port].serialPortName = MALLOC_ZEROED(20);
    strcpy(serialPortParams[port].serialPortName, "Serial Port");
}

static void mibinit_ltrxSerial(uint16_t type)
{
    (void)type;
    for(uint16_t serialPortCount = 0; serialPortCount < MAX_SERIAL_SNMP_SUPPORT; serialPortCount++)
    {
        SerialInitializeMIBTable(serialPortCount);
    }
}

static void SerialUpdateMIBTable(uint16_t port)
{
    if(port  >= MAX_SERIAL_SNMP_SUPPORT)
    {
        return;
    }
    /*
        Modify the variables
    */
}

static const MIBVAR mibvar_ltrxSerial[] =
{
    {{9,{SERIAL_MIB_OID,1,0}}, 0, SNMP_Integer, sizeof(int), &serialPortNumber},
    {{10,{SERIAL_MIB_OID,2,1,1}}, 0, SNMP_Integer, sizeof(int), &serialPortParams[0].serialPortIndex},
    {{10,{SERIAL_MIB_OID,2,1,2}}, MIBOPT_CAR+MIBOPT_W+MIBOPT_CAW, SNMP_String, 20, &serialPortParams[0].serialPortName},
    {{10,{SERIAL_MIB_OID,2,1,3}}, 0, SNMP_Integer, sizeof(int), &serialPortParams[0].serialPortInPktCnt},
    {{10,{SERIAL_MIB_OID,2,1,4}}, 0, SNMP_Integer, sizeof(int), &serialPortParams[0].serialPortOutPktCnt},
    {{10,{SERIAL_MIB_OID,2,1,5}}, MIBOPT_CAR+MIBOPT_W+MIBOPT_CAW, SNMP_Integer, sizeof(unsigned long), &serialPortParams[0].serialPortInSpeed},
    {{10,{SERIAL_MIB_OID,2,1,6}}, MIBOPT_CAR+MIBOPT_W+MIBOPT_CAW, SNMP_Integer, sizeof(unsigned long), &serialPortParams[0].serialPortOutSpeed},
    {{10,{SERIAL_MIB_OID,2,1,7}}, MIBOPT_CAR+MIBOPT_W+MIBOPT_CAW, SNMP_Integer, sizeof(int), &serialPortParams[0].serialPortInFlowCtrl},
    {{10,{SERIAL_MIB_OID,2,1,8}}, MIBOPT_CAR+MIBOPT_W+MIBOPT_CAW, SNMP_Integer, sizeof(int), &serialPortParams[0].serialPortOutFlowCtrl},

};

static int mibvarsize_ltrxSerial(void)
{
    return ARRAY_SIZE(mibvar_ltrxSerial);
}

static const MIBTAB mibtab_ltrxSerial[] =
{
    {{8,{SERIAL_MIB_OID,2}}, 1,{1,0,0,0}, sizeof(serialPortTableStruct)},
    {{8,{SERIAL_MIB_OID,2}}, 1,{1}, sizeof(serialPortTableStruct)},
};

static int mibtabsize_ltrxSerial(void)
{
    return ARRAY_SIZE(mibtab_ltrxSerial);
}

static int mibindex_ltrxSerial(int varix, int tabix)
{
    (void) tabix;
	uint16_t us1;
    const uint8_t *cp;
    int count;
    uint16_t i;
    cp = (const uint8_t *)mibvar_ltrxSerial[varix].oid.name + 6;
    us1 = *cp++ << 8;
    us1 += *cp;
    if(us1 == 0x2202 || us1 == 0x2203)
    {
        if(tabix >= serialPortNumber)
        {
            return -1; // End of table
        }
        return 1; // Entry valid
    }
    else if(us1 == 0x2205)
    {
        /* inSig */
        count = 0;
        for(i = 0; i < serialPortNumber; ++i)
        {
            count += serialPortParams[i].serialPortInPktCnt;
        }
        if(tabix < count)
        {
            return 1;
        }
        else
        {
            return -1;
        }
    }
    else if(us1 == 0x2206)
    {
        /* outSig */
        count = 0;
        for(i = 0; i < serialPortNumber; ++i)
        {
            count += serialPortParams[i].serialPortOutPktCnt;
        }
        if(tabix < count)
        {
            return 1;
        }
        else
        {
            return -1;
        }
    }
    return -1;
}

static void mibget_ltrxSerial(int varix, int tabix, uint8_t **vvptr)
{
    (void)vvptr;
    (void)tabix;
    (void)varix;
    for(uint16_t serialPortCount = 0; serialPortCount < MAX_SERIAL_SNMP_SUPPORT; serialPortCount++)
    {
        SerialUpdateMIBTable(serialPortCount);
    }
}

static int mibset_ltrxSerial(int varix, int tabix)
{
    (void) varix;
    (void) tabix;
    /*
        Store the variables in flash
    */
   return 0;
}

const OID g_oidMibLtrxSerial = {7, {SERIAL_MIB_OID}};

const MIB g_mibLtrxSerial =
{
    mibvar_ltrxSerial,
    mibvarsize_ltrxSerial,
    mibtab_ltrxSerial,
    mibtabsize_ltrxSerial,
    mibget_ltrxSerial,
    mibset_ltrxSerial,
    0,  /* set2() */
    mibindex_ltrxSerial,
    0,  /* index2() */
    mibinit_ltrxSerial,  /* init() */
    0,  /* check() */
    0,  /* check2() */
};

void snmp_demo_module_registration(void)
{
    ltrx_module_register(&g_snmp_demoModuleInfo);
}

void snmp_demo_module_startup(void)
{
    g_snmpExternalFunctionEntry_pointer = ltrx_module_functions_lookup(
        "snmp"
    );
    g_snmpModule = ltrx_module_lookup("snmp");
    SnmpMibHandlerRegister(&g_oidMibLtrxSerial, &g_mibLtrxSerial);
    TLOG(
        TLOG_SEVERITY_LEVEL__INFORMATIONAL,
        "snmp_demo_module_startup"
    );
}

void snmp_demo_module_shutdown(void)
{
}


/*!
** @}
*/

/*!
** @}
*/
