
PRODUCT_ID := Y4

LOAD_ADDRESS_FW := 0x004A0000
ENTRY_POINT_OFFSET := 0

# DO NOT CHANGE THE PARTITION SIZE VALUE
PARTITION_SIZE := 0x1E0000

PARTITION_NAME_PREFIX := _partition
PARTITION_NUMBERS := $(strip 1 2)
PARTITION_NAMES := $(foreach PN,$(PARTITION_NUMBERS),$(strip $(PARTITION_NAME_PREFIX)$(PN)))

PART1 = $(word 1, $(PARTITION_NAMES))
PART2 = $(word 2, $(PARTITION_NAMES))

INSTALL_ADDRESS_FW$(PART1) := 0x14020000
INSTALL_ADDRESS_FW$(PART2) := $(shell printf 0x%X $$(($(INSTALL_ADDRESS_FW$(PART1))+$(PARTITION_SIZE))))

BOOTLOADER_LOAD_OFFSET$(PART1) = $(call SYMBOL_VALUE,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/main$(PART1).elf,ltrx_linker_module_main_data_offset)
BOOTLOADER_LOAD_LENGTH$(PART1) = $(call SYMBOL_VALUE,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/main$(PART1).elf,ltrx_linker_module_main_data_size)

BOOTLOADER_LOAD_OFFSET$(PART2) = $(call SYMBOL_VALUE,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/main$(PART2).elf,ltrx_linker_module_main_data_offset)
BOOTLOADER_LOAD_LENGTH$(PART2) = $(call SYMBOL_VALUE,$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/main/main$(PART2).elf,ltrx_linker_module_main_data_size)

export BSP_DIRECTORY_NAME := bcm943907

TARGET_VERSION = $(LANTRONIX_VERSION).$(SDK_VERSION)

include ../../../env/env.make
include $(LANTRONIX_DIRECTORY)/version.make
include $(LANTRONIX_DIRECTORY)/defines.make
include ../../../rules/common.make

CFLAGS += -mcpu=cortex-r4 -mthumb-interwork -mthumb -mlittle-endian -funsigned-char -fno-builtin-memcpy

ASMFLAGS += -mcpu=cortex-r4 -mthumb-interwork -mlittle-endian

LDFLAGS += -mcpu=cortex-r4 -mthumb-interwork -mthumb -mlittle-endian -Wl,--defsym,STACK_SIZE=800 -Wl,--defsym,FIQ_STACK_SIZE=0 -Wl,--defsym,IRQ_STACK_SIZE=1024 -Wl,--defsym,SYS_STACK_SIZE=0

AVAILABLE_FLASH_SIZE := ((8*1024*1024)-(40*1024))
AVAILABLE_RAM_SIZE := (2048*1024)

USAGE_MESSAGE = $$(($(1))) of $$(($(2))) ($$((($(1))*100/($(2))))%, $$((($(2))-($(1)))) remaining)

.PHONY: image_summary check_image_size

check_image_size: $(PREVIOUS_ELF_FILE)
	@echo $(shell [ $$(($(call SYMBOL_VALUE,$(PREVIOUS_ELF_FILE),ltrx_linker_module_$(PREVIOUS_MODULE)_flash_end)-$(INSTALL_ADDRESS_FW$(lastword $(PARTITION_NAMES))))) -ge $$(($(PARTITION_SIZE))) ] && \
	echo "WARNING: The image size is greater than the partition size!")

image_summary: check_image_size
	@echo "Image Summary (Partition size is $(PARTITION_SIZE)):"
	@echo "  Flash Usage: $(call USAGE_MESSAGE,$(call SYMBOL_VALUE,$(PREVIOUS_ELF_FILE),ltrx_linker_module_$(PREVIOUS_MODULE)_flash_end)-$(INSTALL_ADDRESS_FW$(lastword $(PARTITION_NAMES))),$(PARTITION_SIZE))"
	@echo "  SRAM Usage:  $(call USAGE_MESSAGE,$(call SYMBOL_VALUE,$(PREVIOUS_ELF_FILE),ltrx_linker_module_$(PREVIOUS_MODULE)_ram_end)-$(LOAD_ADDRESS_FW),$(AVAILABLE_RAM_SIZE))"
