/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class DiscardChangesOperation
implements IEGitOperation {
    String revision;
    IResource[] files;
    ISchedulingRule schedulingRule;

    public DiscardChangesOperation(IResource[] files) {
        this(files, null);
    }

    public DiscardChangesOperation(IResource[] files, String revision) {
        this.files = new IResource[files.length];
        System.arraycopy(files, 0, this.files, 0, files.length);
        this.revision = revision;
        this.schedulingRule = MultiRule.combine((ISchedulingRule)DiscardChangesOperation.calcRefreshRule(files), (ISchedulingRule)RuleUtil.getRuleForRepositories(files));
    }

    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    private static ISchedulingRule calcRefreshRule(IResource[] resources) {
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ISchedulingRule rule = ruleFactory.refreshRule(resource);
            if (rule != null) {
                rules.add(rule);
            }
            ++n2;
        }
        if (rules.size() == 0) {
            return null;
        }
        return new MultiRule((ISchedulingRule[])rules.toArray(new IResource[rules.size()]));
    }

    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                DiscardChangesOperation.this.discardChanges(actMonitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    private void discardChanges(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CoreText.DiscardChangesOperation_discardingChanges, 2);
        boolean errorOccurred = false;
        IResource[] iResourceArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            Repository repo = DiscardChangesOperation.getRepository(res);
            if (repo == null) {
                IStatus status = Activator.error(CoreText.DiscardChangesOperation_repoNotFound, null);
                throw new CoreException(status);
            }
            ++n2;
        }
        try {
            this.discardChanges();
        }
        catch (GitAPIException e) {
            errorOccurred = true;
            Activator.logError(CoreText.DiscardChangesOperation_discardFailed, e);
        }
        monitor.worked(1);
        try {
            ProjectUtil.refreshResources(this.files, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            errorOccurred = true;
            Activator.logError(CoreText.DiscardChangesOperation_refreshFailed, e);
        }
        monitor.worked(1);
        monitor.done();
        if (errorOccurred) {
            IStatus status = Activator.error(CoreText.DiscardChangesOperation_discardFailedSeeLog, null);
            throw new CoreException(status);
        }
    }

    private static Repository getRepository(IResource resource) {
        IProject project = resource.getProject();
        RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
        if (repositoryMapping != null) {
            return repositoryMapping.getRepository();
        }
        return null;
    }

    private void discardChanges() throws GitAPIException {
        Map<Repository, Collection<String>> pathsByRepository = ResourceUtil.splitResourcesByRepository(this.files);
        for (Map.Entry<Repository, Collection<String>> entry : pathsByRepository.entrySet()) {
            Repository repository = entry.getKey();
            Collection<String> paths = entry.getValue();
            CheckoutCommand checkoutCommand = new Git(repository).checkout();
            checkoutCommand.setStartPoint(this.revision);
            if (!paths.isEmpty()) {
                for (String path : paths) {
                    checkoutCommand.addPath(path);
                }
            } else {
                checkoutCommand.setAllPaths(true);
            }
            checkoutCommand.call();
        }
    }
}

