/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;

public class CreatePatchOperation
implements IEGitOperation {
    public static final int DEFAULT_CONTEXT_LINES = 3;
    private final RevCommit commit;
    private final Repository repository;
    private DiffHeaderFormat headerFormat = DiffHeaderFormat.EMAIL;
    private String currentEncoding = null;
    private String patchContent;
    private int contextLines = 3;
    private TreeFilter pathFilter = null;

    public CreatePatchOperation(Repository repository, RevCommit commit) {
        if (repository == null) {
            throw new IllegalArgumentException(CoreText.CreatePatchOperation_repoRequired);
        }
        this.repository = repository;
        this.commit = commit;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        EclipseGitProgressTransformer gitMonitor = monitor == null ? new EclipseGitProgressTransformer((IProgressMonitor)new NullProgressMonitor()) : new EclipseGitProgressTransformer(monitor);
        final StringBuilder sb = new StringBuilder();
        DiffFormatter diffFmt = new DiffFormatter(new ByteArrayOutputStream(){

            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                if (CreatePatchOperation.this.currentEncoding == null) {
                    sb.append(this.toString());
                } else {
                    try {
                        sb.append(this.toString(CreatePatchOperation.this.currentEncoding));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        sb.append(this.toString());
                    }
                }
                this.reset();
            }
        }){
            private IProject project;

            public void format(DiffEntry ent) throws IOException, CorruptObjectException, MissingObjectException {
                IProject p;
                if (DiffHeaderFormat.WORKSPACE == CreatePatchOperation.this.headerFormat && !(p = CreatePatchOperation.this.getProject(ent)).equals((Object)this.project)) {
                    this.project = p;
                    this.getOutputStream().write(Constants.encodeASCII((String)("#P " + this.project.getName() + "\n")));
                }
                super.format(ent);
            }
        };
        diffFmt.setProgressMonitor((ProgressMonitor)gitMonitor);
        diffFmt.setContext(this.contextLines);
        if (this.headerFormat != null && this.headerFormat != DiffHeaderFormat.NONE) {
            this.writeGitPatchHeader(sb);
        }
        diffFmt.setRepository(this.repository);
        diffFmt.setPathFilter(this.pathFilter);
        try {
            if (this.commit != null) {
                RevCommit[] parents = this.commit.getParents();
                if (parents.length > 1) {
                    throw new IllegalStateException(CoreText.CreatePatchOperation_cannotCreatePatchForMergeCommit);
                }
                if (parents.length == 0) {
                    throw new IllegalStateException(CoreText.CreatePatchOperation_cannotCreatePatchForFirstCommit);
                }
                List diffs = diffFmt.scan((AnyObjectId)parents[0].getId(), (AnyObjectId)this.commit.getId());
                for (DiffEntry ent : diffs) {
                    String path = DiffEntry.ChangeType.DELETE.equals((Object)ent.getChangeType()) ? ent.getOldPath() : ent.getNewPath();
                    this.currentEncoding = CompareCoreUtils.getResourceEncoding(this.repository, path);
                    diffFmt.format(ent);
                }
            } else {
                diffFmt.format((AbstractTreeIterator)new DirCacheIterator(this.repository.readDirCache()), (AbstractTreeIterator)new FileTreeIterator(this.repository));
            }
        }
        catch (IOException e) {
            Activator.logError(CoreText.CreatePatchOperation_patchFileCouldNotBeWritten, e);
        }
        if (DiffHeaderFormat.WORKSPACE == this.headerFormat) {
            this.updateWorkspacePatchPrefixes(sb, diffFmt);
        }
        if (sb.charAt(sb.length() - 1) == '\n') {
            sb.setLength(sb.length() - 1);
        }
        this.patchContent = sb.toString();
    }

    private IProject getProject(DiffEntry ent) {
        DiffEntry.Side side = ent.getChangeType() == DiffEntry.ChangeType.ADD ? DiffEntry.Side.NEW : DiffEntry.Side.OLD;
        String path = ent.getPath(side);
        return this.getProject(path);
    }

    private IProject getProject(String path) {
        URI pathUri = this.repository.getWorkTree().toURI().resolve(URIUtil.toURI((String)path));
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(pathUri);
        Assert.isLegal((files.length == 1 ? 1 : 0) != 0, (String)NLS.bind((String)CoreText.CreatePatchOperation_couldNotFindProject, (Object)path, (Object)this.repository));
        return files[0].getProject();
    }

    public String getPatchContent() {
        if (this.patchContent == null) {
            throw new IllegalStateException("#execute needs to be called before this method.");
        }
        return this.patchContent;
    }

    private void writeGitPatchHeader(StringBuilder sb) {
        String template = this.headerFormat.getTemplate();
        String[] segments = template.split("\\$\\{");
        Stack<String> evaluated = new Stack<String>();
        evaluated.add(segments[0]);
        int i = 1;
        while (i < segments.length) {
            String segment = segments[i];
            String value = null;
            int brace = segment.indexOf(125);
            if (brace > 0) {
                String keyword = segment.substring(0, brace);
                keyword = keyword.toUpperCase().replaceAll(" ", "_");
                value = CreatePatchOperation.processKeyword(this.commit, DiffHeaderKeyword.valueOf(keyword));
            }
            String trailingCharacters = segment.substring(brace + 1);
            if (value != null) {
                evaluated.add(value);
                evaluated.add(trailingCharacters);
            } else if (!evaluated.isEmpty()) {
                evaluated.add(trailingCharacters);
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        for (String string : evaluated) {
            buffer.append(string);
        }
        sb.append(buffer);
    }

    private static String processKeyword(RevCommit commit, DiffHeaderKeyword keyword) {
        SimpleDateFormat dtfmt = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
        switch (keyword) {
            case SHA1: {
                return commit.getId().getName();
            }
            case AUTHOR: {
                return String.valueOf(commit.getAuthorIdent().getName()) + " <" + commit.getAuthorIdent().getEmailAddress() + ">";
            }
            case AUTHOR_DATE: {
                dtfmt.setTimeZone(commit.getAuthorIdent().getTimeZone());
                return dtfmt.format(commit.getAuthorIdent().getWhen());
            }
            case DATE: {
                return dtfmt.format(System.currentTimeMillis());
            }
            case TITLE_LINE: {
                return commit.getShortMessage();
            }
            case FULL_COMMIT_MESSAGE: {
                return commit.getFullMessage().substring(commit.getShortMessage().length());
            }
        }
        return null;
    }

    public void updateWorkspacePatchPrefixes(StringBuilder sb, DiffFormatter diffFmt) {
        RawText rt = new RawText(sb.toString().getBytes());
        String oldPrefix = diffFmt.getOldPrefix();
        String newPrefix = diffFmt.getNewPrefix();
        StringBuilder newSb = new StringBuilder();
        Pattern diffPattern = Pattern.compile("^diff --git (" + oldPrefix + "(.+)) (" + newPrefix + "(.+))$");
        Pattern oldPattern = Pattern.compile("^--- (" + oldPrefix + "(.+))$");
        Pattern newPattern = Pattern.compile("^\\+\\+\\+ (" + newPrefix + "(.+))$");
        int i = 0;
        while (i < rt.size()) {
            IPath newPath;
            IProject project;
            String group;
            String line = rt.getString(i);
            Matcher diffMatcher = diffPattern.matcher(line);
            Matcher oldMatcher = oldPattern.matcher(line);
            Matcher newMatcher = newPattern.matcher(line);
            if (diffMatcher.find()) {
                group = diffMatcher.group(2);
                project = this.getProject(group);
                newPath = CreatePatchOperation.computeWorkspacePath((IPath)new Path(group), project);
                line = line.replaceAll(diffMatcher.group(1), newPath.toString());
                group = diffMatcher.group(4);
                newPath = CreatePatchOperation.computeWorkspacePath((IPath)new Path(group), project);
                line = line.replaceAll(diffMatcher.group(3), newPath.toString());
            } else if (oldMatcher.find()) {
                group = oldMatcher.group(2);
                project = this.getProject(group);
                newPath = CreatePatchOperation.computeWorkspacePath((IPath)new Path(group), project);
                line = line.replaceAll(oldMatcher.group(1), newPath.toString());
            } else if (newMatcher.find()) {
                group = newMatcher.group(2);
                project = this.getProject(group);
                newPath = CreatePatchOperation.computeWorkspacePath((IPath)new Path(group), project);
                line = line.replaceAll(newMatcher.group(1), newPath.toString());
            }
            newSb.append(line);
            if (++i >= rt.size() && rt.isMissingNewlineAtEnd()) continue;
            newSb.append(rt.getLineDelimiter());
        }
        sb.setLength(0);
        sb.append((CharSequence)newSb);
    }

    public static IPath computeWorkspacePath(IPath path, IProject project) {
        RepositoryMapping rm = RepositoryMapping.getMapping((IResource)project);
        String repoRelativePath = rm.getRepoRelativePath((IResource)project);
        if (repoRelativePath == null) {
            return path;
        }
        if (repoRelativePath.equals("")) {
            return path;
        }
        return path.removeFirstSegments(path.matchingFirstSegments((IPath)new Path(repoRelativePath)));
    }

    public void setHeaderFormat(DiffHeaderFormat format) {
        this.headerFormat = format;
    }

    public void setContextLines(int contextLines) {
        this.contextLines = contextLines;
    }

    public static String suggestFileName(RevCommit commit) {
        char[] charArray;
        String name = commit.getShortMessage();
        name = name.trim();
        StringBuilder filteredBuilder = new StringBuilder();
        char[] cArray = charArray = name.toCharArray();
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c) || Character.isDigit(c)) {
                filteredBuilder.append(c);
            }
            if (Character.isWhitespace(c) || c == '/') {
                filteredBuilder.append("-");
            }
            ++n2;
        }
        name = filteredBuilder.toString();
        if (name.length() > 52) {
            name = name.substring(0, 52);
        }
        while (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        name = name.concat(".patch");
        return name;
    }

    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    public void setPathFilter(TreeFilter pathFilter) {
        this.pathFilter = pathFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffHeaderFormat {
        NONE(CoreText.DiffHeaderFormat_None, false, null),
        WORKSPACE(CoreText.DiffHeaderFormat_Workspace, false, "### Eclipse Workspace Patch 1.0\n"),
        EMAIL(CoreText.DiffHeaderFormat_Email, true, "From ${sha1} ${date}\nFrom: ${author}\nDate: ${author date}\nSubject: [PATCH] ${title line}\n${full commit message}\n"),
        ONELINE(CoreText.DiffHeaderFormat_Oneline, true, "${sha1} ${title line}\n");

        private final String description;
        private final boolean commitRequired;
        private final String template;

        private DiffHeaderFormat(String d, boolean c, String t) {
            this.description = d;
            this.commitRequired = c;
            this.template = t;
        }

        public boolean isCommitRequired() {
            return this.commitRequired;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DiffHeaderKeyword {
        SHA1,
        AUTHOR_DATE,
        AUTHOR,
        DATE,
        TITLE_LINE,
        FULL_COMMIT_MESSAGE;

    }
}

