/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCache {
    private final Map<File, Reference<Repository>> repositoryCache = new HashMap<File, Reference<Repository>>();

    RepositoryCache() {
    }

    public synchronized Repository lookupRepository(File gitDir) throws IOException {
        Repository d;
        RepositoryCache.prune(this.repositoryCache);
        Reference<Repository> r = this.repositoryCache.get(gitDir);
        Repository repository = d = r != null ? r.get() : null;
        if (d == null) {
            d = new FileRepository(gitDir);
            this.repositoryCache.put(gitDir, new WeakReference<Repository>(d));
        }
        return d;
    }

    public synchronized Repository[] getAllRepositories() {
        RepositoryCache.prune(this.repositoryCache);
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Reference<Repository> reference : this.repositoryCache.values()) {
            repositories.add(reference.get());
        }
        return repositories.toArray(new Repository[repositories.size()]);
    }

    private static void prune(Map<File, Reference<Repository>> map) {
        Iterator<Map.Entry<File, Reference<Repository>>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Repository repository = i.next().getValue().get();
            if (repository != null && repository.getDirectory().exists()) continue;
            i.remove();
        }
    }

    public void clear() {
        this.repositoryCache.clear();
    }
}

