/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.language.settings.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.AbstractExecutableExtensionBase;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsBroadcastingProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class MBSLanguageSettingsProvider
extends AbstractExecutableExtensionBase
implements ILanguageSettingsBroadcastingProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        IPath projectPath = rc.getProjectRelativePath();
        ICLanguageSetting[] languageSettings = null;
        if (rc instanceof IFile) {
            ICLanguageSetting ls = cfgDescription.getLanguageSettingForFile(projectPath, true);
            if (ls == null) return this.getSettingEntries(cfgDescription, (IResource)rc.getParent(), languageId);
            languageSettings = new ICLanguageSetting[]{ls};
        } else {
            ICResourceDescription rcDescription = cfgDescription.getResourceDescription(projectPath, false);
            languageSettings = this.getLanguageSettings(rcDescription);
        }
        ArrayList list = new ArrayList();
        if (languageSettings == null) return LanguageSettingsStorage.getPooledList(list);
        ICLanguageSetting[] iCLanguageSettingArray = languageSettings;
        int n = languageSettings.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            ICLanguageSetting langSetting = iCLanguageSettingArray[n2];
            if (langSetting != null && (id = langSetting.getLanguageId()) != null && id.equals(languageId)) {
                int kindsBits = langSetting.getSupportedEntryKinds();
                int kind = 1;
                while (kind <= kindsBits) {
                    if ((kindsBits & kind) != 0) {
                        list.addAll(langSetting.getSettingEntriesList(kind));
                    }
                    kind <<= 1;
                }
            }
            ++n2;
        }
        return LanguageSettingsStorage.getPooledList(list);
    }

    private ICLanguageSetting[] getLanguageSettings(ICResourceDescription rcDescription) {
        ICLanguageSetting[] array = null;
        switch (rcDescription.getType()) {
            case 1: 
            case 2: 
            case 4: {
                ICFolderDescription foDes = (ICFolderDescription)rcDescription;
                array = foDes.getLanguageSettings();
                break;
            }
            case 8: {
                ICFileDescription fiDes = (ICFileDescription)rcDescription;
                ICLanguageSetting ls = fiDes.getLanguageSetting();
                if (ls == null) break;
                array = new ICLanguageSetting[]{ls};
            }
        }
        if (array == null) {
            array = new ICLanguageSetting[]{};
        }
        return array;
    }

    public LanguageSettingsStorage copyStorage() {
        class PretendStorage
        extends LanguageSettingsStorage {
            PretendStorage() {
            }

            public boolean isEmpty() {
                return false;
            }

            public LanguageSettingsStorage clone() throws CloneNotSupportedException {
                return this;
            }

            public boolean equals(Object obj) {
                return false;
            }
        }
        return new PretendStorage();
    }
}

