/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTextRendering;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ASCIIRendering
extends AbstractAsyncTextRendering {
    private final int numCharsPerByte = 1;

    public ASCIIRendering(String renderingId) {
        super(renderingId);
        String codepage = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.defaultAsciiCodePage");
        this.setCodePage(codepage);
    }

    public void dispose() {
        super.dispose();
    }

    public int getNumCharsPerByte() {
        return 1;
    }

    public byte[] getBytes(String renderingId, BigInteger address, MemoryByte[] currentValues, String data) {
        byte[] bytes = super.getBytes(renderingId, address, currentValues, data);
        int i = 0;
        while (i < bytes.length && i < currentValues.length) {
            if (bytes[i] == 1 && currentValues[i].getValue() == 0) {
                bytes[i] = 0;
            }
            ++i;
        }
        return bytes;
    }

    public String getString(String renderingId, BigInteger address, MemoryByte[] data) {
        MemoryByte[] copy = new MemoryByte[data.length];
        int i = 0;
        while (i < data.length) {
            copy[i] = new MemoryByte();
            if (data[i].getValue() == 0) {
                copy[i].setValue((byte)1);
            } else {
                copy[i].setValue(data[i].getValue());
            }
            copy[i].setFlags(data[i].getFlags());
            ++i;
        }
        return super.getString(renderingId, address, copy);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.debug.ui.defaultAsciiCodePage")) {
            String codePage = (String)event.getNewValue();
            this.setCodePage(codePage);
            if (this.isVisible()) {
                this.updateLabels();
            }
        }
        super.propertyChange(event);
    }
}

