/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.model.AbstractCheckerWithProblemPreferences;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.Checkers;
import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICheckerWithPreferences;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemCategory;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.LaunchModeProblemPreference;
import org.eclipse.cdt.codan.internal.core.CodanPreferencesLoader;
import org.eclipse.cdt.codan.internal.core.ICheckerEnablementVerifier;
import org.eclipse.cdt.codan.internal.core.model.CodanProblem;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemCategory;
import org.eclipse.cdt.codan.internal.core.model.ProblemProfile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class CheckersRegistry
implements Iterable<IChecker>,
ICheckersRegistry {
    private static final String NAME_ATTR = "name";
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    private static final String CHECKERS_EXTENSION_POINT_NAME = "checkers";
    private static final String CHECKER_ENABLEMENT_EXTENSION_POINT_NAME = "checkerEnablement";
    private static final String CHECKER_ELEMENT = "checker";
    private static final String PROBLEM_ELEMENT = "problem";
    private static final String CATEGORY_ELEMENT = "category";
    private static final Object DEFAULT = "DEFAULT";
    public static final String CLONE_SUFFIX = ".COPY";
    private Collection<IChecker> checkers = new ArrayList<IChecker>();
    private static CheckersRegistry instance;
    private static boolean initialized;
    private final Map<Object, IProblemProfile> profiles = new HashMap<Object, IProblemProfile>();
    private final Map<IChecker, Collection<IProblem>> problemList = new HashMap<IChecker, Collection<IProblem>>();
    private final Map<String, IChecker> problemCheckerMapping = new HashMap<String, IChecker>();
    private final List<ICheckerEnablementVerifier> checkerEnablementVerifiers = new ArrayList<ICheckerEnablementVerifier>();

    static {
        initialized = false;
    }

    private CheckersRegistry() {
        instance = this;
        this.profiles.put(DEFAULT, new ProblemProfile(DEFAULT));
        this.readCheckersRegistry();
        this.readCheckerEnablementVerifier();
        initialized = true;
    }

    private void readCheckersRegistry() {
        IConfigurationElement configurationElement;
        IExtensionPoint ep = this.getExtensionPoint(CHECKERS_EXTENSION_POINT_NAME);
        if (ep == null) {
            return;
        }
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            configurationElement = elements[i];
            this.processCategories(configurationElement);
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            configurationElement = elements[i];
            this.processProblem(configurationElement);
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            configurationElement = elements[i];
            this.processChecker(configurationElement);
            ++i;
        }
        for (IChecker c : this.problemList.keySet()) {
            if (!(c instanceof ICheckerWithPreferences)) continue;
            Collection<IProblem> list = this.problemList.get(c);
            for (IProblem p : list) {
                if (!(p instanceof IProblemWorkingCopy)) continue;
                try {
                    ((ICheckerWithPreferences)((Object)c)).initPreferences((IProblemWorkingCopy)p);
                }
                catch (Throwable t) {
                    CodanCorePlugin.log(t);
                }
            }
        }
    }

    private void processCategories(IConfigurationElement configurationElement) {
        if (configurationElement.getName().equals(CATEGORY_ELEMENT)) {
            String id = CheckersRegistry.getAtt(configurationElement, ID_ATTR);
            if (id == null) {
                return;
            }
            String name = CheckersRegistry.getAtt(configurationElement, NAME_ATTR);
            if (name == null) {
                return;
            }
            CodanProblemCategory cat = new CodanProblemCategory(id, name);
            String category = CheckersRegistry.getAtt(configurationElement, "parentCategory", false);
            this.addCategory(cat, category);
        }
    }

    private void processChecker(IConfigurationElement configurationElement) {
        block11: {
            try {
                IConfigurationElement[] children1;
                int n;
                if (!configurationElement.getName().equals(CHECKER_ELEMENT)) break block11;
                String id = CheckersRegistry.getAtt(configurationElement, ID_ATTR);
                if (id == null) {
                    return;
                }
                String name = CheckersRegistry.getAtt(configurationElement, NAME_ATTR, false);
                if (name == null) {
                    name = id;
                }
                IChecker checkerObj = null;
                try {
                    Object checker = configurationElement.createExecutableExtension(CLASS_ATTR);
                    checkerObj = (IChecker)checker;
                    this.addChecker(checkerObj);
                }
                catch (CoreException e) {
                    CodanCorePlugin.log(e);
                    return;
                }
                boolean hasRef = false;
                IConfigurationElement[] children2 = configurationElement.getChildren(PROBLEM_ELEMENT);
                if (children2 != null) {
                    IConfigurationElement[] iConfigurationElementArray = children2;
                    n = children2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement ref = iConfigurationElementArray[n2];
                        CodanProblem p = this.processProblem(ref);
                        this.addRefProblem(checkerObj, p);
                        hasRef = true;
                        ++n2;
                    }
                }
                if ((children1 = configurationElement.getChildren("problemRef")) != null) {
                    IConfigurationElement[] iConfigurationElementArray = children1;
                    int n3 = children1.length;
                    n = 0;
                    while (n < n3) {
                        IConfigurationElement ref = iConfigurationElementArray[n];
                        hasRef = true;
                        IProblem p = this.getDefaultProfile().findProblem(ref.getAttribute("refId"));
                        this.addRefProblem(checkerObj, p);
                        ++n;
                    }
                }
                if (!hasRef) {
                    CodanProblem p = new CodanProblem(id, name);
                    this.addProblem(p, null);
                    this.addRefProblem(checkerObj, p);
                }
            }
            catch (Throwable e) {
                CodanCorePlugin.log(e);
            }
        }
    }

    private CodanProblem processProblem(IConfigurationElement configurationElement) {
        if (configurationElement.getName().equals(PROBLEM_ELEMENT)) {
            CodanSeverity cSev;
            String id = CheckersRegistry.getAtt(configurationElement, ID_ATTR);
            if (id == null) {
                return null;
            }
            String name = CheckersRegistry.getAtt(configurationElement, NAME_ATTR);
            if (name == null) {
                name = id;
            }
            CodanProblem p = new CodanProblem(id, name);
            String category = CheckersRegistry.getAtt(configurationElement, CATEGORY_ELEMENT, false);
            if (category == null) {
                category = "org.eclipse.cdt.codan.core.categories.ProgrammingProblems";
            }
            String enab = CheckersRegistry.getAtt(configurationElement, "defaultEnabled", false);
            String sev = CheckersRegistry.getAtt(configurationElement, "defaultSeverity", false);
            String patt = CheckersRegistry.getAtt(configurationElement, "messagePattern", false);
            String desc = CheckersRegistry.getAtt(configurationElement, "description", false);
            String markerType = CheckersRegistry.getAtt(configurationElement, "markerType", false);
            String smultiple = CheckersRegistry.getAtt(configurationElement, "multiple", false);
            if (enab != null) {
                p.setEnabled(Boolean.valueOf(enab));
            }
            if (sev != null && (cSev = CodanSeverity.valueOf(sev)) != null) {
                p.setSeverity(cSev);
            }
            if (patt != null) {
                p.setMessagePattern(patt);
            }
            if (markerType != null) {
                p.setMarkerType(markerType);
            }
            p.setDescription(desc);
            if (smultiple != null) {
                p.setMultiple(Boolean.valueOf(smultiple));
            }
            this.addProblem(p, category);
            return p;
        }
        return null;
    }

    private static String getAtt(IConfigurationElement configurationElement, String name) {
        return CheckersRegistry.getAtt(configurationElement, name, true);
    }

    private static String getAtt(IConfigurationElement configurationElement, String name, boolean req) {
        String elementValue = configurationElement.getAttribute(name);
        if (elementValue == null && req) {
            CodanCorePlugin.log("Extension " + configurationElement.getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: " + configurationElement.getName() + "." + name);
        }
        return elementValue;
    }

    private void readCheckerEnablementVerifier() {
        IExtensionPoint ep = this.getExtensionPoint(CHECKER_ENABLEMENT_EXTENSION_POINT_NAME);
        IConfigurationElement[] iConfigurationElementArray = ep.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                this.checkerEnablementVerifiers.add((ICheckerEnablementVerifier)ce.createExecutableExtension(CLASS_ATTR));
            }
            catch (CoreException e) {
                CodanCorePlugin.log(e);
            }
            ++n2;
        }
    }

    private IExtensionPoint getExtensionPoint(String extensionPointName) {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.codan.core", extensionPointName);
    }

    @Override
    public Iterator<IChecker> iterator() {
        return this.checkers.iterator();
    }

    public static synchronized CheckersRegistry getInstance() {
        if (instance == null) {
            return new CheckersRegistry();
        }
        if (!initialized) {
            throw new IllegalStateException("Registry is not initialized");
        }
        return instance;
    }

    @Override
    public void addChecker(IChecker checker) {
        this.checkers.add(checker);
    }

    @Override
    public void addProblem(IProblem p, String category) {
        IProblemCategory cat = this.getDefaultProfile().findCategory(category);
        if (cat == null) {
            cat = this.getDefaultProfile().getRoot();
        }
        ((ProblemProfile)this.getDefaultProfile()).addProblem(p, cat);
    }

    @Override
    public void addCategory(IProblemCategory p, String category) {
        IProblemCategory cat = this.getDefaultProfile().findCategory(category);
        if (cat == null) {
            cat = this.getDefaultProfile().getRoot();
        }
        ((ProblemProfile)this.getDefaultProfile()).addCategory(p, cat);
    }

    @Override
    public void addRefProblem(IChecker c, IProblem p) {
        Collection<IProblem> plist = this.problemList.get(c);
        if (plist == null) {
            plist = new ArrayList<IProblem>();
            this.problemList.put(c, plist);
        }
        plist.add(p);
        this.problemCheckerMapping.put(p.getId(), c);
    }

    public IChecker getCheckerForProblem(IProblem problem) {
        return this.problemCheckerMapping.get(problem.getId());
    }

    @Override
    public Collection<IProblem> getRefProblems(IChecker checker) {
        return this.problemList.get(checker);
    }

    @Override
    public IProblemProfile getDefaultProfile() {
        return this.profiles.get(DEFAULT);
    }

    @Override
    public IProblemProfile getWorkspaceProfile() {
        IProblemProfile wp = this.profiles.get(ResourcesPlugin.getWorkspace());
        if (wp == null) {
            wp = (IProblemProfile)this.getDefaultProfile().clone();
            ((ProblemProfile)wp).setResource(ResourcesPlugin.getWorkspace());
            CodanPreferencesLoader loader = new CodanPreferencesLoader(wp);
            Preferences[] preferences = new Preferences[]{InstanceScope.INSTANCE.getNode("org.eclipse.cdt.codan.core"), ConfigurationScope.INSTANCE.getNode("org.eclipse.cdt.codan.core"), DefaultScope.INSTANCE.getNode("org.eclipse.cdt.codan.core")};
            loader.load(preferences);
            this.profiles.put(ResourcesPlugin.getWorkspace(), wp);
        }
        return wp;
    }

    @Override
    public void updateProfile(IResource element, IProblemProfile profile) {
        IProblemProfile defaultProfile = this.getDefaultProfile();
        this.profiles.clear();
        this.profiles.put(DEFAULT, defaultProfile);
        if (profile != null && element != null) {
            this.profiles.put(element, profile);
        }
    }

    @Override
    public IProblemProfile getResourceProfile(IResource element) {
        IProblemProfile prof = this.profiles.get(element);
        if (prof == null) {
            if (element instanceof IProject) {
                prof = (IProblemProfile)this.getWorkspaceProfile().clone();
                ((ProblemProfile)prof).setResource(element);
                CodanPreferencesLoader loader = new CodanPreferencesLoader(prof);
                IEclipsePreferences projectNode = CodanPreferencesLoader.getProjectNode((IProject)element);
                boolean useWorkspace = projectNode.getBoolean("useParentScope", true);
                if (!useWorkspace) {
                    loader.load((Preferences)projectNode);
                }
                this.profiles.put(element, prof);
            } else {
                prof = element.getParent() != null ? this.getResourceProfile((IResource)element.getParent()) : this.getResourceProfile((IResource)element.getProject());
            }
        }
        return prof;
    }

    @Override
    public IProblemProfile getResourceProfileWorkingCopy(IResource element) {
        IProblemProfile prof = (IProblemProfile)this.getResourceProfile(element).clone();
        return prof;
    }

    public boolean isCheckerEnabled(IChecker checker, IResource resource, CheckerLaunchMode mode) {
        if (resource.getType() != 1) {
            return false;
        }
        if (mode == CheckerLaunchMode.RUN_AS_YOU_TYPE && !Checkers.canCheckerRunAsYouType(checker)) {
            return false;
        }
        for (ICheckerEnablementVerifier verifier : this.checkerEnablementVerifiers) {
            if (verifier.isCheckerEnabled(checker, resource, mode)) continue;
            return false;
        }
        IProblemProfile resourceProfile = this.getResourceProfile(resource);
        Collection<IProblem> refProblems = this.getRefProblems(checker);
        for (IProblem p : refProblems) {
            LaunchModeProblemPreference pref;
            IProblem problem = resourceProfile.findProblem(p.getId());
            if (problem == null) {
                throw new IllegalArgumentException(String.valueOf(p.getId()) + " is not registered");
            }
            if (!problem.isEnabled()) {
                return false;
            }
            if (!(checker instanceof AbstractCheckerWithProblemPreferences) || !(pref = ((AbstractCheckerWithProblemPreferences)checker).getLaunchModePreference(problem)).isRunningInMode(mode)) continue;
            return true;
        }
        return false;
    }

    public int getCheckersSize() {
        return this.checkers.size();
    }

    public void replicateProblem(IProblem problem, IProblemProfile profile) {
        CodanProblem x = (CodanProblem)problem.clone();
        x.setId(this.getNextCloneId(problem, profile));
        ((ProblemProfile)profile).addProblem(x, problem.getParentCategory());
    }

    private String getNextCloneId(IProblem problem, IProblemProfile profile) {
        IProblem[] problems = profile.getProblems();
        String prefix = String.valueOf(problem.getId()) + CLONE_SUFFIX;
        int max = 0;
        int i = 0;
        while (i < problems.length) {
            IProblem x = problems[i];
            if (x.getId().startsWith(prefix)) {
                int num = 0;
                try {
                    num = Integer.parseInt(x.getId().substring(prefix.length()));
                }
                catch (NumberFormatException numberFormatException) {}
                if (max < num) {
                    max = num;
                }
            }
            ++i;
        }
        return String.valueOf(prefix) + ++max;
    }
}

