/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.io.File;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.IInteractionContextReader;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.SaxContextContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxContextReader
implements IInteractionContextReader {
    private IInteractionContextScaling contextScaling;

    public void setContextScaling(IInteractionContextScaling contextScaling) {
        this.contextScaling = contextScaling;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public InteractionContext readContext(String handleIdentifier, File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                ZipInputStream zipInputStream;
                block12: {
                    zipInputStream = new ZipInputStream(fileInputStream);
                    try {
                        String encoded = URLEncoder.encode(handleIdentifier, "UTF-8");
                        String contextFileName = String.valueOf(encoded) + ".xml";
                        ZipEntry entry = zipInputStream.getNextEntry();
                        while (entry != null) {
                            if (contextFileName.equals(entry.getName())) break;
                            entry = zipInputStream.getNextEntry();
                        }
                        if (entry != null) break block12;
                    }
                    catch (Throwable throwable) {
                        zipInputStream.close();
                        throw throwable;
                    }
                    zipInputStream.close();
                    return null;
                }
                SaxContextContentHandler contentHandler = new SaxContextContentHandler(handleIdentifier, this.contextScaling);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(contentHandler);
                reader.parse(new InputSource(zipInputStream));
                InteractionContext interactionContext = contentHandler.getContext();
                zipInputStream.close();
                return interactionContext;
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (Exception e) {
            File saveFile = new File(String.valueOf(file.getAbsolutePath()) + "-save");
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Error loading context, backup saved to \"" + saveFile + "\"", (Throwable)e));
            file.renameTo(saveFile);
            return null;
        }
    }
}

