/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.LogLevelType;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IEnableUstEvents;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.BaseEventComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TargetNodeComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlContentProvider;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlLabelProvider;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceProviderGroup;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.UstProviderComponent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnableUstEventsComposite
extends Composite
implements IEnableUstEvents {
    private Button fTracepointsActivateButton;
    private CheckboxTreeViewer fTracepointsViewer;
    private Button fWildcardActivateButton;
    private Text fWildcardText;
    private Button fLogLevelActivateButton;
    private Text fLogLevelEventNameText;
    private CCombo fLogLevelCombo;
    private Button fLogLevelButton;
    private Button fLogLevelOnlyButton;
    private final TraceProviderGroup fProviderGroup;
    private boolean fIsTracepoints;
    private boolean fIsAllTracepoints;
    private List<String> fSelectedEvents;
    private boolean fIsWildcard;
    private String fWildcard;
    private boolean fIsLogLevel;
    private String fLogLevelEventName;
    private LogLevelType fLogLevelType;
    private TraceLogLevel fLogLevel;

    public EnableUstEventsComposite(Composite parent, int style, TraceProviderGroup providerGroup) {
        super(parent, style);
        this.fProviderGroup = providerGroup;
    }

    @Override
    public boolean isTracepoints() {
        return this.fIsTracepoints;
    }

    @Override
    public boolean isAllTracePoints() {
        return this.fIsAllTracepoints;
    }

    @Override
    public List<String> getEventNames() {
        return new ArrayList<String>(this.fSelectedEvents);
    }

    @Override
    public boolean isWildcard() {
        return this.fIsWildcard;
    }

    @Override
    public String getWildcard() {
        return this.fWildcard;
    }

    @Override
    public boolean isLogLevel() {
        return this.fIsLogLevel;
    }

    @Override
    public LogLevelType getLogLevelType() {
        return this.fLogLevelType;
    }

    @Override
    public TraceLogLevel getLogLevel() {
        return this.fLogLevel;
    }

    @Override
    public String getLogLevelEventName() {
        return this.fLogLevelEventName;
    }

    public void createContent() {
        this.createTracepointsGroup();
        this.createWildCardGroup();
        this.createLogLevelGroup();
        this.setEnablements(GroupEnum.TRACEPOINTS);
    }

    public boolean isValid() {
        this.fIsTracepoints = this.fTracepointsActivateButton.getSelection();
        this.fIsWildcard = this.fWildcardActivateButton.getSelection();
        this.fIsLogLevel = this.fLogLevelActivateButton.getSelection();
        this.fIsAllTracepoints = false;
        this.fSelectedEvents = new ArrayList<String>();
        if (this.fIsTracepoints) {
            this.fIsAllTracepoints = this.fTracepointsViewer.getChecked((Object)this.fProviderGroup);
            HashSet<String> set = new HashSet<String>();
            Object[] checkedElements = this.fTracepointsViewer.getCheckedElements();
            int i = 0;
            while (i < checkedElements.length) {
                ITraceControlComponent component = (ITraceControlComponent)checkedElements[i];
                if (!set.contains(component.getName()) && component instanceof BaseEventComponent) {
                    set.add(component.getName());
                    this.fSelectedEvents.add(component.getName());
                }
                ++i;
            }
        }
        this.fLogLevelType = LogLevelType.LOGLEVEL_NONE;
        this.fLogLevelEventName = null;
        if (this.fIsLogLevel) {
            if (this.fLogLevelButton.getSelection()) {
                this.fLogLevelType = LogLevelType.LOGLEVEL;
            } else if (this.fLogLevelOnlyButton.getSelection()) {
                this.fLogLevelType = LogLevelType.LOGLEVEL_ONLY;
            }
            String temp = this.fLogLevelEventNameText.getText();
            if (!temp.matches("^[\\s]{0,}$") && !temp.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidLogLevelEventNameError) + " (" + temp + ") \n"));
                return false;
            }
            if (!temp.matches("\\s*")) {
                this.fLogLevelEventName = temp;
            }
            TraceLogLevel[] levels = TraceLogLevel.values();
            int id = this.fLogLevelCombo.getSelectionIndex();
            if (id < 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidLogLevel) + " (" + temp + ") \n"));
                return false;
            }
            this.fLogLevel = levels[id];
        }
        this.fWildcard = null;
        if (this.fIsWildcard) {
            String tempWildcard = this.fWildcardText.getText();
            if (!tempWildcard.matches("^[\\s]{0,}$") && !tempWildcard.matches("^[a-zA-Z0-9\\-\\_\\*]{1,}$")) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidWildcardError) + " (" + tempWildcard + ") \n"));
                return false;
            }
            if (!tempWildcard.matches("\\s*")) {
                this.fWildcard = tempWildcard;
            }
        }
        return true;
    }

    private void createTracepointsGroup() {
        Group tpMainGroup = new Group((Composite)this, 32);
        tpMainGroup.setText(Messages.TraceControl_EnableEventsTracepointGroupName);
        GridLayout layout = new GridLayout(2, false);
        tpMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        tpMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)tpMainGroup, 0);
        layout = new GridLayout(1, true);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fTracepointsActivateButton = new Button(buttonComposite, 16);
        this.fTracepointsActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        data = new GridData(768);
        this.fTracepointsActivateButton.setLayoutData((Object)data);
        this.fTracepointsActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableUstEventsComposite.this.setEnablements(GroupEnum.TRACEPOINTS);
            }
        });
        Group tpGroup = new Group((Composite)tpMainGroup, 32);
        layout = new GridLayout(1, true);
        tpGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        tpGroup.setLayoutData((Object)data);
        this.fTracepointsViewer = new CheckboxTreeViewer((Composite)tpGroup, 770);
        this.fTracepointsViewer.getTree().setToolTipText(Messages.TraceControl_EnableEventsTracepointTreeTooltip);
        this.fTracepointsViewer.setContentProvider((IContentProvider)new UstContentProvider());
        this.fTracepointsViewer.setLabelProvider((IBaseLabelProvider)new UstLabelProvider());
        this.fTracepointsViewer.addCheckStateListener((ICheckStateListener)new UstCheckStateListener());
        this.fTracepointsViewer.setInput((Object)this.fProviderGroup.getParent());
        this.fTracepointsViewer.getTree().setLayoutData((Object)new GridData(1808));
    }

    private void createWildCardGroup() {
        Group wildcardMainGroup = new Group((Composite)this, 32);
        wildcardMainGroup.setText(Messages.TraceControl_EnableEventsWildcardGroupName);
        GridLayout layout = new GridLayout(2, false);
        wildcardMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        wildcardMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)wildcardMainGroup, 0);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fWildcardActivateButton = new Button(buttonComposite, 16);
        this.fWildcardActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fWildcardActivateButton.setSelection(false);
        data = new GridData(768);
        this.fWildcardActivateButton.setLayoutData((Object)data);
        this.fWildcardActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableUstEventsComposite.this.setEnablements(GroupEnum.WILDCARD);
            }
        });
        Group wildcardGroup = new Group((Composite)wildcardMainGroup, 32);
        layout = new GridLayout(3, true);
        wildcardGroup.setLayout((Layout)layout);
        data = new GridData(768);
        wildcardGroup.setLayoutData((Object)data);
        Label wildcardLabel = new Label((Composite)wildcardGroup, 16384);
        wildcardLabel.setText(Messages.TraceControl_EnableEventsWildcardLabel);
        data = new GridData(768);
        data.horizontalSpan = 1;
        wildcardLabel.setLayoutData((Object)data);
        this.fWildcardText = new Text((Composite)wildcardGroup, 16384);
        this.fWildcardText.setToolTipText(Messages.TraceControl_EnableEventsWildcardTooltip);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.fWildcardText.setLayoutData((Object)data);
    }

    private void createLogLevelGroup() {
        Group logLevelMainGroup = new Group((Composite)this, 32);
        logLevelMainGroup.setText(Messages.TraceControl_EnableEventsLogLevelGroupName);
        GridLayout layout = new GridLayout(2, false);
        logLevelMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        logLevelMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)logLevelMainGroup, 0);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fLogLevelActivateButton = new Button(buttonComposite, 16);
        this.fLogLevelActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fLogLevelActivateButton.setSelection(false);
        data = new GridData(768);
        this.fLogLevelActivateButton.setLayoutData((Object)data);
        this.fLogLevelActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableUstEventsComposite.this.setEnablements(GroupEnum.LOGLEVEL);
            }
        });
        Group logLevelGroup = new Group((Composite)logLevelMainGroup, 32);
        layout = new GridLayout(3, true);
        logLevelGroup.setLayout((Layout)layout);
        logLevelGroup.setLayoutData((Object)new GridData(768));
        Label logLevelEventNameLabel = new Label((Composite)logLevelGroup, 16384);
        logLevelEventNameLabel.setText(Messages.TraceControl_EnableEventsEventNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        logLevelEventNameLabel.setLayoutData((Object)data);
        this.fLogLevelEventNameText = new Text((Composite)logLevelGroup, 16384);
        this.fLogLevelEventNameText.setToolTipText(Messages.TraceControl_EnableEventsLoglevelEventNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.fLogLevelEventNameText.setLayoutData((Object)data);
        TraceLogLevel[] levels = TraceLogLevel.values();
        String[] levelNames = new String[levels.length - 1];
        int k = 0;
        int i = 0;
        while (i < levels.length) {
            if (levels[i] != TraceLogLevel.LEVEL_UNKNOWN) {
                levelNames[k++] = levels[i].getInName();
            }
            ++i;
        }
        this.fLogLevelCombo = new CCombo((Composite)logLevelGroup, 8);
        this.fLogLevelCombo.setItems(levelNames);
        this.fLogLevelCombo.setToolTipText(Messages.TraceControl_EnableEventsLogLevelTooltip);
        data = new GridData(768);
        data.horizontalSpan = 4;
        this.fLogLevelCombo.setLayoutData((Object)data);
        this.fLogLevelButton = new Button((Composite)logLevelGroup, 16);
        this.fLogLevelButton.setText(Messages.TraceControl_EnableEventsLogLevelTypeName);
        this.fLogLevelButton.setToolTipText(Messages.TraceControl_EnableEventsLogLevelTypeTooltip);
        data = new GridData(1808);
        this.fLogLevelButton.setLayoutData((Object)data);
        this.fLogLevelOnlyButton = new Button((Composite)logLevelGroup, 16);
        this.fLogLevelOnlyButton.setText(Messages.TraceControl_EnableEventsLogLevelOnlyTypeName);
        this.fLogLevelOnlyButton.setToolTipText(Messages.TraceControl_EnableEventsLogLevelOnlyTypeTooltip);
        data = new GridData(1808);
        this.fLogLevelButton.setLayoutData((Object)data);
    }

    private void setEnablements(GroupEnum group) {
        this.fTracepointsActivateButton.setSelection(group == GroupEnum.TRACEPOINTS);
        this.fTracepointsViewer.getTree().setEnabled(group == GroupEnum.TRACEPOINTS);
        this.fWildcardActivateButton.setSelection(group == GroupEnum.WILDCARD);
        this.fWildcardText.setEnabled(group == GroupEnum.WILDCARD);
        this.fLogLevelActivateButton.setSelection(group == GroupEnum.LOGLEVEL);
        this.fLogLevelEventNameText.setEnabled(group == GroupEnum.LOGLEVEL);
        this.fLogLevelCombo.setEnabled(group == GroupEnum.LOGLEVEL);
        this.fLogLevelButton.setEnabled(group == GroupEnum.LOGLEVEL);
        this.fLogLevelOnlyButton.setEnabled(group == GroupEnum.LOGLEVEL);
    }

    private static enum GroupEnum {
        TRACEPOINTS,
        WILDCARD,
        LOGLEVEL;

    }

    public final class UstCheckStateListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getChecked()) {
                if (event.getElement() instanceof TraceProviderGroup) {
                    EnableUstEventsComposite.this.fTracepointsViewer.setSubtreeChecked(event.getElement(), true);
                }
                if (event.getElement() instanceof UstProviderComponent) {
                    EnableUstEventsComposite.this.fTracepointsViewer.setSubtreeChecked(event.getElement(), true);
                }
            } else {
                if (event.getElement() instanceof TraceProviderGroup) {
                    EnableUstEventsComposite.this.fTracepointsViewer.setSubtreeChecked(event.getElement(), true);
                }
                if (event.getElement() instanceof UstProviderComponent) {
                    ITraceControlComponent component = (ITraceControlComponent)event.getElement();
                    EnableUstEventsComposite.this.fTracepointsViewer.setSubtreeChecked(event.getElement(), false);
                    EnableUstEventsComposite.this.fTracepointsViewer.setChecked((Object)component.getParent(), false);
                } else {
                    ITraceControlComponent component = (ITraceControlComponent)event.getElement();
                    EnableUstEventsComposite.this.fTracepointsViewer.setChecked((Object)component.getParent(), false);
                    EnableUstEventsComposite.this.fTracepointsViewer.setChecked((Object)component.getParent().getParent(), false);
                }
            }
        }
    }

    public static final class UstContentProvider
    extends TraceControlContentProvider {
        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TargetNodeComponent) {
                List<ITraceControlComponent> children = ((ITraceControlComponent)parentElement).getChildren(TraceProviderGroup.class);
                return children.toArray(new ITraceControlComponent[children.size()]);
            }
            if (parentElement instanceof TraceProviderGroup) {
                List<ITraceControlComponent> children = ((ITraceControlComponent)parentElement).getChildren(UstProviderComponent.class);
                return children.toArray(new ITraceControlComponent[children.size()]);
            }
            if (parentElement instanceof ITraceControlComponent) {
                return ((ITraceControlComponent)parentElement).getChildren();
            }
            return new Object[0];
        }
    }

    public static final class UstLabelProvider
    extends TraceControlLabelProvider {
        @Override
        public Image getImage(Object element) {
            return null;
        }

        @Override
        public String getText(Object element) {
            if (element != null && element instanceof TraceProviderGroup) {
                return Messages.TraceControl_EnableEventsTracepointTreeAllLabel;
            }
            if (element != null && element instanceof UstProviderComponent) {
                return String.valueOf(Messages.TraceControl_EnableEventsTracepointTreeAllLabel) + " - " + ((UstProviderComponent)element).getName();
            }
            return super.getText(element);
        }
    }
}

