/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaLanguageSettings {
    private String languageName = "<unknown>";
    public static final String COMMAND_ERROR_LOGIN = "error_login";
    public static final String COMMAND_ERROR_COLLISION = "error_collision";
    public static final String COMMAND_ERROR_COMMENT_REQUIRED = "error_comment_required";
    public static final String COMMAND_ERROR_LOGGED_OUT = "error_logged_out";
    public static final String COMMAND_BAD_LOGIN = "bad_login";
    public static final String COMMAND_PROCESSED = "processed";
    public static final String COMMAND_CHANGES_SUBMITTED = "changes_submitted";
    public static final String COMMAND_SUSPICIOUS_ACTION = "suspicious_action";
    public static final String COMMAND_BUG = "bug";
    public static final String COMMAND_SUBMITTED = "submitted";
    public static final String COMMAND_ERROR_CONFIRM_MATCH = "error_confirm_match";
    public static final String COMMAND_ERROR_MATCH_FAILED = "error_match_failed";
    private final Map<String, List<String>> languageAttributes = new LinkedHashMap<String, List<String>>();

    public BugzillaLanguageSettings(String languageName) {
        this.languageName = languageName;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.languageName == null ? 0 : this.languageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BugzillaLanguageSettings other = (BugzillaLanguageSettings)obj;
        return !(this.languageName == null ? other.languageName != null : !this.languageName.equals(other.languageName));
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public void addLanguageAttribute(String command, String response) {
        List<String> commandList = this.languageAttributes.get(command);
        if (commandList == null) {
            commandList = new LinkedList<String>();
            this.languageAttributes.put(command.toLowerCase(), commandList);
        }
        commandList.add(response);
    }

    public List<String> getResponseForCommand(String command) {
        return this.languageAttributes.get(command);
    }
}

