/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.IGDBJtagConnection;
import org.eclipse.cdt.debug.gdbjtag.core.Messages;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBJtagDSFFinalLaunchSequence
extends Sequence {
    private Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            GDBJtagDSFFinalLaunchSequence.this.fTracker = new DsfServicesTracker(Activator.getBundleContext(), GDBJtagDSFFinalLaunchSequence.this.fLaunch.getSession().getId());
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            if (GDBJtagDSFFinalLaunchSequence.this.fTracker != null) {
                GDBJtagDSFFinalLaunchSequence.this.fTracker.dispose();
            }
            GDBJtagDSFFinalLaunchSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            GDBJtagDSFFinalLaunchSequence.this.fGDBBackend = (IGDBBackend)GDBJtagDSFFinalLaunchSequence.this.fTracker.getService(IGDBBackend.class);
            if (GDBJtagDSFFinalLaunchSequence.this.fGDBBackend == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain GDBBackend service", null));
            }
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            GDBJtagDSFFinalLaunchSequence.this.fCommandControl = (IGDBControl)GDBJtagDSFFinalLaunchSequence.this.fTracker.getService(IGDBControl.class);
            if (GDBJtagDSFFinalLaunchSequence.this.fCommandControl == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain control service", null));
            } else {
                GDBJtagDSFFinalLaunchSequence.this.fCommandFactory = GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getCommandFactory();
            }
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            GDBJtagDSFFinalLaunchSequence.this.fProcService = (IMIProcesses)GDBJtagDSFFinalLaunchSequence.this.fTracker.getService(IMIProcesses.class);
            if (GDBJtagDSFFinalLaunchSequence.this.fProcService == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain process service", null));
            }
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            IPath dir = null;
            try {
                dir = GDBJtagDSFFinalLaunchSequence.this.fGDBBackend.getGDBWorkingDirectory();
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get working directory", (Throwable)e));
                requestMonitor.done();
                return;
            }
            if (dir != null) {
                GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand(GDBJtagDSFFinalLaunchSequence.this.fCommandFactory.createMIEnvironmentCD(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), dir.toPortableString()), new DataRequestMonitor((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), requestMonitor));
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            try {
                final String gdbinitFile = GDBJtagDSFFinalLaunchSequence.this.fGDBBackend.getGDBInitFile();
                if (gdbinitFile != null && gdbinitFile.length() > 0) {
                    GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand(GDBJtagDSFFinalLaunchSequence.this.fCommandFactory.createCLISource(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), gdbinitFile), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleCompleted() {
                            if (!gdbinitFile.equals(".gdbinit")) {
                                requestMonitor.setStatus(this.getStatus());
                            }
                            requestMonitor.done();
                        }
                    });
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get gdbinit option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                String args = GDBJtagDSFFinalLaunchSequence.this.fGDBBackend.getProgramArguments();
                if (args != null) {
                    String[] argArray = args.replaceAll("\n", " ").split(" ");
                    IMIContainerDMContext containerDmc = GDBJtagDSFFinalLaunchSequence.this.fProcService.createContainerContextFromGroupId(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), "");
                    GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand(GDBJtagDSFFinalLaunchSequence.this.fCommandFactory.createMIGDBSetArgs(containerDmc, argArray), new DataRequestMonitor((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get inferior arguments", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            boolean clear = false;
            Properties properties = new Properties();
            try {
                clear = GDBJtagDSFFinalLaunchSequence.this.fGDBBackend.getClearEnvironment();
                properties = GDBJtagDSFFinalLaunchSequence.this.fGDBBackend.getEnvironmentVariables();
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get environment information", (Throwable)e));
                requestMonitor.done();
                return;
            }
            if (clear || properties.size() > 0) {
                GDBJtagDSFFinalLaunchSequence.this.fCommandControl.setEnvironment(properties, clear, requestMonitor);
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            boolean isNonStop = false;
            try {
                isNonStop = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", LaunchUtils.getIsNonStopModeDefault());
            }
            catch (CoreException coreException) {}
            if (isNonStop) {
                GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand(GDBJtagDSFFinalLaunchSequence.this.fCommandFactory.createMIGDBSetTargetAsync(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), true), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), requestMonitor){

                    protected void handleSuccess() {
                        GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand(GDBJtagDSFFinalLaunchSequence.this.fCommandFactory.createMIGDBSetPagination(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), false), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), requestMonitor){

                            protected void handleSuccess() {
                                GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand(GDBJtagDSFFinalLaunchSequence.this.fCommandFactory.createMIGDBSetNonStop(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), true), new DataRequestMonitor((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), requestMonitor));
                            }
                        });
                    }
                });
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                boolean autolib = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB", true);
                GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand(GDBJtagDSFFinalLaunchSequence.this.fCommandFactory.createMIGDBSetAutoSolib(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), autolib), new DataRequestMonitor((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), requestMonitor));
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot set shared library option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            try {
                List p = GDBJtagDSFFinalLaunchSequence.this.fGDBBackend.getSharedLibraryPaths();
                if (p.size() > 0) {
                    String[] paths = p.toArray(new String[p.size()]);
                    GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand(GDBJtagDSFFinalLaunchSequence.this.fCommandFactory.createMIGDBSetSolibSearchPath(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), paths), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleSuccess() {
                            requestMonitor.done();
                        }
                    });
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot set share library paths", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            Throwable exception = null;
            try {
                GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice = GDBJtagDSFFinalLaunchSequence.this.getGDBJtagDevice(GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration());
            }
            catch (NullPointerException e) {
                exception = e;
            }
            catch (CoreException e) {
                exception = e;
            }
            if (GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get Jtag device", exception));
            }
            rm.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true)) {
                    String symbolsFileName = null;
                    if (config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols") && config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true)) {
                        IPath programFile = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                        if (programFile != null) {
                            symbolsFileName = programFile.toOSString();
                        }
                    } else {
                        symbolsFileName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
                        symbolsFileName = symbolsFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(symbolsFileName) : null;
                    }
                    if (symbolsFileName == null) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, Messages.getString("GDBJtagDebugger.err_no_img_file"), null));
                        rm.done();
                        return;
                    }
                    symbolsFileName = symbolsFileName.replace("\\", "\\\\");
                    String symbolsOffset = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
                    if (symbolsOffset.length() > 0) {
                        symbolsOffset = "0x" + symbolsOffset;
                    }
                    ArrayList<String> commands = new ArrayList<String>();
                    GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doLoadSymbol(symbolsFileName, symbolsOffset, commands);
                    GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot load symbol", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true)) {
                    ArrayList<String> commands = new ArrayList<String>();
                    if (GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice instanceof IGDBJtagConnection) {
                        URI uri = new URI(config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection", "unspecified-ip-address:unspecified-port-number"));
                        IGDBJtagConnection device = (IGDBJtagConnection)((Object)GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice);
                        device.doRemote(uri.getSchemeSpecificPart(), commands);
                    } else {
                        String ipAddress = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "unspecified-ip-address");
                        int portNumber = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
                        GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doRemote(ipAddress, portNumber, commands);
                    }
                    GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot connect to remote target", (Throwable)e));
                rm.done();
            }
            catch (URISyntaxException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Invalid remote target connection syntax", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.doReset", true)) {
                    ArrayList<String> commands = new ArrayList<String>();
                    GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doReset(commands);
                    GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot reset the remote target", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            int defaultDelay = GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.getDefaultDelay();
            try {
                ArrayList<String> commands = new ArrayList<String>();
                GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doDelay(config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.delay", defaultDelay), commands);
                GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot delay the remote target", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.doHalt", true)) {
                    ArrayList<String> commands = new ArrayList<String>();
                    GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doHalt(commands);
                    GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot halt the remote target", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                String userCmd = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.initCommands", "");
                userCmd = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(userCmd);
                if (userCmd.length() > 0) {
                    String[] commands = userCmd.split("\\r?\\n");
                    CountingRequestMonitor crm = new CountingRequestMonitor((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), rm);
                    crm.setDoneCount(commands.length);
                    int i = 0;
                    while (i < commands.length) {
                        GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), commands[i]), new DataRequestMonitor((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), (RequestMonitor)crm));
                        ++i;
                    }
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot run user defined init commands", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                String imageFileName = null;
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true)) {
                    if (config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage") && config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true)) {
                        IPath programFile = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                        if (programFile != null) {
                            imageFileName = programFile.toOSString();
                        }
                    } else {
                        imageFileName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "");
                        imageFileName = imageFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(imageFileName) : null;
                    }
                    if (imageFileName == null) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, Messages.getString("GDBJtagDebugger.err_no_img_file"), null));
                        rm.done();
                        return;
                    }
                    imageFileName = imageFileName.replace("\\", "\\\\");
                    String imageOffset = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
                    if (imageOffset.length() > 0) {
                        imageOffset = imageFileName.endsWith(".elf") ? "" : "0x" + config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
                    }
                    ArrayList<String> commands = new ArrayList<String>();
                    GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doLoadImage(imageFileName, imageOffset, commands);
                    GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot load image", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            if (GDBJtagDSFFinalLaunchSequence.this.fSessionType != SessionType.CORE) {
                MIBreakpointsManager bpmService = (MIBreakpointsManager)GDBJtagDSFFinalLaunchSequence.this.fTracker.getService(MIBreakpointsManager.class);
                IMIContainerDMContext containerDmc = GDBJtagDSFFinalLaunchSequence.this.fProcService.createContainerContextFromGroupId(GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), "");
                IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IBreakpoints.IBreakpointsTargetDMContext.class);
                bpmService.startTrackingBreakpoints(bpTargetDmc, requestMonitor);
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false)) {
                    String pcRegister = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", ""));
                    ArrayList<String> commands = new ArrayList<String>();
                    GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doSetPC(pcRegister, commands);
                    GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot set program counter", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", false)) {
                    String stopAt = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "");
                    ArrayList<String> commands = new ArrayList<String>();
                    GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doStopAt(stopAt, commands);
                    GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot run the stop script", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false)) {
                    ArrayList<String> commands = new ArrayList<String>();
                    GDBJtagDSFFinalLaunchSequence.this.fGdbJtagDevice.doContinue(commands);
                    GDBJtagDSFFinalLaunchSequence.this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot resume the remote target", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor rm) {
            ILaunchConfiguration config = GDBJtagDSFFinalLaunchSequence.this.fLaunch.getLaunchConfiguration();
            try {
                String userCmd = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.runCommands", "");
                if (userCmd.length() > 0) {
                    userCmd = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(userCmd);
                    String[] commands = userCmd.split("\\r?\\n");
                    CountingRequestMonitor crm = new CountingRequestMonitor((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), rm);
                    crm.setDoneCount(commands.length);
                    int i = 0;
                    while (i < commands.length) {
                        GDBJtagDSFFinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext(), commands[i]), new DataRequestMonitor((Executor)GDBJtagDSFFinalLaunchSequence.this.getExecutor(), (RequestMonitor)crm));
                        ++i;
                    }
                } else {
                    rm.done();
                }
            }
            catch (CoreException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot run user defined run commands", (Throwable)e));
                rm.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            GDBJtagDSFFinalLaunchSequence.this.fLaunch.getSession().dispatchEvent((Object)new DataModelInitializedEvent((IDMContext)GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getContext()), GDBJtagDSFFinalLaunchSequence.this.fCommandControl.getProperties());
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            GDBJtagDSFFinalLaunchSequence.this.fTracker.dispose();
            GDBJtagDSFFinalLaunchSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};
    GdbLaunch fLaunch;
    SessionType fSessionType;
    boolean fAttach;
    private IGDBControl fCommandControl;
    private IGDBBackend fGDBBackend;
    private IMIProcesses fProcService;
    private CommandFactory fCommandFactory;
    private IGDBJtagDevice fGdbJtagDevice;
    DsfServicesTracker fTracker;

    private void queueCommands(List<String> commands, RequestMonitor rm) {
        if (!commands.isEmpty()) {
            this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), this.composeCommand(commands)), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    public GDBJtagDSFFinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, SessionType sessionType, boolean attach, RequestMonitorWithProgress rm) {
        super(executor, rm, LaunchMessages.getString((String)"FinalLaunchSequence.0"), LaunchMessages.getString((String)"FinalLaunchSequence.1"));
        this.fLaunch = launch;
        this.fSessionType = sessionType;
        this.fAttach = attach;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private IGDBJtagDevice getGDBJtagDevice(ILaunchConfiguration config) throws CoreException, NullPointerException {
        GDBJtagDeviceContribution[] availableDevices;
        IGDBJtagDevice gdbJtagDevice = null;
        String jtagDeviceName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "");
        GDBJtagDeviceContribution[] gDBJtagDeviceContributionArray = availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int n = availableDevices.length;
        int n2 = 0;
        while (n2 < n) {
            GDBJtagDeviceContribution availableDevice = gDBJtagDeviceContributionArray[n2];
            if (jtagDeviceName.equals(availableDevice.getDeviceName())) {
                gdbJtagDevice = availableDevice.getDevice();
                break;
            }
            ++n2;
        }
        return gdbJtagDevice;
    }

    private String composeCommand(Collection<String> commands) {
        if (commands.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = commands.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }
}

