/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.cdt.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.cdt.debug.ui.memory.transport.Messages;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryImporter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.UIJob;

public class ImportMemoryDialog
extends SelectionDialog {
    private static final String IMPORT_SETTINGS = "IMPORT_DIALOG";
    private static final String SELECTED_IMPORTER = "SELECTED_IMPORTER";
    private Combo fFormatCombo;
    private IMemoryBlock fMemoryBlock;
    private Control fCurrentControl = null;
    private IMemoryImporter[] fFormatImporters;
    private String[] fFormatNames;
    private IDialogSettings fProperties = MemoryTransportPlugin.getDefault().getDialogSettings("IMPORT_DIALOG");
    private IMemoryRenderingSite fMemoryView;
    private final String INITIAL_ADDRESS = "Initial address";

    public ImportMemoryDialog(Shell parent, IMemoryBlock memoryBlock, BigInteger initialStartAddr, IMemoryRenderingSite renderingSite) {
        super(parent);
        super.setTitle(Messages.getString("ImportMemoryDialog.Title"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMemoryBlock = memoryBlock;
        this.fMemoryView = renderingSite;
        String initialAddress = this.fProperties.get("Initial address");
        if (initialAddress == null) {
            String addrstr = "0x" + initialStartAddr.toString(16);
            this.fProperties.put("Start", addrstr);
            this.fProperties.put("Initial address", addrstr);
        } else {
            String addrstr = "0x" + initialStartAddr.toString(16);
            if (!initialAddress.equals(addrstr)) {
                this.fProperties.put("Start", addrstr);
                this.fProperties.put("Initial address", addrstr);
            } else {
                String startAddr = this.fProperties.get("Start");
                if (startAddr == null) {
                    this.fProperties.put("Start", addrstr);
                    this.fProperties.put("Initial address", addrstr);
                }
            }
        }
    }

    public void scrollRenderings(final BigInteger address) {
        UIJob job = new UIJob("repositionRenderings"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IMemoryRenderingContainer[] iMemoryRenderingContainerArray = ImportMemoryDialog.this.fMemoryView.getMemoryRenderingContainers();
                int n = iMemoryRenderingContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemoryRenderingContainer container = iMemoryRenderingContainerArray[n2];
                    IMemoryRendering rendering = container.getActiveRendering();
                    if (rendering instanceof IRepositionableMemoryRendering) {
                        try {
                            ((IRepositionableMemoryRendering)rendering).goToAddress(address);
                        }
                        catch (DebugException ex) {
                            MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(Messages.getString("ImportMemoryDialog.ErrRepositioningRendering"), address.toString(16)), (Throwable)ex));
                        }
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setThread(Display.getDefault().getThread());
        job.schedule();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results != null) {
            return results;
        }
        return new Object[0];
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.fCurrentControl != null) {
            this.fCurrentControl.dispose();
        }
        IMemoryImporter currentImporter = this.getCurrentImporter();
        currentImporter.importMemory();
        this.fProperties.put(SELECTED_IMPORTER, currentImporter.getId());
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(MemoryTransportPlugin.getUniqueIdentifier()) + ".ImportMemoryDialog_context");
        Composite composite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label textLabel = new Label(composite, 0);
        textLabel.setText(Messages.getString("ImportMemoryDialog.Format"));
        this.fFormatCombo = new Combo(composite, 2056);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fFormatCombo, 0, 0x1000000);
        textLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)textLabel);
        this.fFormatCombo.setLayoutData((Object)data);
        Vector<Object> importers = new Vector<Object>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.cdt.debug.ui.memory.transport.memoryTransport");
        IConfigurationElement[] points = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < points.length) {
            IConfigurationElement element = points[i];
            if ("importer".equals(element.getName())) {
                try {
                    importers.addElement(element.createExecutableExtension("class"));
                }
                catch (Exception e) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
                }
            }
            ++i;
        }
        this.fFormatImporters = new IMemoryImporter[importers.size()];
        this.fFormatNames = new String[importers.size()];
        i = 0;
        while (i < this.fFormatImporters.length) {
            this.fFormatImporters[i] = (IMemoryImporter)importers.elementAt(i);
            this.fFormatNames[i] = ((IMemoryImporter)importers.elementAt(i)).getName();
            ++i;
        }
        final Composite container = new Composite(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fFormatCombo);
        data.left = new FormAttachment(0);
        container.setLayoutData((Object)data);
        this.fFormatCombo.setItems(this.fFormatNames);
        this.fFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportMemoryDialog.this.fCurrentControl != null) {
                    ImportMemoryDialog.this.fCurrentControl.dispose();
                }
                ImportMemoryDialog.this.fCurrentControl = ImportMemoryDialog.this.getCurrentImporter().createControl(container, ImportMemoryDialog.this.fMemoryBlock, ImportMemoryDialog.this.fProperties, ImportMemoryDialog.this);
            }
        });
        this.setCurrentImporter(this.fProperties.get(SELECTED_IMPORTER));
        this.fCurrentControl = this.getCurrentImporter().createControl(container, this.fMemoryBlock, this.fProperties, this);
        return composite;
    }

    public void setValid(boolean isValid) {
        this.getButton(0).setEnabled(isValid);
    }

    private IMemoryImporter getCurrentImporter() {
        return this.fFormatImporters[this.fFormatCombo.getSelectionIndex()];
    }

    private void setCurrentImporter(String id) {
        if (id == null || id.length() == 0) {
            this.fFormatCombo.select(0);
        }
        int index = 0;
        while (index < this.fFormatImporters.length) {
            if (this.fFormatImporters[index].getId().equals(id)) {
                this.fFormatCombo.select(index);
                return;
            }
            ++index;
        }
        this.fFormatCombo.select(0);
    }
}

