/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.custom;

import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.advanced.STextEnvironment;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;

public class STextCharTypes {
    static final byte B = 10;
    static final byte L = 0;
    static final byte R = 1;
    static final byte AL = 2;
    static final byte AN = 6;
    static final byte EN = 3;
    private static final int CHARTYPES_ADD = 2;
    protected final ISTextExpert expert;
    protected final STextTypeHandler handler;
    protected final STextEnvironment environment;
    protected final String text;
    private byte[] types;
    private int direction = -1;

    public STextCharTypes(ISTextExpert expert, String text) {
        this.expert = expert;
        this.handler = expert.getTypeHandler();
        this.environment = expert.getEnvironment();
        this.text = text;
        this.types = new byte[text.length()];
    }

    public int getDirection() {
        if (this.direction < 0) {
            this.direction = this.handler.getDirection(this.expert, this.text, this);
        }
        return this.direction;
    }

    private byte getCachedTypeAt(int index) {
        return (byte)(this.types[index] - 2);
    }

    private boolean hasCachedTypeAt(int i) {
        return this.types[i] != 0;
    }

    public byte getBidiTypeAt(int index) {
        if (this.hasCachedTypeAt(index)) {
            return this.getCachedTypeAt(index);
        }
        byte charType = Character.getDirectionality(this.text.charAt(index));
        if (charType == 10) {
            if (this.direction < 0) {
                if (this.direction < -1) {
                    return charType;
                }
                this.direction = -2;
                this.direction = this.handler.getDirection(this.expert, this.text, this);
            }
            charType = this.direction == 1 ? (byte)1 : 0;
        }
        this.setBidiTypeAt(index, charType);
        return charType;
    }

    public void setBidiTypeAt(int index, byte charType) {
        this.types[index] = (byte)(charType + 2);
    }

    public int resolveOrientation() {
        int orient = this.environment.getOrientation();
        if ((orient & 2) == 0) {
            return orient;
        }
        orient &= 0xFFFFFFFD;
        int len = this.text.length();
        int i = 0;
        while (i < len) {
            block5: {
                byte charType;
                block6: {
                    block4: {
                        if (this.hasCachedTypeAt(i)) break block4;
                        charType = Character.getDirectionality(this.text.charAt(i));
                        if (charType == 10) break block5;
                        this.setBidiTypeAt(i, charType);
                        break block6;
                    }
                    charType = this.getCachedTypeAt(i);
                }
                if (charType == 0) {
                    return 0;
                }
                if (charType == 1 || charType == 2) {
                    return 1;
                }
            }
            ++i;
        }
        return orient;
    }
}

