/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.commons.workbench.CommonsWorkbenchPlugin;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class BusyAnimator {
    private static final int UPDATE_INTERVAL = 90;
    private Animator animator;
    private final IBusyClient client;
    private Image[] images;
    private Image oldImage;

    public BusyAnimator(IBusyClient client) {
        this.client = client;
    }

    public void start() {
        if (this.animator != null) {
            this.stop();
        }
        try {
            if (this.images == null) {
                this.images = CommonImages.getProgressImages();
                if (this.images == null) {
                    return;
                }
            }
            this.oldImage = this.client.getImage();
            if (this.images.length > 1) {
                this.animator = new Animator(this.images);
                this.animator.run();
            }
        }
        catch (SWTException e) {
            CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.workbench", "Failed to start animation", (Throwable)e));
        }
    }

    public void stop() {
        if (this.animator != null) {
            this.animator.stop();
            this.animator = null;
            this.updateTitleImage(this.oldImage);
            this.oldImage = null;
        }
    }

    private boolean updateTitleImage(Image image) {
        if (!PlatformUI.getWorkbench().isClosing()) {
            if (image != null && !image.isDisposed()) {
                this.client.setImage(image);
                return true;
            }
            if (this.oldImage != null && !this.oldImage.isDisposed()) {
                this.client.setImage(this.oldImage);
            }
        }
        return false;
    }

    private class Animator
    implements Runnable {
        int imageDataIndex = 0;
        private final Image[] images;
        private boolean stopped;

        public Animator(Image[] images) {
            this.images = images;
        }

        public void run() {
            if (this.stopped) {
                return;
            }
            try {
                Image image = this.images[this.imageDataIndex];
                this.imageDataIndex = (this.imageDataIndex + 1) % this.images.length;
                if (BusyAnimator.this.updateTitleImage(image)) {
                    PlatformUI.getWorkbench().getDisplay().timerExec(90, (Runnable)this);
                }
            }
            catch (Exception e) {
                CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.workbench", "Failed to update animation", (Throwable)e));
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }

    public static interface IBusyClient {
        public void setImage(Image var1);

        public Image getImage();
    }
}

