/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.SharedLibrary;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;

public class DestroyedEvent
implements ICDIDestroyedEvent {
    Session session;
    ICDIObject source;

    public DestroyedEvent(Session s, MIThreadExitEvent cthread) {
        this.session = s;
        Target target = this.session.getTarget(cthread.getMISession());
        this.source = new Thread(target, cthread.getId());
    }

    public DestroyedEvent(Session s, MIVarDeletedEvent var) {
        this.session = s;
        VariableManager varMgr = this.session.getVariableManager();
        MISession miSession = var.getMISession();
        String varName = var.getVarName();
        Variable variable = varMgr.removeVariableFromList(miSession, varName);
        if (variable != null) {
            this.source = variable;
        } else {
            ExpressionManager expMgr = this.session.getExpressionManager();
            variable = expMgr.removeVariableFromList(miSession, varName);
            if (variable != null) {
                this.source = variable;
            } else {
                Target target = this.session.getTarget(miSession);
                this.source = new CObject(target);
            }
        }
    }

    public DestroyedEvent(Session s, MIBreakpointDeletedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = this.session.getBreakpointManager();
        MISession miSession = bpoint.getMISession();
        int number = bpoint.getNumber();
        Breakpoint breakpoint = mgr.getBreakpoint(miSession, number);
        if (breakpoint != null) {
            this.source = breakpoint;
            mgr.deleteBreakpoint(miSession, number);
        } else {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public DestroyedEvent(Session s, MISharedLibUnloadedEvent slib) {
        this.session = s;
        SharedLibraryManager mgr = this.session.getSharedLibraryManager();
        MISession miSession = slib.getMISession();
        String name = slib.getName();
        SharedLibrary lib = mgr.getSharedLibrary(miSession, name);
        if (lib != null) {
            mgr.deleteSharedLibrary(miSession, lib);
            this.source = lib;
        } else {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public DestroyedEvent(Session s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public DestroyedEvent(Session s) {
        this.session = s;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

