/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemTypeId;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.refactoring.CCompositeChange;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.osgi.util.NLS;

public abstract class CRefactoring
extends Refactoring {
    protected String name = Messages.Refactoring_name;
    protected final ICProject project;
    protected final ITranslationUnit tu;
    protected Region selectedRegion;
    protected final RefactoringStatus initStatus;
    protected CRefactoringContext refactoringContext;
    private ModificationCollector modificationCollector;

    public CRefactoring(ICElement element, ISelection selection, ICProject project) {
        this.project = project;
        this.initStatus = new RefactoringStatus();
        if (!(element instanceof ISourceReference)) {
            this.tu = null;
            this.initStatus.addFatalError(Messages.Refactoring_SelectionNotValid);
            return;
        }
        ISourceReference sourceRef = (ISourceReference)element;
        this.tu = CModelUtil.toWorkingCopy(sourceRef.getTranslationUnit());
        if (selection instanceof ITextSelection) {
            this.selectedRegion = SelectionHelper.getRegion(selection);
        } else {
            try {
                ISourceRange sourceRange = sourceRef.getSourceRange();
                this.selectedRegion = new Region(sourceRange.getIdStartPos(), sourceRange.getIdLength());
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
    }

    public void setContext(CRefactoringContext refactoringContext) {
        Assert.isNotNull((Object)((Object)refactoringContext));
        this.refactoringContext = refactoringContext;
    }

    public final RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask(Messages.CRefactoring_checking_final_conditions, 10);
        CheckConditionsContext context = new CheckConditionsContext();
        context.add((IConditionChecker)new ValidateEditChecker(this.getValidationContext()));
        ResourceChangeChecker resourceChecker = new ResourceChangeChecker();
        IResourceChangeDescriptionFactory deltaFactory = resourceChecker.getDeltaFactory();
        context.add((IConditionChecker)resourceChecker);
        RefactoringStatus result = this.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 8), context);
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.modificationCollector = new ModificationCollector(deltaFactory);
        this.collectModifications(pm, this.modificationCollector);
        result.merge(context.check((IProgressMonitor)new SubProgressMonitor(pm, 2)));
        pm.done();
        return result;
    }

    protected RefactoringStatus checkFinalConditions(IProgressMonitor subProgressMonitor, CheckConditionsContext checkContext) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        if (CRefactoring.isProgressMonitorCanceled((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        sm.subTask(Messages.Refactoring_PM_LoadTU);
        IASTTranslationUnit ast = this.getAST(this.tu, (IProgressMonitor)sm);
        if (ast == null) {
            this.initStatus.addError(NLS.bind((String)Messages.Refactoring_ParsingError, (Object)this.tu.getPath()));
            return this.initStatus;
        }
        if (CRefactoring.isProgressMonitorCanceled((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        sm.subTask(Messages.Refactoring_PM_CheckTU);
        this.checkAST(ast);
        sm.worked(2);
        sm.subTask(Messages.Refactoring_PM_InitRef);
        sm.done();
        return this.initStatus;
    }

    protected static boolean isProgressMonitorCanceled(IProgressMonitor sm, RefactoringStatus status) {
        if (sm.isCanceled()) {
            status.addFatalError(Messages.Refactoring_CanceledByUser);
            return true;
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CCompositeChange finalChange = this.modificationCollector.createFinalChange();
        finalChange.setDescription(new RefactoringChangeDescriptor(this.getRefactoringDescriptor()));
        return finalChange;
    }

    protected abstract RefactoringDescriptor getRefactoringDescriptor();

    protected abstract void collectModifications(IProgressMonitor var1, ModificationCollector var2) throws CoreException, OperationCanceledException;

    public String getName() {
        return this.name;
    }

    public ITranslationUnit getTranslationUnit() {
        return this.tu;
    }

    protected IASTTranslationUnit getAST(ITranslationUnit tu, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.refactoringContext.getAST(tu, pm);
    }

    protected IIndex getIndex() throws OperationCanceledException, CoreException {
        return this.refactoringContext.getIndex();
    }

    protected boolean checkAST(IASTTranslationUnit ast) {
        ProblemFinder problemFinder = new ProblemFinder(this.initStatus);
        ast.accept((ASTVisitor)problemFinder);
        return problemFinder.hasProblem();
    }

    protected List<IASTName> findAllMarkedNames(IASTTranslationUnit ast) {
        final ArrayList<IASTName> names = new ArrayList<IASTName>();
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                if (name.isPartOfTranslationUnitFile() && SelectionHelper.doesNodeOverlapWithRegion((IASTNode)name, CRefactoring.this.selectedRegion) && !(name instanceof ICPPASTQualifiedName)) {
                    names.add(name);
                }
                return super.visit(name);
            }
        });
        return names;
    }

    private class ProblemFinder
    extends ASTVisitor {
        private boolean problemFound = false;
        private final RefactoringStatus status;

        public ProblemFinder(RefactoringStatus status) {
            this.shouldVisitProblems = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitTypeIds = true;
            this.status = status;
        }

        public int visit(IASTProblem problem) {
            this.addWarningToState();
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTProblemDeclaration) {
                this.addWarningToState();
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTProblemExpression) {
                this.addWarningToState();
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTProblemStatement) {
                this.addWarningToState();
            }
            return 3;
        }

        public int visit(IASTTypeId typeId) {
            if (typeId instanceof IASTProblemTypeId) {
                this.addWarningToState();
            }
            return 3;
        }

        public boolean hasProblem() {
            return this.problemFound;
        }

        private void addWarningToState() {
            if (!this.problemFound) {
                this.status.addWarning(Messages.Refactoring_CompileErrorInTU);
                this.problemFound = true;
            }
        }
    }
}

