/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language.settings.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsBroadcastingProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsBaseProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingEntryDialog;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProviderAssociationManager;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProvidersLabelProvider;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProvidersPage;
import org.eclipse.cdt.internal.ui.newui.LanguageSettingsImages;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.internal.ui.newui.StatusMessageLine;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class LanguageSettingsEntriesTab
extends AbstractCPropertyTab {
    private static final int[] DEFAULT_ENTRIES_SASH_WEIGHTS = new int[]{10, 30};
    private SashForm sashFormEntries;
    private Tree treeLanguages;
    private Tree treeEntries;
    private TreeViewer treeEntriesViewer;
    private String currentLanguageId = null;
    private static String currentLanguageIdGlobal = null;
    private Button builtInCheckBox;
    private Button enableProvidersCheckBox;
    private StatusMessageLine fStatusLine;
    private LanguageSettingsProvidersPage masterPropertyPage = null;
    private static final int BUTTON_ADD = 0;
    private static final int BUTTON_EDIT = 1;
    private static final int BUTTON_DELETE = 2;
    private static final int BUTTON_MOVE_UP = 4;
    private static final int BUTTON_MOVE_DOWN = 5;
    private static final String[] BUTTON_LABELS = new String[6];
    private static final String CLEAR_STR = Messages.LanguageSettingsProviderTab_Clear;
    private Map<String, List<ILanguageSettingsProvider>> initialProvidersMap;

    public LanguageSettingsEntriesTab() {
        LanguageSettingsEntriesTab.BUTTON_LABELS[0] = ADD_STR;
        LanguageSettingsEntriesTab.BUTTON_LABELS[1] = EDIT_STR;
        LanguageSettingsEntriesTab.BUTTON_LABELS[2] = DEL_STR;
        LanguageSettingsEntriesTab.BUTTON_LABELS[4] = MOVEUP_STR;
        LanguageSettingsEntriesTab.BUTTON_LABELS[5] = MOVEDOWN_STR;
        this.initialProvidersMap = new HashMap<String, List<ILanguageSettingsProvider>>();
    }

    private IResource getResource() {
        return (IResource)this.page.getElement();
    }

    private ICConfigurationDescription getConfigurationDescription() {
        return this.getResDesc().getConfiguration();
    }

    private ILanguageSettingsProvider getSelectedProvider() {
        ILanguageSettingsProvider provider = null;
        TreeItem[] items = this.treeEntries.getSelection();
        if (items.length == 1) {
            TreeItem item = items[0];
            Object itemData = item.getData();
            if (itemData instanceof ICLanguageSettingEntry && (item = item.getParentItem()) != null) {
                itemData = item.getData();
            }
            if (itemData instanceof ILanguageSettingsProvider) {
                provider = (ILanguageSettingsProvider)itemData;
            }
        }
        return provider;
    }

    private ICLanguageSettingEntry getSelectedEntry() {
        TreeItem item;
        Object itemData;
        ICLanguageSettingEntry entry = null;
        TreeItem[] items = this.treeEntries.getSelection();
        if (items.length == 1 && (itemData = (item = items[0]).getData()) instanceof ICLanguageSettingEntry) {
            entry = (ICLanguageSettingEntry)itemData;
        }
        return entry;
    }

    private List<ICLanguageSettingEntry> getSettingEntriesUpResourceTree(ILanguageSettingsProvider provider) {
        if (this.currentLanguageId == null) {
            return null;
        }
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        IResource rc = this.getResource();
        List entries = LanguageSettingsManager.getSettingEntriesUpResourceTree((ILanguageSettingsProvider)provider, (ICConfigurationDescription)cfgDescription, (IResource)rc, (String)this.currentLanguageId);
        return entries;
    }

    private List<ICLanguageSettingEntry> getSettingEntries(ILanguageSettingsProvider provider) {
        if (this.currentLanguageId == null) {
            return null;
        }
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        IResource rc = this.getResource();
        return provider.getSettingEntries(cfgDescription, rc, this.currentLanguageId);
    }

    private void trackInitialSettings() {
        if (!this.page.isForPrefs()) {
            ICConfigurationDescription[] cfgDescriptions;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescriptions = this.page.getCfgsEditable();
            int n = cfgDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
                if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                    String cfgId = cfgDescription.getId();
                    List initialProviders = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
                    this.initialProvidersMap.put(cfgId, initialProviders);
                }
                ++n2;
            }
        }
    }

    private void createTreeForLanguages(Composite parent) {
        this.treeLanguages = new Tree(parent, 2308);
        this.treeLanguages.setLayoutData((Object)new GridData(1040));
        this.treeLanguages.setHeaderVisible(true);
        this.treeLanguages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = LanguageSettingsEntriesTab.this.treeLanguages.getSelection();
                if (items.length > 0) {
                    LanguageSettingsEntriesTab.this.currentLanguageId = (String)items[0].getData();
                    currentLanguageIdGlobal = LanguageSettingsEntriesTab.this.currentLanguageId;
                    LanguageSettingsEntriesTab.this.updateTreeForEntries();
                }
            }
        });
        final TreeColumn columnLanguages = new TreeColumn(this.treeLanguages, 0);
        columnLanguages.setText(Messages.AbstractLangsListTab_Languages);
        columnLanguages.setWidth(200);
        columnLanguages.setResizable(false);
        columnLanguages.setToolTipText(Messages.AbstractLangsListTab_Languages);
        this.treeLanguages.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int x = ((LanguageSettingsEntriesTab)LanguageSettingsEntriesTab.this).treeLanguages.getBounds().width - 5;
                if (columnLanguages.getWidth() != x) {
                    columnLanguages.setWidth(x);
                }
            }
        });
    }

    private void createTreeForEntries(Composite parent) {
        this.treeEntries = new Tree(parent, 2820);
        this.treeEntries.setLayoutData((Object)new GridData(1040));
        this.treeEntries.setHeaderVisible(true);
        this.treeEntries.setLinesVisible(true);
        final TreeColumn treeCol = new TreeColumn(this.treeEntries, 0);
        this.treeEntries.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int x = ((LanguageSettingsEntriesTab)LanguageSettingsEntriesTab.this).treeEntries.getClientArea().width;
                if (treeCol.getWidth() != x) {
                    treeCol.setWidth(x);
                }
            }
        });
        treeCol.setText(Messages.LanguageSettingsProviderTab_SettingEntries);
        treeCol.setWidth(200);
        treeCol.setResizable(false);
        treeCol.setToolTipText(Messages.LanguageSettingsProviderTab_SettingEntriesTooltip);
        this.treeEntriesViewer = new TreeViewer(this.treeEntries);
        this.treeEntriesViewer.setContentProvider((IContentProvider)new EntriesTreeContentProvider());
        this.treeEntriesViewer.setLabelProvider((IBaseLabelProvider)new EntriesTreeLabelProvider());
        this.treeEntriesViewer.setUseHashlookup(true);
        this.treeEntries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LanguageSettingsEntriesTab.this.treeLanguages.getSelectionCount() == 0) {
                    LanguageSettingsEntriesTab.this.selectLanguage(LanguageSettingsEntriesTab.this.currentLanguageId);
                }
                LanguageSettingsEntriesTab.this.updateStatusLine();
                LanguageSettingsEntriesTab.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (LanguageSettingsEntriesTab.this.buttonIsEnabled(1) && LanguageSettingsEntriesTab.this.treeEntries.getSelection().length > 0) {
                    LanguageSettingsEntriesTab.this.buttonPressed(1);
                }
            }
        });
    }

    private void createSashForm() {
        this.sashFormEntries = new SashForm(this.usercomp, 256);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.grabExcessVerticalSpace = true;
        this.sashFormEntries.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        this.sashFormEntries.setLayout((Layout)layout);
        this.createTreeForLanguages((Composite)this.sashFormEntries);
        this.createTreeForEntries((Composite)this.sashFormEntries);
        this.sashFormEntries.setWeights(DEFAULT_ENTRIES_SASH_WEIGHTS);
    }

    private void createBuiltInsCheckBox() {
        this.builtInCheckBox = this.setupCheck(this.usercomp, Messages.AbstractLangsListTab_ShowBuiltin, 1, 768);
        this.builtInCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageSettingsEntriesTab.this.updateTreeForEntries();
            }
        });
        this.builtInCheckBox.setSelection(true);
        this.builtInCheckBox.setEnabled(true);
    }

    private void createEnableProvidersCheckBox() {
        if (this.masterPropertyPage != null) {
            this.enableProvidersCheckBox = this.setupCheck(this.usercomp, Messages.LanguageSettingsProviders_EnableForProject, 2, 768);
            this.enableProvidersCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = LanguageSettingsEntriesTab.this.enableProvidersCheckBox.getSelection();
                    LanguageSettingsEntriesTab.this.masterPropertyPage.setLanguageSettingsProvidersEnabled(enabled);
                    LanguageSettingsEntriesTab.this.enableTabControls(enabled);
                    LanguageSettingsEntriesTab.this.updateStatusLine();
                }
            });
            this.enableProvidersCheckBox.setSelection(this.masterPropertyPage.isLanguageSettingsProvidersEnabled());
            this.enableProvidersCheckBox.setEnabled(this.page.isForProject());
            this.enableTabControls(this.enableProvidersCheckBox.getSelection());
        }
    }

    @Override
    public void createControls(Composite parent) {
        super.createControls(parent);
        this.currentLanguageId = null;
        this.usercomp.setLayout((Layout)new GridLayout());
        GridData gd = (GridData)this.usercomp.getLayoutData();
        gd.heightHint = 1;
        if (this.page instanceof LanguageSettingsProvidersPage) {
            this.masterPropertyPage = (LanguageSettingsProvidersPage)this.page;
        }
        this.trackInitialSettings();
        this.createSashForm();
        this.fStatusLine = new StatusMessageLine(this.usercomp, 16384, 2);
        this.createBuiltInsCheckBox();
        this.createEnableProvidersCheckBox();
        this.initButtons(BUTTON_LABELS);
        this.updateData(this.getResDesc());
    }

    private void enableTabControls(boolean enable) {
        this.sashFormEntries.setEnabled(enable);
        this.treeLanguages.setEnabled(enable);
        this.treeEntries.setEnabled(enable);
        this.builtInCheckBox.setEnabled(enable);
        this.buttoncomp.setEnabled(enable);
        if (enable) {
            this.updateTreeForEntries();
        } else {
            this.buttonSetEnabled(0, false);
            this.buttonSetEnabled(1, false);
            this.buttonSetEnabled(2, false);
            this.buttonSetEnabled(4, false);
            this.buttonSetEnabled(5, false);
        }
    }

    @Override
    protected void updateButtons() {
        ILanguageSettingsProvider provider = this.getSelectedProvider();
        ICLanguageSettingEntry entry = this.getSelectedEntry();
        List<ICLanguageSettingEntry> entries = this.getSettingEntriesUpResourceTree(provider);
        boolean isEntrySelected = entry != null;
        boolean isProviderSelected = !isEntrySelected && provider != null;
        boolean isAllowedToEdit = provider instanceof ILanguageSettingsEditableProvider && LanguageSettingsProviderAssociationManager.isAllowedToEditEntries(provider);
        boolean isAllowedToClear = provider instanceof ILanguageSettingsEditableProvider && LanguageSettingsProviderAssociationManager.isAllowedToClear(provider);
        boolean canAdd = isAllowedToEdit;
        boolean canEdit = isAllowedToEdit && isEntrySelected;
        boolean canDelete = isAllowedToEdit && isEntrySelected;
        boolean canClear = isAllowedToClear && isProviderSelected && entries != null && entries.size() > 0;
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        if (isAllowedToEdit && isEntrySelected && entries != null) {
            int last = entries.size() - 1;
            int pos = this.getExactIndex(entries, entry);
            if (pos >= 0 && pos <= last) {
                canMoveUp = pos != 0;
                canMoveDown = pos != last;
            }
        }
        this.buttonSetText(2, isProviderSelected ? CLEAR_STR : DEL_STR);
        this.buttonSetEnabled(0, canAdd);
        this.buttonSetEnabled(1, canEdit);
        this.buttonSetEnabled(2, canDelete || canClear);
        this.buttonSetEnabled(4, canMoveUp);
        this.buttonSetEnabled(5, canMoveDown);
    }

    private void updateStatusLine() {
        IStatus status = null;
        if (this.enableProvidersCheckBox.getSelection()) {
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
            status = LanguageSettingsImages.getStatus(this.getSelectedEntry(), cfgDescription);
        }
        if (status == null || status == Status.OK_STATUS) {
            boolean isAllowedEditing;
            ILanguageSettingsProvider provider = this.getSelectedProvider();
            boolean bl = isAllowedEditing = provider instanceof ILanguageSettingsEditableProvider && LanguageSettingsProviderAssociationManager.isAllowedToEditEntries(provider);
            if (provider != null && !isAllowedEditing) {
                status = new Status(1, "org.eclipse.cdt.ui", Messages.LanguageSettingsEntriesTab_Entries_Not_Editable);
            }
        }
        if ((status == null || status == Status.OK_STATUS) && this.treeLanguages.getItemCount() <= 0) {
            status = new Status(4, "org.eclipse.cdt.ui", Messages.LanguageSettingsEntriesTab_Cannot_Determine_Languages);
        }
        this.fStatusLine.setErrorStatus(status);
    }

    @Override
    public void buttonPressed(int buttonIndex) {
        ILanguageSettingsProvider selectedProvider = this.getSelectedProvider();
        ICLanguageSettingEntry selectedEntry = this.getSelectedEntry();
        switch (buttonIndex) {
            case 0: {
                this.performAdd(selectedProvider);
                break;
            }
            case 1: {
                this.performEdit(selectedProvider, selectedEntry);
                break;
            }
            case 2: {
                this.performDelete(selectedProvider, selectedEntry);
                break;
            }
            case 4: {
                this.performMoveUp(selectedProvider, selectedEntry);
                break;
            }
            case 5: {
                this.performMoveDown(selectedProvider, selectedEntry);
            }
        }
        this.treeEntries.setFocus();
    }

    private int getExactIndex(List<ICLanguageSettingEntry> entries, ICLanguageSettingEntry entry) {
        if (entries != null) {
            int i = 0;
            while (i < entries.size()) {
                if (entries.get(i) == entry) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private TreeItem findProviderItem(String id) {
        TreeItem[] providerItems;
        TreeItem[] treeItemArray = providerItems = this.treeEntries.getItems();
        int n = providerItems.length;
        int n2 = 0;
        while (n2 < n) {
            ILanguageSettingsProvider provider;
            TreeItem providerItem = treeItemArray[n2];
            Object providerItemData = providerItem.getData();
            if (providerItemData instanceof ILanguageSettingsProvider && (provider = (ILanguageSettingsProvider)providerItemData).getId().equals(id)) {
                return providerItem;
            }
            ++n2;
        }
        return null;
    }

    private TreeItem findEntryItem(String providerId, ICLanguageSettingEntry entry) {
        TreeItem[] providerItems;
        TreeItem[] treeItemArray = providerItems = this.treeEntries.getItems();
        int n = providerItems.length;
        int n2 = 0;
        while (n2 < n) {
            ILanguageSettingsProvider provider;
            TreeItem providerItem = treeItemArray[n2];
            Object providerItemData = providerItem.getData();
            if (providerItemData instanceof ILanguageSettingsProvider && (provider = (ILanguageSettingsProvider)providerItemData).getId().equals(providerId)) {
                TreeItem[] entryItems;
                TreeItem[] treeItemArray2 = entryItems = providerItem.getItems();
                int n3 = entryItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem entryItem = treeItemArray2[n4];
                    Object entryItemData = entryItem.getData();
                    if (entryItemData == entry) {
                        return entryItem;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private void selectItem(String providerId, ICLanguageSettingEntry entry) {
        TreeItem providerItem = this.findProviderItem(providerId);
        if (providerItem != null) {
            TreeItem entryItem;
            this.treeEntries.select(providerItem);
            if (providerItem.getItems().length > 0) {
                this.treeEntries.showItem(providerItem.getItems()[0]);
            }
            if ((entryItem = this.findEntryItem(providerId, entry)) != null) {
                this.treeEntries.showItem(entryItem);
                this.treeEntries.select(entryItem);
            }
            this.updateStatusLine();
        }
    }

    private void addEntry(ILanguageSettingsProvider provider, ICLanguageSettingEntry entry) {
        if (provider != null && entry != null) {
            String providerId = provider.getId();
            List<ICLanguageSettingEntry> entries = this.getEntriesShownToUser(provider);
            ICLanguageSettingEntry selectedEntry = this.getSelectedEntry();
            int pos = this.getExactIndex(entries, selectedEntry);
            entries.add(pos + 1, entry);
            this.saveEntries(provider, entries);
            this.updateTreeForEntries();
            this.selectItem(providerId, entry);
            this.updateButtons();
        }
    }

    private void saveEntries(ILanguageSettingsProvider provider, List<ICLanguageSettingEntry> entries) {
        if (provider instanceof ILanguageSettingsEditableProvider) {
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
            IResource rc = this.getResource();
            if (entries != null && rc != null) {
                List parentEntries = null;
                parentEntries = rc instanceof IProject ? new ArrayList() : LanguageSettingsManager.getSettingEntriesUpResourceTree((ILanguageSettingsProvider)provider, (ICConfigurationDescription)cfgDescription, (IResource)rc.getParent(), (String)this.currentLanguageId);
                if (entries.equals(parentEntries)) {
                    entries = null;
                }
            }
            ((ILanguageSettingsEditableProvider)provider).setSettingEntries(cfgDescription, rc, this.currentLanguageId, entries);
        }
    }

    private List<ICLanguageSettingEntry> getEntriesShownToUser(ILanguageSettingsProvider provider) {
        IResource rc;
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        List<ICLanguageSettingEntry> entries = provider.getSettingEntries(cfgDescription, rc = this.getResource(), this.currentLanguageId);
        if (entries == null) {
            entries = this.getSettingEntriesUpResourceTree(provider);
        }
        entries = new ArrayList<ICLanguageSettingEntry>(entries);
        return entries;
    }

    private void performAdd(ILanguageSettingsProvider selectedProvider) {
        if (selectedProvider instanceof ILanguageSettingsEditableProvider) {
            ICLanguageSettingEntry settingEntry;
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
            ICLanguageSettingEntry selectedEntry = this.getSelectedEntry();
            LanguageSettingEntryDialog addDialog = new LanguageSettingEntryDialog(this.usercomp.getShell(), cfgDescription, selectedEntry, true);
            if (addDialog.open() && (settingEntry = addDialog.getEntries()[0]) != null) {
                selectedProvider = this.getWorkingCopy((ILanguageSettingsEditableProvider)selectedProvider);
                this.addEntry(selectedProvider, settingEntry);
            }
        }
    }

    private ILanguageSettingsEditableProvider getWorkingCopy(ILanguageSettingsEditableProvider provider) {
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        List<ILanguageSettingsProvider> initialProviders = this.initialProvidersMap.get(cfgDescription.getId());
        if (initialProviders.contains(provider)) {
            ArrayList<ILanguageSettingsEditableProvider> providers = new ArrayList<ILanguageSettingsEditableProvider>(((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders());
            int pos = providers.indexOf(provider);
            if (pos >= 0) {
                try {
                    provider = provider.clone();
                    providers.set(pos, provider);
                    ((ILanguageSettingsProvidersKeeper)cfgDescription).setLanguageSettingProviders(providers);
                }
                catch (CloneNotSupportedException e) {
                    CUIPlugin.log("Internal Error: cannot clone provider " + provider.getId(), e);
                }
            } else {
                CUIPlugin.log("Internal Error: cannot find provider " + provider.getId(), new Exception());
            }
        }
        return provider;
    }

    private void performEdit(ILanguageSettingsProvider selectedProvider, ICLanguageSettingEntry selectedEntry) {
        if (selectedProvider instanceof ILanguageSettingsEditableProvider && selectedEntry != null) {
            ICLanguageSettingEntry newEntry;
            ICConfigurationDescription cfgDecsription = this.getConfigurationDescription();
            LanguageSettingEntryDialog editDialog = new LanguageSettingEntryDialog(this.usercomp.getShell(), cfgDecsription, selectedEntry);
            if (editDialog.open() && (newEntry = editDialog.getEntries()[0]) != null) {
                selectedProvider = this.getWorkingCopy((ILanguageSettingsEditableProvider)selectedProvider);
                this.replaceEntry(selectedProvider, selectedEntry, newEntry);
            }
        }
    }

    private void deleteEntry(ILanguageSettingsProvider provider, ICLanguageSettingEntry entry) {
        if (provider != null && entry != null) {
            String providerId = provider.getId();
            List<ICLanguageSettingEntry> entries = this.getEntriesShownToUser(provider);
            int pos = this.getExactIndex(entries, entry);
            entries.remove(entry);
            this.saveEntries(provider, entries);
            if (pos >= entries.size()) {
                pos = entries.size() - 1;
            }
            ICLanguageSettingEntry entryToSelect = pos >= 0 ? entries.get(pos) : null;
            this.updateTreeForEntries();
            this.selectItem(providerId, entryToSelect);
            this.updateButtons();
        }
    }

    private void replaceEntry(ILanguageSettingsProvider provider, ICLanguageSettingEntry oldEntry, ICLanguageSettingEntry newEntry) {
        if (provider != null && oldEntry != null && newEntry != null) {
            String providerId = provider.getId();
            List<ICLanguageSettingEntry> entries = this.getEntriesShownToUser(provider);
            int pos = this.getExactIndex(entries, oldEntry);
            entries.set(pos, newEntry);
            this.saveEntries(provider, entries);
            this.updateTreeForEntries();
            this.selectItem(providerId, newEntry);
            this.updateButtons();
        }
    }

    private void clearProvider(ILanguageSettingsProvider provider) {
        if (provider != null) {
            String providerId = provider.getId();
            ArrayList<ICLanguageSettingEntry> empty = new ArrayList<ICLanguageSettingEntry>();
            this.saveEntries(provider, empty);
            this.updateTreeForEntries();
            this.selectItem(providerId, null);
            this.updateButtons();
        }
    }

    private void performDelete(ILanguageSettingsProvider selectedProvider, ICLanguageSettingEntry selectedEntry) {
        if (selectedProvider instanceof ILanguageSettingsEditableProvider) {
            selectedProvider = this.getWorkingCopy((ILanguageSettingsEditableProvider)selectedProvider);
            if (selectedEntry != null) {
                this.deleteEntry(selectedProvider, selectedEntry);
            } else {
                this.clearProvider(selectedProvider);
            }
        }
    }

    private void moveEntry(ILanguageSettingsProvider provider, ICLanguageSettingEntry entry, boolean up) {
        if (provider != null && entry != null) {
            String providerId = provider.getId();
            List<ICLanguageSettingEntry> entries = this.getEntriesShownToUser(provider);
            int pos = this.getExactIndex(entries, entry);
            int newPos = up ? pos - 1 : pos + 1;
            Collections.swap(entries, pos, newPos);
            this.saveEntries(provider, entries);
            this.updateTreeForEntries();
            this.selectItem(providerId, entry);
            this.updateButtons();
        }
    }

    private void performMoveUp(ILanguageSettingsProvider selectedProvider, ICLanguageSettingEntry selectedEntry) {
        if (selectedEntry != null && selectedProvider instanceof ILanguageSettingsEditableProvider) {
            selectedProvider = this.getWorkingCopy((ILanguageSettingsEditableProvider)selectedProvider);
            this.moveEntry(selectedProvider, selectedEntry, true);
        }
    }

    private void performMoveDown(ILanguageSettingsProvider selectedProvider, ICLanguageSettingEntry selectedEntry) {
        if (selectedEntry != null && selectedProvider instanceof ILanguageSettingsEditableProvider) {
            selectedProvider = this.getWorkingCopy((ILanguageSettingsEditableProvider)selectedProvider);
            this.moveEntry(selectedProvider, selectedEntry, false);
        }
    }

    private List<ILanguageSettingsProvider> getProviders(String languageSettingId) {
        LinkedList<ILanguageSettingsProvider> itemsList = new LinkedList<ILanguageSettingsProvider>();
        if (this.currentLanguageId != null) {
            IResource rc = this.getResource();
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
            if (rc != null && cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                List cfgProviders = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
                for (ILanguageSettingsProvider cfgProvider : cfgProviders) {
                    List languageIds;
                    ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)cfgProvider);
                    if (rawProvider instanceof LanguageSettingsBaseProvider && (languageIds = ((LanguageSettingsBaseProvider)rawProvider).getLanguageScope()) != null && !languageIds.contains(this.currentLanguageId)) continue;
                    itemsList.add(cfgProvider);
                }
            }
        }
        return itemsList;
    }

    private void updateTreeForEntries() {
        List<ILanguageSettingsProvider> tableItems = this.getProviders(this.currentLanguageId);
        this.treeEntriesViewer.setInput((Object)tableItems.toArray(new Object[tableItems.size()]));
        this.updateStatusLine();
        this.updateButtons();
    }

    private void updateTreeForLanguages(ICResourceDescription rcDes) {
        this.treeLanguages.removeAll();
        this.currentLanguageId = null;
        List languageIds = LanguageSettingsManager.getLanguages((ICResourceDescription)rcDes);
        Collections.sort(languageIds);
        for (String langId : languageIds) {
            String langName;
            ILanguage language = LanguageManager.getInstance().getLanguage(langId);
            if (language == null || (langName = language.getName()) == null || langName.length() == 0) continue;
            TreeItem t = new TreeItem(this.treeLanguages, 0);
            t.setText(0, langName);
            t.setData((Object)langId);
            if (currentLanguageIdGlobal != null && currentLanguageIdGlobal.equals(langId)) {
                this.currentLanguageId = currentLanguageIdGlobal;
                this.treeLanguages.setSelection(t);
                continue;
            }
            if (this.currentLanguageId != null) continue;
            this.currentLanguageId = langId;
        }
    }

    private void selectLanguage(String langId) {
        currentLanguageIdGlobal = this.currentLanguageId = langId;
        TreeItem[] treeItemArray = this.treeLanguages.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem t = treeItemArray[n2];
            if (t.getData().equals(langId)) {
                this.treeLanguages.setSelection(t);
                break;
            }
            ++n2;
        }
    }

    @Override
    public void updateData(ICResourceDescription rcDes) {
        if (!this.canBeVisible()) {
            return;
        }
        if (rcDes != null) {
            if (this.page.isMultiCfg()) {
                this.setAllVisible(false, null);
                return;
            }
            this.setAllVisible(true, null);
            this.updateTreeForLanguages(rcDes);
            this.updateTreeForEntries();
            if (this.masterPropertyPage != null) {
                boolean enabled = this.masterPropertyPage.isLanguageSettingsProvidersEnabled();
                this.enableProvidersCheckBox.setSelection(enabled);
                this.enableTabControls(enabled);
            }
        }
        this.updateButtons();
    }

    @Override
    protected void performDefaults() {
        if (this.page.isForFile() || this.page.isForFolder()) {
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
            if (!(cfgDescription instanceof ILanguageSettingsProvidersKeeper)) {
                return;
            }
            boolean changed = false;
            IResource rc = this.getResource();
            List oldProviders = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
            ArrayList<Object> newProviders = new ArrayList<Object>(oldProviders.size());
            block0: for (ILanguageSettingsProvider provider : oldProviders) {
                ILanguageSettingsEditableProvider providerCopy = null;
                if (provider instanceof ILanguageSettingsEditableProvider) {
                    TreeItem[] treeItemArray = this.treeLanguages.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem langItems = treeItemArray[n2];
                        String langId = (String)langItems.getData();
                        if (langId != null && provider.getSettingEntries(cfgDescription, rc, langId) != null) {
                            if (providerCopy == null && (providerCopy = LanguageSettingsManager.getProviderCopy((ILanguageSettingsEditableProvider)((ILanguageSettingsEditableProvider)provider), (boolean)true)) == null) continue block0;
                            providerCopy.setSettingEntries(cfgDescription, rc, langId, null);
                            changed = true;
                        }
                        ++n2;
                    }
                }
                if (providerCopy != null) {
                    newProviders.add(providerCopy);
                    continue;
                }
                newProviders.add(provider);
            }
            if (changed) {
                ((ILanguageSettingsProvidersKeeper)cfgDescription).setLanguageSettingProviders(newProviders);
                this.updateTreeForEntries();
            }
        }
    }

    @Override
    protected void performApply(ICResourceDescription srcRcDescription, ICResourceDescription destRcDescription) {
        if (!this.page.isForPrefs()) {
            ICConfigurationDescription sd = srcRcDescription.getConfiguration();
            ICConfigurationDescription dd = destRcDescription.getConfiguration();
            if (sd instanceof ILanguageSettingsProvidersKeeper && dd instanceof ILanguageSettingsProvidersKeeper) {
                List newProviders = ((ILanguageSettingsProvidersKeeper)sd).getLanguageSettingProviders();
                ((ILanguageSettingsProvidersKeeper)dd).setLanguageSettingProviders(newProviders);
            }
        }
        this.performOK();
        this.trackInitialSettings();
        this.updateData(this.getResDesc());
    }

    @Override
    protected void performOK() {
        if (this.masterPropertyPage != null && this.enableProvidersCheckBox.getEnabled()) {
            this.masterPropertyPage.applyLanguageSettingsProvidersEnabled();
        }
    }

    @Override
    public boolean canBeVisible() {
        if (!ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(null)) {
            return false;
        }
        if (this.page.isForFile()) {
            List languageIds = LanguageSettingsManager.getLanguages((ICResourceDescription)this.getResDesc());
            for (String langId : languageIds) {
                ILanguage language = LanguageManager.getInstance().getLanguage(langId);
                if (language == null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private class EntriesTreeContentProvider
    implements ITreeContentProvider {
        private EntriesTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            if (parentElement instanceof ILanguageSettingsProvider) {
                ILanguageSettingsProvider lsProvider = (ILanguageSettingsProvider)parentElement;
                ArrayList entriesList = LanguageSettingsEntriesTab.this.getSettingEntriesUpResourceTree(lsProvider);
                if (entriesList == null) {
                    return null;
                }
                entriesList = new ArrayList(entriesList);
                if (!LanguageSettingsEntriesTab.this.builtInCheckBox.getSelection()) {
                    Iterator iter = entriesList.iterator();
                    while (iter.hasNext()) {
                        ICLanguageSettingEntry entry = (ICLanguageSettingEntry)iter.next();
                        if (!entry.isBuiltIn()) continue;
                        iter.remove();
                    }
                }
                return entriesList.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class EntriesTreeLabelProvider
    extends LanguageSettingsProvidersLabelProvider {
        private EntriesTreeLabelProvider() {
        }

        @Override
        protected String[] getOverlayKeys(ILanguageSettingsProvider provider) {
            String[] overlayKeys = super.getOverlayKeys(provider);
            if (provider.getName() == null) {
                return overlayKeys;
            }
            if (LanguageSettingsEntriesTab.this.currentLanguageId != null) {
                IResource rc = LanguageSettingsEntriesTab.this.getResource();
                List entries = LanguageSettingsEntriesTab.this.getSettingEntries(provider);
                if (entries == null && !(rc instanceof IProject)) {
                    List entriesParent = LanguageSettingsEntriesTab.this.getSettingEntriesUpResourceTree(provider);
                    if (entriesParent != null) {
                        overlayKeys[1] = "icons/ovr16/path_inherit_co.gif";
                    }
                } else if (provider instanceof ILanguageSettingsBroadcastingProvider && (LanguageSettingsEntriesTab.this.page.isForFile() || LanguageSettingsEntriesTab.this.page.isForFolder())) {
                    List entriesParent = provider.getSettingEntries(null, null, LanguageSettingsEntriesTab.this.currentLanguageId);
                    if (entries != null && !entries.equals(entriesParent)) {
                        overlayKeys[1] = "icons/ovr16/setting_nav.gif";
                    }
                }
            }
            ICConfigurationDescription cfgDescription = LanguageSettingsEntriesTab.this.getConfigurationDescription();
            List initialProviders = (List)LanguageSettingsEntriesTab.this.initialProvidersMap.get(cfgDescription.getId());
            if (initialProviders != null && !initialProviders.contains(provider)) {
                overlayKeys[1] = "icons/ovr16/edited_ovr.gif";
            }
            return overlayKeys;
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof ICLanguageSettingEntry) {
                ICConfigurationDescription cfgDescription = LanguageSettingsEntriesTab.this.getConfigurationDescription();
                return LanguageSettingsImages.getImage((ICLanguageSettingEntry)element, cfgDescription);
            }
            return super.getImage(element);
        }

        @Override
        public String getText(Object element) {
            if (element instanceof ICLanguageSettingEntry) {
                ICLanguageSettingEntry entry = (ICLanguageSettingEntry)element;
                String s = entry.getName();
                if (entry.getKind() == 4 && (entry.getFlags() & 0x20) == 0) {
                    s = String.valueOf(s) + '=' + entry.getValue();
                }
                return s;
            }
            return super.getText(element);
        }
    }
}

