/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticToken;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class SemanticHighlightings {
    private static final RGB RGB_BLACK = new RGB(0, 0, 0);
    public static final String STATIC_FIELD = "staticField";
    public static final String FIELD = "field";
    public static final String METHOD_DECLARATION = "methodDeclaration";
    public static final String STATIC_METHOD_INVOCATION = "staticMethod";
    public static final String FUNCTION_DECLARATION = "functionDeclaration";
    public static final String FUNCTION = "function";
    public static final String LOCAL_VARIABLE_DECLARATION = "localVariableDeclaration";
    public static final String LOCAL_VARIABLE = "localVariable";
    public static final String GLOBAL_VARIABLE = "globalVariable";
    public static final String PARAMETER_VARIABLE = "parameterVariable";
    public static final String TEMPLATE_PARAMETER = "templateParameter";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String MACRO_REFERENCE = "macroSubstitution";
    public static final String MACRO_DEFINITION = "macroDefinition";
    public static final String TYPEDEF = "typedef";
    public static final String NAMESPACE = "namespace";
    public static final String LABEL = "label";
    public static final String ENUMERATOR = "enumerator";
    public static final String PROBLEM = "problem";
    public static final String EXTERNAL_SDK = "externalSDK";
    public static final String OVERLOADED_OPERATOR = "overloadedOperator";
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.cdt.ui/debug/SemanticHighlighting"));
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public static String getColorPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getStrikethroughPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".strikethrough";
    }

    public static String getUnderlinePreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".underline";
    }

    public static String getEnabledPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new MacroReferenceHighlighting(), new ProblemHighlighting(), new ExternalSDKHighlighting(), new ClassHighlighting(), new StaticFieldHighlighting(), new FieldHighlighting(), new MethodDeclarationHighlighting(), new StaticMethodInvocationHighlighting(), new ParameterVariableHighlighting(), new LocalVariableDeclarationHighlighting(), new LocalVariableHighlighting(), new GlobalVariableHighlighting(), new TemplateParameterHighlighting(), new OverloadedOperatorHighlighting(), new MethodHighlighting(), new EnumHighlighting(), new MacroDefinitionHighlighting(), new FunctionDeclarationHighlighting(), new FunctionHighlighting(), new TypedefHighlighting(), new NamespaceHighlighting(), new LabelHighlighting(), new EnumeratorHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore store) {
        SemanticHighlighting[] semanticHighlightings;
        store.setDefault("semanticHighlighting.enabled", true);
        SemanticHighlighting[] semanticHighlightingArray = semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int n = semanticHighlightings.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticHighlighting semanticHighlighting = semanticHighlightingArray[n2];
            store.setDefault(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), DEBUG || semanticHighlighting.isEnabledByDefault());
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)SemanticHighlightings.getColorPreferenceKey(semanticHighlighting), (RGB)semanticHighlighting.getDefaultTextColor());
            store.setDefault(SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            store.setDefault(SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            store.setDefault(SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting), semanticHighlighting.isStrikethroughByDefault());
            store.setDefault(SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting), DEBUG || semanticHighlighting.isUnderlineByDefault());
            ++n2;
        }
    }

    public static boolean affectsEnablement(IPreferenceStore store, PropertyChangeEvent event) {
        SemanticHighlighting highlighting;
        SemanticHighlighting[] highlightings;
        if (event.getProperty().equals("semanticHighlighting.enabled")) {
            return true;
        }
        String relevantKey = null;
        SemanticHighlighting[] semanticHighlightingArray = highlightings = SemanticHighlightings.getSemanticHighlightings();
        int n = highlightings.length;
        int n2 = 0;
        while (n2 < n) {
            highlighting = semanticHighlightingArray[n2];
            if (event.getProperty().equals(SemanticHighlightings.getEnabledPreferenceKey(highlighting))) {
                relevantKey = event.getProperty();
                break;
            }
            ++n2;
        }
        if (relevantKey == null) {
            return false;
        }
        semanticHighlightingArray = highlightings;
        n = highlightings.length;
        n2 = 0;
        while (n2 < n) {
            highlighting = semanticHighlightingArray[n2];
            String key = SemanticHighlightings.getEnabledPreferenceKey(highlighting);
            if (!key.equals(relevantKey) && store.getBoolean(key)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isEnabled(IPreferenceStore store) {
        SemanticHighlighting[] highlightings;
        if (!store.getBoolean("semanticHighlighting.enabled")) {
            return false;
        }
        SemanticHighlighting[] semanticHighlightingArray = highlightings = SemanticHighlightings.getSemanticHighlightings();
        int n = highlightings.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticHighlighting highlighting = semanticHighlightingArray[n2];
            String enabledKey = SemanticHighlightings.getEnabledPreferenceKey(highlighting);
            if (store.getBoolean(enabledKey)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private SemanticHighlightings() {
    }

    private static final class ClassHighlighting
    extends SemanticHighlighting {
        private ClassHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.CLASS;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 80, 50);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_classes;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            if (node instanceof ICPPASTQualifiedName || node instanceof ICPPASTTemplateId) {
                return false;
            }
            return node instanceof IASTName && (binding = token.getBinding()) instanceof ICPPClassType && !(binding instanceof ICPPTemplateParameter);
        }
    }

    private static final class EnumHighlighting
    extends SemanticHighlighting {
        private EnumHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.ENUM;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(100, 70, 50);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_enums;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            return node instanceof IASTName && (binding = token.getBinding()) instanceof IEnumeration;
        }
    }

    private static final class EnumeratorHighlighting
    extends SemanticHighlighting {
        private EnumeratorHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.ENUMERATOR;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_enumerator;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IEnumerator) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ExternalSDKHighlighting
    extends SemanticHighlighting {
        private ExternalSDKHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.EXTERNAL_SDK;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(100, 40, 128);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isStrikethroughByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_externalSDK;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                if (name instanceof IASTImplicitName) {
                    return false;
                }
                if (name.isReference()) {
                    IBinding binding = token.getBinding();
                    IIndex index = token.getRoot().getIndex();
                    return this.isExternalSDKReference(binding, index);
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isExternalSDKReference(IBinding binding, IIndex index) {
            if (!(binding instanceof IFunction)) return false;
            try {
                IIndexName[] decls;
                if (binding instanceof IIndexBinding ? ((IIndexBinding)binding).isFileLocal() : !(binding instanceof ICExternalBinding)) {
                    return false;
                }
                IIndexName[] iIndexNameArray = decls = index.findNames(binding, 9);
                int n = decls.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        if (decls.length == 0) return false;
                        return true;
                    }
                    IIndexName decl = iIndexNameArray[n2];
                    IIndexFile indexFile = decl.getFile();
                    if (indexFile != null && indexFile.getLocation().getFullPath() != null) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (CoreException exc) {
                CUIPlugin.log(exc.getStatus());
                return false;
            }
        }
    }

    private static final class FieldHighlighting
    extends SemanticHighlighting {
        private FieldHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.FIELD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_field;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IField) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class FunctionDeclarationHighlighting
    extends SemanticHighlighting {
        private FunctionDeclarationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.FUNCTION_DECLARATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_functionDeclaration;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTImplicitName) {
                return false;
            }
            if (node instanceof IASTName && (name = (IASTName)node).isDeclaration()) {
                IBinding binding = token.getBinding();
                if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
                    return true;
                }
                if (binding instanceof IProblemBinding) {
                    if (name instanceof ICPPASTQualifiedName) {
                        return false;
                    }
                    node = name.getParent();
                    while (node instanceof IASTName) {
                        node = node.getParent();
                    }
                    if (node instanceof IASTFunctionDeclarator) {
                        while (node != token.getRoot() && !(node.getParent() instanceof IASTDeclSpecifier)) {
                            node = node.getParent();
                        }
                        return !(node instanceof ICPPASTCompositeTypeSpecifier);
                    }
                }
            }
            return false;
        }
    }

    private static final class FunctionHighlighting
    extends SemanticHighlighting {
        private FunctionHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.FUNCTION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_function;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTImplicitName) {
                return false;
            }
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class GlobalVariableHighlighting
    extends SemanticHighlighting {
        private GlobalVariableHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.GLOBAL_VARIABLE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_globalVariable;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (!(!(binding instanceof IVariable) || binding instanceof IField || binding instanceof IParameter || binding instanceof ICPPTemplateNonTypeParameter || binding instanceof IProblemBinding)) {
                    try {
                        IScope scope = binding.getScope();
                        if (!LocalVariableHighlighting.isLocalScope(scope)) {
                            return true;
                        }
                    }
                    catch (DOMException exc) {
                        CUIPlugin.log(exc);
                    }
                }
            }
            return false;
        }
    }

    private static final class LabelHighlighting
    extends SemanticHighlighting {
        private LabelHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.LABEL;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_label;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof ILabel;
        }
    }

    private static final class LocalVariableDeclarationHighlighting
    extends SemanticHighlighting {
        private LocalVariableDeclarationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE_DECLARATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(128, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_localVariableDeclaration;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTName && (name = (IASTName)node).isDeclaration() && (binding = token.getBinding()) instanceof IVariable && !(binding instanceof IField) && !(binding instanceof IParameter) && !(binding instanceof IProblemBinding)) {
                try {
                    IScope scope = binding.getScope();
                    if (LocalVariableHighlighting.isLocalScope(scope)) {
                        return true;
                    }
                }
                catch (DOMException exc) {
                    CUIPlugin.log(exc);
                }
            }
            return false;
        }
    }

    private static final class LocalVariableHighlighting
    extends SemanticHighlighting {
        private LocalVariableHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_localVariable;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTName && (name = (IASTName)node).isReference() && (binding = token.getBinding()) instanceof IVariable && !(binding instanceof IField) && !(binding instanceof IParameter) && !(binding instanceof IProblemBinding)) {
                try {
                    IScope scope = binding.getScope();
                    if (LocalVariableHighlighting.isLocalScope(scope)) {
                        return true;
                    }
                }
                catch (DOMException exc) {
                    CUIPlugin.log(exc);
                }
            }
            return false;
        }

        public static boolean isLocalScope(IScope scope) {
            while (scope != null) {
                if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                    return true;
                }
                try {
                    scope = scope.getParent();
                }
                catch (DOMException dOMException) {
                    scope = null;
                }
            }
            return false;
        }
    }

    private static final class MacroDefinitionHighlighting
    extends SemanticHighlighting {
        private MacroDefinitionHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.MACRO_DEFINITION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_macroDefintion;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTName name;
            IBinding binding = token.getBinding();
            return binding instanceof IMacroBinding && !(name = (IASTName)token.getNode()).isReference();
        }
    }

    private static final class MacroReferenceHighlighting
    extends SemanticHighlighting {
        private MacroReferenceHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.MACRO_REFERENCE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_macroSubstitution;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTName name;
            IBinding binding = token.getBinding();
            return binding instanceof IMacroBinding && (name = (IASTName)token.getNode()).isReference();
        }
    }

    private static final class MethodDeclarationHighlighting
    extends SemanticHighlighting {
        private MethodDeclarationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD_DECLARATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_methodDeclaration;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            block8: {
                node = token.getNode();
                if (node instanceof IASTImplicitName) {
                    return false;
                }
                if (!(node instanceof IASTName) || (name = (IASTName)node).isReference()) break block8;
                binding = token.getBinding();
                if (binding instanceof ICPPMethod) {
                    return true;
                }
                if (!(binding instanceof IProblemBinding)) break block8;
                node = name.getParent();
                while (node instanceof IASTName) {
                    node = node.getParent();
                }
                if (!(node instanceof ICPPASTFunctionDeclarator)) break block8;
                if (!(name instanceof ICPPASTQualifiedName)) ** GOTO lbl20
                qName = (ICPPASTQualifiedName)name;
                names = qName.getNames();
                if (names.length <= 1 || !(names[names.length - 2].getBinding() instanceof ICPPClassType)) break block8;
                return true;
lbl-1000:
                // 1 sources

                {
                    node = node.getParent();
lbl20:
                    // 2 sources

                    ** while (node != token.getRoot() && !(node.getParent() instanceof IASTDeclSpecifier))
                }
lbl21:
                // 1 sources

                if (node instanceof ICPPASTCompositeTypeSpecifier) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class MethodHighlighting
    extends SemanticHighlighting {
        private MethodHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_method;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTImplicitName) {
                return false;
            }
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ICPPMethod) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class NamespaceHighlighting
    extends SemanticHighlighting {
        private NamespaceHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.NAMESPACE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_namespace;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof ICPPNamespace;
        }
    }

    private static final class OverloadedOperatorHighlighting
    extends SemanticHighlighting {
        private OverloadedOperatorHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.OVERLOADED_OPERATOR;
        }

        @Override
        public boolean requiresImplicitNames() {
            return true;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(200, 100, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_overloadedOperators;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTImplicitName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTImplicitName && (name = (IASTImplicitName)node).isReference() && name.isOperator()) {
                IBinding binding = name.resolveBinding();
                if (binding instanceof ICPPMethod && !(binding instanceof IProblemBinding) && ((ICPPMethod)binding).isImplicit()) {
                    return false;
                }
                if (binding instanceof ICPPUnknownBinding) {
                    return false;
                }
                char[] chars = name.toCharArray();
                return chars[0] != '~' && !OverloadableOperator.isNew((char[])chars) && !OverloadableOperator.isDelete((char[])chars);
            }
            return false;
        }
    }

    private static final class ParameterVariableHighlighting
    extends SemanticHighlighting {
        private ParameterVariableHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.PARAMETER_VARIABLE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_parameterVariable;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof IParameter;
        }
    }

    private static final class ProblemHighlighting
    extends SemanticHighlighting {
        private ProblemHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.PROBLEM;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(224, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isStrikethroughByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_problem;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node.getTranslationUnit().isBasedOnIncompleteIndex()) {
                return false;
            }
            if (node instanceof IASTProblem) {
                return true;
            }
            IBinding binding = token.getBinding();
            return binding instanceof IProblemBinding;
        }
    }

    private static final class StaticFieldHighlighting
    extends SemanticHighlighting {
        private StaticFieldHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_FIELD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_staticField;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IField && !(binding instanceof IProblemBinding)) {
                    return ((IField)binding).isStatic();
                }
            }
            return false;
        }
    }

    private static final class StaticMethodInvocationHighlighting
    extends SemanticHighlighting {
        private StaticMethodInvocationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_METHOD_INVOCATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return RGB_BLACK;
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_staticMethodInvocation;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                if (!name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ICPPMethod && !(binding instanceof IProblemBinding)) {
                    return ((ICPPMethod)binding).isStatic();
                }
            }
            return false;
        }
    }

    private static final class TemplateParameterHighlighting
    extends SemanticHighlighting {
        private TemplateParameterHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.TEMPLATE_PARAMETER;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(100, 70, 50);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_templateParameter;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            return node instanceof IASTName && (binding = token.getBinding()) instanceof ICPPTemplateParameter;
        }
    }

    private static final class TypedefHighlighting
    extends SemanticHighlighting {
        private TypedefHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.TYPEDEF;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 80, 50);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return CEditorMessages.SemanticHighlighting_typeDef;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ITypedef) {
                    return true;
                }
            }
            return false;
        }
    }
}

