/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.breakpoints;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.RawBreakpointVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class GdbBreakpointVMProvider
extends BreakpointVMProvider {
    private final DsfSession fSession;
    private final DsfServicesTracker fServicesTracker;

    public GdbBreakpointVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext);
        this.fSession = session;
        this.fServicesTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), this.fSession.getId());
    }

    public void dispose() {
        this.fServicesTracker.dispose();
        super.dispose();
    }

    protected void calcFileteredBreakpoints(DataRequestMonitor<IBreakpoint[]> rm) {
        if (Boolean.TRUE.equals(this.getPresentationContext().getProperty("FilterSelection"))) {
            IBreakpoint[] allBreakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            ArrayList<IBreakpoint> filteredBPs = new ArrayList<IBreakpoint>(allBreakpoints.length);
            IBreakpoint[] iBreakpointArray = allBreakpoints;
            int n = allBreakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint bp = iBreakpointArray[n2];
                if (bp instanceof ICBreakpoint && bp.getModelIdentifier().equals("org.eclipse.cdt.debug.core")) {
                    filteredBPs.add(bp);
                }
                ++n2;
            }
            rm.setData((Object)filteredBPs.toArray(new IBreakpoint[filteredBPs.size()]));
            rm.done();
        } else {
            super.calcFileteredBreakpoints(rm);
        }
    }

    protected IVMNode createBreakpointVMNode() {
        return new RawBreakpointVMNode((BreakpointVMProvider)this);
    }

    public void getBreakpointsForDebugContext(ISelection debugContext, final DataRequestMonitor<IBreakpoint[]> rm) {
        Object element;
        IRunControl.IExecutionDMContext _execCtx = null;
        if (debugContext instanceof IStructuredSelection && (element = ((IStructuredSelection)debugContext).getFirstElement()) instanceof IDMVMContext) {
            _execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRunControl.IExecutionDMContext.class);
        }
        if (_execCtx == null || !this.fSession.getId().equals(_execCtx.getSessionId())) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10002, "Debug context doesn't contain a thread", null));
            rm.done();
            return;
        }
        final IRunControl.IExecutionDMContext execCtx = _execCtx;
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IBreakpointsExtension bpService = (IBreakpointsExtension)GdbBreakpointVMProvider.this.fServicesTracker.getService(IBreakpointsExtension.class);
                    if (bpService == null) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Breakpoints service not available", null));
                        rm.done();
                        return;
                    }
                    bpService.getExecutionContextBreakpoints(execCtx, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]>((Executor)GdbBreakpointVMProvider.this.fSession.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            MIBreakpointsManager bpManager = (MIBreakpointsManager)GdbBreakpointVMProvider.this.fServicesTracker.getService(MIBreakpointsManager.class);
                            if (bpManager == null) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Breakpoints service not available", null));
                                rm.done();
                                return;
                            }
                            IBreakpoint bp = null;
                            if (((IBreakpoints.IBreakpointDMContext[])this.getData()).length > 0) {
                                bp = bpManager.findPlatformBreakpoint(((IBreakpoints.IBreakpointDMContext[])this.getData())[0]);
                            }
                            if (bp != null) {
                                rm.setData((Object)new IBreakpoint[]{bp});
                            } else {
                                rm.setData((Object)new IBreakpoint[0]);
                            }
                            rm.done();
                        }
                    });
                }
            });
        }
        catch (RejectedExecutionException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Request for monitor: '" + ((Object)((Object)this)).toString() + "' resulted in a rejected execution exception.", (Throwable)e));
            rm.done();
        }
    }
}

