/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;

public class GitModelTree
extends GitModelObjectContainer {
    private final int kind;
    protected final IPath path;
    final Map<String, GitModelObject> cachedTreeMap = new HashMap<String, GitModelObject>();

    public GitModelTree(GitModelObjectContainer parent, IPath fullPath, int kind) {
        super(parent);
        this.kind = kind;
        this.path = fullPath;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public IPath getLocation() {
        return this.path;
    }

    public int getKind() {
        return this.kind;
    }

    public int repositoryHashCode() {
        return this.getParent().repositoryHashCode();
    }

    public GitModelObject[] getChildren() {
        Collection<GitModelObject> values = this.cachedTreeMap.values();
        return values.toArray(new GitModelObject[values.size()]);
    }

    public boolean isContainer() {
        return true;
    }

    public void dispose() {
        for (GitModelObject value : this.cachedTreeMap.values()) {
            value.dispose();
        }
        this.cachedTreeMap.clear();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getParent() == null ? 0 : ((Object)((Object)this.getParent())).hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GitModelTree other = (GitModelTree)((Object)obj);
        if (this.getParent() == null ? other.getParent() != null : !((Object)((Object)this.getParent())).equals((Object)other.getParent())) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        return "ModelTree[location=" + this.getLocation() + "]";
    }
}

