/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.CommitInfoBuilder;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

class FormatJob
extends Job {
    private Object lock = new Object();
    private FormatRequest formatRequest;
    private FormatResult formatResult;

    public boolean belongsTo(Object family) {
        if (family.equals(JobFamilies.FORMAT_COMMIT_INFO)) {
            return true;
        }
        return super.belongsTo(family);
    }

    FormatJob(FormatRequest formatRequest) {
        super(UIText.FormatJob_buildingCommitInfo);
        this.formatRequest = formatRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FormatResult getFormatResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.formatResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        String commitInfo;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        try {
            CommitInfoBuilder builder;
            Object object = this.lock;
            synchronized (object) {
                SWTCommit commit = (SWTCommit)this.formatRequest.getCommit();
                commit.parseBody();
                builder = new CommitInfoBuilder(this.formatRequest.getRepository(), commit, this.formatRequest.getCurrentDiffs(), this.formatRequest.isFill(), this.formatRequest.getAllRefs());
                builder.setColors(this.formatRequest.getLinkColor(), this.formatRequest.getDarkGrey(), this.formatRequest.getHunkheaderColor(), this.formatRequest.getLinesAddedColor(), this.formatRequest.getLinesRemovedColor());
            }
            commitInfo = builder.format(styles, monitor);
        }
        catch (IOException e) {
            return Activator.createErrorStatus(e.getMessage(), e);
        }
        StyleRange[] arr = new StyleRange[styles.size()];
        styles.toArray(arr);
        Arrays.sort(arr, new Comparator<StyleRange>(){

            @Override
            public int compare(StyleRange o1, StyleRange o2) {
                return o1.start - o2.start;
            }
        });
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Object object = this.lock;
        synchronized (object) {
            this.formatResult = new FormatResult(commitInfo, arr);
        }
        return Status.OK_STATUS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FormatRequest {
        private Repository repository;
        private PlotCommit<?> commit;
        private boolean fill;
        List<FileDiff> currentDiffs;
        private Color linkColor;
        private Color darkGrey;
        private Color hunkheaderColor;
        private Color linesAddedColor;
        private Color linesRemovedColor;
        private Collection<Ref> allRefs;

        public Color getLinkColor() {
            return this.linkColor;
        }

        public void setLinkColor(Color linkColor) {
            this.linkColor = linkColor;
        }

        public Color getDarkGrey() {
            return this.darkGrey;
        }

        public void setDarkGrey(Color darkGrey) {
            this.darkGrey = darkGrey;
        }

        public Color getHunkheaderColor() {
            return this.hunkheaderColor;
        }

        public void setHunkheaderColor(Color hunkheaderColor) {
            this.hunkheaderColor = hunkheaderColor;
        }

        public Color getLinesAddedColor() {
            return this.linesAddedColor;
        }

        public void setLinesAddedColor(Color linesAddedColor) {
            this.linesAddedColor = linesAddedColor;
        }

        public Color getLinesRemovedColor() {
            return this.linesRemovedColor;
        }

        public void setLinesRemovedColor(Color linesRemovedColor) {
            this.linesRemovedColor = linesRemovedColor;
        }

        public Collection<Ref> getAllRefs() {
            return this.allRefs;
        }

        public void setAllRefs(Collection<Ref> allRefs) {
            this.allRefs = allRefs;
        }

        FormatRequest(Repository repository, PlotCommit<?> commit, boolean fill, List<FileDiff> currentDiffs, Color linkColor, Color darkGrey, Color hunkheaderColor, Color linesAddedColor, Color linesRemovedColor, Collection<Ref> allRefs) {
            this.repository = repository;
            this.commit = commit;
            this.fill = fill;
            this.currentDiffs = new ArrayList<FileDiff>(currentDiffs);
            this.linkColor = linkColor;
            this.darkGrey = darkGrey;
            this.hunkheaderColor = hunkheaderColor;
            this.linesAddedColor = linesAddedColor;
            this.linesRemovedColor = linesRemovedColor;
            this.allRefs = allRefs;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public PlotCommit<?> getCommit() {
            return this.commit;
        }

        public boolean isFill() {
            return this.fill;
        }

        public List<FileDiff> getCurrentDiffs() {
            return this.currentDiffs;
        }
    }

    static class FormatResult {
        String commitInfo;
        StyleRange[] styleRange;

        FormatResult(String commmitInfo, StyleRange[] styleRange) {
            this.commitInfo = commmitInfo;
            this.styleRange = styleRange;
        }

        public String getCommitInfo() {
            return this.commitInfo;
        }

        public StyleRange[] getStyleRange() {
            return this.styleRange;
        }
    }
}

