/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.List;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.dialogs.FileTreeContentProvider;
import org.eclipse.egit.ui.internal.dialogs.FileTreeLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonDeletedFilesTree
extends TreeViewer {
    private final List<String> filePaths;

    public NonDeletedFilesTree(Composite parent, Repository repository, List<String> pathList) {
        super(NonDeletedFilesTree.createComposite(parent), 2048);
        this.filePaths = pathList;
        Composite main = this.getTree().getParent();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getTree());
        final FileTreeContentProvider cp = new FileTreeContentProvider(repository);
        this.setContentProvider((IContentProvider)cp);
        this.setLabelProvider((IBaseLabelProvider)new FileTreeLabelProvider());
        this.setInput(this.filePaths);
        this.expandAll();
        ToolBar dropDownBar = new ToolBar(main, 0x820000);
        GridDataFactory.swtDefaults().align(1, 1).grab(false, false).applyTo((Control)dropDownBar);
        final ToolItem dropDownItem = new ToolItem(dropDownBar, 4);
        Image dropDownImage = UIIcons.HIERARCHY.createImage();
        UIUtils.hookDisposal((Widget)dropDownItem, (Resource)dropDownImage);
        dropDownItem.setImage(dropDownImage);
        final Menu menu = new Menu((Control)dropDownBar);
        dropDownItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menu.dispose();
            }
        });
        dropDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle b = dropDownItem.getBounds();
                Point p = dropDownItem.getParent().toDisplay(new Point(b.x, b.y + b.height));
                menu.setLocation(p.x, p.y);
                menu.setVisible(true);
            }
        });
        final MenuItem showRepoRelative = new MenuItem(menu, 16);
        showRepoRelative.setText(UIText.NonDeletedFilesTree_RepoRelativePathsButton);
        showRepoRelative.setSelection(true);
        showRepoRelative.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (showRepoRelative.getSelection()) {
                    cp.setMode(FileTreeContentProvider.Mode.REPO_RELATIVE_PATHS);
                    NonDeletedFilesTree.this.setInput(NonDeletedFilesTree.this.getInput());
                    NonDeletedFilesTree.this.expandAll();
                }
            }
        });
        final MenuItem showFull = new MenuItem(menu, 16);
        showFull.setText(UIText.NonDeletedFilesTree_FileSystemPathsButton);
        showFull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (showFull.getSelection()) {
                    cp.setMode(FileTreeContentProvider.Mode.FULL_PATHS);
                    NonDeletedFilesTree.this.setInput(NonDeletedFilesTree.this.getInput());
                    NonDeletedFilesTree.this.expandAll();
                }
            }
        });
        final MenuItem showResource = new MenuItem(menu, 16);
        showResource.setText(UIText.NonDeletedFilesTree_ResourcePathsButton);
        showResource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (showResource.getSelection()) {
                    cp.setMode(FileTreeContentProvider.Mode.RESOURCE_PATHS);
                    NonDeletedFilesTree.this.setInput(NonDeletedFilesTree.this.getInput());
                    NonDeletedFilesTree.this.expandAll();
                }
            }
        });
    }

    private static Composite createComposite(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(2).applyTo(main);
        return main;
    }
}

