/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.FileEditableRevision;
import org.eclipse.egit.ui.internal.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.LocalFileRevision;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTreeView
extends ViewPart
implements IMenuListener,
IShowInSource {
    public static final String INDEX_VERSION = "%%%INDEX%%%";
    public static final String ID = "org.eclipse.egit.ui.CompareTreeView";
    private static final Image FILE_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image SAME_CONTENT = UIIcons.ELCL16_SYNCED.createImage();
    private Image ADDED = UIIcons.ELCL16_ADD.createImage();
    private Image DELETED = UIIcons.ELCL16_DELETE.createImage();
    private RepositoryMapping repositoryMapping;
    private TreeViewer tree;
    private ActionFactory.IWorkbenchAction showEqualsAction;
    private Map<IPath, GitFileRevision> compareVersionMap = new HashMap<IPath, GitFileRevision>();
    private Map<IPath, GitFileRevision> baseVersionMap = new HashMap<IPath, GitFileRevision>();
    private Set<IPath> addedPaths = new HashSet<IPath>();
    private Set<IPath> equalContentPaths = new HashSet<IPath>();
    private Set<IPath> baseVersionPathsWithChildren = new HashSet<IPath>();
    private Map<IPath, List<PathNodeAdapter>> compareVersionPathsWithChildren = new HashMap<IPath, List<PathNodeAdapter>>();
    private Set<IPath> deletedPaths = new HashSet<IPath>();
    private List<ActionFactory.IWorkbenchAction> actionsToDispose = new ArrayList<ActionFactory.IWorkbenchAction>();
    private Object input;
    private String compareVersion;
    private String baseVersion;
    private boolean showEquals = false;

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        this.tree = new TreeViewer(main, 2);
        this.tree.setContentProvider((IContentProvider)new PathNodeContentProvider());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tree.getTree());
        this.tree.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CompareTreeView.this.reactOnOpen(event);
            }
        });
        this.tree.getTree().setEnabled(false);
        this.createActions();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tree);
        this.createContextMenu();
    }

    private void createActions() {
        CompareUtils.ReuseCompareEditorAction reuseCompareEditorAction = new CompareUtils.ReuseCompareEditorAction();
        this.actionsToDispose.add(reuseCompareEditorAction);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)reuseCompareEditorAction);
        this.showEqualsAction = new BooleanPrefAction((IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore(), "CompareTreeView_ShowEquals", UIText.CompareTreeView_EqualFilesTooltip){

            public void apply(boolean value) {
                CompareTreeView.this.buildTrees(false);
            }
        };
        this.showEqualsAction.setImageDescriptor(UIIcons.ELCL16_SYNCED);
        this.showEqualsAction.setEnabled(false);
        this.actionsToDispose.add(this.showEqualsAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.showEqualsAction);
        Action expandAllAction = new Action(UIText.CompareTreeView_CollapseAllTooltip){

            public void run() {
                CompareTreeView.this.tree.collapseAll();
            }
        };
        expandAllAction.setImageDescriptor(UIIcons.COLLAPSEALL);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)expandAllAction);
    }

    private void reactOnOpen(OpenEvent event) {
        Object right;
        Object left;
        block12: {
            Object node;
            Object selected;
            block14: {
                block13: {
                    block11: {
                        selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (selected instanceof IContainer) {
                            TreeViewer tv;
                            tv.setExpandedState(selected, !(tv = (TreeViewer)event.getViewer()).getExpandedState(selected));
                            return;
                        }
                        if (!(selected instanceof IFile)) break block11;
                        IFile res = (IFile)selected;
                        LocalFileRevision revision = new LocalFileRevision(res);
                        left = new FileEditableRevision((IFileRevision)revision, res, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
                        GitFileRevision rightRevision = this.compareVersionMap.get(new Path(this.repositoryMapping.getRepoRelativePath((IResource)res)));
                        if (rightRevision == null) {
                            right = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.CompareTreeView_ItemNotFoundInVersionMessage, (Object)res.getName(), (Object)this.getCompareVersion()));
                        } else {
                            String encoding = CompareCoreUtils.getResourceEncoding((IResource)res);
                            right = new FileRevisionTypedElement((IFileRevision)rightRevision, encoding);
                        }
                        break block12;
                    }
                    if (!(selected instanceof GitFileRevision)) break block13;
                    GitFileRevision rightRevision = (GitFileRevision)selected;
                    left = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.CompareTreeView_ItemNotFoundInVersionMessage, (Object)rightRevision.getName(), (Object)this.getBaseVersion()));
                    right = new FileRevisionTypedElement((IFileRevision)rightRevision, null);
                    break block12;
                }
                if (!(selected instanceof PathNode)) break block14;
                node = (PathNode)selected;
                String encoding = CompareCoreUtils.getResourceEncoding((Repository)this.getRepository(), (String)((PathNode)node).getRepoRelativePath());
                switch (((PathNode)node).type) {
                    case FILE_BOTH_SIDES_DIFFER: 
                    case FILE_BOTH_SIDES_SAME: {
                        GitFileRevision rightRevision = this.compareVersionMap.get(((PathNode)node).path);
                        right = new FileRevisionTypedElement((IFileRevision)rightRevision, encoding);
                        GitFileRevision leftRevision = this.baseVersionMap.get(((PathNode)node).path);
                        left = new FileRevisionTypedElement((IFileRevision)leftRevision, encoding);
                        break block12;
                    }
                    case FILE_DELETED: {
                        GitFileRevision rightRevision = this.compareVersionMap.get(((PathNode)node).path);
                        right = new FileRevisionTypedElement((IFileRevision)rightRevision, encoding);
                        left = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.CompareTreeView_ItemNotFoundInVersionMessage, (Object)rightRevision.getName(), (Object)this.getBaseVersion()));
                        break block12;
                    }
                    case FILE_ADDED: {
                        GitFileRevision leftRevision = this.baseVersionMap.get(((PathNode)node).path);
                        left = new FileRevisionTypedElement((IFileRevision)leftRevision, encoding);
                        right = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.CompareTreeView_ItemNotFoundInVersionMessage, (Object)leftRevision.getName(), (Object)this.getCompareVersion()));
                        break block12;
                    }
                    case FOLDER: {
                        TreeViewer tv = (TreeViewer)event.getViewer();
                        tv.setExpandedState(selected, !tv.getExpandedState(selected));
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (selected instanceof PathNodeAdapter) {
                node = (PathNodeAdapter)selected;
                GitFileRevision rightRevision = this.compareVersionMap.get(((PathNodeAdapter)node).pathNode.path);
                String encoding = CompareCoreUtils.getResourceEncoding((Repository)this.getRepository(), (String)((PathNodeAdapter)node).pathNode.getRepoRelativePath());
                right = new FileRevisionTypedElement((IFileRevision)rightRevision, encoding);
                left = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.CompareTreeView_ItemNotFoundInVersionMessage, (Object)((PathNodeAdapter)node).pathNode.path.lastSegment(), (Object)this.getBaseVersion()));
            } else {
                return;
            }
        }
        GitCompareFileRevisionEditorInput compareInput = new GitCompareFileRevisionEditorInput((ITypedElement)left, (ITypedElement)right, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
        CompareUtils.openInCompare(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (CompareEditorInput)compareInput);
    }

    private String getBaseVersion() {
        if (this.baseVersion == null) {
            return UIText.CompareTreeView_WorkspaceVersionText;
        }
        return this.baseVersion;
    }

    private String getCompareVersion() {
        return this.compareVersion;
    }

    public void setFocus() {
        this.tree.getTree().setFocus();
    }

    public void setInput(IResource[] input, String compareVersion) {
        this.setResourceInput(input);
        this.baseVersion = null;
        this.compareVersion = compareVersion;
        this.buildTrees(true);
        this.updateControls();
    }

    private void setResourceInput(IResource[] input) {
        if (input.length > 0) {
            IResource originalInput;
            ArrayList<IResource> resources = new ArrayList<IResource>(input.length);
            ArrayList<IPath> allPaths = new ArrayList<IPath>(input.length);
            IResource[] iResourceArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                originalInput = iResourceArray[n2];
                allPaths.add(originalInput.getFullPath());
                ++n2;
            }
            iResourceArray = input;
            n = input.length;
            n2 = 0;
            while (n2 < n) {
                originalInput = iResourceArray[n2];
                boolean skip = false;
                for (IPath path : allPaths) {
                    if (!path.isPrefixOf(originalInput.getFullPath()) || path.segmentCount() >= originalInput.getFullPath().segmentCount()) continue;
                    skip = true;
                    break;
                }
                if (!skip) {
                    resources.add(originalInput);
                }
                ++n2;
            }
            this.input = resources.toArray(new IResource[resources.size()]);
        } else {
            this.input = input;
        }
    }

    public void setInput(IResource[] input, String baseVersion, String compareVersion) {
        this.setResourceInput(input);
        this.baseVersion = baseVersion;
        this.compareVersion = compareVersion;
        this.buildTrees(true);
        this.updateControls();
    }

    public void setInput(Repository input, String baseVersion, String compareVersion) {
        this.input = input;
        this.baseVersion = baseVersion;
        this.compareVersion = compareVersion;
        this.buildTrees(true);
        this.updateControls();
    }

    private void updateControls() {
        for (ActionFactory.IWorkbenchAction action : this.actionsToDispose) {
            action.setEnabled(this.input != null);
        }
        this.tree.getTree().setEnabled(this.input != null);
        if (this.input == null) {
            this.setContentDescription(UIText.CompareTreeView_NoInputText);
        } else {
            String name;
            if (this.input instanceof IResource[]) {
                IResource[] resources = (IResource[])this.input;
                name = resources.length == 1 ? resources[0].getFullPath().makeRelative().toString() : UIText.CompareTreeView_MultipleResourcesHeaderText;
            } else if (this.input instanceof Repository) {
                name = Activator.getDefault().getRepositoryUtil().getRepositoryName((Repository)this.input);
            } else {
                throw new IllegalStateException();
            }
            if (this.baseVersion == null) {
                this.setContentDescription(NLS.bind((String)UIText.CompareTreeView_ComparingWorkspaceVersionDescription, (Object)name, (Object)(this.compareVersion.equals(INDEX_VERSION) ? UIText.CompareTreeView_IndexVersionText : this.compareVersion)));
            } else {
                this.setContentDescription(NLS.bind((String)UIText.CompareTreeView_ComparingTwoVersionDescription, (Object[])new String[]{this.baseVersion, name, this.compareVersion.equals(INDEX_VERSION) ? UIText.CompareTreeView_IndexVersionText : this.compareVersion}));
            }
        }
    }

    private void buildTrees(final boolean buildMaps) {
        RevCommit baseCommit;
        RevCommit compareCommit;
        Repository repo;
        final Object[] wsExpaneded = this.tree.getExpandedElements();
        final ISelection wsSel = this.tree.getSelection();
        this.tree.setInput(null);
        if (this.baseVersion == null) {
            this.tree.setContentProvider((IContentProvider)new WorkbenchTreeContentProvider());
            this.tree.setComparator((ViewerComparator)new WorkbenchTreeComparator());
            this.tree.setLabelProvider((IBaseLabelProvider)new WorkbenchTreeLabelProvider());
        } else {
            this.tree.setContentProvider((IContentProvider)new PathNodeContentProvider());
            this.tree.setComparator((ViewerComparator)new PathNodeTreeComparator());
            this.tree.setLabelProvider((IBaseLabelProvider)new PathNodeLabelProvider());
        }
        for (ActionFactory.IWorkbenchAction action : this.actionsToDispose) {
            action.setEnabled(false);
        }
        this.showEquals = Activator.getDefault().getPreferenceStore().getBoolean("CompareTreeView_ShowEquals");
        if (this.input instanceof IResource[]) {
            this.repositoryMapping = RepositoryMapping.getMapping((IResource)((IResource[])this.input)[0]);
            if (this.repositoryMapping == null || this.repositoryMapping.getRepository() == null) {
                return;
            }
            repo = this.repositoryMapping.getRepository();
        } else if (this.input instanceof Repository) {
            repo = (Repository)this.input;
        } else {
            return;
        }
        RevWalk rw = new RevWalk(repo);
        try {
            try {
                ObjectId commitId = repo.resolve(this.compareVersion);
                RevCommit revCommit = compareCommit = commitId != null ? rw.parseCommit((AnyObjectId)commitId) : null;
                if (this.baseVersion == null) {
                    baseCommit = null;
                } else {
                    commitId = repo.resolve(this.baseVersion);
                    baseCommit = rw.parseCommit((AnyObjectId)commitId);
                }
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                rw.release();
                return;
            }
        }
        finally {
            rw.release();
        }
        this.showBusy(true);
        try {
            try {
                new ProgressMonitorDialog(this.getViewSite().getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            if (buildMaps) {
                                CompareTreeView.this.buildMaps(repo, baseCommit, compareCommit, monitor);
                            }
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    CompareTreeView.this.tree.setInput(CompareTreeView.this.input);
                                    CompareTreeView.this.tree.setExpandedElements(wsExpaneded);
                                    CompareTreeView.this.tree.setSelection(wsSel);
                                    CompareTreeView.this.updateControls();
                                }
                            });
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.handleError(e.getTargetException().getMessage(), e.getTargetException(), true);
                this.showBusy(false);
            }
            catch (InterruptedException interruptedException) {
                this.input = null;
                this.showBusy(false);
            }
        }
        finally {
            this.showBusy(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void buildMaps(Repository repository, RevCommit baseCommit, RevCommit compareCommit, IProgressMonitor monitor) throws InterruptedException, IOException {
        monitor.beginTask(UIText.CompareTreeView_AnalyzingRepositoryTaskText, -1);
        useIndex = this.compareVersion.equals("%%%INDEX%%%");
        this.deletedPaths.clear();
        this.equalContentPaths.clear();
        this.baseVersionMap.clear();
        this.compareVersionMap.clear();
        this.compareVersionPathsWithChildren.clear();
        this.addedPaths.clear();
        this.baseVersionPathsWithChildren.clear();
        checkIgnored = false;
        tw = new TreeWalk(repository);
        try {
            if (baseCommit == null) {
                checkIgnored = true;
                baseTreeIndex = tw.addTree((AbstractTreeIterator)new AdaptableFileTreeIterator(repository, ResourcesPlugin.getWorkspace().getRoot()));
            } else {
                baseTreeIndex = tw.addTree((AbstractTreeIterator)new CanonicalTreeParser(null, repository.newObjectReader(), (AnyObjectId)baseCommit.getTree()));
            }
            compareTreeIndex = useIndex == false ? tw.addTree((AbstractTreeIterator)new CanonicalTreeParser(null, repository.newObjectReader(), (AnyObjectId)compareCommit.getTree())) : tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
            if (this.input instanceof IResource[]) {
                resources = (IResource[])this.input;
                orFilters = new ArrayList<PathFilter>(resources.length);
                var15_12 = resources;
                var14_13 = resources.length;
                var13_14 = 0;
                while (var13_14 < var14_13) {
                    resource = var15_12[var13_14];
                    relPath = this.repositoryMapping.getRepoRelativePath(resource);
                    if (relPath.length() > 0) {
                        orFilters.add(PathFilter.create((String)relPath));
                    }
                    ++var13_14;
                }
                if (checkIgnored) {
                    if (orFilters.size() > 1) {
                        andFilter = AndTreeFilter.create((TreeFilter)new NotIgnoredFilter(baseTreeIndex), (TreeFilter)OrTreeFilter.create(orFilters));
                        tw.setFilter(andFilter);
                    } else if (orFilters.size() == 1) {
                        andFilter = AndTreeFilter.create((TreeFilter)new NotIgnoredFilter(baseTreeIndex), (TreeFilter)((TreeFilter)orFilters.get(0)));
                        tw.setFilter(andFilter);
                    } else {
                        tw.setFilter((TreeFilter)new NotIgnoredFilter(baseTreeIndex));
                    }
                } else if (orFilters.size() > 1) {
                    tw.setFilter(OrTreeFilter.create(orFilters));
                } else if (orFilters.size() == 1) {
                    tw.setFilter((TreeFilter)orFilters.get(0));
                }
            }
            tw.setRecursive(true);
            if (!monitor.isCanceled()) ** GOTO lbl108
            throw new InterruptedException();
lbl-1000:
            // 1 sources

            {
                block31: {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    compareVersionIterator = tw.getTree(compareTreeIndex, AbstractTreeIterator.class);
                    baseVersionIterator = tw.getTree(baseTreeIndex, AbstractTreeIterator.class);
                    if (compareVersionIterator == null || baseVersionIterator == null) break block31;
                    monitor.setTaskName(baseVersionIterator.getEntryPathString());
                    currentPath = new Path(baseVersionIterator.getEntryPathString());
                    if (!useIndex) {
                        this.compareVersionMap.put((IPath)currentPath, GitFileRevision.inCommit((Repository)repository, (RevCommit)compareCommit, (String)baseVersionIterator.getEntryPathString(), (ObjectId)tw.getObjectId(compareTreeIndex)));
                    } else {
                        this.compareVersionMap.put((IPath)currentPath, GitFileRevision.inIndex((Repository)repository, (String)baseVersionIterator.getEntryPathString()));
                    }
                    if (baseCommit != null) {
                        this.baseVersionMap.put((IPath)currentPath, GitFileRevision.inCommit((Repository)repository, (RevCommit)baseCommit, (String)baseVersionIterator.getEntryPathString(), (ObjectId)tw.getObjectId(baseTreeIndex)));
                    }
                    if (equalContent = compareVersionIterator.getEntryObjectId().equals((AnyObjectId)baseVersionIterator.getEntryObjectId())) {
                        this.equalContentPaths.add((IPath)currentPath);
                    }
                    if (!equalContent || this.showEquals) ** GOTO lbl-1000
                    continue;
                    while (this.baseVersionPathsWithChildren.add((IPath)(currentPath = currentPath.removeLastSegments(1)))) lbl-1000:
                    // 2 sources

                    {
                        if (currentPath.segmentCount() > 0) continue;
                        continue block4;
                    }
                    continue;
                }
                if (baseVersionIterator != null && compareVersionIterator == null) {
                    monitor.setTaskName(baseVersionIterator.getEntryPathString());
                    currentPath = new Path(baseVersionIterator.getEntryPathString());
                    this.addedPaths.add((IPath)currentPath);
                    if (baseCommit != null) {
                        this.baseVersionMap.put((IPath)currentPath, GitFileRevision.inCommit((Repository)repository, (RevCommit)baseCommit, (String)baseVersionIterator.getEntryPathString(), (ObjectId)tw.getObjectId(baseTreeIndex)));
                    }
                    while (currentPath.segmentCount() > 0) {
                        if (!this.baseVersionPathsWithChildren.add((IPath)(currentPath = currentPath.removeLastSegments(1)))) continue block4;
                    }
                } else {
                    if (compareVersionIterator == null || baseVersionIterator != null) continue;
                    monitor.setTaskName(compareVersionIterator.getEntryPathString());
                    currentPath = new Path(compareVersionIterator.getEntryPathString());
                    this.deletedPaths.add((IPath)currentPath);
                    children = this.compareVersionPathsWithChildren.get(currentPath.removeLastSegments(1));
                    if (children == null) {
                        children = new ArrayList<PathNodeAdapter>(1);
                        this.compareVersionPathsWithChildren.put(currentPath.removeLastSegments(1), children);
                    }
                    children.add(new PathNodeAdapter(new PathNode((IPath)currentPath, PathNode.Type.FILE_DELETED)));
                    if (!useIndex) {
                        this.compareVersionMap.put((IPath)currentPath, GitFileRevision.inCommit((Repository)repository, (RevCommit)compareCommit, (String)compareVersionIterator.getEntryPathString(), (ObjectId)tw.getObjectId(compareTreeIndex)));
                        continue;
                    }
                    this.compareVersionMap.put((IPath)currentPath, GitFileRevision.inIndex((Repository)repository, (String)compareVersionIterator.getEntryPathString()));
                }
lbl108:
                // 9 sources

                ** while (tw.next())
            }
lbl109:
            // 1 sources

        }
        finally {
            tw.release();
            monitor.done();
        }
    }

    public void dispose() {
        super.dispose();
        for (ActionFactory.IWorkbenchAction action : this.actionsToDispose) {
            action.dispose();
        }
        this.ADDED.dispose();
        this.DELETED.dispose();
        this.SAME_CONTENT.dispose();
    }

    public void menuAboutToShow(IMenuManager manager) {
        ITreeSelection selection = (ITreeSelection)this.tree.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        manager.add((IContributionItem)new Separator("group.open"));
        manager.add((IContributionItem)new Separator("additions"));
        IAction openAction = this.createOpenAction(selection);
        if (openAction != null) {
            manager.appendToGroup("group.open", openAction);
        }
        MenuManager showInSubMenu = new MenuManager(UIText.CompareTreeView_ShowIn_label);
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getSite().getWorkbenchWindow()));
        manager.appendToGroup("group.open", (IContributionItem)showInSubMenu);
    }

    public ShowInContext getShowInContext() {
        IPath repoPath = this.getRepositoryPath();
        ITreeSelection selection = (ITreeSelection)this.tree.getSelection();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (Object obj : selection) {
            PathNode pathNode;
            IResource resource;
            if (obj instanceof IResource) {
                resources.add((IResource)obj);
                continue;
            }
            if (!(obj instanceof PathNode) || repoPath == null || (resource = ResourceUtil.getResourceForLocation((IPath)repoPath.append((pathNode = (PathNode)obj).getRepoRelativePath()))) == null) continue;
            resources.add(resource);
        }
        return new ShowInContext(null, (ISelection)new StructuredSelection(resources));
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)this);
        Menu contextMenu = manager.createContextMenu(this.tree.getControl());
        this.tree.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.tree);
    }

    private void openFileInEditor(String filePath) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        File file = new File(filePath);
        if (!file.exists()) {
            String message = NLS.bind((String)UIText.CommitFileDiffViewer_FileDoesNotExist, (Object)filePath);
            Activator.showError(message, null);
        }
        IWorkbenchPage page = window.getActivePage();
        EgitUiEditorUtils.openEditor(file, page);
    }

    private IAction createOpenAction(ITreeSelection selection) {
        final List<String> pathsToOpen = this.getSelectedPaths(selection);
        if (pathsToOpen == null || pathsToOpen.isEmpty()) {
            return null;
        }
        return new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel){

            public void run() {
                for (String filePath : pathsToOpen) {
                    CompareTreeView.this.openFileInEditor(filePath);
                }
            }
        };
    }

    private List<String> getSelectedPaths(ITreeSelection selection) {
        IPath repoPath = this.getRepositoryPath();
        ArrayList<String> pathsToOpen = new ArrayList<String>();
        for (Object obj : selection) {
            if (obj instanceof IFile) {
                pathsToOpen.add(((IFile)obj).getLocation().toOSString());
                continue;
            }
            if (obj instanceof PathNode && repoPath != null) {
                PathNode pathNode = (PathNode)obj;
                if (pathNode.type == PathNode.Type.FOLDER || pathNode.type == PathNode.Type.FILE_DELETED) {
                    return null;
                }
                pathsToOpen.add(repoPath.append(pathNode.path).toOSString());
                continue;
            }
            return null;
        }
        return pathsToOpen;
    }

    private IPath getRepositoryPath() {
        Repository repo = this.getRepository();
        if (repo != null) {
            return new Path(repo.getWorkTree().getAbsolutePath());
        }
        return null;
    }

    private Repository getRepository() {
        if (this.repositoryMapping != null) {
            return this.repositoryMapping.getRepository();
        }
        if (this.input instanceof Repository) {
            return (Repository)this.input;
        }
        return null;
    }

    static final class PathNode {
        public final IPath path;
        public final Type type;

        public PathNode(IPath path, Type type) {
            this.path = path;
            this.type = type;
        }

        public String getRepoRelativePath() {
            return this.path.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathNode other = (PathNode)obj;
            if (!this.path.equals((Object)other.path)) {
                return false;
            }
            return this.type.equals((Object)other.type);
        }

        public String toString() {
            return String.valueOf(this.type.name()) + ": " + this.path.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            FOLDER,
            FILE_ADDED,
            FILE_DELETED,
            FILE_BOTH_SIDES_DIFFER,
            FILE_BOTH_SIDES_SAME;

        }
    }

    private static final class PathNodeAdapter
    implements IWorkbenchAdapter {
        private static final Object[] EMPTYARRAY = new Object[0];
        PathNode pathNode;

        public PathNodeAdapter(PathNode path) {
            this.pathNode = path;
        }

        public Object[] getChildren(Object o) {
            return EMPTYARRAY;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return UIIcons.ELCL16_DELETE;
        }

        public String getLabel(Object o) {
            return this.pathNode.path.lastSegment();
        }

        public Object getParent(Object o) {
            return null;
        }
    }

    private final class PathNodeContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private PathNodeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (CompareTreeView.this.baseVersionPathsWithChildren.isEmpty() && CompareTreeView.this.addedPaths.isEmpty()) {
                return new String[]{UIText.CompareTreeView_NoDifferencesFoundMessage};
            }
            if (CompareTreeView.this.input instanceof IResource[]) {
                IResource[] resources = (IResource[])CompareTreeView.this.input;
                Object[] nodes = new PathNode[resources.length];
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    if (resource instanceof IFile) {
                        Path path = new Path(CompareTreeView.this.repositoryMapping.getRepoRelativePath(resource));
                        PathNode.Type type = CompareTreeView.this.addedPaths.contains(path) ? PathNode.Type.FILE_ADDED : (CompareTreeView.this.equalContentPaths.contains(path) ? PathNode.Type.FILE_BOTH_SIDES_SAME : PathNode.Type.FILE_BOTH_SIDES_DIFFER);
                        nodes[i] = new PathNode((IPath)path, type);
                    } else {
                        nodes[i] = new PathNode((IPath)new Path(CompareTreeView.this.repositoryMapping.getRepoRelativePath(resource)), PathNode.Type.FOLDER);
                    }
                    ++i;
                }
                return nodes;
            }
            return new PathNode[]{new PathNode((IPath)new Path(""), PathNode.Type.FOLDER)};
        }

        public Object[] getChildren(Object parentElement) {
            List deletedChildren;
            PathNode parentNode = (PathNode)parentElement;
            IPath parent = parentNode.path;
            ArrayList<PathNode> children = new ArrayList<PathNode>();
            for (IPath childPath : CompareTreeView.this.baseVersionPathsWithChildren) {
                if (childPath.segmentCount() <= 0 || !childPath.removeLastSegments(1).equals((Object)parent)) continue;
                children.add(new PathNode(childPath, PathNode.Type.FOLDER));
            }
            for (IPath mapPath : CompareTreeView.this.baseVersionMap.keySet()) {
                if (!mapPath.removeLastSegments(1).equals((Object)parent) || !CompareTreeView.this.showEquals && CompareTreeView.this.equalContentPaths.contains(mapPath)) continue;
                if (CompareTreeView.this.addedPaths.contains(mapPath)) {
                    children.add(new PathNode(mapPath, PathNode.Type.FILE_ADDED));
                    continue;
                }
                if (CompareTreeView.this.equalContentPaths.contains(mapPath)) {
                    children.add(new PathNode(mapPath, PathNode.Type.FILE_BOTH_SIDES_SAME));
                    continue;
                }
                children.add(new PathNode(mapPath, PathNode.Type.FILE_BOTH_SIDES_DIFFER));
            }
            if (parentNode.type == PathNode.Type.FOLDER && (deletedChildren = (List)CompareTreeView.this.compareVersionPathsWithChildren.get(parent)) != null) {
                for (PathNodeAdapter path : deletedChildren) {
                    children.add(path.pathNode);
                }
            }
            return children.toArray();
        }

        public boolean hasChildren(Object element) {
            if (!(element instanceof PathNode)) {
                return false;
            }
            IPath parent = ((PathNode)element).path;
            for (IPath childPath : CompareTreeView.this.baseVersionPathsWithChildren) {
                if (!childPath.removeLastSegments(1).equals((Object)parent)) continue;
                return true;
            }
            for (IPath mapPath : CompareTreeView.this.baseVersionMap.keySet()) {
                if (!mapPath.removeLastSegments(1).equals((Object)parent) || !CompareTreeView.this.showEquals && CompareTreeView.this.equalContentPaths.contains(mapPath)) continue;
                return true;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (!(element instanceof PathNode)) {
                return null;
            }
            IPath currentPath = ((PathNode)element).path;
            if (currentPath.segmentCount() > 0) {
                return currentPath.removeLastSegments(1);
            }
            return null;
        }
    }

    private final class PathNodeLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private PathNodeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                return null;
            }
            PathNode.Type type = ((PathNode)element).type;
            switch (type) {
                case FILE_BOTH_SIDES_SAME: {
                    return CompareTreeView.this.SAME_CONTENT;
                }
                case FILE_BOTH_SIDES_DIFFER: {
                    return FILE_IMAGE;
                }
                case FILE_ADDED: {
                    return CompareTreeView.this.ADDED;
                }
                case FILE_DELETED: {
                    return CompareTreeView.this.DELETED;
                }
                case FOLDER: {
                    return FOLDER_IMAGE;
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            IPath path = ((PathNode)element).path;
            if (path.segmentCount() == 0) {
                return UIText.CompareTreeView_RepositoryRootName;
            }
            return path.lastSegment();
        }
    }

    private static final class PathNodeTreeComparator
    extends ViewerComparator {
        private static final int UNKNOWNCATEGORY = 50;

        private PathNodeTreeComparator() {
        }

        public int category(Object element) {
            if (element instanceof PathNode) {
                return ((PathNode)element).type.ordinal();
            }
            return 50;
        }
    }

    private final class WorkbenchTreeComparator
    extends ViewerComparator {
        private static final int FOLDERCATEGORY = 5;
        private static final int ADDEDCATEGORY = 10;
        private static final int DELETEDCATEGORY = 15;
        private static final int CHANGEDCATEGORY = 20;
        private static final int UNCHANGEDCATEGORY = 30;
        private static final int UNKNOWNCATEGORY = 50;

        private WorkbenchTreeComparator() {
        }

        public int category(Object element) {
            IResource adapter = (IResource)this.getAdapter(element, IResource.class);
            if (adapter != null) {
                if (adapter instanceof IContainer) {
                    return 5;
                }
                if (adapter instanceof IFile) {
                    IFile file = (IFile)adapter;
                    Path path = new Path(CompareTreeView.this.repositoryMapping.getRepoRelativePath((IResource)file));
                    if (CompareTreeView.this.addedPaths.contains(path)) {
                        return 10;
                    }
                    if (CompareTreeView.this.equalContentPaths.contains(path)) {
                        return 30;
                    }
                    return 20;
                }
            }
            if (element instanceof PathNodeAdapter) {
                return 15;
            }
            return 50;
        }

        private Object getAdapter(Object sourceObject, Class adapterType) {
            Object result;
            IAdaptable adaptable;
            Object result2;
            Assert.isNotNull((Object)adapterType);
            if (sourceObject == null) {
                return null;
            }
            if (adapterType.isInstance(sourceObject)) {
                return sourceObject;
            }
            if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
                Assert.isTrue((boolean)adapterType.isInstance(result2));
                return result2;
            }
            if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
                return result;
            }
            return null;
        }
    }

    private final class WorkbenchTreeContentProvider
    extends WorkbenchContentProvider {
        private WorkbenchTreeContentProvider() {
        }

        public Object[] getChildren(Object element) {
            List deletedChildren;
            boolean rebuildArray = false;
            Object[] children = element == CompareTreeView.this.input ? (Object[])CompareTreeView.this.input : super.getChildren(element);
            ArrayList<Object> childList = new ArrayList<Object>(children.length);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isFile;
                Object child = objectArray[n2];
                Path path = new Path(CompareTreeView.this.repositoryMapping.getRepoRelativePath((IResource)child));
                boolean bl = isFile = ((IResource)child).getType() == 1;
                if (isFile && !CompareTreeView.this.compareVersionMap.containsKey(path) && !CompareTreeView.this.addedPaths.contains(path)) {
                    rebuildArray = true;
                } else if (!CompareTreeView.this.showEquals && CompareTreeView.this.equalContentPaths.contains(path)) {
                    rebuildArray = true;
                } else if (child instanceof IContainer && !CompareTreeView.this.baseVersionPathsWithChildren.contains(path)) {
                    rebuildArray = true;
                } else if (!CompareTreeView.this.showEquals && CompareTreeView.this.equalContentPaths.contains(path)) {
                    rebuildArray = true;
                } else {
                    childList.add(child);
                }
                ++n2;
            }
            if (element instanceof IContainer && (deletedChildren = (List)CompareTreeView.this.compareVersionPathsWithChildren.get(new Path(CompareTreeView.this.repositoryMapping.getRepoRelativePath((IResource)element)))) != null) {
                rebuildArray = true;
                for (IWorkbenchAdapter path : deletedChildren) {
                    childList.add(path);
                }
            }
            if (rebuildArray) {
                return childList.toArray();
            }
            return children;
        }
    }

    private final class WorkbenchTreeLabelProvider
    extends WorkbenchLabelProvider {
        private WorkbenchTreeLabelProvider() {
        }

        protected ImageDescriptor decorateImage(ImageDescriptor baseImage, Object element) {
            if (!(element instanceof IFile)) {
                return super.decorateImage(baseImage, element);
            }
            Path elementPath = new Path(CompareTreeView.this.repositoryMapping.getRepoRelativePath((IResource)((IFile)element)));
            if (CompareTreeView.this.addedPaths.contains(elementPath)) {
                return UIIcons.ELCL16_ADD;
            }
            if (CompareTreeView.this.deletedPaths.contains(elementPath)) {
                return UIIcons.ELCL16_DELETE;
            }
            if (CompareTreeView.this.equalContentPaths.contains(elementPath)) {
                return UIIcons.ELCL16_SYNCED;
            }
            return super.decorateImage(baseImage, element);
        }
    }
}

