/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConfigurationChecker {
    public static void checkConfiguration() {
        Job job = new Job(UIText.ConfigurationChecker_checkConfiguration){

            protected IStatus run(IProgressMonitor monitor) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ConfigurationChecker.check();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void check() {
        ConfigurationChecker.checkGitPrefix();
        ConfigurationChecker.checkHome();
    }

    private static void checkGitPrefix() {
        boolean hidden;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean bl = hidden = !store.getBoolean("show_git_prefix_warning");
        if (!hidden && FS.DETECTED.gitPrefix() == null) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIText.ConfigurationChecker_gitPrefixWarningTitle, (String)UIText.ConfigurationChecker_gitPrefixWarningMessage, (String)UIText.ConfigurationChecker_doNotShowGitPrefixWarningAgain, (boolean)false, null, null);
            store.setValue("show_git_prefix_warning", !dialog.getToggleState());
        }
    }

    private static void checkHome() {
        boolean hidden;
        String home = System.getenv("HOME");
        if (home != null) {
            return;
        }
        home = ConfigurationChecker.calcHomeDir();
        String title = NLS.bind((String)UIText.ConfigurationChecker_checkHomeDirectory, (Object)home);
        String message = NLS.bind((String)UIText.ConfigurationChecker_homeNotSet, (Object)home);
        String toggleMessage = UIText.ConfigurationChecker_doNotShowAgain;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean bl = hidden = !store.getBoolean("show_home_drive_warning");
        if (!hidden) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (String)toggleMessage, (boolean)false, null, null);
            store.setValue("show_home_drive_warning", !dialog.getToggleState());
        }
    }

    private static String calcHomeDir() {
        if (ConfigurationChecker.runsOnWindows()) {
            String homeDrive = System.getenv("HOMEDRIVE");
            if (homeDrive != null) {
                String homePath = SystemReader.getInstance().getenv("HOMEPATH");
                return new File(homeDrive, homePath).getAbsolutePath();
            }
            return System.getenv("HOMESHARE");
        }
        return System.getProperty("user.home");
    }

    private static boolean runsOnWindows() {
        String os;
        try {
            os = System.getProperty("os.name");
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return os.indexOf("Windows") != -1;
    }
}

