/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.index.FileContentKey;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.IndexerStatistics;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.YieldableIndexLock;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerASTVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class PDOMWriter {
    public static int SKIP_ALL_REFERENCES = -1;
    public static int SKIP_TYPE_REFERENCES = 1;
    public static int SKIP_MACRO_REFERENCES = 2;
    public static int SKIP_IMPLICIT_REFERENCES = 4;
    public static int SKIP_NO_REFERENCES = 0;
    private boolean fShowProblems;
    protected boolean fShowInclusionProblems;
    private boolean fShowScannerProblems;
    private boolean fShowSyntaxProblems;
    protected boolean fShowActivity;
    protected final IndexerStatistics fStatistics;
    protected final IndexerInputAdapter fResolver;
    private int fSkipReferences = SKIP_NO_REFERENCES;

    public PDOMWriter(IndexerInputAdapter resolver) {
        this.fStatistics = new IndexerStatistics();
        this.fResolver = resolver;
    }

    protected IndexerInputAdapter getInputAdapter() {
        return this.fResolver;
    }

    public void setShowActivity(boolean val) {
        this.fShowActivity = val;
    }

    public void setShowInclusionProblems(boolean val) {
        this.fShowInclusionProblems = val;
    }

    public void setShowScannerProblems(boolean val) {
        this.fShowScannerProblems = val;
    }

    public void setShowSyntaxProblems(boolean val) {
        this.fShowSyntaxProblems = val;
    }

    public void setShowProblems(boolean val) {
        this.fShowProblems = val;
    }

    public void setSkipReferences(int options) {
        this.fSkipReferences = options;
    }

    public int getSkipReferences() {
        return this.fSkipReferences;
    }

    protected final void addSymbols(IASTTranslationUnit ast, FileInAST[] selectedFiles, IWritableIndex index, boolean flushIndex, FileContext ctx, ITodoTaskUpdater taskUpdater, IProgressMonitor pm) throws InterruptedException, CoreException {
        if (this.fShowProblems) {
            this.fShowInclusionProblems = true;
            this.fShowScannerProblems = true;
            this.fShowSyntaxProblems = true;
        }
        Data data = new Data(ast, selectedFiles, index);
        FileInAST[] fileInASTArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FileInAST file = fileInASTArray[n2];
            data.fSymbolMap.put(file.includeStatement, new Symbols());
            ++n2;
        }
        this.extractSymbols(data);
        this.resolveNames(data, pm);
        this.storeSymbolsInIndex(data, ctx, flushIndex, pm);
        if (taskUpdater != null) {
            HashSet<IIndexFileLocation> locations = new HashSet<IIndexFileLocation>();
            FileInAST[] fileInASTArray2 = selectedFiles;
            int n3 = selectedFiles.length;
            n = 0;
            while (n < n3) {
                FileInAST file = fileInASTArray2[n];
                locations.add(file.fileContentKey.getLocation());
                ++n;
            }
            taskUpdater.updateTasks(ast.getComments(), locations.toArray(new IIndexFileLocation[locations.size()]));
        }
        if (!data.fStati.isEmpty()) {
            List<IStatus> stati = data.fStati;
            String path = null;
            path = selectedFiles.length > 0 ? selectedFiles[selectedFiles.length - 1].fileContentKey.getLocation().getURI().getPath() : ast.getFilePath().toString();
            String msg = NLS.bind((String)Messages.PDOMWriter_errorWhileParsing, (Object)path);
            if (stati.size() == 1) {
                IStatus status = stati.get(0);
                if (msg.equals(status.getMessage())) {
                    throw new CoreException(status);
                }
                throw new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), String.valueOf(msg) + ':' + status.getMessage(), status.getException()));
            }
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.cdt.core", 0, stati.toArray(new IStatus[stati.size()]), msg, null));
        }
    }

    /*
     * Loose catch block
     */
    private void storeSymbolsInIndex(Data data, FileContext ctx, boolean flushIndex, IProgressMonitor pm) throws InterruptedException, CoreException {
        IIndexFragmentFile newFile = ctx == null ? null : ctx.fNewFile;
        int linkageID = data.fAST.getLinkage().getLinkageID();
        int i = 0;
        while (i < data.fSelectedFiles.length) {
            if (pm.isCanceled()) {
                return;
            }
            FileInAST fileInAST = data.fSelectedFiles[i];
            if (fileInAST != null) {
                YieldableIndexLock lock;
                Object th;
                block24: {
                    if (this.fShowActivity) {
                        this.trace("Indexer: adding " + fileInAST.fileContentKey.getLocation().getURI());
                    }
                    th = null;
                    lock = new YieldableIndexLock(data.fIndex, flushIndex);
                    lock.acquire();
                    try {
                        boolean isReplacement = ctx != null && fileInAST.includeStatement == null;
                        IIndexFragmentFile ifile = null;
                        if (!isReplacement || newFile == null) {
                            ifile = this.storeFileInIndex(data, fileInAST, linkageID, lock);
                            this.reportFileWrittenToIndex(fileInAST, ifile);
                        }
                        if (isReplacement) {
                            if (ifile == null) {
                                ifile = newFile;
                            }
                            if (ctx != null && !ctx.fOldFile.equals(ifile) && ifile != null) {
                                if (ctx.fOldFile.hasPragmaOnceSemantics() && !ifile.hasPragmaOnceSemantics()) {
                                    data.fIndex.transferContext(ctx.fOldFile, ifile);
                                    ctx.fLostPragmaOnceSemantics = true;
                                } else {
                                    data.fIndex.transferIncluders(ctx.fOldFile, ifile);
                                }
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        th = e;
                        if (i == data.fSelectedFiles.length - 1) {
                            data.fIndex.clearResultCache();
                        }
                        lock.release();
                        break block24;
                    }
                    catch (StackOverflowError e) {
                        th = e;
                        break block24;
                    }
                    catch (AssertionError e) {
                        th = e;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        if (i == data.fSelectedFiles.length - 1) {
                            data.fIndex.clearResultCache();
                        }
                        lock.release();
                        break block24;
                    }
                    {
                        finally {
                            if (i == data.fSelectedFiles.length - 1) {
                                data.fIndex.clearResultCache();
                            }
                            lock.release();
                        }
                    }
                    if (i == data.fSelectedFiles.length - 1) {
                        data.fIndex.clearResultCache();
                    }
                    lock.release();
                }
                if (th != null) {
                    data.fStati.add(this.createStatus(NLS.bind((String)Messages.PDOMWriter_errorWhileParsing, (Object)fileInAST.fileContentKey.getLocation().getURI().getPath()), (Throwable)th));
                }
                this.fStatistics.fAddToIndexTime = (int)((long)this.fStatistics.fAddToIndexTime + lock.getCumulativeLockTime());
            }
            ++i;
        }
    }

    private void resolveNames(Data data, IProgressMonitor pm) {
        long start = System.currentTimeMillis();
        FileInAST[] fileInASTArray = data.fSelectedFiles;
        int n = data.fSelectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FileInAST file = fileInASTArray[n2];
            if (pm.isCanceled()) {
                return;
            }
            Symbols symbols = data.fSymbolMap.get(file.includeStatement);
            ArrayList<IASTName[]> names = symbols.fNames;
            boolean reported = false;
            Iterator<IASTName[]> j = names.iterator();
            while (j.hasNext()) {
                IASTName[] na = j.next();
                IASTName name = na[0];
                if (name == null) continue;
                Throwable th = null;
                try {
                    IBinding binding = name.resolveBinding();
                    if (name.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME && (((IASTName)name.getParent()).getBinding() == binding || binding instanceof ICPPFunctionTemplate)) {
                        na[0] = null;
                    } else if (binding instanceof IProblemBinding) {
                        ++this.fStatistics.fProblemBindingCount;
                        if (this.fShowProblems) {
                            this.reportProblem((IProblemBinding)binding);
                        }
                    } else if (name.isReference()) {
                        if (binding instanceof ICPPTemplateParameter || binding instanceof ICPPUnknownBinding || (this.fSkipReferences & SKIP_TYPE_REFERENCES) != 0 && this.isTypeReferenceBinding(binding)) {
                            if (!this.isRequiredReference(name)) {
                                na[0] = null;
                            } else {
                                ++this.fStatistics.fReferenceCount;
                            }
                        } else {
                            ++this.fStatistics.fReferenceCount;
                        }
                    } else {
                        ++this.fStatistics.fDeclarationCount;
                    }
                }
                catch (RuntimeException e) {
                    th = e;
                }
                catch (StackOverflowError e) {
                    th = e;
                }
                if (th == null) continue;
                if (!reported) {
                    data.fStati.add(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMWriter_errorResolvingName, (Object)name.toString(), (Object)file.fileContentKey.getLocation().getURI().getPath()), th));
                }
                reported = true;
                j.remove();
            }
            ++n2;
        }
        this.fStatistics.fResolutionTime = (int)((long)this.fStatistics.fResolutionTime + (System.currentTimeMillis() - start));
    }

    private void extractSymbols(Data data) throws CoreException {
        IASTNode[] iASTNodeArray;
        LocationMap lm;
        int unresolvedIncludes = 0;
        IASTTranslationUnit ast = data.fAST;
        final Map<IASTPreprocessorIncludeStatement, Symbols> symbolMap = data.fSymbolMap;
        IASTPreprocessorStatement[] stmts = ast.getAllPreprocessorStatements();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFileLocation sourceLoc;
            IASTPreprocessorStatement stmt = iASTPreprocessorStatementArray[n2];
            if (stmt instanceof IASTPreprocessorIncludeStatement) {
                IASTPreprocessorIncludeStatement include = (IASTPreprocessorIncludeStatement)stmt;
                IASTFileLocation astLoc = include.getFileLocation();
                IASTPreprocessorIncludeStatement owner = astLoc.getContextInclusionStatement();
                boolean updateSource = symbolMap.containsKey(owner);
                if (updateSource) {
                    this.addToMap(symbolMap, owner, include);
                }
                if (include.isActive()) {
                    if (!include.isResolved()) {
                        ++unresolvedIncludes;
                    } else if (updateSource && symbolMap.containsKey(include)) {
                        data.fContextIncludes.add(include);
                    }
                }
            } else if (stmt.isActive() && (stmt instanceof IASTPreprocessorUndefStatement || stmt instanceof IASTPreprocessorMacroDefinition) && (sourceLoc = stmt.getFileLocation()) != null) {
                IASTPreprocessorIncludeStatement owner = sourceLoc.getContextInclusionStatement();
                this.addToMap(symbolMap, owner, stmt);
            }
            ++n2;
        }
        IndexerASTVisitor visitor = new IndexerASTVisitor((this.fSkipReferences & SKIP_IMPLICIT_REFERENCES) == 0){

            @Override
            public void visit(IASTName name, IASTName caller) {
                IASTFileLocation nameLoc;
                if (PDOMWriter.this.fSkipReferences == SKIP_ALL_REFERENCES && name.isReference() && !PDOMWriter.this.isRequiredReference(name)) {
                    return;
                }
                if ((name = PDOMASTAdapter.getAdapterIfAnonymous(name)) != null && (nameLoc = name.getFileLocation()) != null) {
                    IASTPreprocessorIncludeStatement owner = nameLoc.getContextInclusionStatement();
                    PDOMWriter.this.addToMap((Map<IASTPreprocessorIncludeStatement, Symbols>)symbolMap, owner, new IASTName[]{name, caller});
                }
            }
        };
        ast.accept(visitor);
        if ((this.fSkipReferences & SKIP_MACRO_REFERENCES) == 0 && (lm = (LocationMap)ast.getAdapter(LocationMap.class)) != null) {
            IASTName[] refs = lm.getMacroReferences();
            iASTNodeArray = refs;
            int n3 = refs.length;
            int n4 = 0;
            while (n4 < n3) {
                IASTName name = iASTNodeArray[n4];
                IASTFileLocation nameLoc = name.getFileLocation();
                if (nameLoc != null) {
                    IASTPreprocessorIncludeStatement owner = nameLoc.getContextInclusionStatement();
                    IASTName[] iASTNameArray = new IASTName[2];
                    iASTNameArray[0] = name;
                    this.addToMap(symbolMap, owner, iASTNameArray);
                }
                ++n4;
            }
        }
        this.fStatistics.fUnresolvedIncludesCount += unresolvedIncludes;
        this.fStatistics.fPreprocessorProblemCount += ast.getPreprocessorProblemsCount() - unresolvedIncludes;
        if (this.fShowScannerProblems || this.fShowInclusionProblems) {
            boolean reportAll = this.fShowScannerProblems && this.fShowInclusionProblems;
            IASTProblem[] scannerProblems = ast.getPreprocessorProblems();
            iASTNodeArray = scannerProblems;
            int n5 = scannerProblems.length;
            int n6 = 0;
            while (n6 < n5) {
                IASTNode problem = iASTNodeArray[n6];
                if (reportAll || problem.getID() == 0x2000002 == this.fShowInclusionProblems) {
                    this.reportProblem((IASTProblem)problem);
                }
                ++n6;
            }
        }
        List<IASTProblem> problems = visitor.getProblems();
        this.fStatistics.fSyntaxProblemsCount += problems.size();
        if (this.fShowSyntaxProblems) {
            for (IASTProblem problem : problems) {
                this.reportProblem(problem);
            }
        }
    }

    protected final boolean isRequiredReference(IASTName name) {
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof ICPPASTQualifiedName) {
            if (name != ((ICPPASTQualifiedName)parentNode).getLastName()) {
                return false;
            }
            parentNode = parentNode.getParent();
        }
        if (parentNode instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
            return true;
        }
        if (parentNode instanceof IASTDeclSpecifier) {
            IASTDeclSpecifier ds = (IASTDeclSpecifier)parentNode;
            return ds.getStorageClass() == 1;
        }
        return parentNode instanceof ICPPASTUsingDirective;
    }

    private boolean isTypeReferenceBinding(IBinding binding) {
        return binding instanceof ICompositeType || binding instanceof IEnumeration || binding instanceof ITypedef || binding instanceof ICPPNamespace || binding instanceof ICPPNamespaceAlias || binding instanceof ICPPClassTemplate;
    }

    private void addToMap(Map<IASTPreprocessorIncludeStatement, Symbols> symbolMap, IASTPreprocessorIncludeStatement owner, IASTName[] thing) {
        Symbols lists = symbolMap.get(owner);
        if (lists != null) {
            lists.fNames.add(thing);
        }
    }

    private void addToMap(Map<IASTPreprocessorIncludeStatement, Symbols> symbolMap, IASTPreprocessorIncludeStatement owner, IASTPreprocessorIncludeStatement thing) {
        Symbols lists = symbolMap.get(owner);
        if (lists != null) {
            lists.fIncludes.add(thing);
        }
    }

    private void addToMap(Map<IASTPreprocessorIncludeStatement, Symbols> symbolMap, IASTPreprocessorIncludeStatement owner, IASTPreprocessorStatement thing) {
        Symbols lists = symbolMap.get(owner);
        if (lists != null) {
            lists.fMacros.add(thing);
        }
    }

    private IIndexFragmentFile storeFileInIndex(Data data, FileInAST astFile, int linkageID, YieldableIndexLock lock) throws CoreException, InterruptedException {
        IWritableIndex index = data.fIndex;
        FileContentKey fileKey = astFile.fileContentKey;
        IASTPreprocessorIncludeStatement owner = astFile.includeStatement;
        IIndexFileLocation location = fileKey.getLocation();
        ISignificantMacros significantMacros = fileKey.getSignificantMacros();
        IIndexFragmentFile oldFile = index.getWritableFile(linkageID, location, significantMacros);
        IIndexFragmentFile file = index.addUncommittedFile(linkageID, location, significantMacros);
        try {
            boolean pragmaOnce = owner != null ? owner.hasPragmaOnceSemantics() : data.fAST.hasPragmaOnceSemantics();
            file.setPragmaOnceSemantics(pragmaOnce);
            Symbols lists = data.fSymbolMap.get(owner);
            if (lists != null) {
                IASTName[][] names;
                IASTPreprocessorStatement[] macros = lists.fMacros.toArray(new IASTPreprocessorStatement[lists.fMacros.size()]);
                IASTName[][] iASTNameArray = names = (IASTName[][])lists.fNames.toArray((T[])new IASTName[lists.fNames.size()][]);
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName[] name2 = iASTNameArray[n2];
                    IASTName name = name2[0];
                    if (name != null) {
                        ASTInternal.setFullyResolved(name.getBinding(), true);
                    }
                    ++n2;
                }
                ArrayList<IWritableIndex.IncludeInformation> includeInfos = new ArrayList<IWritableIndex.IncludeInformation>();
                int i = 0;
                while (i < lists.fIncludes.size()) {
                    IASTPreprocessorIncludeStatement stmt = lists.fIncludes.get(i);
                    if (!stmt.isResolved()) {
                        includeInfos.add(new IWritableIndex.IncludeInformation(stmt, null, ISignificantMacros.NONE, false));
                    } else {
                        IIndexFileLocation targetLoc = this.fResolver.resolveASTPath(stmt.getPath());
                        ISignificantMacros mainSig = stmt.getSignificantMacros();
                        ISignificantMacros[] iSignificantMacrosArray = stmt.getLoadedVersions();
                        int n3 = iSignificantMacrosArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ISignificantMacros sig = iSignificantMacrosArray[n4];
                            if (!sig.equals(mainSig)) {
                                includeInfos.add(new IWritableIndex.IncludeInformation(stmt, targetLoc, sig, false));
                            }
                            ++n4;
                        }
                        boolean isContext = stmt.isActive() && stmt.isResolved() && (data.fContextIncludes.contains(stmt) || this.isContextFor(oldFile, stmt));
                        includeInfos.add(new IWritableIndex.IncludeInformation(stmt, targetLoc, mainSig, isContext));
                    }
                    ++i;
                }
                IWritableIndex.IncludeInformation[] includeInfoArray = includeInfos.toArray(new IWritableIndex.IncludeInformation[includeInfos.size()]);
                index.setFileContent(file, linkageID, includeInfoArray, macros, names, this.fResolver, lock);
            }
            file.setTimestamp(astFile.hasError ? 0L : astFile.timestamp);
            file.setSourceReadTime(astFile.sourceReadTime);
            file.setSizeAndEncodingHashcode(this.computeFileSizeAndEncodingHashcode(astFile.fileSize, location));
            file.setContentsHash(astFile.contentsHash);
            file = index.commitUncommittedFile();
        }
        finally {
            index.clearUncommittedFile();
        }
        return file;
    }

    protected int computeFileSizeAndEncodingHashcode(IIndexFileLocation location) {
        return this.computeFileSizeAndEncodingHashcode((int)this.fResolver.getFileSize(location), location);
    }

    private int computeFileSizeAndEncodingHashcode(long size, IIndexFileLocation location) {
        return (int)size + 31 * this.fResolver.getEncoding(location).hashCode();
    }

    private boolean isContextFor(IIndexFragmentFile oldFile, IASTPreprocessorIncludeStatement stmt) throws CoreException {
        IIndexInclude ctxInclude;
        IIndexFile target = stmt.getImportedIndexFile();
        return oldFile != null && target != null && (ctxInclude = target.getParsedInContext()) != null && oldFile.equals(ctxInclude.getIncludedBy());
    }

    protected abstract void reportFileWrittenToIndex(FileInAST var1, IIndexFragmentFile var2) throws CoreException;

    private String getLocationInfo(String filename, int lineNumber) {
        return " at " + filename + "(" + lineNumber + ")";
    }

    private void reportProblem(IProblemBinding problem) {
        String msg = "Indexer: unresolved name" + this.getLocationInfo(problem.getFileName(), problem.getLineNumber());
        String pmsg = problem.getMessage();
        if (pmsg != null && pmsg.length() > 0) {
            msg = String.valueOf(msg) + "; " + problem.getMessage();
        }
        this.trace(msg);
    }

    private void reportProblem(IASTProblem problem) {
        String msg = "Indexer: " + problem.getMessageWithLocation();
        this.trace(msg);
    }

    protected void trace(String message) {
        System.out.println(message);
    }

    protected IStatus createStatus(String msg) {
        return CCorePlugin.createStatus(msg);
    }

    protected IStatus createStatus(String msg, Throwable e) {
        return CCorePlugin.createStatus(msg, e);
    }

    private static class Data {
        final IASTTranslationUnit fAST;
        final FileInAST[] fSelectedFiles;
        final IWritableIndex fIndex;
        final Map<IASTPreprocessorIncludeStatement, Symbols> fSymbolMap = new HashMap<IASTPreprocessorIncludeStatement, Symbols>();
        final Set<IASTPreprocessorIncludeStatement> fContextIncludes = new HashSet<IASTPreprocessorIncludeStatement>();
        final List<IStatus> fStati = new ArrayList<IStatus>();

        public Data(IASTTranslationUnit ast, FileInAST[] selectedFiles, IWritableIndex index) {
            this.fAST = ast;
            this.fSelectedFiles = selectedFiles;
            this.fIndex = index;
        }
    }

    public static class FileContext {
        final IIndexFragmentFile fContext;
        final IIndexFragmentFile fOldFile;
        IIndexFragmentFile fNewFile;
        public boolean fLostPragmaOnceSemantics;

        public FileContext(IIndexFragmentFile context, IIndexFragmentFile oldFile) {
            this.fContext = context;
            this.fOldFile = oldFile;
            this.fNewFile = null;
        }
    }

    public static class FileInAST {
        final IASTPreprocessorIncludeStatement includeStatement;
        final FileContentKey fileContentKey;
        final long timestamp;
        final long fileSize;
        final long contentsHash;
        final long sourceReadTime;
        final boolean hasError;

        public FileInAST(IASTPreprocessorIncludeStatement includeStmt, FileContentKey key) {
            this.includeStatement = includeStmt;
            this.fileContentKey = key;
            this.timestamp = includeStmt.getIncludedFileTimestamp();
            this.fileSize = includeStmt.getIncludedFileSize();
            this.contentsHash = includeStmt.getIncludedFileContentsHash();
            this.sourceReadTime = includeStmt.getIncludedFileReadTime();
            this.hasError = includeStmt.isErrorInIncludedFile();
        }

        public FileInAST(FileContentKey key, FileContent codeReader) {
            this.includeStatement = null;
            this.fileContentKey = key;
            this.timestamp = codeReader.getTimestamp();
            this.fileSize = codeReader.getFileSize();
            this.contentsHash = codeReader.getContentsHash();
            this.sourceReadTime = codeReader.getReadTime();
            this.hasError = codeReader.hasError();
        }

        public String toString() {
            return this.fileContentKey.toString();
        }
    }

    private static class Symbols {
        final ArrayList<IASTName[]> fNames = new ArrayList();
        final ArrayList<IASTPreprocessorStatement> fMacros = new ArrayList();
        final ArrayList<IASTPreprocessorIncludeStatement> fIncludes = new ArrayList();

        private Symbols() {
        }
    }
}

