/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTForStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIfStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLabelStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLinkageSpecification;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSwitchStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTWhileStatement;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.CommentHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class NodeCommenter {
    protected ASTVisitor visitor;
    protected CommentHandler commHandler;
    protected NodeCommentMap commentMap;
    protected List<IASTNode> children;

    public NodeCommenter(ASTVisitor visitor, CommentHandler commHandler, NodeCommentMap commentMap) {
        this.visitor = visitor;
        this.commHandler = commHandler;
        this.commentMap = commentMap;
        this.children = new ArrayList<IASTNode>();
    }

    protected void writeNodeList(IASTNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            nodes[i].accept(this.visitor);
            ++i;
        }
    }

    protected void visitNodeIfNotNull(IASTNode node) {
        if (node != null) {
            node.accept(this.visitor);
        }
    }

    protected boolean appendComment(ASTNode node, IASTComment comment) {
        ASTNode com = (ASTNode)((Object)comment);
        if (node.getFileLocation() == null) {
            return false;
        }
        int nodeLineNumber = NodeCommenter.getEndingLineNumber(node);
        int commentLineNumber = NodeCommenter.getStartingLineNumber(comment);
        if (NodeCommenter.getNodeEndPoint(com) <= NodeCommenter.getNodeOffset(node)) {
            this.addLeadingCommentToMap(node, comment);
            return true;
        }
        if (this.isTrailing(node, com, nodeLineNumber, commentLineNumber)) {
            this.addTrailingCommentToMap(node, comment);
            return true;
        }
        return false;
    }

    protected boolean appendFreestandingComment(ASTNode node, IASTComment comment) {
        ASTNode com = (ASTNode)((Object)comment);
        if (node.getFileLocation() == null) {
            return false;
        }
        if (NodeCommenter.getNodeEndPoint(com) <= NodeCommenter.getNodeEndPoint(node)) {
            this.addFreestandingCommentToMap(node, comment);
            return true;
        }
        return false;
    }

    private void addLeadingCommentToMap(ASTNode node, IASTComment comment) {
        this.commentMap.addLeadingCommentToNode(node, comment);
        this.commHandler.allreadyAdded(comment);
    }

    private void addTrailingCommentToMap(ASTNode node, IASTComment comment) {
        this.commentMap.addTrailingCommentToNode(node, comment);
        this.commHandler.allreadyAdded(comment);
    }

    private void addFreestandingCommentToMap(ASTNode node, IASTComment comment) {
        this.commentMap.addFreestandingCommentToNode(node, comment);
        this.commHandler.allreadyAdded(comment);
    }

    private boolean isTrailing(ASTNode node, ASTNode com, int nodeLineNumber, int commentLineNumber) {
        if (nodeLineNumber != commentLineNumber || NodeCommenter.getNodeOffset(com) < NodeCommenter.getNodeEndPoint(node) || !this.canNotBeAddedToParent(node, com) || this.mustBeAddedToSubnodes(node)) {
            return false;
        }
        if (NodeCommenter.getNodeOffset(com) < NodeCommenter.getNodeEndPoint(node) + 2) {
            return true;
        }
        String code = node.getTranslationUnit().getRawSignature();
        int commentOffset = NodeCommenter.getNodeOffset(com) - NodeCommenter.getNodeEndPoint(node) + NodeCommenter.getNodeEndOffset(node);
        int offset = NodeCommenter.getNodeEndOffset(node);
        while (offset < commentOffset) {
            if (!Character.isWhitespace(code.charAt(offset))) {
                return false;
            }
            ++offset;
        }
        return true;
    }

    private boolean canNotBeAddedToParent(ASTNode node, ASTNode com) {
        ASTNode parent = (ASTNode)node.getParent();
        if (this.hasNodeSameEndingAsSubnode(parent)) {
            return true;
        }
        if (parent instanceof IASTTranslationUnit) {
            return true;
        }
        if (parent instanceof ICPPASTTemplateDeclaration) {
            return true;
        }
        if (parent instanceof CPPASTIfStatement) {
            return true;
        }
        if (parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
            parent = (ASTNode)parent.getParent();
        }
        return NodeCommenter.getNodeOffset(com) < NodeCommenter.getNodeEndPoint(parent);
    }

    private boolean mustBeAddedToSubnodes(ASTNode node) {
        return this.hasNodeSameEndingAsSubnode(node);
    }

    private boolean hasNodeSameEndingAsSubnode(ASTNode node) {
        if (node instanceof CPPASTFunctionDefinition) {
            return true;
        }
        if (node instanceof CPPASTDeclarationStatement) {
            return true;
        }
        if (node instanceof CPPASTForStatement) {
            return true;
        }
        if (node instanceof CPPASTLabelStatement) {
            return true;
        }
        if (node instanceof CPPASTIfStatement) {
            return true;
        }
        if (node instanceof CPPASTSwitchStatement) {
            return true;
        }
        if (node instanceof CPPASTWhileStatement) {
            return true;
        }
        if (node instanceof CPPASTTemplateDeclaration) {
            return true;
        }
        if (node instanceof CPPASTLinkageSpecification) {
            return true;
        }
        return node instanceof CPPASTExplicitTemplateInstantiation;
    }

    protected int appendComments(ASTNode node) {
        while (this.commHandler.hasMore()) {
            IASTComment comment = this.commHandler.getFirst();
            if (this.isNotSameFile(node, comment)) {
                return 1;
            }
            if (this.appendComment(node, comment)) continue;
            return 3;
        }
        return 2;
    }

    protected int appendFreestandingComments(ASTNode node) {
        while (this.commHandler.hasMore()) {
            IASTComment comment = this.commHandler.getFirst();
            if (this.isNotSameFile(node, comment)) {
                return 1;
            }
            if (this.appendComment(node, comment)) {
                return 3;
            }
            if (this.appendFreestandingComment(node, comment)) continue;
            return 3;
        }
        return 2;
    }

    public void appendRemainingComments(IASTDeclaration declaration) {
        while (this.commHandler.hasMore()) {
            IASTComment comment = this.commHandler.getFirst();
            if (this.appendComment((ASTNode)((Object)declaration), comment)) continue;
            this.addFreestandingCommentToMap((ASTNode)((Object)declaration), comment);
        }
    }

    private boolean isNotSameFile(IASTNode node, IASTComment comment) {
        if (node.getFileLocation() == null) {
            return true;
        }
        return !node.getFileLocation().getFileName().equals(comment.getFileLocation().getFileName());
    }

    private static int getNodeEndOffset(IASTNode node) {
        IASTFileLocation fileLocation = node.getFileLocation();
        return fileLocation.getNodeOffset() + fileLocation.getNodeLength();
    }

    private static int getNodeOffset(ASTNode node) {
        return node.getOffset();
    }

    private static int getNodeEndPoint(ASTNode node) {
        return node.getOffset() + node.getLength();
    }

    private static int getStartingLineNumber(IASTNode node) {
        return node.getFileLocation().getStartingLineNumber();
    }

    private static int getEndingLineNumber(IASTNode node) {
        return node.getFileLocation().getEndingLineNumber();
    }
}

