/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPDeferredClassInstance
extends CPPUnknownClass
implements ICPPDeferredClassInstance {
    private final ICPPTemplateArgument[] fArguments;
    private final ICPPClassTemplate fClassTemplate;
    private final ICPPScope fLookupScope;

    public CPPDeferredClassInstance(ICPPClassTemplate template, ICPPTemplateArgument[] arguments, ICPPScope lookupScope) {
        super(null, template.getNameCharArray());
        this.fArguments = arguments;
        this.fClassTemplate = template;
        this.fLookupScope = lookupScope;
    }

    public CPPDeferredClassInstance(ICPPClassTemplate template, ICPPTemplateArgument[] arguments) {
        this(template, arguments, null);
    }

    @Override
    public IBinding getOwner() {
        return this.fClassTemplate.getOwner();
    }

    @Override
    public ICPPClassTemplate getClassTemplate() {
        return (ICPPClassTemplate)this.getSpecializedBinding();
    }

    @Override
    public boolean isExplicitSpecialization() {
        return false;
    }

    @Override
    public CPPDeferredClassInstance clone() {
        CPPDeferredClassInstance cloned = (CPPDeferredClassInstance)super.clone();
        return cloned;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        ICPPClassTemplate classTemplate = this.getClassTemplate();
        if (type instanceof ICPPDeferredClassInstance) {
            ICPPDeferredClassInstance rhs = (ICPPDeferredClassInstance)type;
            if (!classTemplate.isSameType((IType)((Object)rhs.getSpecializedBinding()))) {
                return false;
            }
            return CPPTemplates.haveSameArguments(this, rhs);
        }
        return false;
    }

    @Override
    public int getKey() {
        return this.getClassTemplate().getKey();
    }

    @Override
    @Deprecated
    public IType[] getArguments() {
        return CPPTemplates.getArguments(this.getTemplateArguments());
    }

    @Override
    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.fArguments;
    }

    @Override
    public ICPPTemplateDefinition getTemplateDefinition() {
        return this.fClassTemplate;
    }

    @Override
    public ObjectMap getArgumentMap() {
        return ObjectMap.EMPTY_MAP;
    }

    @Override
    public CPPTemplateParameterMap getTemplateParameterMap() {
        ICPPTemplateParameter[] params = this.fClassTemplate.getTemplateParameters();
        int size = Math.min(this.fArguments.length, params.length);
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(size);
        int i = 0;
        while (i < size) {
            map.put(params[i], this.fArguments[i]);
            ++i;
        }
        return map;
    }

    @Override
    public IBinding getSpecializedBinding() {
        return this.getTemplateDefinition();
    }

    @Override
    public IScope getScope() throws DOMException {
        return this.fClassTemplate.getScope();
    }

    @Override
    public ICPPScope asScope() {
        if (this.fLookupScope != null) {
            return this.fLookupScope;
        }
        return super.asScope();
    }

    @Override
    public String toString() {
        return ASTTypeUtil.getType(this, true);
    }
}

