/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTTypeIdExpression
extends ASTNode
implements IASTTypeIdExpression {
    private int op;
    private IASTTypeId typeId;

    public CASTTypeIdExpression() {
    }

    public CASTTypeIdExpression(int op, IASTTypeId typeId) {
        this.op = op;
        this.setTypeId(typeId);
    }

    @Override
    public CASTTypeIdExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTTypeIdExpression copy(IASTNode.CopyStyle style) {
        CASTTypeIdExpression copy = new CASTTypeIdExpression(this.op, this.typeId == null ? null : this.typeId.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public void setOperator(int value) {
        this.assertNotFrozen();
        this.op = value;
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public IType getExpressionType() {
        if (this.getOperator() == 0) {
            return CVisitor.get_SIZE_T(this);
        }
        return CVisitor.createType(this.typeId.getAbstractDeclarator());
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }
}

