/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.tasks.bugs.KeyValueMapping;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.bugs.IProduct;
import org.eclipse.mylyn.tasks.bugs.ISupportResponse;
import org.eclipse.mylyn.tasks.bugs.ITaskContribution;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTaskMapper
implements ITaskContribution,
ISupportResponse {
    private final Map<String, String> attributes;
    private final IProduct product;
    private final IStatus status;
    private TaskData taskData;
    private boolean handled;

    public AttributeTaskMapper(IStatus status, IProduct product) {
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)product);
        this.status = status;
        this.product = product;
        this.attributes = new HashMap<String, String>();
    }

    @Override
    public void appendToDescription(String text) {
        String description = this.getAttribute("description");
        this.setAttribute("description", description != null ? String.valueOf(description) + text : text);
    }

    public TaskData createTaskData(IProgressMonitor monitor) throws CoreException {
        ITaskMapping taskMapping = this.getTaskMapping();
        return TasksUiInternal.createTaskData((TaskRepository)this.getTaskRepository(), (ITaskMapping)taskMapping, (ITaskMapping)taskMapping, (IProgressMonitor)monitor);
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public IProduct getProduct() {
        return this.product;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public TaskData getTaskData() {
        return this.taskData;
    }

    public ITaskMapping getTaskMapping() {
        return new KeyValueMapping(this.attributes);
    }

    public TaskRepository getTaskRepository() {
        String connectorKind;
        TaskRepository taskRepository = null;
        String repositoryUrl = this.attributes.get("repositoryUrl");
        if (repositoryUrl != null && (connectorKind = this.attributes.get("repositoryKind")) != null) {
            taskRepository = TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
        }
        return taskRepository;
    }

    public boolean isMappingComplete() {
        return this.getAttribute("org.eclipse.mylyn.tasks.bugs.mappingComplete") != null || this.getTaskRepository() != null;
    }

    @Override
    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void setTaskData(TaskData taskData) {
        this.taskData = taskData;
    }

    @Override
    public boolean isHandled() {
        return this.handled;
    }

    @Override
    public void setHandled(boolean handled) {
        this.handled = handled;
    }
}

