/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfLightweightContext;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;

class CtfTraceManager {
    private static final int MAX_SIZE = 100;
    private final HashMap<CtfTmfLightweightContext, CtfIterator> fMap = new HashMap();
    private final ArrayList<CtfTmfLightweightContext> fRandomAccess = new ArrayList();
    private final CtfTmfTrace fTrace;
    private final Random fRnd = new Random(System.nanoTime());

    public CtfTraceManager(CtfTmfTrace trace) {
        this.fTrace = trace;
    }

    public CtfIterator getIterator(CtfTmfLightweightContext context) {
        CtfIterator retVal = this.fMap.get(context);
        if (retVal == null) {
            if (this.fRandomAccess.size() < 100) {
                retVal = new CtfIterator(this.fTrace);
                this.addElement(context, retVal);
            } else {
                retVal = this.replaceRandomElement(context);
            }
            retVal.seek((Long)context.getLocation().getLocation());
        }
        return retVal;
    }

    private void addElement(CtfTmfLightweightContext context, CtfIterator elem) {
        this.fMap.put(context, elem);
        this.fRandomAccess.add(context);
    }

    private CtfIterator replaceRandomElement(CtfTmfLightweightContext context) {
        int size = this.fRandomAccess.size();
        int pos = this.fRnd.nextInt(size);
        CtfTmfLightweightContext victim = this.fRandomAccess.get(pos);
        this.fRandomAccess.set(pos, context);
        CtfIterator elem = this.fMap.remove(victim);
        this.fMap.put(context, elem);
        return elem;
    }
}

