/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.Utils;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.internal.ctf.core.trace.Stream;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndex;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class StreamInput
implements IDefinitionScope {
    private final Stream stream;
    private final FileChannel fileChannel;
    public final File file;
    private final StreamInputPacketIndex index;
    private long timestampEnd;
    StructDefinition tracePacketHeaderDef = null;
    StructDefinition streamPacketContextDef = null;

    public StreamInput(Stream stream, FileChannel fileChannel, File file) {
        this.stream = stream;
        this.fileChannel = fileChannel;
        this.file = file;
        this.index = stream.getTrace().getIndex(this);
    }

    public Stream getStream() {
        return this.stream;
    }

    public StreamInputPacketIndex getIndex() {
        return this.index;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public long getTimestampEnd() {
        return this.timestampEnd;
    }

    public void setTimestampEnd(long timestampEnd) {
        this.timestampEnd = timestampEnd;
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        return null;
    }

    public void setupIndex() {
        BitBuffer bitBuffer = new BitBuffer();
        bitBuffer.order(this.getStream().getTrace().getByteOrder());
        if (this.getStream().getTrace().getPacketHeader() != null) {
            this.tracePacketHeaderDef = this.getStream().getTrace().getPacketHeader().createDefinition(this, "trace.packet.header");
        }
        if (this.getStream().getPacketContextDecl() != null) {
            this.streamPacketContextDef = this.getStream().getPacketContextDecl().createDefinition(this, "stream.packet.context");
        }
    }

    public boolean addPacketHeaderIndex() throws CTFReaderException {
        long fileSize;
        long currentPos = 0L;
        if (!this.index.getEntries().isEmpty()) {
            StreamInputPacketIndexEntry pos = this.index.getEntries().lastElement();
            currentPos = StreamInput.computeNextOffset(pos);
        }
        if (currentPos < (fileSize = this.getStreamSize())) {
            BitBuffer bitBuffer = new BitBuffer();
            bitBuffer.order(this.getStream().getTrace().getByteOrder());
            StreamInputPacketIndexEntry packetIndex = new StreamInputPacketIndexEntry(currentPos);
            this.createPacketIndexEntry(fileSize, currentPos, packetIndex, this.tracePacketHeaderDef, this.streamPacketContextDef, bitBuffer);
            this.index.addEntry(packetIndex);
            return true;
        }
        return false;
    }

    private long getStreamSize() {
        return this.file.length();
    }

    private long createPacketIndexEntry(long fileSizeBytes, long packetOffsetBytes, StreamInputPacketIndexEntry packetIndex, StructDefinition tracePacketHeaderDef, StructDefinition streamPacketContextDef, BitBuffer bitBuffer) throws CTFReaderException {
        this.createPacketBitBuffer(fileSizeBytes, packetOffsetBytes, packetIndex, bitBuffer);
        if (tracePacketHeaderDef != null) {
            this.parseTracePacketHeader(tracePacketHeaderDef, bitBuffer);
        }
        if (streamPacketContextDef != null) {
            this.parsePacketContext(fileSizeBytes, streamPacketContextDef, bitBuffer, packetIndex);
        } else {
            StreamInput.setPacketContextNull(fileSizeBytes, packetIndex);
        }
        if (packetIndex.getContentSizeBits() > packetIndex.getPacketSizeBits()) {
            throw new CTFReaderException("Content size > packet size");
        }
        if ((long)packetIndex.getPacketSizeBits() > (fileSizeBytes - packetIndex.getOffsetBytes()) * 8L) {
            throw new CTFReaderException("Not enough data remaining in the file for the size of this packet");
        }
        packetIndex.setDataOffsetBits(bitBuffer.position());
        packetOffsetBytes = StreamInput.computeNextOffset(packetIndex);
        return packetOffsetBytes;
    }

    private static long computeNextOffset(StreamInputPacketIndexEntry packetIndex) {
        return packetIndex.getOffsetBytes() + (long)((packetIndex.getPacketSizeBits() + 7) / 8);
    }

    private MappedByteBuffer createPacketBitBuffer(long fileSizeBytes, long packetOffsetBytes, StreamInputPacketIndexEntry packetIndex, BitBuffer bitBuffer) throws CTFReaderException {
        MappedByteBuffer bb;
        long mapSize = 4096L;
        if (fileSizeBytes - packetIndex.getOffsetBytes() < mapSize) {
            mapSize = fileSizeBytes - packetIndex.getOffsetBytes();
        }
        try {
            bb = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, packetOffsetBytes, mapSize);
        }
        catch (IOException e) {
            throw new CTFReaderException(e);
        }
        bitBuffer.setByteBuffer(bb);
        return bb;
    }

    private void parseTracePacketHeader(StructDefinition tracePacketHeaderDef, BitBuffer bitBuffer) throws CTFReaderException {
        long streamID;
        IntegerDefinition streamIDDef;
        int magic;
        tracePacketHeaderDef.read(bitBuffer);
        IntegerDefinition magicDef = (IntegerDefinition)tracePacketHeaderDef.lookupDefinition("magic");
        if (magicDef != null && (magic = (int)magicDef.getValue()) != -1040441407) {
            throw new CTFReaderException("CTF magic mismatch " + Integer.toHexString(magic) + " vs " + Integer.toHexString(-1040441407));
        }
        ArrayDefinition uuidDef = (ArrayDefinition)tracePacketHeaderDef.lookupDefinition("uuid");
        if (uuidDef != null) {
            byte[] uuidArray = new byte[16];
            int i = 0;
            while (i < 16) {
                IntegerDefinition uuidByteDef = (IntegerDefinition)uuidDef.getElem(i);
                uuidArray[i] = (byte)uuidByteDef.getValue();
                ++i;
            }
            UUID uuid = Utils.makeUUID(uuidArray);
            if (!this.getStream().getTrace().getUUID().equals(uuid)) {
                throw new CTFReaderException("UUID mismatch");
            }
        }
        if ((streamIDDef = (IntegerDefinition)tracePacketHeaderDef.lookupDefinition("stream_id")) != null && (streamID = streamIDDef.getValue()) != this.getStream().getId()) {
            throw new CTFReaderException("Stream ID changing within a StreamInput");
        }
    }

    private static void setPacketContextNull(long fileSizeBytes, StreamInputPacketIndexEntry packetIndex) {
        packetIndex.setContentSizeBits((int)(fileSizeBytes * 8L));
        packetIndex.setPacketSizeBits((int)(fileSizeBytes * 8L));
    }

    private void parsePacketContext(long fileSizeBytes, StructDefinition streamPacketContextDef, BitBuffer bitBuffer, StreamInputPacketIndexEntry packetIndex) {
        IntegerDefinition timestampEndDef;
        streamPacketContextDef.read(bitBuffer);
        IntegerDefinition contentSizeDef = (IntegerDefinition)streamPacketContextDef.lookupDefinition("content_size");
        if (contentSizeDef != null) {
            packetIndex.setContentSizeBits((int)contentSizeDef.getValue());
        } else {
            packetIndex.setContentSizeBits((int)(fileSizeBytes * 8L));
        }
        IntegerDefinition packetSizeDef = (IntegerDefinition)streamPacketContextDef.lookupDefinition("packet_size");
        if (packetSizeDef != null) {
            packetIndex.setPacketSizeBits((int)packetSizeDef.getValue());
        } else if (packetIndex.getContentSizeBits() != 0) {
            packetIndex.setPacketSizeBits(packetIndex.getContentSizeBits());
        } else {
            packetIndex.setPacketSizeBits((int)(fileSizeBytes * 8L));
        }
        IntegerDefinition timestampBeginDef = (IntegerDefinition)streamPacketContextDef.lookupDefinition("timestamp_begin");
        if (timestampBeginDef != null) {
            packetIndex.setTimestampBegin(timestampBeginDef.getValue());
        }
        if ((timestampEndDef = (IntegerDefinition)streamPacketContextDef.lookupDefinition("timestamp_end")) != null) {
            packetIndex.setTimestampEnd(timestampEndDef.getValue());
            this.setTimestampEnd(packetIndex.getTimestampEnd());
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamInput)) {
            return false;
        }
        StreamInput other = (StreamInput)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }
}

