/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui.auth;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.OpenIdAuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.OpenIdCredentials;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.browser.WebBrowserDialog;
import org.eclipse.mylyn.internal.commons.repositories.ui.auth.AbstractCredentialsProviderUi;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIdCredentialsProviderUi
extends AbstractCredentialsProviderUi<OpenIdCredentials> {
    protected OpenIdCredentials credentials;

    @Override
    public IStatus open(Shell parentShell, AuthenticationRequest<AuthenticationType<OpenIdCredentials>> authRequest) {
        if (!(authRequest instanceof OpenIdAuthenticationRequest)) {
            throw new IllegalArgumentException("Extected instanceof OpenIdAuthenticationRequest, got " + authRequest.getClass());
        }
        final OpenIdAuthenticationRequest request = (OpenIdAuthenticationRequest)authRequest;
        final WebBrowserDialog dialog = new WebBrowserDialog(WorkbenchUtil.getShell(), "Login", null, "Login to OpenID Provider", 0, new String[]{IDialogConstants.CANCEL_LABEL}, 0);
        dialog.create();
        dialog.getBrowser().addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String value;
                if (event.location != null && event.location.startsWith(request.getReturnUrl())) {
                    OpenIdCredentialsProviderUi.this.credentials = new OpenIdCredentials(event.location, null);
                }
                if ((value = Browser.getCookie((String)request.getCookie(), (String)request.getCookieUrl())) != null) {
                    OpenIdCredentialsProviderUi.this.credentials = new OpenIdCredentials(event.location, value);
                }
                if (OpenIdCredentialsProviderUi.this.credentials != null) {
                    event.doit = false;
                    dialog.getBrowser().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (dialog.getShell() != null && !dialog.getShell().isDisposed()) {
                                dialog.close();
                            }
                        }
                    });
                }
            }
        });
        dialog.getBrowser().setUrl(String.valueOf(request.getRequestUrl()) + "?" + this.getRequestParameters(request));
        if (dialog.open() == 0) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private String getRequestParameters(OpenIdAuthenticationRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry entry : request.getProviderArgs().entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
                sb.append("=");
                sb.append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    @Override
    public OpenIdCredentials getCredentials() {
        return this.credentials;
    }
}

