/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator {
    private static final String UTF_8 = "utf-8";
    protected final ClassLoader classLoader;
    private static Class<? extends ServiceLocator> implementationClass;
    private static Pattern CLASS_NAME_PATTERN;

    static {
        CLASS_NAME_PATTERN = Pattern.compile("\\s*([^\\s#]+)?#?.*");
    }

    protected ServiceLocator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ServiceLocator getInstance(ClassLoader classLoader) {
        if (implementationClass != null) {
            try {
                return implementationClass.getConstructor(ClassLoader.class).newInstance(classLoader);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return new ServiceLocator(classLoader);
    }

    public static ServiceLocator getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            ServiceLocator.class.getClassLoader();
        }
        return ServiceLocator.getInstance(loader);
    }

    public MarkupLanguage getMarkupLanguage(final String languageName) throws IllegalArgumentException {
        String className;
        if (languageName == null) {
            throw new IllegalArgumentException();
        }
        Pattern classNamePattern = Pattern.compile("\\s*([^\\s#]+)?#?.*");
        final TreeSet names = new TreeSet();
        final MarkupLanguage[] result = new MarkupLanguage[1];
        this.loadMarkupLanguages(new MarkupLanguageVisitor(){

            public boolean accept(MarkupLanguage language) {
                if (languageName.equals(language.getName())) {
                    result[0] = language;
                    return false;
                }
                names.add(language.getName());
                return true;
            }
        });
        if (result[0] != null) {
            return result[0];
        }
        Matcher matcher = classNamePattern.matcher(languageName);
        if (matcher.matches() && (className = matcher.group(1)) != null) {
            try {
                Class<?> clazz = Class.forName(className, true, this.classLoader);
                if (MarkupLanguage.class.isAssignableFrom(clazz)) {
                    MarkupLanguage instance = (MarkupLanguage)clazz.newInstance();
                    return instance;
                }
            }
            catch (Exception exception) {}
        }
        StringBuilder buf = new StringBuilder();
        for (String name : names) {
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append('\'');
            buf.append(name);
            buf.append('\'');
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ServiceLocator.4"), languageName, buf.length() == 0 ? Messages.getString("ServiceLocator.5") : String.valueOf(Messages.getString("ServiceLocator.6")) + buf));
    }

    public Set<MarkupLanguage> getAllMarkupLanguages() {
        final HashSet<MarkupLanguage> markupLanguages = new HashSet<MarkupLanguage>();
        this.loadMarkupLanguages(new MarkupLanguageVisitor(){

            public boolean accept(MarkupLanguage language) {
                markupLanguages.add(language);
                return true;
            }
        });
        return markupLanguages;
    }

    public static void setImplementation(Class<? extends ServiceLocator> implementationClass) {
        ServiceLocator.implementationClass = implementationClass;
    }

    /*
     * Exception decompiling
     */
    private void loadMarkupLanguages(MarkupLanguageVisitor visitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static interface MarkupLanguageVisitor {
        public boolean accept(MarkupLanguage var1);
    }
}

