/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.rawviewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Slider;

public class TmfRawEventViewer
extends Composite
implements ControlListener,
SelectionListener,
KeyListener,
CaretListener,
MouseMoveListener,
MouseTrackListener,
MouseWheelListener {
    private static final Color COLOR_BACKGROUND_ODD = Display.getCurrent().getSystemColor(1);
    private static final Color COLOR_BACKGROUND_EVEN = new Color((Device)Display.getDefault(), 242, 242, 242);
    private static final Color COLOR_BACKGROUND_SELECTED = new Color((Device)Display.getDefault(), 231, 246, 254);
    private static final Color COLOR_BACKGROUND_HIGHLIGHTED = new Color((Device)Display.getDefault(), 246, 252, 255);
    private static final int MAX_LINE_DATA_SIZE = 1000;
    private static final int SLIDER_MAX = 1000000;
    private ITmfTrace<?> fTrace;
    private ITmfContext fBottomContext;
    private ScrolledComposite fScrolledComposite;
    private Composite fTextArea;
    private StyledText fStyledText;
    private Font fFixedFont;
    private Slider fSlider;
    private List<LineData> fLines = new ArrayList<LineData>();
    private boolean fActualRanks = false;
    private int fTopLineIndex;
    private int fLastTopLineIndex;
    private CaretPosition[] fStoredCaretPosition = new CaretPosition[]{new CaretPosition(0, 0), new CaretPosition(0, 0)};
    private int fNumVisibleLines;
    private ITmfLocation<?> fSelectedLocation = null;
    private long fHighlightedRank = Long.MIN_VALUE;
    private int fCursorYCoordinate = -1;
    private int fHoldSelection = 0;

    public TmfRawEventViewer(Composite parent, int style) {
        super(parent, style & 0xFFFFFEFF & 0xFFFFFDFF);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.createTextArea(style & 0x100);
        this.createSlider(style & 0x200);
        this.setTabList(new Control[]{this.fScrolledComposite});
    }

    public void dispose() {
        if (this.fFixedFont != null) {
            this.fFixedFont.dispose();
            this.fFixedFont = null;
        }
        super.dispose();
    }

    private void createTextArea(int style) {
        this.fScrolledComposite = new ScrolledComposite((Composite)this, style);
        this.fScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTextArea = new Composite((Composite)this.fScrolledComposite, 0);
        this.fTextArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fScrolledComposite.setContent((Control)this.fTextArea);
        this.fScrolledComposite.setExpandHorizontal(true);
        this.fScrolledComposite.setExpandVertical(true);
        this.fScrolledComposite.setAlwaysShowScrollBars(true);
        this.fScrolledComposite.setMinSize(this.fTextArea.computeSize(-1, -1));
        this.fScrolledComposite.addControlListener((ControlListener)this);
        GridLayout textAreaGridLayout = new GridLayout();
        textAreaGridLayout.marginHeight = 0;
        textAreaGridLayout.marginWidth = 0;
        this.fTextArea.setLayout((Layout)textAreaGridLayout);
        if (this.fFixedFont == null) {
            this.fFixedFont = System.getProperty("os.name").contains("Windows") ? new Font((Device)Display.getCurrent(), new FontData("Courier New", 10, 0)) : new Font((Device)Display.getCurrent(), new FontData("Monospace", 10, 0));
        }
        this.fStyledText = new StyledText(this.fTextArea, 8);
        this.fStyledText.setFont(this.fFixedFont);
        this.fStyledText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fStyledText.addCaretListener((CaretListener)this);
        this.fStyledText.addMouseMoveListener((MouseMoveListener)this);
        this.fStyledText.addMouseTrackListener((MouseTrackListener)this);
        this.fStyledText.addMouseWheelListener((MouseWheelListener)this);
        this.fStyledText.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.fStyledText.addKeyListener((KeyListener)this);
        this.fTextArea.setBackground(this.fStyledText.getBackground());
        this.fTextArea.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TmfRawEventViewer.this.fTextArea.setFocus();
            }
        });
    }

    private void createSlider(int style) {
        this.fSlider = new Slider((Composite)this, 512);
        this.fSlider.setLayoutData((Object)new GridData(4, 4, false, true));
        this.fSlider.setValues(0, 0, 1000000, 1000000, 1, 1);
        this.fSlider.addSelectionListener((SelectionListener)this);
        if ((style & 0x200) == 0) {
            this.fSlider.setVisible(false);
        }
    }

    public boolean setFocus() {
        boolean isVisible = this.isVisible();
        if (isVisible) {
            this.fTextArea.setFocus();
        }
        return isVisible;
    }

    public void setMenu(Menu menu) {
        this.fStyledText.setMenu(menu);
    }

    public void setTrace(ITmfTrace<?> trace) {
        this.fTrace = trace;
        this.fTopLineIndex = 0;
        this.fLines.clear();
        this.refreshEventCount();
    }

    public void refreshEventCount() {
        if (this.fTrace != null) {
            if (this.fTrace.getNbEvents() > 0L) {
                this.fSlider.setThumb((int)Math.max(1000000L / this.fTrace.getNbEvents(), 1L));
            } else {
                this.fSlider.setThumb(1000000);
            }
            if (!this.isVisible()) {
                return;
            }
            if (this.fLines.size() == 0) {
                this.setTopRank(0L);
            } else if (this.fLines.size() < this.fNumVisibleLines) {
                this.fBottomContext = null;
                this.loadLineData();
                this.fillTextArea();
                this.fSlider.setSelection((int)(1000000.0 * this.fTrace.getLocationRatio(this.fLines.get((int)this.fTopLineIndex).location)));
            }
        }
    }

    public void selectAndReveal(long rank) {
        if (this.fTrace == null || !this.isVisible()) {
            return;
        }
        if (this.fActualRanks && this.fTopLineIndex < this.fLines.size() && rank >= this.fLines.get((int)this.fTopLineIndex).rank) {
            int lastVisibleIndex = Math.min(this.fTopLineIndex + this.fNumVisibleLines, this.fLines.size()) - 1;
            if (rank <= this.fLines.get((int)lastVisibleIndex).rank) {
                int i = this.fTopLineIndex;
                while (i < this.fLines.size()) {
                    if (this.fLines.get((int)i).rank == rank) {
                        this.fSelectedLocation = this.fLines.get((int)i).location;
                        break;
                    }
                    ++i;
                }
                this.refreshLineBackgrounds();
                return;
            }
        }
        this.setTopRank(rank);
        if (this.fLines.size() > 0 && this.fHoldSelection == 0) {
            this.fSelectedLocation = this.fLines.get((int)0).location;
            this.refreshLineBackgrounds();
        }
    }

    public void addSelectionListener(Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.addListener(13, listener);
    }

    public void removeSelectionListener(Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, listener);
    }

    private void sendSelectionEvent(LineData lineData) {
        Event event = new Event();
        event.data = this.fActualRanks ? Long.valueOf(lineData.rank) : lineData.location;
        this.notifyListeners(13, event);
    }

    private void setTopRank(long rank) {
        this.fBottomContext = this.fTrace.seekEvent(rank);
        if (this.fBottomContext == null) {
            return;
        }
        this.fLines.clear();
        this.fActualRanks = true;
        this.fTopLineIndex = 0;
        this.loadLineData();
        this.refreshTextArea();
        if (this.fLines.size() == 0) {
            this.fSlider.setSelection(0);
        } else {
            this.fSlider.setSelection((int)(1000000.0 * this.fTrace.getLocationRatio(this.fLines.get((int)this.fTopLineIndex).location)));
        }
    }

    private void setTopPosition(double ratio) {
        this.fBottomContext = this.fTrace.seekEvent(ratio);
        if (this.fBottomContext == null) {
            return;
        }
        this.fBottomContext.setRank(0L);
        this.fLines.clear();
        this.fActualRanks = false;
        this.fTopLineIndex = 0;
        this.loadLineData();
        this.refreshTextArea();
    }

    private void loadLineData() {
        block24: {
            if (this.fTopLineIndex < 0) {
                if (this.fLines.size() > 0 && this.fTrace.getLocationRatio(this.fLines.get((int)0).location) > 0.0) {
                    double delta;
                    double lastRatio = this.fTrace.getLocationRatio(this.fLines.get((int)(this.fLines.size() - 1)).location);
                    double firstRatio = this.fTrace.getLocationRatio(this.fLines.get((int)0).location);
                    boolean singleEvent = false;
                    if (firstRatio != lastRatio) {
                        delta = (double)Math.max(20, this.fNumVisibleLines) * (lastRatio - firstRatio) / (double)(this.fLines.size() - 1);
                    } else {
                        delta = Math.pow(10.0, -15.0);
                        singleEvent = true;
                    }
                    while (this.fTopLineIndex < 0) {
                        int i;
                        ITmfLocation<?> endLocation = this.fLines.get((int)0).location;
                        firstRatio = Math.max(0.0, firstRatio - delta);
                        ITmfContext context = this.fTrace.seekEvent(firstRatio);
                        int index = 0;
                        long rank = 0L;
                        while (!context.getLocation().equals(endLocation)) {
                            ITmfLocation location = context.getLocation().clone();
                            ITmfEvent event = this.fTrace.getNext(context);
                            if (event == null) break;
                            if (event.getContent() != null && event.getContent().getValue() != null) {
                                String[] lines = event.getContent().getValue().toString().split("\r?\n");
                                i = 0;
                                while (i < lines.length) {
                                    String line = lines[i];
                                    LineData lineData = new LineData(rank, location, line);
                                    this.fLines.add(index++, lineData);
                                    ++this.fTopLineIndex;
                                    ++this.fLastTopLineIndex;
                                    ++i;
                                }
                            } else {
                                LineData lineData = new LineData(rank, location, "");
                                this.fLines.add(index++, lineData);
                                ++this.fTopLineIndex;
                                ++this.fLastTopLineIndex;
                            }
                            ++rank;
                        }
                        long rankOffset = this.fLines.get((int)index).rank - rank;
                        i = 0;
                        while (i < index) {
                            this.fLines.get((int)i).rank += rankOffset;
                            ++i;
                        }
                        if (firstRatio == 0.0) break;
                        if (!singleEvent) continue;
                        delta = Math.min(delta * 10.0, 0.1);
                    }
                }
                if (this.fTopLineIndex < 0) {
                    this.fTopLineIndex = 0;
                }
            }
            while (this.fLines.size() - this.fTopLineIndex < this.fNumVisibleLines) {
                if (this.fBottomContext == null) {
                    if (this.fLines.size() == 0) {
                        this.fBottomContext = this.fTrace.seekEvent(0L);
                    } else {
                        this.fBottomContext = this.fTrace.seekEvent(this.fLines.get((int)(this.fLines.size() - 1)).location);
                        this.fTrace.getNext(this.fBottomContext);
                    }
                    if (this.fBottomContext == null) break;
                }
                long rank = this.fBottomContext.getRank();
                ITmfLocation location = this.fBottomContext.getLocation() != null ? this.fBottomContext.getLocation().clone() : null;
                ITmfEvent event = this.fTrace.getNext(this.fBottomContext);
                if (event == null) break;
                if (event.getContent() != null && event.getContent().getValue() != null) {
                    String[] stringArray = event.getContent().getValue().toString().split("\r?\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        int crPos = line.indexOf(13);
                        if (crPos != -1) {
                            line = line.substring(0, crPos);
                        }
                        LineData lineData = new LineData(rank, location, line);
                        this.fLines.add(lineData);
                        ++n2;
                    }
                    continue;
                }
                LineData lineData = new LineData(rank, location, "");
                this.fLines.add(lineData);
            }
            this.fTopLineIndex = Math.max(0, Math.min(this.fTopLineIndex, this.fLines.size() - 1));
            if (this.fLines.size() <= 1000) break block24;
            if (this.fTopLineIndex < 500) {
                long rank = this.fLines.get((int)999).rank;
                int i = 1000;
                while (i < this.fLines.size()) {
                    if (this.fLines.get((int)i).rank > rank) {
                        this.fLines.subList(i, this.fLines.size()).clear();
                        this.fBottomContext = null;
                        break;
                    }
                    ++i;
                }
            } else {
                long rank = this.fLines.get((int)(this.fLines.size() - 1000)).rank;
                int i = this.fLines.size() - 1000 - 1;
                while (i >= 0) {
                    if (this.fLines.get((int)i).rank < rank) {
                        this.fLines.subList(0, i + 1).clear();
                        this.fTopLineIndex -= i + 1;
                        this.fLastTopLineIndex -= i + 1;
                        break;
                    }
                    --i;
                }
            }
        }
    }

    private void refreshTextArea() {
        this.fStyledText.setText("");
        int i = 0;
        while (i < this.fLines.size() - this.fTopLineIndex && i < this.fNumVisibleLines) {
            if (i > 0) {
                this.fStyledText.append("\n");
            }
            LineData lineData = this.fLines.get(this.fTopLineIndex + i);
            this.fStyledText.append(lineData.string);
            this.setLineBackground(i, lineData);
            ++i;
        }
        this.fTextArea.layout();
        this.fScrolledComposite.setMinSize(this.fTextArea.computeSize(-1, -1));
        this.fLastTopLineIndex = this.fTopLineIndex;
    }

    private void fillTextArea() {
        int endOffset;
        int nextLine;
        int i = nextLine = this.fStyledText.getCharCount() == 0 ? 0 : this.fStyledText.getLineCount();
        while (i < this.fLines.size() - this.fTopLineIndex && i < this.fNumVisibleLines) {
            if (i > 0) {
                this.fStyledText.append("\n");
            }
            LineData lineData = this.fLines.get(this.fTopLineIndex + i);
            this.fStyledText.append(lineData.string);
            this.setLineBackground(i, lineData);
            ++i;
        }
        int endLine = Math.min(this.fNumVisibleLines, this.fLines.size());
        if (endLine < this.fStyledText.getLineCount() && (endOffset = this.fStyledText.getOffsetAtLine(endLine) - 1) > this.fStyledText.getCharCount()) {
            ++this.fHoldSelection;
            this.fStyledText.replaceTextRange(endOffset, this.fStyledText.getCharCount() - endOffset, "");
            --this.fHoldSelection;
        }
        this.fTextArea.layout();
        this.fScrolledComposite.setMinSize(this.fTextArea.computeSize(-1, -1));
    }

    private void updateTextArea() {
        int endOffset;
        int i;
        if (this.fTopLineIndex < this.fLastTopLineIndex) {
            StringBuffer insertedText = new StringBuffer();
            i = this.fTopLineIndex;
            while (i < this.fLastTopLineIndex) {
                insertedText.append(String.valueOf(this.fLines.get((int)i).string) + "\n");
                ++i;
            }
            this.fStyledText.replaceTextRange(0, 0, insertedText.toString());
            i = 0;
            while (i < this.fLastTopLineIndex - this.fTopLineIndex) {
                LineData lineData = this.fLines.get(this.fTopLineIndex + i);
                this.setLineBackground(i, lineData);
                ++i;
            }
            this.fLastTopLineIndex = this.fTopLineIndex;
        } else if (this.fTopLineIndex > this.fLastTopLineIndex) {
            int length = 0;
            i = 0;
            while (i < this.fTopLineIndex - this.fLastTopLineIndex && i < this.fNumVisibleLines) {
                length += this.fLines.get((int)(i + this.fLastTopLineIndex)).string.length();
                if (i < this.fStyledText.getLineCount()) {
                    ++length;
                }
                ++i;
            }
            this.fStyledText.replaceTextRange(0, length, "");
            this.fLastTopLineIndex = this.fTopLineIndex;
            this.fillTextArea();
        }
        int endLine = Math.min(this.fNumVisibleLines, this.fLines.size());
        if (endLine < this.fStyledText.getLineCount() && (endOffset = this.fStyledText.getOffsetAtLine(endLine) - 1) > this.fStyledText.getCharCount()) {
            this.fStyledText.replaceTextRange(endOffset, this.fStyledText.getCharCount() - endOffset, "");
        }
        this.fTextArea.layout();
        this.fScrolledComposite.setMinSize(this.fTextArea.computeSize(-1, -1));
    }

    private void refreshLineBackgrounds() {
        int i = 0;
        while (i < this.fStyledText.getLineCount() && i < this.fNumVisibleLines && i < this.fLines.size() - this.fTopLineIndex) {
            LineData lineData = this.fLines.get(this.fTopLineIndex + i);
            this.setLineBackground(i, lineData);
            ++i;
        }
    }

    private void setLineBackground(int index, LineData lineData) {
        if (lineData.location.equals(this.fSelectedLocation)) {
            this.fStyledText.setLineBackground(index, 1, COLOR_BACKGROUND_SELECTED);
        } else if (lineData.rank == this.fHighlightedRank) {
            this.fStyledText.setLineBackground(index, 1, COLOR_BACKGROUND_HIGHLIGHTED);
        } else if (lineData.rank % 2L == 0L) {
            this.fStyledText.setLineBackground(index, 1, COLOR_BACKGROUND_EVEN);
        } else {
            this.fStyledText.setLineBackground(index, 1, COLOR_BACKGROUND_ODD);
        }
    }

    private void storeCaretPosition(int time, int caretOffset) {
        if (this.fStoredCaretPosition[0].time == time) {
            this.fStoredCaretPosition[0].caretOffset = caretOffset;
        } else {
            this.fStoredCaretPosition[1] = this.fStoredCaretPosition[0];
            this.fStoredCaretPosition[0] = new CaretPosition(time, caretOffset);
        }
    }

    private int getPreviousCaretOffset(int time) {
        if (this.fStoredCaretPosition[0].time == time) {
            return this.fStoredCaretPosition[1].caretOffset;
        }
        return this.fStoredCaretPosition[0].caretOffset;
    }

    private void updateHighlightedRank() {
        if (this.fCursorYCoordinate < 0 || this.fCursorYCoordinate > this.fStyledText.getSize().y) {
            if (this.fHighlightedRank != Long.MIN_VALUE) {
                this.fHighlightedRank = Long.MIN_VALUE;
                this.refreshLineBackgrounds();
            }
            return;
        }
        int offset = this.fStyledText.getOffsetAtLocation(new Point(0, this.fCursorYCoordinate));
        int line = this.fStyledText.getLineAtOffset(offset);
        if (line < this.fLines.size() - this.fTopLineIndex) {
            LineData lineData = this.fLines.get(this.fTopLineIndex + line);
            if (this.fHighlightedRank != lineData.rank) {
                this.fHighlightedRank = lineData.rank;
                this.refreshLineBackgrounds();
            }
        } else if (this.fHighlightedRank != Long.MIN_VALUE) {
            this.fHighlightedRank = Long.MIN_VALUE;
            this.refreshLineBackgrounds();
        }
    }

    public void controlResized(ControlEvent event) {
        int areaHeight = this.fScrolledComposite.getSize().y;
        if (this.fScrolledComposite.getHorizontalBar() != null) {
            areaHeight -= this.fScrolledComposite.getHorizontalBar().getSize().y;
        }
        int lineHeight = this.fStyledText.getLineHeight();
        this.fNumVisibleLines = Math.max((areaHeight + lineHeight - 1) / lineHeight, 1);
        if (this.fBottomContext != null) {
            this.loadLineData();
            this.fillTextArea();
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.fTextArea.setFocus();
        if (this.fLines.size() == 0) {
            return;
        }
        if (e.detail == 1) {
            return;
        }
        ++this.fHoldSelection;
        block0 : switch (e.detail) {
            case 0: {
                if (this.fSlider.getSelection() == 0 || this.fSlider.getThumb() == 1000000) {
                    this.fLines.clear();
                    this.setTopPosition(0.0);
                    break;
                }
                double ratio = (double)this.fSlider.getSelection() / (double)(1000000 - this.fSlider.getThumb());
                double delta = Math.pow(10.0, -15.0);
                this.fLines.clear();
                while (this.fLines.size() == 0) {
                    this.setTopPosition(ratio);
                    if (ratio == 0.0) break block0;
                    delta = Math.min(delta * 10.0, 0.1);
                    ratio = Math.max(ratio - delta, 0.0);
                }
                break;
            }
            case 0x1000002: {
                if (this.fTopLineIndex >= this.fLines.size()) break;
                ++this.fTopLineIndex;
                this.loadLineData();
                this.updateTextArea();
                break;
            }
            case 0x1000006: {
                this.fTopLineIndex += Math.max(this.fNumVisibleLines - 1, 1);
                this.loadLineData();
                this.updateTextArea();
                break;
            }
            case 0x1000001: {
                if (this.fLines.size() == 0) break;
                --this.fTopLineIndex;
                this.loadLineData();
                this.updateTextArea();
                break;
            }
            case 0x1000005: {
                this.fTopLineIndex -= Math.max(this.fNumVisibleLines - 1, 1);
                this.loadLineData();
                this.updateTextArea();
                break;
            }
            case 0x1000007: {
                this.setTopPosition(0.0);
                break;
            }
            case 0x1000008: {
                double ratio = 1.0;
                double delta = Math.pow(10.0, -15.0);
                this.fLines.clear();
                while (this.fLines.size() == 0) {
                    this.setTopPosition(ratio);
                    if (ratio == 0.0) break block0;
                    delta = Math.min(delta * 10.0, 0.1);
                    ratio = Math.max(ratio - delta, 0.0);
                }
                break;
            }
        }
        if (e.detail != 0) {
            this.fSlider.setSelection((int)(1000000.0 * this.fTrace.getLocationRatio(this.fLines.get((int)this.fTopLineIndex).location)));
        }
        this.fHoldSelection = 0;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.fLines.size() == 0) {
            return;
        }
        int caretOffset = this.fStyledText.getCaretOffset();
        int previousCaretOffset = this.getPreviousCaretOffset(e.time);
        int previousLineAtCaretPosition = this.fStyledText.getLineAtOffset(previousCaretOffset);
        int previousColumnAtCaretPosition = this.getPreviousCaretOffset(e.time) - this.fStyledText.getOffsetAtLine(previousLineAtCaretPosition);
        switch (e.keyCode) {
            case 0x1000002: {
                if (previousLineAtCaretPosition < this.fNumVisibleLines - 2) break;
                ++this.fHoldSelection;
                ++this.fTopLineIndex;
                this.loadLineData();
                this.updateTextArea();
                --this.fHoldSelection;
                LineData lineData = this.fLines.get(this.fTopLineIndex + this.fStyledText.getLineAtOffset(this.fStyledText.getCaretOffset()));
                if (lineData.location.equals(this.fSelectedLocation)) break;
                this.fSelectedLocation = lineData.location;
                this.refreshLineBackgrounds();
                this.sendSelectionEvent(lineData);
                break;
            }
            case 0x1000006: {
                if (previousLineAtCaretPosition >= this.fNumVisibleLines - 1) {
                    ++this.fHoldSelection;
                    if (this.fLines.get((int)(this.fTopLineIndex + previousLineAtCaretPosition)).rank % 2L == 0L) {
                        this.fStyledText.setLineBackground(previousLineAtCaretPosition, 1, COLOR_BACKGROUND_EVEN);
                    } else {
                        this.fStyledText.setLineBackground(previousLineAtCaretPosition, 1, COLOR_BACKGROUND_ODD);
                    }
                    this.fSelectedLocation = null;
                    this.fTopLineIndex += Math.max(this.fNumVisibleLines - 1, 1);
                    this.loadLineData();
                    this.updateTextArea();
                    --this.fHoldSelection;
                }
                int line = Math.min(this.fNumVisibleLines - 1, this.fStyledText.getLineCount() - 1);
                int offset = this.fStyledText.getOffsetAtLine(line);
                this.fStyledText.setSelection(offset + Math.min(previousColumnAtCaretPosition, this.fLines.get((int)(this.fTopLineIndex + line)).string.length()));
                break;
            }
            case 0x1000004: {
                if (previousCaretOffset < this.fStyledText.getCharCount() || previousLineAtCaretPosition < this.fNumVisibleLines - 2) break;
                ++this.fHoldSelection;
                ++this.fTopLineIndex;
                this.loadLineData();
                this.updateTextArea();
                --this.fHoldSelection;
                this.fStyledText.setSelection(this.fStyledText.getCaretOffset() + 1);
                break;
            }
            case 0x1000001: {
                if (previousLineAtCaretPosition > 0 || this.fLines.size() == 0) break;
                ++this.fHoldSelection;
                --this.fTopLineIndex;
                this.loadLineData();
                this.updateTextArea();
                --this.fHoldSelection;
                LineData lineData = this.fLines.get(this.fTopLineIndex);
                if (!lineData.location.equals(this.fSelectedLocation)) {
                    this.fSelectedLocation = lineData.location;
                    this.refreshLineBackgrounds();
                    this.sendSelectionEvent(lineData);
                }
                this.fStyledText.setSelection(caretOffset);
                break;
            }
            case 0x1000005: {
                if (previousLineAtCaretPosition > 0) break;
                ++this.fHoldSelection;
                this.fTopLineIndex -= Math.max(this.fNumVisibleLines - 1, 1);
                this.loadLineData();
                this.updateTextArea();
                --this.fHoldSelection;
                LineData lineData = this.fLines.get(this.fTopLineIndex);
                if (!lineData.location.equals(this.fSelectedLocation)) {
                    this.fSelectedLocation = lineData.location;
                    this.refreshLineBackgrounds();
                    this.sendSelectionEvent(lineData);
                }
                this.fStyledText.setSelection(caretOffset);
                break;
            }
            case 0x1000003: {
                if (previousCaretOffset > 0 || this.fLines.size() == 0) break;
                long topRank = this.fLines.get((int)this.fTopLineIndex).rank;
                ++this.fHoldSelection;
                --this.fTopLineIndex;
                this.loadLineData();
                this.updateTextArea();
                --this.fHoldSelection;
                LineData lineData = this.fLines.get(this.fTopLineIndex);
                if (!lineData.location.equals(this.fSelectedLocation)) {
                    this.fSelectedLocation = lineData.location;
                    this.refreshLineBackgrounds();
                    this.sendSelectionEvent(lineData);
                }
                if (topRank == this.fLines.get((int)this.fTopLineIndex).rank) break;
                this.fStyledText.setSelection(this.fLines.get((int)this.fTopLineIndex).string.length());
                break;
            }
            case 0x1000007: {
                if ((e.stateMask & 0x40000) == 0) break;
                this.setTopPosition(0.0);
                LineData lineData = this.fLines.get(this.fTopLineIndex);
                if (lineData.location.equals(this.fSelectedLocation)) break;
                this.fSelectedLocation = lineData.location;
                this.refreshLineBackgrounds();
                this.sendSelectionEvent(lineData);
                break;
            }
            case 0x1000008: {
                if ((e.stateMask & 0x40000) == 0) break;
                double ratio = 1.0;
                double delta = Math.pow(10.0, -15.0);
                this.fLines.clear();
                while (this.fLines.size() == 0) {
                    this.setTopPosition(ratio);
                    if (ratio == 0.0) break;
                    delta = Math.min(delta * 10.0, 0.1);
                    ratio = Math.max(ratio - delta, 0.0);
                }
                LineData lineData = this.fLines.get(this.fTopLineIndex);
                if (lineData.location.equals(this.fSelectedLocation)) break;
                this.fSelectedLocation = lineData.location;
                this.refreshLineBackgrounds();
                this.sendSelectionEvent(lineData);
                break;
            }
        }
        this.updateHighlightedRank();
        this.fSlider.setSelection((int)(1000000.0 * this.fTrace.getLocationRatio(this.fLines.get((int)this.fTopLineIndex).location)));
    }

    public void keyReleased(KeyEvent e) {
    }

    public void caretMoved(CaretEvent event) {
        int line;
        if (this.fHoldSelection == 0 && this.fTopLineIndex + (line = this.fStyledText.getLineAtOffset(event.caretOffset)) < this.fLines.size()) {
            LineData lineData = this.fLines.get(this.fTopLineIndex + line);
            if (!lineData.location.equals(this.fSelectedLocation)) {
                this.fSelectedLocation = lineData.location;
                this.refreshLineBackgrounds();
                this.sendSelectionEvent(lineData);
            }
        }
        this.storeCaretPosition(event.time, event.caretOffset);
        if (this.fHoldSelection == 0) {
            Point caret = this.fStyledText.getLocationAtOffset(this.fStyledText.getCaretOffset());
            Point origin = this.fScrolledComposite.getOrigin();
            if (origin.x > caret.x) {
                origin.x = caret.x;
            } else if (caret.x - origin.x > this.fScrolledComposite.getSize().x) {
                origin.x = caret.x - this.fScrolledComposite.getSize().x + 1;
            }
            this.fScrolledComposite.setOrigin(origin);
        }
    }

    public void mouseMove(MouseEvent e) {
        this.fCursorYCoordinate = e.y;
        if (e.y < 0 || e.y > this.fStyledText.getSize().y) {
            if (this.fHighlightedRank != Long.MIN_VALUE) {
                this.fHighlightedRank = Long.MIN_VALUE;
                this.refreshLineBackgrounds();
            }
            return;
        }
        int offset = this.fStyledText.getOffsetAtLocation(new Point(0, e.y));
        int line = this.fStyledText.getLineAtOffset(offset);
        if (line < this.fLines.size() - this.fTopLineIndex) {
            LineData lineData = this.fLines.get(this.fTopLineIndex + line);
            if (this.fHighlightedRank != lineData.rank) {
                this.fHighlightedRank = lineData.rank;
                this.refreshLineBackgrounds();
            }
        } else if (this.fHighlightedRank != Long.MIN_VALUE) {
            this.fHighlightedRank = Long.MIN_VALUE;
            this.refreshLineBackgrounds();
        }
    }

    public void mouseExit(MouseEvent e) {
        this.fCursorYCoordinate = -1;
        if (this.fHighlightedRank != Long.MIN_VALUE) {
            this.fHighlightedRank = Long.MIN_VALUE;
            this.refreshLineBackgrounds();
        }
    }

    public void mouseEnter(MouseEvent e) {
        this.fCursorYCoordinate = e.y;
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseScrolled(MouseEvent e) {
        if (this.fLines.size() == 0) {
            return;
        }
        ++this.fHoldSelection;
        this.fTopLineIndex -= e.count;
        this.loadLineData();
        this.updateTextArea();
        this.fHoldSelection = 0;
        this.updateHighlightedRank();
        this.fSlider.setSelection((int)(1000000.0 * this.fTrace.getLocationRatio(this.fLines.get((int)this.fTopLineIndex).location)));
    }

    private static class CaretPosition {
        int time;
        int caretOffset;

        public CaretPosition(int time, int caretOffset) {
            this.time = time;
            this.caretOffset = caretOffset;
        }
    }

    private static class LineData {
        long rank;
        ITmfLocation<?> location;
        String string;

        public LineData(long rank, ITmfLocation<?> location, String string) {
            this.rank = rank;
            this.location = location;
            this.string = string.length() == 0 ? " " : string;
        }

        public String toString() {
            return String.valueOf(this.rank) + " [" + this.location + "]: " + this.string;
        }
    }
}

