/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IFont;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.impl.ColorImpl;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.impl.FontImpl;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.ISDPreferences;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SDViewPref
implements ISDPreferences,
IPropertyChangeListener {
    public static final String BACK_COLOR_POSTFIX = "_BACK_COLOR";
    public static final String FORE_COLOR_POSTFIX = "_FORE_COLOR";
    public static final String TEXT_COLOR_POSTFIX = "_TEXT_COLOR";
    private static final String[] FONT_LIST = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    private static final String[] FONT_LIST2 = new String[]{SDMessages._88, SDMessages._89, SDMessages._90, SDMessages._91, SDMessages._92, SDMessages._93, SDMessages._94, SDMessages._95, SDMessages._96};
    private static final String[] PREF_BACK_COLOR_LIST = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    private static final String[] PREF_FORE_COLOR_LIST = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    private static final String[] PREF_TEXT_COLOR_LIST = new String[]{"PREF_LIFELINE", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    protected static final String TEMP_TAG = "_TEMP";
    private static SDViewPref fHandle = null;
    protected Map<String, IFont> fFontPref;
    protected Map<String, IColor> fForeColorPref;
    protected Map<String, IColor> fBackColorPref;
    protected Map<String, IColor> fTextColorPref;
    protected IPreferenceStore fPrefStore = Activator.getDefault().getPreferenceStore();
    protected IColor fTimeCompressionSelectionColor = null;
    protected boolean fNoFocusSelection = false;

    protected SDViewPref() {
        ColorImpl color;
        this.fPrefStore.setDefault("PREF_LINK_FONT", true);
        this.fPrefStore.setDefault("PREF_EXCLUDE_EXTERNAL_TIME", true);
        this.fPrefStore.setDefault("PREF_LIFELINE_WIDTH", 200);
        this.fPrefStore.setDefault("PREF_USE_GRADIENT", true);
        this.fPrefStore.setDefault("PREF_TOOLTIP", true);
        this.fFontPref = new Hashtable<String, IFont>();
        this.fForeColorPref = new Hashtable<String, IColor>();
        this.fBackColorPref = new Hashtable<String, IColor>();
        this.fTextColorPref = new Hashtable<String, IColor>();
        int i = 0;
        while (i < FONT_LIST.length) {
            if (FONT_LIST[i].equals("PREF_FRAME_NAME")) {
                FontData[] data = Display.getDefault().getSystemFont().getFontData();
                data[0].setStyle(1);
                PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)FONT_LIST[i], (FontData)data[0]);
                PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(FONT_LIST[i]) + TEMP_TAG), (FontData)data[0]);
            } else {
                PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)FONT_LIST[i], (FontData[])Display.getDefault().getSystemFont().getFontData());
                PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(FONT_LIST[i]) + TEMP_TAG), (FontData[])Display.getDefault().getSystemFont().getFontData());
            }
            ++i;
        }
        i = 0;
        while (i < PREF_BACK_COLOR_LIST.length) {
            color = PREF_BACK_COLOR_LIST[i].equals("PREF_EXEC") || PREF_BACK_COLOR_LIST[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), 201, 222, 233) : (PREF_BACK_COLOR_LIST[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), 220, 220, 220) : (PREF_BACK_COLOR_LIST[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), 245, 244, 244) : new ColorImpl(Display.getDefault(), 255, 255, 255)));
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        i = 0;
        while (i < PREF_FORE_COLOR_LIST.length) {
            color = PREF_FORE_COLOR_LIST[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), 129, 129, 129) : (PREF_FORE_COLOR_LIST[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), 81, 153, 200) : (PREF_FORE_COLOR_LIST[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), 129, 127, 137) : new ColorImpl(Display.getDefault(), 134, 176, 212)));
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        i = 0;
        while (i < PREF_TEXT_COLOR_LIST.length) {
            color = PREF_TEXT_COLOR_LIST[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), 129, 129, 129) : (PREF_TEXT_COLOR_LIST[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), 0, 0, 0) : (PREF_TEXT_COLOR_LIST[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), 129, 127, 137) : new ColorImpl(Display.getDefault(), 134, 176, 212)));
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        ColorImpl color2 = new ColorImpl(Display.getDefault(), 218, 232, 238);
        PreferenceConverter.setDefault((IPreferenceStore)this.fPrefStore, (String)"PREF_TIME_COMP", (RGB)((Color)color2.getColor()).getRGB());
        color2.dispose();
        this.buildFontsAndColors();
        this.fPrefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPrefStore;
    }

    public void apply() {
        this.buildFontsAndColors();
        this.fPrefStore.firePropertyChangeEvent("PREFOK", null, null);
    }

    public static synchronized SDViewPref getInstance() {
        if (fHandle == null) {
            fHandle = new SDViewPref();
        }
        return fHandle;
    }

    @Override
    public IColor getForeGroundColor(String prefName) {
        if (this.fForeColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX) != null && this.fForeColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX) instanceof ColorImpl) {
            return this.fForeColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(2);
    }

    @Override
    public IColor getBackGroundColor(String prefName) {
        if (this.fBackColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX) != null && this.fBackColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX) instanceof ColorImpl) {
            return this.fBackColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(1);
    }

    @Override
    public IColor getFontColor(String prefName) {
        if (this.fTextColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX) != null && this.fTextColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX) instanceof ColorImpl) {
            return this.fTextColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(2);
    }

    @Override
    public IColor getForeGroundColorSelection() {
        if (this.fNoFocusSelection) {
            return ColorImpl.getSystemColor(33);
        }
        return ColorImpl.getSystemColor(27);
    }

    @Override
    public IColor getBackGroundColorSelection() {
        if (this.fNoFocusSelection) {
            return ColorImpl.getSystemColor(22);
        }
        return ColorImpl.getSystemColor(26);
    }

    @Override
    public IFont getFont(String prefName) {
        if (this.fFontPref.get(prefName) != null) {
            return this.fFontPref.get(prefName);
        }
        return FontImpl.getSystemFont();
    }

    public int getLifelineWidth() {
        return this.fPrefStore.getInt("PREF_LIFELINE_WIDTH");
    }

    public boolean fontLinked() {
        return this.fPrefStore.getBoolean("PREF_LINK_FONT");
    }

    public boolean tooltipEnabled() {
        return this.fPrefStore.getBoolean("PREF_TOOLTIP");
    }

    public boolean excludeExternalTime() {
        return this.fPrefStore.getBoolean("PREF_EXCLUDE_EXTERNAL_TIME");
    }

    @Override
    public boolean useGradienColor() {
        return this.fPrefStore.getBoolean("PREF_USE_GRADIENT");
    }

    @Override
    public IColor getTimeCompressionSelectionColor() {
        return this.fTimeCompressionSelectionColor;
    }

    private void buildFontsAndColors() {
        RGB rgb;
        Display display = Display.getDefault();
        int i = 0;
        while (i < FONT_LIST.length) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.fPrefStore, (String)FONT_LIST[i]);
            if (this.fFontPref.get(FONT_LIST[i]) != null) {
                this.fFontPref.get(FONT_LIST[i]).dispose();
            }
            this.fFontPref.put(FONT_LIST[i], new FontImpl(display, fontData));
            ++i;
        }
        i = 0;
        while (i < PREF_BACK_COLOR_LIST.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX));
            if (this.fBackColorPref.get(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX) != null) {
                this.fBackColorPref.get(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX).dispose();
            }
            this.fBackColorPref.put(String.valueOf(PREF_BACK_COLOR_LIST[i]) + BACK_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        i = 0;
        while (i < PREF_FORE_COLOR_LIST.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX));
            if (this.fForeColorPref.get(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX) != null) {
                this.fForeColorPref.get(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX).dispose();
            }
            this.fForeColorPref.put(String.valueOf(PREF_FORE_COLOR_LIST[i]) + FORE_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        i = 0;
        while (i < PREF_TEXT_COLOR_LIST.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX));
            if (this.fTextColorPref.get(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX) != null) {
                this.fTextColorPref.get(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX).dispose();
            }
            this.fTextColorPref.put(String.valueOf(PREF_TEXT_COLOR_LIST[i]) + TEXT_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        RGB rgb2 = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)"PREF_TIME_COMP");
        if (this.fTimeCompressionSelectionColor != null) {
            this.fTimeCompressionSelectionColor.dispose();
        }
        this.fTimeCompressionSelectionColor = new ColorImpl(display, rgb2.red, rgb2.green, rgb2.blue);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fPrefStore.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fPrefStore.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!event.getProperty().equals("PREFOK")) {
            this.buildFontsAndColors();
            this.fPrefStore.firePropertyChangeEvent("PREFOK", null, null);
        }
    }

    public void setNoFocusSelection(boolean v) {
        this.fNoFocusSelection = v;
    }

    public static String[] getFontList() {
        return Arrays.copyOf(FONT_LIST, FONT_LIST.length);
    }

    public static String[] getFontList2() {
        return Arrays.copyOf(FONT_LIST2, FONT_LIST2.length);
    }

    public static String[] getPrefBackColorList() {
        return Arrays.copyOf(PREF_BACK_COLOR_LIST, PREF_BACK_COLOR_LIST.length);
    }

    public static String[] getPrefForeColorList() {
        return Arrays.copyOf(PREF_FORE_COLOR_LIST, PREF_FORE_COLOR_LIST.length);
    }

    public static String[] getPrefTextColorList() {
        return Arrays.copyOf(PREF_TEXT_COLOR_LIST, PREF_TEXT_COLOR_LIST.length);
    }
}

