/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class RenameExperimentDialog
extends SelectionStatusDialog {
    private final TmfExperimentElement fExperiment;
    private Text fNewExperimentName;
    private final IContainer fExperimentFolder;
    private final TmfProjectElement fProject;

    public RenameExperimentDialog(Shell shell, TmfExperimentElement experiment) {
        super(shell);
        this.fExperiment = experiment;
        TmfExperimentFolder folder = (TmfExperimentFolder)experiment.getParent();
        this.fExperimentFolder = folder.getResource();
        this.fProject = experiment.getProject();
        this.setTitle(Messages.RenameExperimentDialog_DialogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createNewExperimentNameGroup(composite);
        return composite;
    }

    private void createNewExperimentNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        Label oldExperimentLabel = new Label(folderGroup, 0);
        oldExperimentLabel.setFont(font);
        oldExperimentLabel.setText(Messages.RenameExperimentDialog_ExperimentName);
        Text oldExperimentName = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        oldExperimentName.setLayoutData((Object)data);
        oldExperimentName.setFont(font);
        oldExperimentName.setText(this.fExperiment.getName());
        oldExperimentName.setEnabled(false);
        Label newExperimentLabel = new Label(folderGroup, 0);
        newExperimentLabel.setFont(font);
        newExperimentLabel.setText(Messages.RenameExperimentDialog_ExperimentNewName);
        this.fNewExperimentName = new Text(folderGroup, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.fNewExperimentName.setLayoutData((Object)data);
        this.fNewExperimentName.setFont(font);
        this.fNewExperimentName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                RenameExperimentDialog.this.validateNewExperimentName();
            }
        });
    }

    private void validateNewExperimentName() {
        String name = this.fNewExperimentName.getText();
        IWorkspace workspace = this.fExperimentFolder.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 2);
        if ("".equals(name)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", 4, Messages.Dialog_EmptyNameError, null));
            return;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return;
        }
        Path path = new Path(name);
        if (this.fExperimentFolder.getFolder((IPath)path).exists() || this.fExperimentFolder.getFile((IPath)path).exists()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.linuxtools.tmf.ui", ""));
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        IFolder folder = this.renameExperiment(this.fNewExperimentName.getText());
        if (folder == null) {
            return;
        }
        this.setSelectionResult(new IFolder[]{folder});
        super.okPressed();
        if (this.fProject != null) {
            this.fProject.refresh();
        }
    }

    private IFolder renameExperiment(final String newName) {
        IPath oldPath = this.fExperiment.getResource().getFullPath();
        final IPath newPath = oldPath.append("../" + newName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", 1000);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IFolder folder = RenameExperimentDialog.this.fExperiment.getResource();
                    IFile bookmarksFile = folder.getFile(String.valueOf(RenameExperimentDialog.this.fExperiment.getName()) + '_');
                    IFile newBookmarksFile = folder.getFile(String.valueOf(newName) + '_');
                    if (bookmarksFile.exists() && !newBookmarksFile.exists()) {
                        IPath newBookmarksPath = newBookmarksFile.getFullPath();
                        bookmarksFile.move(newBookmarksPath, 33, null);
                    }
                    RenameExperimentDialog.this.fExperiment.getResource().move(newPath, 33, null);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"", (String)NLS.bind((String)"", (Object)exception.getTargetException().getMessage()));
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        return this.fExperiment.getResource();
    }
}

