
#pragma once

/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright ©2015-2025, Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the “License Agreement”).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi, xPico 200 Series,
** and xPort® Edge products.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*****************************************************************************/
/*                             Includes                                      */
/*****************************************************************************/

#include <stdbool.h>
#include <stdint.h>


/*****************************************************************************/
/*                             Defines                                       */
/*****************************************************************************/

/* Values less than this base handle value are reserved */
#define LTRX_GATT_HANDLE_BASE                       0x200

#define LTRX_GATT_MAX_SERVER                        3

#define LTRX_GATT_MAX_SERVICE_PER_SERVER            3

#define LTRX_GATT_MAX_CHARACTERISTIC_PER_SERVICE    16

#define LTRX_GATT_MAX_DESCRIPTOR_PER_CHARACTERISTIC 8


/*****************************************************************************/
/*                             Structures                                    */
/*****************************************************************************/

struct ltrx_gatt_server_descriptor
{
    struct ltrx_uuid uuid;
    uint16_t handle;
    uint8_t permissions;
};

struct ltrx_gatt_server_characteristic
{
    struct ltrx_uuid uuid;
    uint16_t handle;
    uint16_t value_handle;
    uint8_t properties;
    uint8_t permissions;
    uint8_t descriptor_count;
    struct ltrx_gatt_server_descriptor *descriptor_array;
};

/*
** NB: Only primary services are currently supported (not secondary
**     or included services).
*/
struct ltrx_gatt_server_service
{
    struct ltrx_uuid uuid;
    uint16_t handle;
    bool advertise;
    uint8_t characteristic_count;
    struct ltrx_gatt_server_characteristic *characteristic_array;
};

struct ltrx_gatt_server
{
    const char *lgs_service_name;
    uint8_t lgs_service_count;
    const struct ltrx_gatt_server_service *lgs_service_array[
        LTRX_GATT_MAX_SERVICE_PER_SERVER
    ];
    void (*lgs_connection)(
        uint16_t connection_id, bool connected
    );
    int (*lgs_attribute_request_mtu)(
        uint16_t size
    );
    int (*lgs_attribute_request_write_execute)(
        bool proceed
    );
    int (*lgs_attribute_request_read)(
        uint16_t handle,
        uint16_t offset,
        uint8_t *datap,
        uint16_t *lengthp
    );
    int (*lgs_attribute_request_write)(
        uint16_t handle,
        uint16_t offset,
        uint8_t *datap,
        uint16_t length
    );
    int (*lgs_attribute_request_write_prepare)(
        uint16_t handle,
        uint16_t offset,
        uint8_t *datap,
        uint16_t length
    );
    int (*lgs_attribute_request_confirmation)(
        uint16_t handle
    );
};

