
#pragma once

/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright 2015-2025, Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the License Agreement).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi, xPico 200 Series,
** and xPort Edge products.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*****************************************************************************/
/*                             Includes                                      */
/*****************************************************************************/

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

/*****************************************************************************/
/*                              Enums                                        */
/*****************************************************************************/

enum ltrx_crypto_aes_cipher_mode
{
    LTRX_CRYPTO_AES_CIPHER_MODE__CBC,
    LTRX_CRYPTO_AES_CIPHER_MODE__CFB
};

/*****************************************************************************/
/*                             Structs                                       */
/*****************************************************************************/

struct ltrx_crypto_aes_context
{
    uint8_t key[32];
    size_t keyLengthInBits;
    enum ltrx_crypto_aes_cipher_mode cipherMode;
    bool encrypt;
};

struct ltrx_crypto_sha256_context
{
    uint32_t opaque[44];
    bool isInitialCall;
    bool is224;
};

/*****************************************************************************/
/*                            Prototypes                                     */
/*****************************************************************************/

void ltrx_hardware_crypto_aes(
    struct ltrx_crypto_aes_context *context,
    size_t length,
    uint8_t *iv,
    const uint8_t *in,
    uint8_t *out
);

void ltrx_crypto_sha2_digest_begin(
    struct ltrx_crypto_sha256_context *ctx,
    bool is224
);

void ltrx_crypto_sha2_digest_update(
    struct ltrx_crypto_sha256_context *ctx,
    const unsigned char *input,
    size_t length
);

void ltrx_crypto_sha2_digest_end(
    struct ltrx_crypto_sha256_context *ctx,
    const unsigned char *input,
    size_t length,
    unsigned char *hashOutput
);
