
/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright ©2015-2025, Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the “License Agreement”).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi, xPico 200 Series,
** and xPort® Edge products.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
** \addtogroup example
** @{
*/

/*!
** \defgroup ble_test_server ble_test_server
** @{
**
** The \b ble_test_server is primarily aimed at testing the various GATT client
** capabilities found in the ble_explorer example application. It offers three
** attributes:
**  - One with read and write properties
**  - One with read and write with not response properties
**  - One with read and notification and indication properties
**
** The \b ble_test_server is written specifically to serve the capabilities
** encapsulated in the \b ble_explorer module.
**
** \b Note: It is recommended that you enabled background scanning when
** using this demo application.
**
** Build it from project "bleTestServer"
*/

/****************************************************************************/
/*                                 Includes                                 */
/****************************************************************************/

#include "ble_test_server_module_defs.h"
#include "bts_gatt.h"
#include "ltrx_cfgvar.h"



const struct bluetooth_external_functions *g_bluetoothExternalFunctionEntry_pointer;

const struct ltrx_module_info *g_bluetoothModule;


/****************************************************************************/
/*                           Function Definitions                           */
/****************************************************************************/

void ble_test_server_module_registration(void)
{
    ltrx_module_register(&g_ble_test_serverModuleInfo);
}

void ble_test_server_module_startup(void)
{
    g_bluetoothExternalFunctionEntry_pointer = ltrx_module_functions_lookup(
        "bluetooth"
    );
    g_bluetoothModule = ltrx_module_lookup("bluetooth");
}

void ble_test_server_module_shutdown(void)
{
}

/*! @} End of Group. */
/*! @} End of Group. */
