
/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright ©2015-2019. Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the “License Agreement”).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi product.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#pragma once


/****************************************************************************/
/*                                 Includes                                 */
/****************************************************************************/

#include <stdint.h>


/****************************************************************************/
/*                                 Globals                                  */
/****************************************************************************/

extern const char * const g_bt_transport_desc[];

extern const char * const g_ble_addr_type_desc[];

extern const char * const g_ble_scan_event_desc[];

extern const char * const g_gatt_discovery_type_desc[];


/****************************************************************************/
/*                           Function Prototypes                            */
/****************************************************************************/

const char *str_ble_advert_type(uint8_t);

const char *str_scan_event(uint8_t);

uint8_t scan_event_code_from_string(const char *);

const char *str_ble_advert_flags(uint8_t);

const char *str_ble_uuid_service(uint16_t);

const char *str_ble_uuid_characteristic(uint16_t);

const char *str_ble_uuid_descriptor(uint16_t);

const char *str_ble_uuid_attribute(uint16_t);

const char *str_ble_uuid(uint16_t);

const char *str_ble_gatt_appearance(uint16_t);

const char *str_gatt_status(uint8_t);
