/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.settings.model.COutputEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.AbstractBuildRunner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.ExternalBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.InternalBuildRunner;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.HoldsOptions;
import org.eclipse.cdt.managedbuilder.internal.core.IMatchKeyProvider;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedConfigStorageElement;
import org.eclipse.cdt.managedbuilder.internal.core.MapStorageElement;
import org.eclipse.cdt.managedbuilder.internal.core.MatchKey;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildBuildData;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextBuildMacroValues;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IFileContextBuildMacroValues;
import org.eclipse.cdt.managedbuilder.macros.IReservedMacroNameSupplier;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.osgi.framework.Version;

public class Builder
extends HoldsOptions
implements IBuilder,
IMatchKeyProvider<Builder>,
IRealBuildObjectAssociation {
    public static final int UNLIMITED_JOBS = Integer.MAX_VALUE;
    private static final String EMPTY_STRING = "";
    private String superClassId;
    private IToolChain parent;
    private String unusedChildren;
    private String errorParserIds;
    private Boolean isAbstract;
    private String command;
    private String args;
    private IConfigurationElement buildFileGeneratorElement;
    private String versionsSupported;
    private String convertToId;
    private FileContextBuildMacroValues fileContextBuildMacroValues;
    private String builderVariablePattern;
    private Boolean isVariableCaseSensitive;
    private String[] reservedMacroNames;
    private IReservedMacroNameSupplier reservedMacroNameSupplier;
    private IConfigurationElement reservedMacroNameSupplierElement;
    private String autoBuildTarget;
    private Boolean autoBuildEnabled;
    private String incrementalBuildTarget;
    private Boolean incrementalBuildEnabled;
    private String cleanBuildTarget;
    private Boolean cleanBuildEnabled;
    private Boolean managedBuildOn;
    private Boolean keepEnvVarInBuildfile;
    private Boolean supportsManagedBuild;
    private String[] customizedErrorParserIds;
    private HashMap<String, String> customizedEnvironment;
    private Boolean appendEnvironment;
    private String buildPath;
    private HashMap<String, String> customBuildProperties;
    private String ignoreErrCmd;
    private Boolean stopOnErr;
    private String parallelBuildCmd;
    private Boolean isParallelBuildEnabled;
    private Integer parallelNumberAttribute;
    private boolean isTest;
    private boolean isExtensionBuilder = false;
    private boolean resolved = true;
    private IConfigurationElement previousMbsVersionConversionElement = null;
    private IConfigurationElement currentMbsVersionConversionElement = null;
    private BuildBuildData fBuildData;
    private Boolean fSupportsCustomizedBuild;
    private List<Builder> identicalList;
    private ICOutputEntry[] outputEntries;
    private ICommandLauncher fCommandLauncher = null;
    private IConfigurationElement fCommandLauncherElement = null;
    private AbstractBuildRunner fBuildRunner = null;
    private IConfigurationElement fBuildRunnerElement = null;

    public Builder(IToolChain parent, IManagedConfigElement element, String managedBuildRevision) {
        super(true);
        this.parent = parent;
        this.isExtensionBuilder = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionBuilder(this);
    }

    public Builder(ToolChain parent, IBuilder superClass, String Id, String name, boolean isExtensionElement) {
        super(true);
        this.parent = parent;
        this.superClass = superClass;
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionBuilder = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionBuilder(this);
        } else {
            this.fBuildData = new BuildBuildData(this);
            this.setDirty(true);
        }
    }

    public Builder(IToolChain parent, ICStorageElement element, String managedBuildRevision) {
        super(true);
        this.parent = parent;
        this.isExtensionBuilder = false;
        this.fBuildData = new BuildBuildData(this);
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
    }

    private HashMap<String, String> cloneMap(HashMap<String, String> map) {
        return (HashMap)map.clone();
    }

    public Builder(IToolChain parent, String Id, String name, Builder builder) {
        super(true);
        this.parent = parent;
        this.superClass = builder.superClass;
        if (this.superClass != null && builder.superClassId != null) {
            this.superClassId = new String(builder.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        this.setManagedBuildRevision(builder.getManagedBuildRevision());
        this.setVersion(this.getVersionFromId());
        this.isExtensionBuilder = false;
        if (builder.versionsSupported != null) {
            this.versionsSupported = new String(builder.versionsSupported);
        }
        if (builder.convertToId != null) {
            this.convertToId = new String(builder.convertToId);
        }
        if (builder.unusedChildren != null) {
            this.unusedChildren = new String(builder.unusedChildren);
        }
        if (builder.errorParserIds != null) {
            this.errorParserIds = new String(builder.errorParserIds);
        }
        if (builder.isAbstract != null) {
            this.isAbstract = new Boolean(builder.isAbstract);
        }
        if (builder.command != null) {
            this.command = new String(builder.command);
        }
        if (builder.args != null) {
            this.args = new String(builder.args);
        }
        this.autoBuildTarget = builder.autoBuildTarget;
        this.autoBuildEnabled = builder.autoBuildEnabled;
        this.incrementalBuildTarget = builder.incrementalBuildTarget;
        this.incrementalBuildEnabled = builder.incrementalBuildEnabled;
        this.cleanBuildTarget = builder.cleanBuildTarget;
        this.cleanBuildEnabled = builder.cleanBuildEnabled;
        this.managedBuildOn = builder.managedBuildOn;
        this.keepEnvVarInBuildfile = builder.keepEnvVarInBuildfile;
        this.supportsManagedBuild = builder.supportsManagedBuild;
        if (builder.customizedErrorParserIds != null) {
            this.customizedErrorParserIds = (String[])builder.customizedErrorParserIds.clone();
        }
        if (builder.customizedEnvironment != null) {
            this.customizedEnvironment = this.cloneMap(builder.customizedEnvironment);
        }
        this.appendEnvironment = builder.appendEnvironment;
        this.buildPath = builder.buildPath;
        if (builder.customBuildProperties != null) {
            this.customBuildProperties = this.cloneMap(builder.customBuildProperties);
        }
        this.buildFileGeneratorElement = builder.buildFileGeneratorElement;
        if (builder.fileContextBuildMacroValues != null) {
            this.fileContextBuildMacroValues = (FileContextBuildMacroValues)builder.fileContextBuildMacroValues.clone();
            this.fileContextBuildMacroValues.setBuilder(this);
        }
        this.builderVariablePattern = builder.builderVariablePattern;
        if (builder.isVariableCaseSensitive != null) {
            this.isVariableCaseSensitive = new Boolean(builder.isVariableCaseSensitive);
        }
        if (builder.reservedMacroNames != null) {
            this.reservedMacroNames = (String[])builder.reservedMacroNames.clone();
        }
        this.reservedMacroNameSupplierElement = builder.reservedMacroNameSupplierElement;
        this.reservedMacroNameSupplier = builder.reservedMacroNameSupplier;
        this.fBuildData = new BuildBuildData(this);
        this.stopOnErr = builder.stopOnErr;
        this.ignoreErrCmd = builder.ignoreErrCmd;
        this.isParallelBuildEnabled = builder.isParallelBuildEnabled;
        this.parallelNumberAttribute = builder.parallelNumberAttribute;
        this.parallelBuildCmd = builder.parallelBuildCmd;
        if (builder.outputEntries != null) {
            this.outputEntries = (ICOutputEntry[])builder.outputEntries.clone();
        }
        super.copyChildren(builder);
        this.fCommandLauncher = builder.fCommandLauncher;
        this.fCommandLauncherElement = builder.fCommandLauncherElement;
        this.fBuildRunner = builder.fBuildRunner;
        this.fBuildRunnerElement = builder.fBuildRunnerElement;
    }

    public void copySettings(Builder builder, boolean allBuildSettings) {
        try {
            if (this.isAutoBuildEnable() != builder.isAutoBuildEnable()) {
                this.setAutoBuildEnable(builder.isAutoBuildEnable());
            }
        }
        catch (CoreException coreException) {}
        try {
            if (this.isIncrementalBuildEnabled() != builder.isIncrementalBuildEnabled()) {
                this.setIncrementalBuildEnable(builder.isIncrementalBuildEnabled());
            }
        }
        catch (CoreException coreException) {}
        try {
            if (this.isFullBuildEnabled() != builder.isFullBuildEnabled()) {
                this.setFullBuildEnable(builder.isFullBuildEnabled());
            }
        }
        catch (CoreException coreException) {}
        try {
            if (this.isCleanBuildEnabled() != builder.isCleanBuildEnabled()) {
                this.setCleanBuildEnable(builder.isCleanBuildEnabled());
            }
        }
        catch (CoreException coreException) {}
        if (this.isStopOnError() != builder.isStopOnError() && this.supportsStopOnError(builder.isStopOnError())) {
            try {
                this.setStopOnError(builder.isStopOnError());
            }
            catch (CoreException coreException) {}
        }
        if (this.isParallelBuildOn() != builder.isParallelBuildOn() && this.supportsParallelBuild()) {
            try {
                this.setParallelBuildOn(builder.isParallelBuildOn());
            }
            catch (CoreException coreException) {}
        }
        if (this.getParallelizationNumAttribute() != builder.getParallelizationNumAttribute() && this.supportsParallelBuild()) {
            try {
                this.setParallelizationNum(builder.getParallelizationNumAttribute());
            }
            catch (CoreException coreException) {}
        }
        if (builder.keepEnvironmentVariablesInBuildfile() && this.canKeepEnvironmentVariablesInBuildfile()) {
            this.setKeepEnvironmentVariablesInBuildfile(builder.keepEnvironmentVariablesInBuildfile());
        }
        if (this.isManagedBuildOn() != builder.isManagedBuildOn() && this.supportsBuild(builder.isManagedBuildOn())) {
            try {
                this.setManagedBuildOn(builder.isManagedBuildOn());
            }
            catch (CoreException coreException) {}
        }
        if (builder.customizedErrorParserIds != null) {
            this.customizedErrorParserIds = (String[])builder.customizedErrorParserIds.clone();
        }
        if (builder.customizedEnvironment != null) {
            this.customizedEnvironment = this.cloneMap(builder.customizedEnvironment);
        }
        this.appendEnvironment = builder.appendEnvironment;
        if (this.isBuildPathEditable() && !this.getBuildPath().equals(builder.getBuildPath())) {
            this.setBuildPath(builder.getBuildPath());
        }
        if (builder.customBuildProperties != null) {
            this.customBuildProperties = this.cloneMap(builder.customBuildProperties);
        }
        if (allBuildSettings) {
            if (!this.getCommand().equals(builder.getCommand())) {
                this.setCommand(builder.getCommand());
            }
            if (!this.getArgumentsAttribute().equals(builder.getArgumentsAttribute())) {
                this.setArgumentsAttribute(builder.getArgumentsAttribute());
            }
            if (!CDataUtil.objectsEqual((Object)this.getAutoBuildTargetAttribute(), (Object)builder.getAutoBuildTargetAttribute())) {
                this.autoBuildTarget = builder.getAutoBuildTargetAttribute();
            }
            if (!CDataUtil.objectsEqual((Object)this.getIncrementalBuildTargetAttribute(), (Object)builder.getIncrementalBuildTargetAttribute())) {
                this.incrementalBuildTarget = builder.getIncrementalBuildTargetAttribute();
            }
            if (!CDataUtil.objectsEqual((Object)this.getCleanBuildTargetAttribute(), (Object)builder.getCleanBuildTargetAttribute())) {
                this.cleanBuildTarget = builder.getCleanBuildTargetAttribute();
            }
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String buildRunner;
        String isAbs;
        String reservedNames;
        ManagedBuildManager.putConfigElement(this, element);
        String idAttribute = SafeStringInterner.safeIntern((String)element.getAttribute("id"));
        this.setId(idAttribute);
        String nameAttribute = SafeStringInterner.safeIntern((String)element.getAttribute("name"));
        this.setName(nameAttribute);
        this.setVersion(this.getVersionFromId());
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        this.versionsSupported = SafeStringInterner.safeIntern((String)element.getAttribute("versionsSupported"));
        this.convertToId = SafeStringInterner.safeIntern((String)element.getAttribute("convertToId"));
        this.builderVariablePattern = SafeStringInterner.safeIntern((String)element.getAttribute("variableFormat"));
        String isCS = element.getAttribute("isVariableCaseSensitive");
        if (isCS != null) {
            this.isVariableCaseSensitive = new Boolean("true".equals(isCS));
        }
        if ((reservedNames = element.getAttribute("reservedMacroNames")) != null) {
            this.reservedMacroNames = reservedNames.split(",");
        }
        this.reservedMacroNames = SafeStringInterner.safeIntern((String[])this.reservedMacroNames);
        String reservedMacroNameSupplier = element.getAttribute("reservedMacroNameSupplier");
        if (reservedMacroNameSupplier != null && element instanceof DefaultManagedConfigElement) {
            this.reservedMacroNameSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.command = SafeStringInterner.safeIntern((String)element.getAttribute("command"));
        this.args = SafeStringInterner.safeIntern((String)element.getAttribute("arguments"));
        this.autoBuildTarget = SafeStringInterner.safeIntern((String)element.getAttribute("autoBuildTarget"));
        String tmp = element.getAttribute("enableAutoBuild");
        if (tmp != null) {
            this.autoBuildEnabled = Boolean.valueOf(tmp);
        }
        this.incrementalBuildTarget = SafeStringInterner.safeIntern((String)element.getAttribute("incrementalBuildTarget"));
        tmp = element.getAttribute("enableAutoBuild");
        if (tmp != null) {
            this.incrementalBuildEnabled = Boolean.valueOf(tmp);
        }
        this.cleanBuildTarget = SafeStringInterner.safeIntern((String)element.getAttribute("cleanBuildTarget"));
        tmp = element.getAttribute("enableCleanBuild");
        if (tmp != null) {
            this.cleanBuildEnabled = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("managedBuildOn")) != null) {
            this.managedBuildOn = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("keepEnvironmentInBuildfile")) != null) {
            this.keepEnvVarInBuildfile = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("supportsManagedBuild")) != null) {
            this.supportsManagedBuild = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("customizedErrorParsers")) != null) {
            this.customizedErrorParserIds = CDataUtil.stringToArray((String)tmp, (String)";");
        }
        this.customizedErrorParserIds = SafeStringInterner.safeIntern((String[])this.customizedErrorParserIds);
        tmp = element.getAttribute("environment");
        if (tmp != null) {
            this.customizedEnvironment = MapStorageElement.decodeMap(tmp);
        }
        if ((tmp = element.getAttribute("appendEnvironment")) != null) {
            this.appendEnvironment = Boolean.valueOf(tmp);
        }
        this.buildPath = element.getAttribute("buildPath");
        tmp = element.getAttribute("customBuilderProperties");
        if (tmp != null) {
            this.customBuildProperties = MapStorageElement.decodeMap(tmp);
        }
        this.ignoreErrCmd = SafeStringInterner.safeIntern((String)element.getAttribute("ignoreErrCmd"));
        tmp = element.getAttribute("stopOnErr");
        if (tmp != null) {
            this.stopOnErr = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("parallelBuildCmd")) != null) {
            this.parallelBuildCmd = SafeStringInterner.safeIntern((String)tmp);
        }
        if ((tmp = element.getAttribute("parallelBuildOn")) != null) {
            this.isParallelBuildEnabled = Boolean.valueOf(tmp);
            if (this.isParallelBuildEnabled.booleanValue()) {
                tmp = element.getAttribute("parallelizationNumber");
                this.setParallelizationNumAttribute(this.decodeParallelizationNumber(element.getAttribute("parallelizationNumber")));
            }
        }
        this.errorParserIds = SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers"));
        String buildfileGenerator = element.getAttribute("buildfileGenerator");
        if (buildfileGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.buildFileGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.fileContextBuildMacroValues = new FileContextBuildMacroValues(this, element);
        tmp = element.getAttribute("isSystem");
        if (tmp != null) {
            this.isTest = Boolean.valueOf(tmp);
        }
        IManagedConfigElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            String name;
            IManagedConfigElement child = children[i];
            if (!this.loadChild(child) && "outputEntries".equals(name = child.getName())) {
                ICSettingEntry[] entries = LanguageSettingEntriesSerializer.loadEntries((ICStorageElement)new ManagedConfigStorageElement(child));
                if (entries.length == 0) {
                    this.outputEntries = new ICOutputEntry[0];
                } else {
                    ArrayList<ICSettingEntry> list = new ArrayList<ICSettingEntry>(entries.length);
                    int k = 0;
                    while (k < entries.length) {
                        if (entries[k].getKind() == 64) {
                            list.add(entries[k]);
                        }
                        ++k;
                    }
                    this.outputEntries = list.toArray(new ICOutputEntry[list.size()]);
                }
            }
            ++i;
        }
        String commandLauncher = element.getAttribute("commandLauncher");
        if (commandLauncher != null && element instanceof DefaultManagedConfigElement) {
            this.fCommandLauncherElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((buildRunner = element.getAttribute("buildRunner")) != null && element instanceof DefaultManagedConfigElement) {
            this.fBuildRunnerElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    private String encodeParallelizationNumber(Integer jobsNumber) {
        if (jobsNumber <= 0) {
            return "optimal";
        }
        if (jobsNumber.equals(Integer.MAX_VALUE)) {
            return "unlimited";
        }
        return jobsNumber.toString();
    }

    private int decodeParallelizationNumber(String value) {
        int parallelNumber = -1;
        if ("optimal".equals(value)) {
            parallelNumber = -this.getOptimalParallelJobNum();
        } else if ("unlimited".equals(value)) {
            parallelNumber = Integer.MAX_VALUE;
        } else {
            try {
                parallelNumber = Integer.decode(value);
            }
            catch (NumberFormatException e) {
                ManagedBuilderCorePlugin.log(e);
                parallelNumber = this.getOptimalParallelJobNum();
            }
            if (parallelNumber <= 0) {
                parallelNumber = this.isInternalBuilder() ? -this.getOptimalParallelJobNum() : Integer.MAX_VALUE;
            }
        }
        return parallelNumber;
    }

    protected void loadFromProject(ICStorageElement element) {
        String tmp;
        String isAbs;
        if (element.getAttribute("id") != null) {
            this.setId(element.getAttribute("id"));
        }
        if (element.getAttribute("name") != null) {
            this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        }
        this.setVersion(this.getVersionFromId());
        if (element.getAttribute("superClass") != null) {
            this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionBuilder(this.superClassId);
                this.checkForMigrationSupport();
            }
        }
        if (element.getAttribute("versionsSupported") != null) {
            this.versionsSupported = SafeStringInterner.safeIntern((String)element.getAttribute("versionsSupported"));
        }
        if (element.getAttribute("convertToId") != null) {
            this.convertToId = SafeStringInterner.safeIntern((String)element.getAttribute("convertToId"));
        }
        if (element.getAttribute("unusedChildren") != null) {
            this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        }
        if (element.getAttribute("isAbstract") != null && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.getAttribute("command") != null) {
            this.command = SafeStringInterner.safeIntern((String)element.getAttribute("command"));
        }
        if (element.getAttribute("arguments") != null) {
            this.args = SafeStringInterner.safeIntern((String)element.getAttribute("arguments"));
        }
        if (element.getAttribute("autoBuildTarget") != null) {
            this.autoBuildTarget = SafeStringInterner.safeIntern((String)element.getAttribute("autoBuildTarget"));
        }
        if ((tmp = element.getAttribute("enableAutoBuild")) != null) {
            this.autoBuildEnabled = Boolean.valueOf(tmp);
        }
        if (element.getAttribute("incrementalBuildTarget") != null) {
            this.incrementalBuildTarget = SafeStringInterner.safeIntern((String)element.getAttribute("incrementalBuildTarget"));
        }
        if ((tmp = element.getAttribute("enabledIncrementalBuild")) != null) {
            this.incrementalBuildEnabled = Boolean.valueOf(tmp);
        }
        if (element.getAttribute("cleanBuildTarget") != null) {
            this.cleanBuildTarget = SafeStringInterner.safeIntern((String)element.getAttribute("cleanBuildTarget"));
        }
        if ((tmp = element.getAttribute("enableCleanBuild")) != null) {
            this.cleanBuildEnabled = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("managedBuildOn")) != null) {
            this.managedBuildOn = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("keepEnvironmentInBuildfile")) != null) {
            this.keepEnvVarInBuildfile = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("supportsManagedBuild")) != null) {
            this.supportsManagedBuild = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("customizedErrorParsers")) != null) {
            this.customizedErrorParserIds = CDataUtil.stringToArray((String)tmp, (String)";");
        }
        if ((tmp = element.getAttribute("environment")) != null) {
            this.customizedEnvironment = MapStorageElement.decodeMap(tmp);
        }
        if ((tmp = element.getAttribute("appendEnvironment")) != null) {
            this.appendEnvironment = Boolean.valueOf(tmp);
        }
        if (element.getAttribute("buildPath") != null) {
            this.buildPath = SafeStringInterner.safeIntern((String)element.getAttribute("buildPath"));
        }
        if ((tmp = element.getAttribute("customBuilderProperties")) != null) {
            this.customBuildProperties = MapStorageElement.decodeMap(tmp);
        }
        if (element.getAttribute("errorParsers") != null) {
            this.errorParserIds = SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers"));
        }
        element.getAttribute("buildfileGenerator");
        if (element.getAttribute("ignoreErrCmd") != null) {
            this.ignoreErrCmd = SafeStringInterner.safeIntern((String)element.getAttribute("ignoreErrCmd"));
        }
        if ((tmp = element.getAttribute("stopOnErr")) != null) {
            this.stopOnErr = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("parallelBuildCmd")) != null) {
            this.parallelBuildCmd = SafeStringInterner.safeIntern((String)tmp);
        }
        if ((tmp = element.getAttribute("parallelBuildOn")) != null) {
            this.isParallelBuildEnabled = Boolean.valueOf(tmp);
            if (this.isParallelBuildEnabled.booleanValue()) {
                tmp = element.getAttribute("parallelizationNumber");
                this.setParallelizationNumAttribute(this.decodeParallelizationNumber(element.getAttribute("parallelizationNumber")));
            }
        }
        ICStorageElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            String name;
            ICStorageElement child = children[i];
            if (!this.loadChild(child) && "outputEntries".equals(name = child.getName())) {
                ICSettingEntry[] entries = LanguageSettingEntriesSerializer.loadEntries((ICStorageElement)child);
                if (entries.length == 0) {
                    this.outputEntries = new ICOutputEntry[0];
                } else {
                    ArrayList<ICSettingEntry> list = new ArrayList<ICSettingEntry>(entries.length);
                    int k = 0;
                    while (k < entries.length) {
                        if (entries[k].getKind() == 64) {
                            list.add(entries[k]);
                        }
                        ++k;
                    }
                    this.outputEntries = list.toArray(new ICOutputEntry[list.size()]);
                }
            }
            ++i;
        }
    }

    @Override
    public void serialize(ICStorageElement element) {
        this.serialize(element, true);
    }

    public void serialize(ICStorageElement element, boolean resetDirtyState) {
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.versionsSupported != null) {
            element.setAttribute("versionsSupported", this.versionsSupported);
        }
        if (this.convertToId != null) {
            element.setAttribute("convertToId", this.convertToId);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        if (this.command != null) {
            element.setAttribute("command", this.command);
        }
        if (this.args != null) {
            element.setAttribute("arguments", this.args);
        }
        if (this.autoBuildTarget != null) {
            element.setAttribute("autoBuildTarget", this.autoBuildTarget);
        }
        if (this.autoBuildEnabled != null) {
            element.setAttribute("enableAutoBuild", this.autoBuildEnabled.toString());
        }
        if (this.incrementalBuildTarget != null) {
            element.setAttribute("incrementalBuildTarget", this.incrementalBuildTarget);
        }
        if (this.incrementalBuildEnabled != null) {
            element.setAttribute("enabledIncrementalBuild", this.incrementalBuildEnabled.toString());
        }
        if (this.cleanBuildTarget != null) {
            element.setAttribute("cleanBuildTarget", this.cleanBuildTarget);
        }
        if (this.cleanBuildEnabled != null) {
            element.setAttribute("enableCleanBuild", this.cleanBuildEnabled.toString());
        }
        if (this.managedBuildOn != null) {
            element.setAttribute("managedBuildOn", this.managedBuildOn.toString());
        }
        if (this.keepEnvVarInBuildfile != null) {
            element.setAttribute("keepEnvironmentInBuildfile", this.keepEnvVarInBuildfile.toString());
        }
        if (this.supportsManagedBuild != null) {
            element.setAttribute("supportsManagedBuild", this.supportsManagedBuild.toString());
        }
        if (this.customizedErrorParserIds != null) {
            element.setAttribute("customizedErrorParsers", CDataUtil.arrayToString((String[])this.customizedErrorParserIds, (String)";"));
        }
        if (this.customizedEnvironment != null) {
            element.setAttribute("environment", MapStorageElement.encodeMap(this.customizedEnvironment));
        }
        if (this.appendEnvironment != null) {
            element.setAttribute("appendEnvironment", this.appendEnvironment.toString());
        }
        if (this.buildPath != null) {
            element.setAttribute("buildPath", this.buildPath);
        }
        if (this.customBuildProperties != null) {
            element.setAttribute("customBuilderProperties", MapStorageElement.encodeMap(this.customBuildProperties));
        }
        if (this.ignoreErrCmd != null) {
            element.setAttribute("ignoreErrCmd", this.ignoreErrCmd);
        }
        if (this.stopOnErr != null) {
            element.setAttribute("stopOnErr", this.stopOnErr.toString());
        }
        if (this.parallelBuildCmd != null) {
            element.setAttribute("parallelBuildCmd", this.parallelBuildCmd);
        }
        if (this.isParallelBuildEnabled != null) {
            element.setAttribute("parallelBuildOn", this.isParallelBuildEnabled.toString());
        }
        if (this.isParallelBuildOn() && this.parallelNumberAttribute != null) {
            element.setAttribute("parallelizationNumber", this.encodeParallelizationNumber(this.parallelNumberAttribute));
        }
        try {
            super.serialize(element);
        }
        catch (BuildException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        if (this.outputEntries != null) {
            ICStorageElement outEl = element.createChild("outputEntries");
            LanguageSettingEntriesSerializer.serializeEntries((ICSettingEntry[])this.outputEntries, (ICStorageElement)outEl);
        }
        if (resetDirtyState) {
            this.setDirty(false);
        }
    }

    public void serializeRawData(ICStorageElement element) {
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.getName() != null) {
            element.setAttribute("name", this.getName());
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.versionsSupported != null) {
            element.setAttribute("versionsSupported", this.versionsSupported);
        }
        if (this.convertToId != null) {
            element.setAttribute("convertToId", this.convertToId);
        }
        if (this.getErrorParserIds() != null) {
            element.setAttribute("errorParsers", this.getErrorParserIds());
        }
        if (this.getCommand() != null) {
            element.setAttribute("command", this.getCommand());
        }
        if (this.getArgumentsAttribute() != null) {
            element.setAttribute("arguments", this.getArguments());
        }
        if (this.getAutoBuildTargetAttribute() != null) {
            element.setAttribute("autoBuildTarget", this.getAutoBuildTargetAttribute());
        }
        element.setAttribute("enableAutoBuild", Boolean.valueOf(this.isAutoBuildEnable()).toString());
        if (this.getIncrementalBuildTargetAttribute() != null) {
            element.setAttribute("incrementalBuildTarget", this.getIncrementalBuildTargetAttribute());
        }
        element.setAttribute("enabledIncrementalBuild", Boolean.valueOf(this.isIncrementalBuildEnabled()).toString());
        if (this.getCleanBuildTargetAttribute() != null) {
            element.setAttribute("cleanBuildTarget", this.getCleanBuildTargetAttribute());
        }
        element.setAttribute("enableCleanBuild", Boolean.valueOf(this.isCleanBuildEnabled()).toString());
        element.setAttribute("managedBuildOn", Boolean.valueOf(this.isManagedBuildOn()).toString());
        element.setAttribute("keepEnvironmentInBuildfile", Boolean.valueOf(this.keepEnvironmentVariablesInBuildfile()).toString());
        element.setAttribute("supportsManagedBuild", Boolean.valueOf(this.supportsBuild(true)).toString());
        if (this.customizedErrorParserIds != null) {
            element.setAttribute("customizedErrorParsers", CDataUtil.arrayToString((String[])this.customizedErrorParserIds, (String)";"));
        }
        if (this.customizedEnvironment != null) {
            element.setAttribute("environment", MapStorageElement.encodeMap(this.customizedEnvironment));
        }
        element.setAttribute("appendEnvironment", Boolean.valueOf(this.appendEnvironment()).toString());
        if (this.getBuildPathAttribute() != null) {
            element.setAttribute("buildPath", this.getBuildPathAttribute());
        }
        if (this.customBuildProperties != null) {
            element.setAttribute("customBuilderProperties", MapStorageElement.encodeMap(this.customBuildProperties));
        }
        if (this.getIgnoreErrCmdAttribute() != null) {
            element.setAttribute("ignoreErrCmd", this.getIgnoreErrCmdAttribute());
        }
        element.setAttribute("stopOnErr", Boolean.valueOf(this.isStopOnError()).toString());
        if (this.parallelBuildCmd != null) {
            element.setAttribute("parallelBuildCmd", this.parallelBuildCmd);
        }
        if (this.isParallelBuildEnabled != null) {
            element.setAttribute("parallelBuildOn", this.isParallelBuildEnabled.toString());
        }
        if (this.isParallelBuildOn() && this.parallelNumberAttribute != null) {
            element.setAttribute("parallelizationNumber", this.encodeParallelizationNumber(this.parallelNumberAttribute));
        }
        try {
            super.serialize(element);
        }
        catch (BuildException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        if (this.outputEntries != null) {
            ICStorageElement outEl = element.createChild("outputEntries");
            LanguageSettingEntriesSerializer.serializeEntries((ICSettingEntry[])this.outputEntries, (ICStorageElement)outEl);
        }
    }

    @Override
    public IToolChain getParent() {
        return this.parent;
    }

    @Override
    public IBuilder getSuperClass() {
        return (IBuilder)this.superClass;
    }

    @Override
    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    @Override
    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    @Override
    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    @Override
    public String getCommand() {
        if (this.command == null) {
            if (this.superClass != null) {
                return this.getSuperClass().getCommand();
            }
            return "make";
        }
        return this.command;
    }

    @Override
    public String getArguments() {
        String args = this.getArgumentsAttribute();
        String stopOnErrCmd = this.getStopOnErrCmd(this.isStopOnError());
        int parallelNum = this.getParallelizationNum();
        String parallelCmd = this.isParallelBuildOn() ? this.getParallelizationCmd(parallelNum) : EMPTY_STRING;
        String reversedStopOnErrCmd = this.getStopOnErrCmd(!this.isStopOnError());
        String reversedParallelBuildCmd = !this.isParallelBuildOn() ? this.getParallelizationCmd(parallelNum) : EMPTY_STRING;
        args = this.removeCmd(args, reversedStopOnErrCmd);
        args = this.removeCmd(args, reversedParallelBuildCmd);
        args = this.addCmd(args, stopOnErrCmd);
        args = this.addCmd(args, parallelCmd);
        return args != null ? args.trim() : null;
    }

    private String addCmd(String args, String cmd) {
        if (cmd.length() == 0) {
            return args;
        }
        if (this.getCmdIndex(args, cmd) == -1) {
            if (args.length() != 0) {
                args = String.valueOf(args) + ' ';
            }
            args = String.valueOf(args) + cmd;
        }
        return args;
    }

    private String removeCmd(String args, String cmd) {
        int index = this.getCmdIndex(args, cmd);
        if (index != -1) {
            String prefix = args.substring(0, index).trim();
            String suffix = args.substring(index + cmd.length(), args.length()).trim();
            args = prefix.length() == 0 ? suffix : (suffix.length() == 0 ? prefix : String.valueOf(prefix) + ' ' + suffix);
            args = args.trim();
        }
        return args;
    }

    private int getCmdIndex(String args, String cmd) {
        if (cmd.length() == 0) {
            return -1;
        }
        String tmp = args;
        int index = -1;
        index = tmp.indexOf(cmd);
        while (index != -1) {
            char c;
            int end;
            char c2;
            if ((index == 0 || (c2 = tmp.charAt(index - 1)) == '\t' || c2 == ' ') && ((end = index + cmd.length()) >= tmp.length() || (c = tmp.charAt(end)) == '\t' || c == ' ')) break;
            index = tmp.indexOf(cmd, index + 1);
        }
        return index;
    }

    public String getParallelizationCmd(int num) {
        String pattern = this.getParrallelBuildCmd();
        if (pattern.length() == 0 || num == 0) {
            return EMPTY_STRING;
        }
        return this.processParallelPattern(pattern, num == Integer.MAX_VALUE, num);
    }

    private String processParallelPattern(String pattern, boolean empty, int num) {
        String result;
        Assert.isTrue((num > 0 ? 1 : 0) != 0);
        int start = pattern.indexOf("[");
        int end = -1;
        boolean hasStartChar = false;
        if (start != -1) {
            end = pattern.indexOf("]");
            if (end != -1) {
                hasStartChar = true;
            } else {
                start = -1;
            }
        }
        if (start == -1 && (start = pattern.indexOf("*")) != -1) {
            end = start + "*".length();
        }
        if (start == -1) {
            result = pattern;
        } else {
            String prefix = pattern.substring(0, start);
            String suffix = pattern.substring(end);
            String numStr = pattern.substring(start, end);
            if (empty) {
                result = String.valueOf(prefix) + suffix;
            } else {
                String resolvedNum;
                if (hasStartChar) {
                    numStr = numStr.substring(0, "[".length());
                    numStr = numStr.substring(numStr.length() - "]".length());
                    int numStart = pattern.indexOf("*");
                    if (numStart != -1) {
                        int numEnd = numStart + "*".length();
                        String numPrefix = numStr.substring(0, numStart);
                        String numSuffix = numStr.substring(numEnd);
                        resolvedNum = String.valueOf(numPrefix) + new Integer(num).toString() + numSuffix;
                    } else {
                        resolvedNum = EMPTY_STRING;
                    }
                } else {
                    resolvedNum = new Integer(num).toString();
                }
                result = String.valueOf(prefix) + resolvedNum + suffix;
            }
        }
        return result;
    }

    public String getArgumentsAttribute() {
        if (this.args == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getArgumentsAttribute();
            }
            return EMPTY_STRING;
        }
        return this.args;
    }

    @Override
    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.superClass != null) {
            ids = this.getSuperClass().getErrorParserIds();
        }
        return ids;
    }

    @Override
    public String[] getErrorParserList() {
        String parserIDs = this.getErrorParserIds();
        String[] errorParsers = null;
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{EMPTY_STRING};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    @Override
    public void setCommand(String cmd) {
        if (this.getCommand().equals(cmd)) {
            return;
        }
        if (cmd == null && this.command == null) {
            return;
        }
        if (this.command == null || cmd == null || !cmd.equals(this.command)) {
            this.command = cmd;
            this.setDirty(true);
        }
    }

    @Override
    public void setArguments(String newArgs) {
        if (this.getArguments().equals(newArgs)) {
            return;
        }
        if (newArgs != null) {
            String stopOnErrCmd = this.getStopOnErrCmd(this.isStopOnError());
            String parallelCmd = this.isParallelBuildOn() ? this.getParallelizationCmd(this.getParallelizationNum()) : EMPTY_STRING;
            newArgs = this.removeCmd(newArgs, stopOnErrCmd);
            newArgs = this.removeCmd(newArgs, parallelCmd);
        }
        this.setArgumentsAttribute(newArgs);
    }

    public void setArgumentsAttribute(String newArgs) {
        if (newArgs == null && this.args == null) {
            return;
        }
        if (this.args == null || newArgs == null || !newArgs.equals(this.args)) {
            this.args = newArgs;
            this.setDirty(true);
        }
    }

    @Override
    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.setDirty(true);
        }
    }

    @Override
    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    @Override
    public IConfigurationElement getBuildFileGeneratorElement() {
        if (this.buildFileGeneratorElement == null && this.superClass != null) {
            return ((Builder)this.superClass).getBuildFileGeneratorElement();
        }
        return this.buildFileGeneratorElement;
    }

    @Override
    public IManagedBuilderMakefileGenerator getBuildFileGenerator() {
        IConfigurationElement element = this.getBuildFileGeneratorElement();
        if (element != null) {
            try {
                if (element.getName().equalsIgnoreCase("target")) {
                    if (element.getAttribute("makefileGenerator") != null) {
                        return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("makefileGenerator");
                    }
                } else if (element.getAttribute("buildfileGenerator") != null) {
                    return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("buildfileGenerator");
                }
            }
            catch (CoreException coreException) {
            }
            catch (ClassCastException classCastException) {}
        }
        return new GnuMakefileGenerator();
    }

    @Override
    public void setBuildFileGeneratorElement(IConfigurationElement element) {
        this.buildFileGeneratorElement = element;
        this.setDirty(true);
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionBuilder;
    }

    @Override
    public boolean isDirty() {
        if (this.isExtensionBuilder) {
            return false;
        }
        return super.isDirty();
    }

    @Override
    public void setDirty(boolean isDirty) {
        super.setDirty(isDirty);
    }

    @Override
    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionBuilder(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "builder", this.getId());
                }
            }
        }
    }

    @Override
    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.superClass != null) {
                return this.getSuperClass().getConvertToId();
            }
            return EMPTY_STRING;
        }
        return this.convertToId;
    }

    @Override
    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
            this.setDirty(true);
        }
    }

    @Override
    public String getVersionsSupported() {
        if (this.versionsSupported == null) {
            if (this.superClass != null) {
                return this.getSuperClass().getVersionsSupported();
            }
            return EMPTY_STRING;
        }
        return this.versionsSupported;
    }

    @Override
    public void setVersionsSupported(String versionsSupported) {
        if (versionsSupported == null && this.versionsSupported == null) {
            return;
        }
        if (versionsSupported == null || this.versionsSupported == null || !versionsSupported.equals(this.versionsSupported)) {
            this.versionsSupported = versionsSupported;
            this.setDirty(true);
        }
    }

    @Override
    public IFileContextBuildMacroValues getFileContextBuildMacroValues() {
        if (this.fileContextBuildMacroValues == null && this.superClass != null) {
            return this.getSuperClass().getFileContextBuildMacroValues();
        }
        return this.fileContextBuildMacroValues;
    }

    @Override
    public String getBuilderVariablePattern() {
        if (this.builderVariablePattern == null && this.superClass != null) {
            return this.getSuperClass().getBuilderVariablePattern();
        }
        return this.builderVariablePattern;
    }

    @Override
    public boolean isVariableCaseSensitive() {
        if (this.isVariableCaseSensitive == null) {
            if (this.superClass != null) {
                return this.getSuperClass().isVariableCaseSensitive();
            }
            return true;
        }
        return this.isVariableCaseSensitive;
    }

    @Override
    public String[] getReservedMacroNames() {
        if (this.reservedMacroNames == null && this.superClass != null) {
            return this.getSuperClass().getReservedMacroNames();
        }
        return this.reservedMacroNames;
    }

    @Override
    public IReservedMacroNameSupplier getReservedMacroNameSupplier() {
        if (this.reservedMacroNameSupplier == null && this.reservedMacroNameSupplierElement != null) {
            try {
                this.reservedMacroNameSupplier = (IReservedMacroNameSupplier)this.reservedMacroNameSupplierElement.createExecutableExtension("reservedMacroNameSupplier");
            }
            catch (CoreException coreException) {}
        }
        if (this.reservedMacroNameSupplier == null && this.superClass != null) {
            return this.getSuperClass().getReservedMacroNameSupplier();
        }
        return this.reservedMacroNameSupplier;
    }

    public void checkForMigrationSupport() {
        boolean isExists = false;
        if (this.getSuperClass() == null) {
            String high = ManagedBuildManager.getExtensionBuilderMap().lastKey();
            SortedMap<String, ? extends IBuilder> subMap = null;
            if (this.superClassId.compareTo(high) > 0) {
                IToolChain parent = this.getParent();
                IConfiguration parentConfig = parent.getParent();
                IManagedProject managedProject = parentConfig.getManagedProject();
                if (managedProject != null) {
                    managedProject.setValid(false);
                }
                return;
            }
            subMap = ManagedBuildManager.getExtensionBuilderMap().subMap(this.superClassId, String.valueOf(high) + "\u0000");
            String baseId = ManagedBuildManager.getIdFromIdAndVersion(this.superClassId);
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.superClassId);
            Collection<? extends IBuilder> c = subMap.values();
            IBuilder[] builderElements = c.toArray(new IBuilder[c.size()]);
            int i = 0;
            while (i < builderElements.length) {
                String versionsSupported;
                IBuilder builderElement = builderElements[i];
                if (ManagedBuildManager.getIdFromIdAndVersion(builderElement.getId()).compareTo(baseId) > 0) break;
                if (ManagedBuildManager.getIdFromIdAndVersion(builderElement.getId()).equals(baseId) && (versionsSupported = builderElement.getVersionsSupported()) != null && !versionsSupported.equals(EMPTY_STRING)) {
                    String[] tmpVersions = versionsSupported.split(",");
                    int j = 0;
                    while (j < tmpVersions.length) {
                        if (new Version(version).equals((Object)new Version(tmpVersions[j]))) {
                            String supportedVersion = ManagedBuildManager.getVersionFromIdAndVersion(builderElement.getId());
                            this.setId(String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(this.getId())) + "_" + supportedVersion);
                            this.superClass = builderElement;
                            this.superClassId = this.superClass.getId();
                            isExists = true;
                            break;
                        }
                        ++j;
                    }
                    if (isExists) break;
                }
                ++i;
            }
        }
        if (this.getSuperClass() != null) {
            String convertToId = this.getSuperClass().getConvertToId();
            if (convertToId == null || convertToId.equals(EMPTY_STRING)) {
                return;
            }
            this.getConverter(convertToId);
        } else {
            IToolChain parent = this.getParent();
            IConfiguration parentConfig = parent.getParent();
            IManagedProject managedProject = parentConfig.getManagedProject();
            if (managedProject != null) {
                managedProject.setValid(false);
            }
        }
    }

    private void getConverter(String convertToId) {
        IToolChain parent;
        IConfiguration parentConfig;
        IManagedProject managedProject;
        String fromId = null;
        String toId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        toId = element.getAttribute("toId");
                        if (fromId.equals(this.getSuperClass().getId()) && toId.equals(convertToId)) {
                            String mbsVersion = element.getAttribute("mbsVersion");
                            Version currentMbsVersion = ManagedBuildManager.getBuildInfoVersion();
                            if (currentMbsVersion.compareTo(new Version(mbsVersion)) > 0) {
                                this.previousMbsVersionConversionElement = element;
                            } else {
                                this.currentMbsVersionConversionElement = element;
                            }
                            return;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((managedProject = (parentConfig = (parent = this.getParent()).getParent()).getManagedProject()) != null) {
            managedProject.setValid(false);
        }
    }

    public IConfigurationElement getPreviousMbsVersionConversionElement() {
        return this.previousMbsVersionConversionElement;
    }

    public IConfigurationElement getCurrentMbsVersionConversionElement() {
        return this.currentMbsVersionConversionElement;
    }

    @Override
    public CBuildData getBuildData() {
        return this.fBuildData;
    }

    @Override
    public String[] getErrorParsers() {
        if (this.isCustomBuilder() && this.customizedErrorParserIds != null) {
            return (String[])this.customizedErrorParserIds.clone();
        }
        IToolChain parent = this.getParent();
        IConfiguration parentConfig = parent.getParent();
        return parentConfig.getErrorParserList();
    }

    public String[] getCustomizedErrorParserIds() {
        if (this.customizedErrorParserIds != null) {
            return (String[])this.customizedErrorParserIds.clone();
        }
        return null;
    }

    public void setCustomizedErrorParserIds(String[] ids) {
        this.customizedErrorParserIds = ids != null ? (String[])ids.clone() : ids;
    }

    @Override
    public void setErrorParsers(String[] parsers) throws CoreException {
        if (this.isCustomBuilder()) {
            this.customizedErrorParserIds = parsers != null && parsers.length != 0 ? (String[])parsers.clone() : parsers;
        } else {
            IToolChain parent = this.getParent();
            IConfiguration parentConfig = parent.getParent();
            parentConfig.setErrorParserList(parsers);
        }
    }

    private Object getMacroContextData() {
        return this;
    }

    @Override
    public String getBuildArguments() {
        String args = this.getArguments();
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        try {
            args = provider.resolveValue(args, EMPTY_STRING, " ", 3, this.getMacroContextData());
        }
        catch (BuildMacroException buildMacroException) {}
        return args;
    }

    @Override
    public IPath getBuildCommand() {
        String command = this.getCommand();
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        try {
            command = provider.resolveValue(command, EMPTY_STRING, " ", 3, this.getMacroContextData());
        }
        catch (BuildMacroException buildMacroException) {}
        return new Path(command);
    }

    public String getBuildPathAttribute() {
        return this.getBuildPathAttribute(true);
    }

    public String getBuildPathAttribute(boolean querySuperClass) {
        if (this.buildPath == null && querySuperClass && this.superClass != null) {
            return ((Builder)this.superClass).getBuildPathAttribute(true);
        }
        return this.buildPath;
    }

    @Override
    public void setBuildPath(String path) {
        this.setBuildPathAttribute(path);
    }

    public void setBuildPathAttribute(String path) {
        this.buildPath = path;
        this.setDirty(true);
    }

    @Override
    public String getBuildPath() {
        if (this.isManagedBuildOn()) {
            return this.getDefaultBuildPath();
        }
        String path = this.getBuildPathAttribute();
        if (path == null) {
            path = this.getDefaultBuildPath();
        }
        return path;
    }

    private boolean isBuildPathEditable() {
        return !this.isManagedBuildOn();
    }

    public String getDefaultBuildPath() {
        String result;
        Configuration cfg = (Configuration)this.getConfguration();
        if (cfg != null) {
            if (!this.isExtensionElement() && !cfg.isPreference()) {
                Path buildPath;
                IProject project = cfg.getOwner().getProject();
                if (this.isManagedBuildOn()) {
                    IManagedBuilderMakefileGenerator gen = this.getBuildFileGenerator();
                    if (gen instanceof IManagedBuilderMakefileGenerator2) {
                        ((IManagedBuilderMakefileGenerator2)gen).initialize(6, cfg, this, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        gen.initialize(project, ManagedBuildManager.getBuildInfo((IResource)project), (IProgressMonitor)new NullProgressMonitor());
                    }
                    buildPath = gen.getBuildWorkingDir();
                    if (buildPath == null) {
                        buildPath = new Path(cfg.getName());
                    }
                } else {
                    buildPath = Path.EMPTY;
                }
                if (!buildPath.isAbsolute()) {
                    buildPath = project.getFullPath().append((IPath)buildPath);
                    IStringVariableManager mngr = VariablesPlugin.getDefault().getStringVariableManager();
                    result = buildPath.toString();
                    result = mngr.generateVariableExpression("workspace_loc", result);
                } else {
                    result = buildPath.toString();
                }
            } else if (this.isManagedBuildOn()) {
                result = cfg.getName();
                if (result == null) {
                    result = EMPTY_STRING;
                }
            } else {
                result = EMPTY_STRING;
            }
        } else {
            result = EMPTY_STRING;
        }
        return result;
    }

    @Override
    public IPath getBuildLocation() {
        String path = this.getBuildPath();
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        try {
            path = provider.resolveValue(path, EMPTY_STRING, " ", 3, this.getMacroContextData());
        }
        catch (BuildMacroException buildMacroException) {}
        return new Path(path);
    }

    @Override
    public boolean isDefaultBuildCmd() {
        return this.isExtensionBuilder || this.command == null && this.args == null && this.superClass != null;
    }

    @Override
    public boolean isStopOnError() {
        if (this.stopOnErr == null) {
            if (this.superClass != null) {
                return this.getSuperClass().isStopOnError();
            }
            return true;
        }
        return this.stopOnErr;
    }

    @Override
    public void setBuildArguments(String args) throws CoreException {
        this.setArguments(args);
    }

    @Override
    public void setBuildCommand(IPath command) throws CoreException {
        String cmd = command != null ? command.toString() : null;
        this.setCommand(cmd);
    }

    @Override
    public void setBuildLocation(IPath location) throws CoreException {
        String path = location != null ? location.toString() : null;
        this.setBuildPath(path);
    }

    @Override
    public void setStopOnError(boolean on) throws CoreException {
        if (this.isStopOnError() == on) {
            return;
        }
        if (this.supportsStopOnError(on)) {
            String curCmd = this.getStopOnErrCmd(this.isStopOnError());
            String args = this.getArgumentsAttribute();
            String updatedArgs = this.removeCmd(args, curCmd);
            if (!updatedArgs.equals(args)) {
                this.setArgumentsAttribute(updatedArgs);
            }
            this.stopOnErr = on;
        }
        this.setDirty(true);
    }

    @Override
    public void setUseDefaultBuildCmd(boolean on) throws CoreException {
        if (!this.isExtensionBuilder && this.superClass != null) {
            if (on) {
                this.command = null;
                this.args = null;
            } else {
                this.command = this.getCommand();
            }
        }
    }

    public String getAutoBuildTargetAttribute() {
        if (this.autoBuildTarget == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getAutoBuildTargetAttribute();
            }
            return null;
        }
        return this.autoBuildTarget;
    }

    @Override
    public String getAutoBuildTarget() {
        String attr = this.getAutoBuildTargetAttribute();
        if (attr != null) {
            IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
            try {
                attr = provider.resolveValue(attr, EMPTY_STRING, " ", 3, this.getMacroContextData());
            }
            catch (BuildMacroException buildMacroException) {}
        }
        if (attr == null) {
            attr = "all";
        }
        return attr;
    }

    public String getCleanBuildTargetAttribute() {
        if (this.cleanBuildTarget == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getCleanBuildTargetAttribute();
            }
            return null;
        }
        return this.cleanBuildTarget;
    }

    @Override
    public String getCleanBuildTarget() {
        String attr = this.getCleanBuildTargetAttribute();
        if (attr != null) {
            IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
            try {
                attr = provider.resolveValue(attr, EMPTY_STRING, " ", 3, this.getMacroContextData());
            }
            catch (BuildMacroException buildMacroException) {}
        }
        if (attr == null) {
            attr = "clean";
        }
        return attr;
    }

    @Override
    public String getFullBuildTarget() {
        return this.getIncrementalBuildTarget();
    }

    public String getIncrementalBuildTargetAttribute() {
        if (this.incrementalBuildTarget == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getIncrementalBuildTargetAttribute();
            }
            return null;
        }
        return this.incrementalBuildTarget;
    }

    @Override
    public String getIncrementalBuildTarget() {
        String attr = this.getIncrementalBuildTargetAttribute();
        if (attr != null) {
            IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
            try {
                attr = provider.resolveValue(attr, EMPTY_STRING, " ", 3, this.getMacroContextData());
            }
            catch (BuildMacroException buildMacroException) {}
        }
        if (attr == null) {
            attr = "all";
        }
        return attr;
    }

    @Override
    public boolean isAutoBuildEnable() {
        if (this.autoBuildEnabled == null) {
            if (this.superClass != null) {
                return this.getSuperClass().isAutoBuildEnable();
            }
            return false;
        }
        return this.autoBuildEnabled;
    }

    @Override
    public boolean isCleanBuildEnabled() {
        if (this.cleanBuildEnabled == null) {
            if (this.superClass != null) {
                return this.getSuperClass().isCleanBuildEnabled();
            }
            return true;
        }
        return this.cleanBuildEnabled;
    }

    @Override
    public boolean isFullBuildEnabled() {
        return this.isIncrementalBuildEnabled();
    }

    @Override
    public boolean isIncrementalBuildEnabled() {
        if (this.incrementalBuildEnabled == null) {
            if (this.superClass != null) {
                return this.getSuperClass().isIncrementalBuildEnabled();
            }
            return true;
        }
        return this.incrementalBuildEnabled;
    }

    @Override
    public void setAutoBuildEnable(boolean enabled) throws CoreException {
        this.autoBuildEnabled = enabled;
    }

    @Override
    public void setAutoBuildTarget(String target) throws CoreException {
        this.autoBuildTarget = target;
    }

    @Override
    public void setCleanBuildEnable(boolean enabled) throws CoreException {
        this.cleanBuildEnabled = enabled;
    }

    @Override
    public void setCleanBuildTarget(String target) throws CoreException {
        this.cleanBuildTarget = target;
    }

    @Override
    public void setFullBuildEnable(boolean enabled) throws CoreException {
        this.setIncrementalBuildEnable(enabled);
    }

    @Override
    public void setFullBuildTarget(String target) throws CoreException {
        this.setIncrementalBuildTarget(target);
    }

    @Override
    public void setIncrementalBuildEnable(boolean enabled) throws CoreException {
        this.incrementalBuildEnabled = enabled;
    }

    @Override
    public void setIncrementalBuildTarget(String target) throws CoreException {
        this.incrementalBuildTarget = target;
    }

    @Override
    public boolean appendEnvironment() {
        if (this.appendEnvironment == null) {
            if (this.superClass != null) {
                return this.getSuperClass().appendEnvironment();
            }
            return true;
        }
        return this.appendEnvironment;
    }

    @Override
    public String getBuildAttribute(String name, String defaultValue) {
        String result = null;
        if ("org.eclipse.cdt.make.core.build.target.inc".equals(name)) {
            result = this.getIncrementalBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.build.target.auto".equals(name)) {
            result = this.getAutoBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.build.target.clean".equals(name)) {
            result = this.getCleanBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.build.location".equals(name)) {
            result = this.getBuildPathAttribute();
        } else if ("org.eclipse.cdt.make.core.build.command".equals(name)) {
            result = this.getCommand();
        } else if ("org.eclipse.cdt.make.core.build.arguments".equals(name)) {
            result = this.getArguments();
        } else if ("org.eclipse.cdt.make.core.buildCommand".equals(name)) {
            result = this.getCommand();
        } else if ("org.eclipse.cdt.make.core.buildLocation".equals(name)) {
            result = this.getBuildPathAttribute();
        } else if ("org.eclipse.cdt.make.core.stopOnError".equals(name)) {
            result = Boolean.valueOf(this.isStopOnError()).toString();
        } else if ("org.eclipse.cdt.make.core.useDefaultBuildCmd".equals(name)) {
            result = Boolean.valueOf(this.isDefaultBuildCmd()).toString();
        } else if ("org.eclipse.cdt.make.core.autoBuildTarget".equals(name)) {
            result = this.getAutoBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.incrementalBuildTarget".equals(name)) {
            result = this.getIncrementalBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.fullBuildTarget".equals(name)) {
            result = this.getIncrementalBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.cleanBuildTarget".equals(name)) {
            result = this.getCleanBuildTargetAttribute();
        } else if ("org.eclipse.cdt.make.core.enableFullBuild".equals(name)) {
            result = Boolean.valueOf(this.isFullBuildEnabled()).toString();
        } else if ("org.eclipse.cdt.make.core.enableCleanBuild".equals(name)) {
            result = Boolean.valueOf(this.isCleanBuildEnabled()).toString();
        } else if ("org.eclipse.cdt.make.core.enabledIncrementalBuild".equals(name)) {
            result = Boolean.valueOf(this.isIncrementalBuildEnabled()).toString();
        } else if ("org.eclipse.cdt.make.core.enableAutoBuild".equals(name)) {
            result = Boolean.valueOf(this.isAutoBuildEnable()).toString();
        } else if ("org.eclipse.cdt.make.core.buildArguments".equals(name)) {
            result = this.getArguments();
        } else if ("org.eclipse.cdt.make.core.environment".equals(name)) {
            result = this.customizedEnvironment != null ? MapStorageElement.encodeMap(this.customizedEnvironment) : null;
        } else if ("org.eclipse.cdt.make.core.append_environment".equals(name)) {
            result = Boolean.valueOf(this.appendEnvironment()).toString();
        } else if (this.customBuildProperties != null) {
            result = this.customBuildProperties.get(name);
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static String[] toBuildAttributes(String name) {
        if ("incrementalBuildTarget".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.target.inc", "org.eclipse.cdt.make.core.incrementalBuildTarget", "org.eclipse.cdt.make.core.build.target.full", "org.eclipse.cdt.make.core.fullBuildTarget"};
        }
        if ("autoBuildTarget".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.target.auto", "org.eclipse.cdt.make.core.autoBuildTarget"};
        }
        if ("cleanBuildTarget".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.target.clean", "org.eclipse.cdt.make.core.cleanBuildTarget"};
        }
        if ("buildPath".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.location", "org.eclipse.cdt.make.core.buildLocation"};
        }
        if ("command".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.command", "org.eclipse.cdt.make.core.buildCommand"};
        }
        if ("arguments".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.build.arguments", "org.eclipse.cdt.make.core.buildArguments"};
        }
        if ("stopOnErr".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.stopOnError"};
        }
        if ("enabledIncrementalBuild".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.enabledIncrementalBuild", "org.eclipse.cdt.make.core.enableFullBuild"};
        }
        if ("enableCleanBuild".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.enableCleanBuild"};
        }
        if ("enableAutoBuild".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.enableAutoBuild"};
        }
        if ("environment".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.environment"};
        }
        if ("appendEnvironment".equals(name)) {
            return new String[]{"org.eclipse.cdt.make.core.append_environment"};
        }
        if ("customizedErrorParsers".equals(name)) {
            return new String[]{"org.eclipse.cdt.core.errorOutputParser"};
        }
        return new String[0];
    }

    public static String toBuilderAttribute(String name) {
        if ("org.eclipse.cdt.make.core.build.target.inc".equals(name) || "org.eclipse.cdt.make.core.incrementalBuildTarget".equals(name) || "org.eclipse.cdt.make.core.build.target.full".equals(name) || "org.eclipse.cdt.make.core.fullBuildTarget".equals(name)) {
            return "incrementalBuildTarget";
        }
        if ("org.eclipse.cdt.make.core.build.target.auto".equals(name) || "org.eclipse.cdt.make.core.autoBuildTarget".equals(name)) {
            return "autoBuildTarget";
        }
        if ("org.eclipse.cdt.make.core.build.target.clean".equals(name) || "org.eclipse.cdt.make.core.cleanBuildTarget".equals(name)) {
            return "cleanBuildTarget";
        }
        if ("org.eclipse.cdt.make.core.build.location".equals(name) || "org.eclipse.cdt.make.core.buildLocation".equals(name)) {
            return "buildPath";
        }
        if ("org.eclipse.cdt.make.core.build.command".equals(name) || "org.eclipse.cdt.make.core.buildCommand".equals(name)) {
            return "command";
        }
        if ("org.eclipse.cdt.make.core.build.arguments".equals(name) || "org.eclipse.cdt.make.core.buildArguments".equals(name)) {
            return "arguments";
        }
        if ("org.eclipse.cdt.make.core.stopOnError".equals(name)) {
            return "stopOnErr";
        }
        if ("org.eclipse.cdt.make.core.enabledIncrementalBuild".equals(name) || "org.eclipse.cdt.make.core.enableFullBuild".equals(name)) {
            return "enabledIncrementalBuild";
        }
        if ("org.eclipse.cdt.make.core.enableCleanBuild".equals(name)) {
            return "enableCleanBuild";
        }
        if ("org.eclipse.cdt.make.core.enableAutoBuild".equals(name)) {
            return "enableAutoBuild";
        }
        if ("org.eclipse.cdt.make.core.environment".equals(name)) {
            return "environment";
        }
        if ("org.eclipse.cdt.make.core.append_environment".equals(name)) {
            return "appendEnvironment";
        }
        if ("org.eclipse.cdt.core.errorOutputParser".equals(name)) {
            return "customizedErrorParsers";
        }
        return null;
    }

    @Override
    public Map<String, String> getEnvironment() {
        if (this.customizedEnvironment != null) {
            return this.cloneMap(this.customizedEnvironment);
        }
        return null;
    }

    @Override
    public Map<String, String> getExpandedEnvironment() throws CoreException {
        if (this.customizedEnvironment != null) {
            HashMap<String, String> expanded = this.cloneMap(this.customizedEnvironment);
            ICdtVariableManager mngr = CCorePlugin.getDefault().getCdtVariableManager();
            String separator = CCorePlugin.getDefault().getBuildEnvironmentManager().getDefaultDelimiter();
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(this.getParent().getParent());
            Set entrySet = expanded.entrySet();
            for (Map.Entry entry : entrySet) {
                String value = (String)entry.getValue();
                try {
                    value = mngr.resolveValue(value, EMPTY_STRING, separator, cfgDes);
                    entry.setValue(value);
                }
                catch (CdtVariableException cdtVariableException) {}
            }
            return expanded;
        }
        return null;
    }

    @Override
    public void setAppendEnvironment(boolean append) throws CoreException {
        this.appendEnvironment = append;
    }

    @Override
    public void setBuildAttribute(String name, String value) throws CoreException {
        if ("org.eclipse.cdt.make.core.build.target.inc".equals(name)) {
            this.incrementalBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.build.target.auto".equals(name)) {
            this.autoBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.build.target.clean".equals(name)) {
            this.cleanBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.build.location".equals(name)) {
            this.buildPath = value;
        } else if ("org.eclipse.cdt.make.core.build.command".equals(name)) {
            this.command = value;
        } else if ("org.eclipse.cdt.make.core.build.arguments".equals(name)) {
            this.args = value;
        } else if ("org.eclipse.cdt.make.core.buildCommand".equals(name)) {
            this.command = value;
        } else if ("org.eclipse.cdt.make.core.buildLocation".equals(name)) {
            this.buildPath = value;
        } else if ("org.eclipse.cdt.make.core.stopOnError".equals(name)) {
            this.stopOnErr = Boolean.valueOf(value);
        } else if ("org.eclipse.cdt.make.core.useDefaultBuildCmd".equals(name)) {
            if ((value == null || Boolean.valueOf(value).booleanValue()) && this.superClass != null) {
                this.command = null;
            }
        } else if ("org.eclipse.cdt.make.core.autoBuildTarget".equals(name)) {
            this.autoBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.incrementalBuildTarget".equals(name)) {
            this.incrementalBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.fullBuildTarget".equals(name)) {
            this.autoBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.cleanBuildTarget".equals(name)) {
            this.cleanBuildTarget = value;
        } else if ("org.eclipse.cdt.make.core.enableFullBuild".equals(name)) {
            this.autoBuildEnabled = value != null ? Boolean.valueOf(value) : null;
        } else if ("org.eclipse.cdt.make.core.enableCleanBuild".equals(name)) {
            this.cleanBuildEnabled = value != null ? Boolean.valueOf(value) : null;
        } else if ("org.eclipse.cdt.make.core.enabledIncrementalBuild".equals(name)) {
            this.incrementalBuildEnabled = value != null ? Boolean.valueOf(value) : null;
        } else if ("org.eclipse.cdt.make.core.enableAutoBuild".equals(name)) {
            this.autoBuildEnabled = value != null ? Boolean.valueOf(value) : null;
        } else if ("org.eclipse.cdt.make.core.buildArguments".equals(name)) {
            this.args = value;
        } else if ("org.eclipse.cdt.make.core.environment".equals(name)) {
            this.customizedEnvironment = value == null ? null : MapStorageElement.decodeMap(value);
        } else if ("org.eclipse.cdt.make.core.append_environment".equals(name)) {
            this.appendEnvironment = value != null ? Boolean.valueOf(value) : null;
        } else {
            this.getCustomBuildPropertiesMap().put(name, value);
        }
    }

    private Map<String, String> getCustomBuildPropertiesMap() {
        if (this.customBuildProperties == null) {
            this.customBuildProperties = new HashMap();
        }
        return this.customBuildProperties;
    }

    @Override
    public void setEnvironment(Map<String, String> env) throws CoreException {
        this.customizedEnvironment = new HashMap<String, String>(env);
    }

    @Override
    public boolean isCustomBuilder() {
        return !this.isExtensionBuilder && this.getParent().getBuilder() != this;
    }

    public IConfiguration getConfguration() {
        if (this.getParent() != null) {
            return this.getParent().getParent();
        }
        return null;
    }

    @Override
    public boolean isManagedBuildOn() {
        Boolean attr;
        IConfiguration cfg = this.getConfguration();
        if (cfg != null) {
            if (!cfg.supportsBuild(true)) {
                return false;
            }
            if (!cfg.supportsBuild(false)) {
                return true;
            }
        }
        if ((attr = this.getManagedBuildOnAttribute()) != null) {
            return attr;
        }
        return true;
    }

    public Boolean getManagedBuildOnAttribute() {
        if (this.managedBuildOn == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getManagedBuildOnAttribute();
            }
            return null;
        }
        return this.managedBuildOn;
    }

    @Override
    public void setManagedBuildOn(boolean on) throws CoreException {
        this.managedBuildOn = on;
    }

    @Override
    public boolean canKeepEnvironmentVariablesInBuildfile() {
        return BuildMacroProvider.canKeepMacrosInBuildfile(this);
    }

    @Override
    public boolean keepEnvironmentVariablesInBuildfile() {
        if (this.keepEnvVarInBuildfile == null) {
            if (this.superClass != null) {
                return this.getSuperClass().keepEnvironmentVariablesInBuildfile();
            }
            return false;
        }
        return this.keepEnvVarInBuildfile;
    }

    @Override
    public void setKeepEnvironmentVariablesInBuildfile(boolean keep) {
        this.keepEnvVarInBuildfile = keep;
    }

    @Override
    public boolean supportsCustomizedBuild() {
        if (this.fSupportsCustomizedBuild == null) {
            IManagedBuilderMakefileGenerator makeGen = this.getBuildFileGenerator();
            this.fSupportsCustomizedBuild = makeGen instanceof IManagedBuilderMakefileGenerator2 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.fSupportsCustomizedBuild;
    }

    @Override
    public boolean supportsBuild(boolean managed) {
        if (this.supportsManagedBuild == null) {
            if (this.superClass != null) {
                return this.getSuperClass().supportsBuild(managed);
            }
            return managed || !this.isInternalBuilder();
        }
        return this.supportsManagedBuild;
    }

    public void setParent(IToolChain toolChain) {
        this.parent = toolChain;
    }

    @Override
    public boolean matches(IBuilder builder) {
        if (builder == this) {
            return true;
        }
        IBuilder rBld = ManagedBuildManager.getRealBuilder(this);
        if (rBld == null) {
            return false;
        }
        return rBld == ManagedBuildManager.getRealBuilder(builder);
    }

    @Override
    public MatchKey<Builder> getMatchKey() {
        if (this.isAbstract()) {
            return null;
        }
        if (!this.isExtensionBuilder) {
            return null;
        }
        return new MatchKey<Builder>(this);
    }

    @Override
    public void setIdenticalList(List<Builder> list) {
        this.identicalList = list;
    }

    public String getNameAndVersion() {
        String name = this.getName();
        String version = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
        if (version != null && version.length() != 0) {
            return new StringBuffer().append(name).append(" (").append(version).append(EMPTY_STRING).toString();
        }
        return name;
    }

    @Override
    public List<Builder> getIdenticalList() {
        return this.identicalList;
    }

    @Override
    public boolean isInternalBuilder() {
        IBuilder internalBuilder = ManagedBuildManager.getInternalBuilder();
        IBuilder builder = this;
        while (builder != null) {
            if (internalBuilder == builder) {
                return true;
            }
            builder = builder.getSuperClass();
        }
        return false;
    }

    public int getOptimalParallelJobNum() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int getParallelizationNumAttribute() {
        if (!this.isParallelBuildOn()) {
            return 1;
        }
        if (this.parallelNumberAttribute == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getParallelizationNumAttribute();
            }
            return 1;
        }
        return this.parallelNumberAttribute;
    }

    private void setParallelizationNumAttribute(int parallelNumber) {
        this.isParallelBuildEnabled = parallelNumber != 1;
        this.parallelNumberAttribute = parallelNumber > 0 ? Integer.valueOf(parallelNumber) : Integer.valueOf(-this.getOptimalParallelJobNum());
    }

    @Override
    public int getParallelizationNum() {
        return Math.abs(this.getParallelizationNumAttribute());
    }

    @Override
    public void setParallelizationNum(int jobs) throws CoreException {
        if (!this.supportsParallelBuild()) {
            return;
        }
        if (this.parallelNumberAttribute == null || this.parallelNumberAttribute != jobs) {
            String curCmd = this.getParallelizationCmd(this.getParallelizationNum());
            String args = this.getArgumentsAttribute();
            String updatedArgs = this.removeCmd(args, curCmd);
            if (!updatedArgs.equals(args)) {
                this.setArgumentsAttribute(updatedArgs);
            }
            this.setParallelizationNumAttribute(jobs);
            this.setDirty(true);
        }
    }

    @Override
    public boolean supportsParallelBuild() {
        if (this.isInternalBuilder()) {
            return true;
        }
        return this.getParrallelBuildCmd().length() != 0;
    }

    @Override
    public boolean supportsStopOnError(boolean on) {
        if (this.isInternalBuilder()) {
            return true;
        }
        if (!on) {
            return this.getIgnoreErrCmdAttribute().length() != 0;
        }
        return true;
    }

    public String getStopOnErrCmd(boolean stop) {
        if (!stop) {
            return this.getIgnoreErrCmdAttribute();
        }
        return EMPTY_STRING;
    }

    public String getIgnoreErrCmdAttribute() {
        if (this.ignoreErrCmd == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getIgnoreErrCmdAttribute();
            }
            return EMPTY_STRING;
        }
        return this.ignoreErrCmd;
    }

    public String getParrallelBuildCmd() {
        if (this.parallelBuildCmd == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getParrallelBuildCmd();
            }
            return EMPTY_STRING;
        }
        return this.parallelBuildCmd;
    }

    @Override
    public boolean isParallelBuildOn() {
        if (!this.supportsParallelBuild()) {
            return false;
        }
        if (this.isParallelBuildEnabled == null) {
            if (this.superClass != null) {
                return this.getSuperClass().isParallelBuildOn();
            }
            return false;
        }
        return this.isParallelBuildEnabled;
    }

    @Override
    public void setParallelBuildOn(boolean on) throws CoreException {
        if (on) {
            this.setParallelizationNum(-1);
        } else {
            this.setParallelizationNum(1);
        }
    }

    public Set<String> contributeErrorParsers(Set<String> set) {
        if (this.getErrorParserIds() != null) {
            String[] ids;
            if (set == null) {
                set = new HashSet<String>();
            }
            if ((ids = this.getErrorParserList()).length != 0) {
                set.addAll(Arrays.asList(ids));
            }
        }
        return set;
    }

    public void resetErrorParsers() {
        this.errorParserIds = null;
    }

    void removeErrorParsers(Set<String> set) {
        Set<String> oldSet = this.contributeErrorParsers(null);
        if (oldSet == null) {
            oldSet = new HashSet<String>();
        }
        oldSet.removeAll(set);
        this.setErrorParserList(oldSet.toArray(new String[oldSet.size()]));
    }

    public void setErrorParserList(String[] ids) {
        if (ids == null) {
            this.errorParserIds = null;
        } else if (ids.length == 0) {
            this.errorParserIds = EMPTY_STRING;
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(ids[0]);
            int i = 1;
            while (i < ids.length) {
                buf.append(";").append(ids[i]);
                ++i;
            }
            this.errorParserIds = buf.toString();
        }
    }

    @Override
    public boolean isSystemObject() {
        if (this.isTest) {
            return true;
        }
        if (this.getConvertToId().length() != 0) {
            return true;
        }
        if (this.getParent() != null) {
            return this.getParent().isSystemObject();
        }
        return false;
    }

    @Override
    public String getUniqueRealName() {
        String name = this.getName();
        if (name == null) {
            name = this.getId();
        } else {
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
            if (version != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(name);
                buf.append(" (v").append(version).append(")");
                name = buf.toString();
            }
        }
        return name;
    }

    public ICOutputEntry[] getOutputEntries() {
        if (this.isManagedBuildOn()) {
            return this.getDefaultOutputSettings();
        }
        ICOutputEntry[] entries = this.getOutputEntrySettings();
        if (entries == null || entries.length == 0) {
            entries = this.getDefaultOutputSettings();
        }
        return entries;
    }

    private ICOutputEntry[] getDefaultOutputSettings() {
        Configuration cfg = (Configuration)this.getConfguration();
        if (cfg == null || cfg.isPreference() || cfg.isExtensionElement()) {
            return new ICOutputEntry[]{new COutputEntry((IPath)Path.EMPTY, null, 24)};
        }
        Object path = ManagedBuildManager.getBuildFullPath(cfg, this);
        IProject proj = cfg.getOwner().getProject();
        IPath projFullPath = proj.getFullPath();
        path = path != null && projFullPath.isPrefixOf(path) ? path.removeFirstSegments(projFullPath.segmentCount()).makeRelative() : Path.EMPTY;
        return new ICOutputEntry[]{new COutputEntry(path, null, 24)};
    }

    public ICOutputEntry[] getOutputEntrySettings() {
        if (this.outputEntries == null) {
            if (this.superClass != null) {
                return ((Builder)this.superClass).getOutputEntrySettings();
            }
            return null;
        }
        return (ICOutputEntry[])this.outputEntries.clone();
    }

    public void setOutputEntries(ICOutputEntry[] entries) {
        this.outputEntries = entries != null ? (ICOutputEntry[])entries.clone() : null;
    }

    private int getSuperClassNum() {
        int num = 0;
        IBuilder superTool = this.getSuperClass();
        while (superTool != null) {
            ++num;
            superTool = superTool.getSuperClass();
        }
        return num;
    }

    @Override
    public int compareTo(Builder other) {
        if (other.isSystemObject() != this.isSystemObject()) {
            return this.isSystemObject() ? 1 : -1;
        }
        return this.getSuperClassNum() - other.getSuperClassNum();
    }

    @Override
    public IRealBuildObjectAssociation getExtensionObject() {
        return (Builder)ManagedBuildManager.getExtensionBuilder(this);
    }

    @Override
    public IRealBuildObjectAssociation[] getIdenticBuildObjects() {
        return (IRealBuildObjectAssociation[])ManagedBuildManager.findIdenticalBuilders(this);
    }

    @Override
    public IRealBuildObjectAssociation getRealBuildObject() {
        return (Builder)ManagedBuildManager.getRealBuilder(this);
    }

    @Override
    public IRealBuildObjectAssociation getSuperClassObject() {
        return (Builder)this.getSuperClass();
    }

    @Override
    public final int getType() {
        return 4;
    }

    @Override
    public boolean isRealBuildObject() {
        return ManagedBuildManager.getRealBuilder(this) == this;
    }

    @Override
    public boolean isExtensionBuildObject() {
        return this.isExtensionElement();
    }

    @Override
    public String toString() {
        return this.getUniqueRealName();
    }

    @Override
    public ICommandLauncher getCommandLauncher() {
        if (this.fCommandLauncher != null) {
            return this.fCommandLauncher;
        }
        if (this.fCommandLauncher == null && this.fCommandLauncherElement != null) {
            try {
                this.fCommandLauncher = (ICommandLauncher)this.fCommandLauncherElement.createExecutableExtension("commandLauncher");
                return this.fCommandLauncher;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (this.fCommandLauncher == null && this.superClass != null) {
            return this.getSuperClass().getCommandLauncher();
        }
        if (this.fCommandLauncher == null) {
            this.fCommandLauncher = new CommandLauncher();
        }
        return this.fCommandLauncher;
    }

    @Override
    public AbstractBuildRunner getBuildRunner() throws CoreException {
        if (this.fBuildRunner != null) {
            return this.fBuildRunner;
        }
        if (this.fBuildRunnerElement != null) {
            this.fBuildRunner = (AbstractBuildRunner)this.fBuildRunnerElement.createExecutableExtension("buildRunner");
            return this.fBuildRunner;
        }
        if (this.superClass != null) {
            return this.getSuperClass().getBuildRunner();
        }
        if (this.isInternalBuilder()) {
            return new InternalBuildRunner();
        }
        return new ExternalBuildRunner();
    }

    @Override
    protected IResourceInfo getParentResourceInfo() {
        return null;
    }
}

