/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ErrorViewPart;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ViewDescriptor;

public class ViewReference
extends WorkbenchPartReference
implements IViewReference {
    private ViewDescriptor descriptor;
    private ViewSite viewSite;
    private IMemento memento;

    public ViewReference(IEclipseContext windowContext, IWorkbenchPage page, MPart part, ViewDescriptor descriptor) {
        super(windowContext, page, part);
        this.descriptor = descriptor;
        if (descriptor == null) {
            this.setImageDescriptor(ImageDescriptor.getMissingImageDescriptor());
        } else {
            this.setImageDescriptor(descriptor.getImageDescriptor());
        }
        String mementoString = (String)this.getModel().getPersistedState().get(MEMENTO_KEY);
        if (mementoString != null) {
            try {
                this.memento = XMLMemento.createReadRoot(new StringReader(mementoString));
            }
            catch (WorkbenchException e) {
                WorkbenchPlugin.log((Throwable)((Object)e));
            }
        }
    }

    void persist() {
        IViewPart view = this.getView(false);
        if (view != null) {
            XMLMemento root = XMLMemento.createWriteRoot("view");
            view.saveState(root);
            StringWriter writer = new StringWriter();
            try {
                root.save(writer);
                this.getModel().getPersistedState().put(MEMENTO_KEY, writer.toString());
            }
            catch (IOException e) {
                WorkbenchPlugin.log(e);
            }
        }
    }

    public String getPartName() {
        return this.descriptor.getLabel();
    }

    public String getSecondaryId() {
        MPart part = this.getModel();
        for (String tag : part.getTags()) {
            if (!tag.startsWith("3x-secondary:")) continue;
            return tag.substring("3x-secondary:".length());
        }
        return null;
    }

    public IViewPart getView(boolean restore) {
        return (IViewPart)this.getPart(restore);
    }

    public boolean isFastView() {
        return false;
    }

    public IWorkbenchPart createPart() throws PartInitException {
        try {
            if (this.descriptor == null) {
                return this.createErrorPart();
            }
            return this.descriptor.createView();
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            throw new PartInitException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, status.getCode(), status.getMessage(), (Throwable)e));
        }
    }

    IWorkbenchPart createErrorPart() {
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, NLS.bind((String)WorkbenchMessages.ViewFactory_initException, (Object)this.getModel().getElementId()));
        return this.createErrorPart((IStatus)status);
    }

    public IWorkbenchPart createErrorPart(IStatus status) {
        return new ErrorViewPart(status);
    }

    public void initialize(IWorkbenchPart part) throws PartInitException {
        this.viewSite = new ViewSite(this.getModel(), part, this, this.descriptor == null ? null : this.descriptor.getConfigurationElement());
        IViewPart view = (IViewPart)part;
        view.init(this.viewSite, this.memento);
        if (view.getSite() != this.viewSite || view.getViewSite() != this.viewSite) {
            String id = this.descriptor == null ? this.getModel().getElementId() : this.descriptor.getId();
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_siteException, (Object)id));
        }
        this.legacyPart = part;
        this.addPropertyListeners();
    }

    public PartSite getSite() {
        return this.viewSite;
    }
}

