/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupLanguageConfiguration
implements Cloneable {
    private List<Block> blocks = new ArrayList<Block>();
    private List<PatternBasedElement> phraseModifiers = new ArrayList<PatternBasedElement>();
    private List<PatternBasedElement> tokens = new ArrayList<PatternBasedElement>();
    private boolean escapingHtmlAndXml = false;
    private boolean enableUnwrappedParagraphs = true;
    private boolean newlinesMustCauseLineBreak = false;
    private boolean optimizeForRepositoryUsage = false;
    private Boolean wikiWordLinking = true;
    private Locale locale;

    public List<PatternBasedElement> getTokens() {
        return this.tokens;
    }

    public List<PatternBasedElement> getPhraseModifiers() {
        return this.phraseModifiers;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public boolean isParagraphBreaking(Block block) {
        return true;
    }

    public boolean isEscapingHtmlAndXml() {
        return this.escapingHtmlAndXml;
    }

    public void setEscapingHtmlAndXml(boolean escapingHtmlAndXml) {
        this.escapingHtmlAndXml = escapingHtmlAndXml;
    }

    public boolean isEnableUnwrappedParagraphs() {
        return this.enableUnwrappedParagraphs;
    }

    public void setEnableUnwrappedParagraphs(boolean enableUnwrappedParagraphs) {
        this.enableUnwrappedParagraphs = enableUnwrappedParagraphs;
    }

    public boolean isNewlinesMustCauseLineBreak() {
        return this.newlinesMustCauseLineBreak;
    }

    public void setNewlinesMustCauseLineBreak(boolean newlinesMustCauseLineBreak) {
        this.newlinesMustCauseLineBreak = newlinesMustCauseLineBreak;
    }

    public void addPhraseModifierExtensions(MarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        for (PatternBasedElement element : this.getPhraseModifiers()) {
            phraseModifierSyntax.add(element);
        }
    }

    public boolean isOptimizeForRepositoryUsage() {
        return this.optimizeForRepositoryUsage;
    }

    public void setOptimizeForRepositoryUsage(boolean optimizeForRepositoryUsage) {
        this.optimizeForRepositoryUsage = optimizeForRepositoryUsage;
    }

    public Boolean isWikiWordLinking() {
        return this.wikiWordLinking;
    }

    public void setWikiWordLinking(Boolean wikiWordLinking) {
        this.wikiWordLinking = wikiWordLinking;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void addBlockExtensions(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        for (Block block : this.getBlocks()) {
            blocks.add(this.computeInsertPosition(block), block);
            if (!this.isParagraphBreaking(block)) continue;
            paragraphBreakingBlocks.add(block);
        }
    }

    protected int computeInsertPosition(Block block) {
        return 0;
    }

    public void addTokenExtensions(MarkupLanguage.PatternBasedSyntax tokenSyntax) {
        for (PatternBasedElement element : this.getTokens()) {
            tokenSyntax.add(element);
        }
    }

    public MarkupLanguageConfiguration clone() {
        try {
            MarkupLanguageConfiguration copy = (MarkupLanguageConfiguration)super.clone();
            copy.blocks = new ArrayList<Block>(this.blocks.size());
            for (Block block : this.blocks) {
                copy.blocks.add(block.clone());
            }
            copy.phraseModifiers = new ArrayList<PatternBasedElement>(this.phraseModifiers.size());
            for (PatternBasedElement element : this.phraseModifiers) {
                copy.phraseModifiers.add(element.clone());
            }
            copy.tokens = new ArrayList<PatternBasedElement>(this.tokens.size());
            for (PatternBasedElement element : this.tokens) {
                copy.tokens.add(element.clone());
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

