/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.repositories.core.ILocationService;
import org.eclipse.mylyn.commons.repositories.core.IRepositoryLocationChangeListener;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocationChangeEvent;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.internal.commons.repositories.core.CredentialsFactory;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.LocationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryLocation
extends PlatformObject {
    private static boolean flushCredentialsErrorLogged;
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_OFFLINE = "org.eclipse.mylyn.tasklist.repositories.offline";
    public static final String PROPERTY_PROXY_HOST = "org.eclipse.mylyn.repositories.proxy.host";
    public static final String PROPERTY_PROXY_PORT = "org.eclipse.mylyn.repositories.proxy.port";
    public static final String PROPERTY_PROXY_USEDEFAULT = "org.eclipse.mylyn.repositories.proxy.usedefault";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_USERNAME = "org.eclipse.mylyn.repositories.username";
    private static final String ENABLED = ".enabled";
    private ICredentialsStore credentialsStore;
    private IStatus errorStatus = null;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private final List<IRepositoryLocationChangeListener> repositoryLocationChangeListeners = new CopyOnWriteArrayList<IRepositoryLocationChangeListener>();
    private ILocationService service;
    private final boolean workingCopy;

    private static Map<String, String> createDefaultProperties() {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put(PROPERTY_PROXY_USEDEFAULT, Boolean.TRUE.toString());
        return defaultProperties;
    }

    public RepositoryLocation() {
        this(RepositoryLocation.createDefaultProperties(), LocationService.getDefault(), false);
    }

    public RepositoryLocation(String url) {
        this();
        this.setUrl(url);
    }

    public RepositoryLocation(Map<String, String> properties) {
        this(properties, LocationService.getDefault(), true);
    }

    public RepositoryLocation(Map<String, String> properties, ILocationService service, boolean workingCopy) {
        this.properties.putAll(properties);
        this.service = service;
        this.workingCopy = workingCopy;
        if (this.properties.get(PROPERTY_ID) == null) {
            this.properties.put(PROPERTY_ID, UUID.randomUUID().toString());
        }
    }

    public RepositoryLocation(RepositoryLocation source) {
        this(source.getProperties(), source.getService(), true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void apply(RepositoryLocation location) {
        block8: {
            String oldId = this.getProperty(PROPERTY_ID);
            ICredentialsStore oldCredentialsStore = null;
            if (oldId != null) {
                oldCredentialsStore = this.getCredentialsStore();
            }
            HashSet<String> removed = new HashSet<String>(this.properties.keySet());
            removed.removeAll(location.properties.keySet());
            for (Map.Entry<String, String> entry : location.properties.entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
            for (String key : removed) {
                this.setProperty(key, null);
            }
            String newId = this.getProperty(PROPERTY_ID);
            if (newId != null) {
                ICredentialsStore newCredentialsStore = this.getCredentialsStore();
                if (!newId.equals(oldId) && oldCredentialsStore != null) {
                    oldCredentialsStore.copyTo(newCredentialsStore);
                    oldCredentialsStore.clear();
                }
                if (location.getCredentialsStore() instanceof InMemoryCredentialsStore) {
                    ((InMemoryCredentialsStore)location.getCredentialsStore()).copyTo(newCredentialsStore);
                }
                try {
                    newCredentialsStore.flush();
                }
                catch (IOException e) {
                    if (flushCredentialsErrorLogged) break block8;
                    flushCredentialsErrorLogged = true;
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.core", "Unexpected error occured while flushing credentials. Credentials may not have been saved.", (Throwable)e));
                }
            }
        }
        this.fireRepositoryLocationChangeEvent(RepositoryLocationChangeEvent.Type.ALL);
    }

    public void clearCredentials() {
        this.getCredentialsStore().clear();
    }

    public boolean getBooleanPropery(String key) {
        String value = this.getProperty(key);
        return value != null && Boolean.parseBoolean(value);
    }

    public <T extends AuthenticationCredentials> T getCredentials(AuthenticationType<T> authType) {
        return this.getCredentials(authType, true);
    }

    public <T extends AuthenticationCredentials> T getCredentials(AuthenticationType<T> authType, boolean loadSecrets) {
        String prefix = authType.getKey();
        if (this.getBooleanPropery(String.valueOf(prefix) + ENABLED)) {
            if (this.getId() == null) {
                return null;
            }
            return CredentialsFactory.create(authType.getCredentialsType(), this.getCredentialsStore(), prefix, loadSecrets);
        }
        return null;
    }

    public ICredentialsStore getCredentialsStore() {
        if (this.credentialsStore == null) {
            return this.getService().getCredentialsStore(this.getId());
        }
        return this.credentialsStore;
    }

    public String getId() {
        String id = this.getProperty(PROPERTY_ID);
        if (id == null) {
            throw new IllegalStateException("Repository ID is not set");
        }
        return id;
    }

    public String getLabel() {
        String label = this.properties.get(PROPERTY_LABEL);
        if (label != null && label.length() > 0) {
            return label;
        }
        return this.getUrl();
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Proxy getProxy() {
        if (Boolean.parseBoolean(this.getProperty(PROPERTY_PROXY_USEDEFAULT))) {
            return null;
        }
        String proxyHost = this.getProperty(PROPERTY_PROXY_HOST);
        String proxyPort = this.getProperty(PROPERTY_PROXY_PORT);
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null) {
            try {
                int proxyPortNum = Integer.parseInt(proxyPort);
                UserCredentials credentials = this.getCredentials(AuthenticationType.PROXY);
                if (credentials != null) {
                    return NetUtil.createProxy((String)proxyHost, (int)proxyPortNum, (String)credentials.getUserName(), (String)credentials.getPassword(), (String)credentials.getDomain());
                }
                return NetUtil.createProxy((String)proxyHost, (int)proxyPortNum);
            }
            catch (NumberFormatException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.core", 0, "Error occured while configuring proxy. Invalid port \"" + proxyPort + "\" specified.", (Throwable)e));
            }
        }
        return null;
    }

    public Proxy getProxyForHost(String host, String proxyType) {
        Proxy proxy = this.getProxy();
        if (proxy != null) {
            return proxy;
        }
        return this.getService().getProxyForHost(host, proxyType);
    }

    public ILocationService getService() {
        return this.service;
    }

    public IStatus getStatus() {
        return this.errorStatus;
    }

    public String getUrl() {
        return this.getProperty(PROPERTY_URL);
    }

    public String getUserName() {
        return this.getProperty(PROPERTY_USERNAME);
    }

    public boolean hasProperty(String name) {
        String value = this.getProperty(name);
        return value != null && value.trim().length() > 0;
    }

    public boolean hasUrl(String url) {
        Assert.isNotNull((Object)url);
        String myUrl = this.getUrl();
        if (myUrl == null) {
            return false;
        }
        try {
            return new URI(String.valueOf(url) + "/").normalize().equals(new URI(String.valueOf(myUrl) + "/").normalize());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public boolean isOffline() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_OFFLINE));
    }

    public boolean isWorkingCopy() {
        return this.workingCopy;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public <T extends AuthenticationCredentials> void removeCredentials(AuthenticationType<T> authType, T credentials) {
        String prefix = authType.getKey();
        credentials.clear(this.getCredentialsStore(), prefix);
    }

    public void removeProperty(String key) {
        this.setProperty(key, null);
    }

    public <T extends AuthenticationCredentials> T requestCredentials(AuthenticationRequest<AuthenticationType<T>> request, IProgressMonitor monitor) {
        return this.getService().requestCredentials(request, monitor);
    }

    public <T extends AuthenticationCredentials> void setCredentials(AuthenticationType<T> authType, T credentials) {
        String prefix = authType.getKey();
        if (credentials == null) {
            this.setProperty(String.valueOf(prefix) + ENABLED, String.valueOf(false));
        } else {
            this.setProperty(String.valueOf(prefix) + ENABLED, String.valueOf(true));
            credentials.save(this.getCredentialsStore(), prefix);
        }
        this.fireRepositoryLocationChangeEvent(RepositoryLocationChangeEvent.Type.CREDENTIALS);
    }

    public void setCredentialsStore(ICredentialsStore credentialsStore) {
        this.credentialsStore = credentialsStore;
    }

    public void setIdPreservingCredentialsStore(String id) {
        Assert.isNotNull((Object)id);
        ICredentialsStore store = this.getCredentialsStore();
        this.setProperty(PROPERTY_ID, id);
        if (this.credentialsStore == null) {
            this.setCredentialsStore(store);
        }
    }

    public void setLabel(String label) {
        this.setProperty(PROPERTY_LABEL, label);
    }

    public void setOffline(boolean offline) {
        this.properties.put(PROPERTY_OFFLINE, String.valueOf(offline));
    }

    public void setProperty(String key, String newValue) {
        this.validatePropertyChange(key, newValue);
        String oldValue = this.properties.get(key);
        if (this.hasChanged(oldValue, newValue)) {
            this.properties.put(key.intern(), newValue != null ? newValue.intern() : null);
            this.handlePropertyChange(key, oldValue, newValue);
        }
    }

    public void validatePropertyChange(String key, String newValue) {
        Assert.isNotNull((Object)key);
        if (key.equals(PROPERTY_ID) && newValue == null) {
            throw new IllegalArgumentException("The ID property must not be null");
        }
    }

    public void setProxy(Proxy proxy) {
        if (proxy == null) {
            this.setProperty(PROPERTY_PROXY_USEDEFAULT, Boolean.toString(true));
        } else {
            SocketAddress address = proxy.address();
            if (address instanceof InetSocketAddress) {
                this.setProperty(PROPERTY_PROXY_HOST, ((InetSocketAddress)address).getHostName());
                this.setProperty(PROPERTY_PROXY_PORT, Integer.toString(((InetSocketAddress)address).getPort()));
                this.setProperty(PROPERTY_PROXY_USEDEFAULT, Boolean.toString(false));
            } else {
                throw new IllegalArgumentException("Invalid proxy address");
            }
        }
        this.fireRepositoryLocationChangeEvent(RepositoryLocationChangeEvent.Type.PROYX);
    }

    public void setService(ILocationService service) {
        this.service = service;
    }

    public void setStatus(IStatus errorStatus) {
        this.errorStatus = errorStatus;
    }

    public void setUrl(String url) {
        this.setProperty(PROPERTY_URL, url);
    }

    public void setUserName(String userName) {
        this.setProperty(PROPERTY_USERNAME, userName);
    }

    public String toString() {
        return this.getLabel();
    }

    private void handlePropertyChange(String key, Object old, Object value) {
        if (PROPERTY_ID.equals(key)) {
            this.credentialsStore = null;
        }
        this.firePropertyChangeEvent(key, old, value);
    }

    private void firePropertyChangeEvent(String key, Object old, Object value) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, key, old, value);
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private void fireRepositoryLocationChangeEvent(RepositoryLocationChangeEvent.Type type) {
        RepositoryLocationChangeEvent event = new RepositoryLocationChangeEvent(this, type);
        for (IRepositoryLocationChangeListener listener : this.repositoryLocationChangeListeners) {
            listener.repositoryChanged(event);
        }
    }

    private boolean hasChanged(Object oldValue, Object newValue) {
        return oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null;
    }
}

