/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentContext;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentLocation;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpointIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class TmfExperiment<T extends ITmfEvent>
extends TmfTrace<T>
implements ITmfEventParser<T> {
    public static final int DEFAULT_INDEX_PAGE_SIZE = 5000;
    protected static TmfExperiment<?> fCurrentExperiment = null;
    protected ITmfTrace<T>[] fTraces;
    private boolean fInitialized = false;
    private IFile fBookmarksFile;
    private TmfExperimentContext fExperimentContext;
    private Integer fEndSynchReference;

    public TmfExperiment(Class<T> type, String id, ITmfTrace<T>[] traces) {
        this(type, id, traces, 5000);
    }

    public TmfExperiment(Class<T> type, String path, ITmfTrace<T>[] traces, int indexPageSize) {
        this.setCacheSize(indexPageSize);
        this.setStreamingInterval(0L);
        this.setIndexer(new TmfCheckpointIndexer<ITmfTrace<ITmfEvent>>(this, indexPageSize));
        this.setParser(this);
        try {
            super.initialize(null, path, type);
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
        }
        this.fTraces = traces;
        this.setTimeRange(TmfTimeRange.NULL_RANGE);
    }

    @Override
    public synchronized void dispose() {
        TmfExperimentDisposedSignal signal = new TmfExperimentDisposedSignal((Object)this, this);
        this.broadcast(signal);
        if (fCurrentExperiment == this) {
            fCurrentExperiment = null;
        }
        if (this.getIndexer() != null) {
            this.getIndexer().dispose();
        }
        if (this.fTraces != null) {
            ITmfTrace<T>[] iTmfTraceArray = this.fTraces;
            int n = this.fTraces.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace<T> trace = iTmfTraceArray[n2];
                trace.dispose();
                ++n2;
            }
            this.fTraces = null;
        }
        super.dispose();
    }

    @Override
    public void initTrace(IResource resource, String path, Class<T> type) {
    }

    @Override
    public boolean validate(IProject project, String path) {
        return true;
    }

    public static void setCurrentExperiment(TmfExperiment<?> experiment) {
        if (fCurrentExperiment != null && fCurrentExperiment != experiment) {
            fCurrentExperiment.dispose();
        }
        fCurrentExperiment = experiment;
    }

    public static TmfExperiment<?> getCurrentExperiment() {
        return fCurrentExperiment;
    }

    public ITmfTrace<T>[] getTraces() {
        return this.fTraces;
    }

    public ITmfTimestamp getTimestamp(int index) {
        ITmfContext context = this.seekEvent(index);
        T event = this.getNext(context);
        return event != null ? event.getTimestamp() : null;
    }

    public void setBookmarksFile(IFile file) {
        this.fBookmarksFile = file;
    }

    public IFile getBookmarksFile() {
        return this.fBookmarksFile;
    }

    @Override
    protected synchronized ITmfContext armRequest(ITmfDataRequest<T> request) {
        if (this.fTraces == null) {
            return null;
        }
        if (request instanceof ITmfEventRequest && !TmfTimestamp.BIG_BANG.equals(((ITmfEventRequest)request).getRange().getStartTime()) && request.getIndex() == 0L) {
            ITmfContext context = this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
            return context;
        }
        if (this.fExperimentContext != null && this.fExperimentContext.getRank() == request.getIndex()) {
            return this.fExperimentContext;
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfLocation<?> location) {
        if (location != null && !(location instanceof TmfExperimentLocation)) {
            return null;
        }
        if (this.fTraces == null) {
            return null;
        }
        TmfExperimentLocation expLocation = location == null ? new TmfExperimentLocation(new TmfLocationArray(new ITmfLocation[this.fTraces.length])) : (TmfExperimentLocation)location.clone();
        TmfExperimentContext context = new TmfExperimentContext(new ITmfContext[this.fTraces.length]);
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfLocation<? extends Comparable<?>> trcLocation = ((TmfLocationArray)expLocation.getLocation()).getLocations()[i];
            context.getContexts()[i] = this.fTraces[i].seekEvent(trcLocation);
            ((TmfLocationArray)expLocation.getLocation()).getLocations()[i] = context.getContexts()[i].getLocation().clone();
            context.getEvents()[i] = this.fTraces[i].getNext(context.getContexts()[i]);
            ++i;
        }
        context.setLocation(expLocation);
        context.setLastTrace(-1);
        context.setRank(location == null ? 0L : -1L);
        this.fExperimentContext = context;
        return context;
    }

    @Override
    public ITmfContext seekEvent(double ratio) {
        ITmfContext context = this.seekEvent((long)(ratio * (double)this.getNbEvents()));
        return context;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        if (location instanceof TmfExperimentLocation) {
            return (double)this.seekEvent(location).getRank() / (double)this.getNbEvents();
        }
        return 0.0;
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        ITmfLocation[] locations = new ITmfLocation[this.fTraces.length];
        int i = 0;
        while (i < this.fTraces.length) {
            locations[i] = this.fTraces[i].getCurrentLocation();
            ++i;
        }
        return new TmfExperimentLocation(new TmfLocationArray(locations));
    }

    @Override
    public synchronized T parseEvent(ITmfContext context) {
        ITmfContext savedContext = context.clone();
        T event = this.getNext(savedContext);
        return event;
    }

    @Override
    public synchronized T getNext(ITmfContext context) {
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (this.fTraces == null) {
            return null;
        }
        TmfExperimentContext expContext = (TmfExperimentContext)context;
        int lastTrace = expContext.getLastTrace();
        if (lastTrace != -1) {
            ITmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = this.fTraces[lastTrace].getNext(traceContext);
            expContext.setLastTrace(-1);
        }
        int trace = -1;
        ITmfTimestamp timestamp = TmfTimestamp.BIG_CRUNCH;
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfTimestamp otherTS;
            ITmfEvent event = expContext.getEvents()[i];
            if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                trace = i;
                timestamp = otherTS;
            }
            ++i;
        }
        ITmfEvent event = null;
        if (trace != -1 && (event = expContext.getEvents()[trace]) != null) {
            this.updateAttributes(expContext, event.getTimestamp());
            expContext.increaseRank();
            expContext.setLastTrace(trace);
            ITmfContext traceContext = expContext.getContexts()[trace];
            TmfExperimentLocation location = (TmfExperimentLocation)expContext.getLocation();
            if (location != null) {
                ((TmfLocationArray)location.getLocation()).getLocations()[trace] = traceContext.getLocation().clone();
            }
            this.fExperimentContext = expContext.clone();
            this.processEvent(event);
        }
        return (T)event;
    }

    @Override
    public synchronized String toString() {
        return "[TmfExperiment (" + this.getName() + ")]";
    }

    private synchronized void initializeStreamingMonitor() {
        if (this.fInitialized) {
            return;
        }
        this.fInitialized = true;
        if (this.getStreamingInterval() == 0L) {
            ITmfContext context = this.seekEvent(0L);
            T event = this.getNext(context);
            if (event == null) {
                return;
            }
            TmfTimeRange timeRange = new TmfTimeRange(event.getTimestamp().clone(), TmfTimestamp.BIG_CRUNCH);
            final TmfExperimentRangeUpdatedSignal signal = new TmfExperimentRangeUpdatedSignal(this, this, timeRange);
            new Thread(){

                @Override
                public void run() {
                    TmfExperiment.this.broadcast(signal);
                }
            }.start();
            return;
        }
        Thread thread = new Thread("Streaming Monitor for experiment " + this.getName()){
            private ITmfTimestamp safeTimestamp;
            private ITmfTimestamp lastSafeTimestamp;
            private TmfTimeRange timeRange;
            {
                this.safeTimestamp = null;
                this.lastSafeTimestamp = null;
                this.timeRange = null;
            }

            @Override
            public void run() {
                while (!TmfExperiment.this.fExecutor.isShutdown()) {
                    if (!TmfExperiment.this.getIndexer().isIndexing()) {
                        ITmfTimestamp startTimestamp = TmfTimestamp.BIG_CRUNCH;
                        ITmfTimestamp endTimestamp = TmfTimestamp.BIG_BANG;
                        ITmfTrace<T>[] iTmfTraceArray = TmfExperiment.this.fTraces;
                        int n = TmfExperiment.this.fTraces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITmfTrace trace = iTmfTraceArray[n2];
                            if (trace.getStartTime().compareTo(startTimestamp) < 0) {
                                startTimestamp = trace.getStartTime();
                            }
                            if (trace.getStreamingInterval() != 0L && trace.getEndTime().compareTo(endTimestamp) > 0) {
                                endTimestamp = trace.getEndTime();
                            }
                            ++n2;
                        }
                        if (this.safeTimestamp != null && (this.lastSafeTimestamp == null || this.safeTimestamp.compareTo(this.lastSafeTimestamp, false) > 0)) {
                            this.timeRange = new TmfTimeRange(startTimestamp, this.safeTimestamp);
                            this.lastSafeTimestamp = this.safeTimestamp;
                        } else {
                            this.timeRange = null;
                        }
                        this.safeTimestamp = endTimestamp;
                        if (this.timeRange != null) {
                            TmfExperimentRangeUpdatedSignal signal = new TmfExperimentRangeUpdatedSignal(TmfExperiment.this, TmfExperiment.this, this.timeRange);
                            TmfExperiment.this.broadcast(signal);
                        }
                    }
                    try {
                        Thread.sleep(TmfExperiment.this.getStreamingInterval());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        thread.start();
    }

    @Override
    public long getStreamingInterval() {
        long interval = 0L;
        ITmfTrace<T>[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace<T> trace = iTmfTraceArray[n2];
            interval = Math.max(interval, trace.getStreamingInterval());
            ++n2;
        }
        return interval;
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<T> signal) {
        TmfExperiment<ITmfEvent> experiment = signal.getExperiment();
        if (experiment == this) {
            TmfExperiment.setCurrentExperiment(experiment);
            this.fEndSynchReference = signal.getReference();
        }
    }

    @TmfSignalHandler
    public void endSync(TmfEndSynchSignal signal) {
        if (this.fEndSynchReference != null && this.fEndSynchReference.intValue() == signal.getReference()) {
            this.fEndSynchReference = null;
            this.initializeStreamingMonitor();
        }
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() == this) {
            this.broadcast(new TmfExperimentUpdatedSignal((Object)this, this));
        }
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        if (signal.getExperiment() == this) {
            this.getIndexer().buildIndex(this.getNbEvents(), signal.getRange(), false);
        }
    }
}

