/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree;

import java.nio.ByteBuffer;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.HTNode;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.HistoryTree;

class CoreNode
extends HTNode {
    private int nbChildren = 0;
    private int[] children;
    private long[] childStart;
    private int extension;

    CoreNode(HistoryTree tree, int seqNumber, int parentSeqNumber, long start) {
        super(tree, seqNumber, parentSeqNumber, start);
        this.children = new int[this.ownerTree.config.maxChildren];
        this.childStart = new long[this.ownerTree.config.maxChildren];
    }

    @Override
    protected void readSpecificHeader(ByteBuffer buffer) {
        this.extension = buffer.getInt();
        this.nbChildren = buffer.getInt();
        this.children = new int[this.ownerTree.config.maxChildren];
        int i = 0;
        while (i < this.nbChildren) {
            this.children[i] = buffer.getInt();
            ++i;
        }
        i = this.nbChildren;
        while (i < this.ownerTree.config.maxChildren) {
            buffer.getInt();
            ++i;
        }
        this.childStart = new long[this.ownerTree.config.maxChildren];
        i = 0;
        while (i < this.nbChildren) {
            this.childStart[i] = buffer.getLong();
            ++i;
        }
        i = this.nbChildren;
        while (i < this.ownerTree.config.maxChildren) {
            buffer.getLong();
            ++i;
        }
    }

    @Override
    protected void writeSpecificHeader(ByteBuffer buffer) {
        buffer.putInt(this.extension);
        buffer.putInt(this.nbChildren);
        int i = 0;
        while (i < this.nbChildren) {
            buffer.putInt(this.children[i]);
            ++i;
        }
        i = this.nbChildren;
        while (i < this.ownerTree.config.maxChildren) {
            buffer.putInt(0);
            ++i;
        }
        i = 0;
        while (i < this.nbChildren) {
            buffer.putLong(this.childStart[i]);
            ++i;
        }
        i = this.nbChildren;
        while (i < this.ownerTree.config.maxChildren) {
            buffer.putLong(0L);
            ++i;
        }
    }

    int getNbChildren() {
        return this.nbChildren;
    }

    int getChild(int index) {
        return this.children[index];
    }

    int getLatestChild() {
        return this.children[this.nbChildren - 1];
    }

    long getChildStart(int index) {
        return this.childStart[index];
    }

    long getLatestChildStart() {
        return this.childStart[this.nbChildren - 1];
    }

    int getExtensionSequenceNumber() {
        return this.extension;
    }

    void linkNewChild(CoreNode childNode) {
        assert (this.nbChildren < this.ownerTree.config.maxChildren);
        this.children[this.nbChildren] = childNode.getSequenceNumber();
        this.childStart[this.nbChildren] = childNode.getNodeStart();
        ++this.nbChildren;
    }

    @Override
    protected byte getNodeType() {
        return 1;
    }

    @Override
    protected int getTotalHeaderSize() {
        int specificSize = 8 + 4 * this.ownerTree.config.maxChildren + 8 * this.ownerTree.config.maxChildren;
        return CoreNode.getCommonHeaderSize() + specificSize;
    }

    @Override
    protected String toStringSpecific() {
        return "Core Node, " + this.nbChildren + " children, ";
    }
}

